var host = location.origin;
var ws = host.replace('http','ws')

var host2 = localStorage.getItem('smartcube')//|| location.host;
var ws2 = `ws://${host2}`

const apps= "sitzknochenabstand";
var hockerNormData;


var aLangKeys = new Object();
var lang = "de";
let reloadTimer = null;


const canvas = document.getElementById("heatmapCanvas");
const container = document.getElementById("container");
const chart = echarts.init(document.getElementById('balance_container'));
const matte_con = document.getElementById('matte_con');
const cloud = document.getElementById('cloud_div');
//const cloud_h = document.getElementById('cloud_h')
const cloud_icon = document.getElementById('cloud_icon');
const cloud_con = document.getElementById('cloud_con');
const network = document.getElementById('network');
const network_ip = document.getElementById('network_ip');
//const network_h = document.getElementById('network_h')

let isrequired = new Object();
let userdata = new Object();
let products = new Object();
const imgURL = "https://produkte.velometrik.de/";

var scale_norm=10



if(ip===""){
  network.classList.remove('mdi-network-outline')
  network.classList.add('mdi-network-off-outline')
  network.style.color = 'var(--error)'
  //network_h.style.color = 'var(--error)'
  cloud.style.backgroundColor = 'var(--error)';
  cloud_icon.classList.add('mdi','font_xl','mdi-cloud-off-outline')
  network_ip.innerHTML = "--"
}

if (ip.length > 11){
  network_ip.style.fontSize = "10px";
}

var cols = 28;
var rows = 16;

var data = [
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  85,
  0,
  0,
  0,
  0,
  0,
  107,
  95,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  79,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  100,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  80,
  100,
  74,
  0,
  74,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  74,
  90,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  79,
  167,
  126,
  90,
  76,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  88,
  119,
  114,
  84,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  100,
  184,
  195,
  109,
  74,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  79,
  136,
  147,
  96,
  80,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  73,
  130,
  238,
  213,
  90,
  80,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  85,
  152,
  152,
  118,
  79,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  83,
  147,
  254,
  151,
  107,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  128,
  152,
  123,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  73,
  152,
  227,
  136,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  101,
  109,
  119,
  76,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  94,
  140,
  108,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  76,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  84,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  100,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
]



var gradient = getReducedGradient()

try {
  var sitzknochen = new WebSocket(`${ws}/apps/${apps}`, ["soap", "wamp"]);
} catch (error) {
}

try {
  var sitzkonochen2 = new WebSocket(`${ws2}/apps/${apps}`,["soap","wamp"]);
} catch (error) {
}

scheduleReloadIfNoState();

sitzknochen.onopen = (e)=>{
  sendMatte('switch create_norm on')
  sendMatte('switch create_jpeg off')
}

sitzknochen.onmessage = handleMessage;

sitzkonochen2.onmessage = handleMessage2;





const upscaledData = upscaleMatrixWithOffset(data, rows, cols, rows * 5, cols * 5, 4);

drawHeatmap(upscaledData, rows * 5, cols * 5, canvas, container, gradient);
updateChart(data, rows, cols); 


/**
 * The function `upscaleMatrixWithOffset` takes a matrix, its dimensions, a new size, and a multiplier,
 * and returns a scaled matrix with an offset.
 * @param matrix - The `matrix` parameter in the `upscaleMatrixWithOffset` function represents the
 * original matrix that you want to upscale with an offset. This matrix contains the values that you
 * want to scale up to a new size specified by `newRows` and `newCols`.
 * @param rows - The `rows` parameter in the `upscaleMatrixWithOffset` function represents the number
 * of rows in the original matrix that you want to upscale. It is used to calculate the scaling factor
 * for the rows in the new matrix.
 * @param cols - The `cols` parameter in the `upscaleMatrixWithOffset` function represents the number
 * of columns in the original matrix that you want to upscale. It is used to calculate the scaling
 * factor for the x-axis in order to determine how the values in the new matrix should be interpolated
 * based on the original
 * @param newRows - The `newRows` parameter in the `upscaleMatrixWithOffset` function represents the
 * number of rows in the new scaled matrix that you want to generate from the original matrix. This
 * parameter determines the height of the scaled matrix that will be created based on the scaling
 * factor and offset specified in the function
 * @param newCols - The `newCols` parameter in the `upscaleMatrixWithOffset` function represents the
 * number of columns in the new scaled matrix that you want to generate from the original matrix. This
 * parameter determines the width of the new matrix that will be created after upscaling the original
 * matrix.
 * @param multiply - The `multiply` parameter in the `upscaleMatrixWithOffset` function is used to
 * calculate the offset for scaling the matrix. The offset is calculated as `Math.floor((multiply - 1)
 * / 2)`. This offset helps in determining the starting point for scaling the matrix based on the
 * @returns The function `upscaleMatrixWithOffset` returns a new matrix that has been upscaled from the
 * original matrix based on the specified rows, columns, new rows, new columns, and multiplication
 * factor.
 */
function upscaleMatrixWithOffset(matrix, rows, cols, newRows, newCols, multiply) {
  const scaledMatrix = new Float32Array(newRows * newCols);
  const scaleX = cols / newCols;
  const scaleY = rows / newRows;
  const offset = Math.floor((multiply - 1) / 2);

  for (let y = 0; y < newRows; y++) {
      let origY = (y - offset) * scaleY;
      origY = Math.max(0, Math.min(origY, rows - 1));  // Begrenzung auf gültige Werte
      const y1 = Math.floor(origY);
      const y2 = Math.min(y1 + 1, rows - 1);
      const ty = origY - y1;

      for (let x = 0; x < newCols; x++) {
          let origX = (x - offset) * scaleX;
          origX = Math.max(0, Math.min(origX, cols - 1));  // Begrenzung auf gültige Werte
          const x1 = Math.floor(origX);
          const x2 = Math.min(x1 + 1, cols - 1);
          const tx = origX - x1;

          // Direkter Zugriff auf Matrix-Werte
          const idx1 = y1 * cols;
          const idx2 = y2 * cols;

          const q11 = matrix[idx1 + x1];
          const q21 = matrix[idx1 + x2];
          const q12 = matrix[idx2 + x1];
          const q22 = matrix[idx2 + x2];

          // Bilineare Interpolation mit reduzierten Operationen
          const value = (q11 * (1 - tx) + q21 * tx) * (1 - ty) +
                        (q12 * (1 - tx) + q22 * tx) * ty;

          scaledMatrix[y * newCols + x] = value;
      }
  }
  return scaledMatrix;
}


/**
 * The function `drawHeatmap` takes a matrix of values, number of rows and columns, a canvas element,
 * parent div, and a gradient, and draws a heatmap based on the values in the matrix using the
 * specified color gradient.
 * @param matrix - The `matrix` parameter in the `drawHeatmap` function represents the data values that
 * will be used to generate the heatmap. Each element in the matrix corresponds to a cell in the
 * heatmap grid, and its value determines the color intensity of that cell on the heatmap.
 * @param rows - Rows is the number of rows in the heatmap grid where each row represents a set of
 * values to be visualized.
 * @param cols - The `cols` parameter in the `drawHeatmap` function represents the number of columns in
 * the heatmap grid. It determines how many vertical sections the heatmap will be divided into for
 * visualization.
 * @param canvas - The `canvas` parameter in the `drawHeatmap` function is the HTML canvas element
 * where the heatmap will be drawn. It is used to get the 2D rendering context (`ctx`) for drawing
 * shapes and colors on the canvas. The heatmap will be drawn within this canvas element based on the
 * @param parentDiv - The `parentDiv` parameter in the `drawHeatmap` function represents the parent
 * HTML element where the heatmap canvas will be displayed. It is used to determine the dimensions of
 * the canvas based on the size of the parent element.
 * @param gradient - The `gradient` parameter in the `drawHeatmap` function is an array that defines
 * the color gradient mapping for the heatmap. Each element in the `gradient` array should be an object
 * with two properties:
 */
function drawHeatmap(matrix, rows, cols, canvas, parentDiv, gradient) {
  const ctx = canvas.getContext('2d');
  canvas.width = parentDiv.clientWidth;
  canvas.height = parentDiv.clientHeight;

  const cellWidth = canvas.width / cols;
  const cellHeight = canvas.height / rows;

  function getColor(value, gradient) {
      const normalizedValue = value / 255;
      for (let i = 0; i < gradient.length - 1; i++) {
          const start = gradient[i];
          const end = gradient[i + 1];
          if (normalizedValue >= start.value && normalizedValue <= end.value) {
              const t = (normalizedValue - start.value) / (end.value - start.value);
              const startColor = start.color.match(/\d+/g).map(Number);
              const endColor = end.color.match(/\d+/g).map(Number);
              const r = Math.round(startColor[0] + t * (endColor[0] - startColor[0]));
              const g = Math.round(startColor[1] + t * (endColor[1] - startColor[1]));
              const b = Math.round(startColor[2] + t * (endColor[2] - startColor[2]));
              return `rgb(${r},${g},${b})`;
          }
      }
      return gradient[0].color;
  }

  ctx.clearRect(0, 0, canvas.width, canvas.height);

  for (let y = 0; y < rows; y++) {
      for (let x = 0; x < cols; x++) {
          const value = matrix[y * cols + x];
          const color = getColor(value, gradient);
          ctx.fillStyle = color;
          ctx.fillRect(
              Math.floor(x * cellWidth),
              Math.floor((rows - y - 1) * cellHeight),
              Math.ceil(cellWidth),
              Math.ceil(cellHeight)
          );
      }
  }
}

/**
 * The function `getReducedGradient` returns a specific gradient based on the input contrast level or
 * the full gradient if no specific level is provided.
 * @param contrastLevel - The `contrastLevel` parameter determines which gradient to select based on
 * the provided value. The function `getReducedGradient` returns a specific gradient array based on the
 * `contrastLevel` input.
 * @returns The function `getReducedGradient` returns a specific gradient array based on the
 * `contrastLevel` parameter provided. If `contrastLevel` is 1, it returns `gradient1`, if it's 2, it
 * returns `gradient2`, if it's 3, it returns `gradient3`, and if none of these cases match, it returns
 * `fullGradient`.
 */
function getReducedGradient(contrastLevel) {
  // Definiere alle Gradienten
  const gradient1 = [
    { value: 0, color: 'rgb(0, 0, 0)' },   // Schwarz (Hintergrund)
    { value: 0.2, color: 'rgb(0, 255, 0)' }, // Dunkelblau
    { value: 0.3, color: 'rgb(0, 255, 0)' }, // Türkis
    { value: 0.4, color: 'rgb(0, 255, 0)' }, // Türkis/Grün
    { value: 0.5, color: 'rgb(255, 0, 0)' }, // Grün
    { value: 0.7, color: 'rgb(255, 0, 0)' }, // Gelb
    { value: 0.8, color: 'rgb(255, 0, 0)' }, // Orange
    { value: 1, color: 'rgb(255, 0, 0)' }   // Rot
  ];

  const gradient2 = [
    { value: 0, color: 'rgb(0, 0, 0)' },   // Schwarz (Hintergrund)
    { value: 0.2, color: 'rgb(0, 255, 255)' }, // Dunkelblau
    { value: 0.3, color: 'rgb(0, 255, 255)' }, // Türkis
    { value: 0.4, color: 'rgb(0, 255, 0)' }, // Türkis/Grün
    { value: 0.5, color: 'rgb(255, 255, 0)' }, // Grün
    { value: 0.7, color: 'rgb(255, 255, 0)' }, // Gelb
    { value: 0.8, color: 'rgb(255, 0, 0)' }, // Orange
    { value: 1, color: 'rgb(255, 0, 0)' }   // Rot
  ];

  const gradient3 = [
    { value: 0, color: 'rgb(0, 0, 0)' },   // Schwarz (Hintergrund)
    { value: 0.2, color: 'rgb(0, 0, 255)' }, // Dunkelblau
    { value: 0.3, color: 'rgb(0, 255, 255)' }, // Türkis
    { value: 0.4, color: 'rgb(0, 255, 0)' }, // Türkis/Grün
    { value: 0.5, color: 'rgb(255, 255, 0)' }, // Grün
    { value: 0.7, color: 'rgb(255, 255, 0)' }, // Gelb
    { value: 0.8, color: 'rgb(255, 165, 0)' }, // Orange
    { value: 1, color: 'rgb(255, 0, 0)' }   // Rot
  ];

  const fullGradient = [
      { value: 0, color: 'rgb(21, 21, 21)' },   // Schwarz (Hintergrund)
      { value: 0.2, color: 'rgb(0, 0, 255)' }, // Dunkelblau
      { value: 0.3, color: 'rgb(0, 255, 255)' }, // Türkis
      { value: 0.4, color: 'rgb(0, 255, 128)' }, // Türkis/Grün
      { value: 0.5, color: 'rgb(0, 255, 0)' }, // Grün
      { value: 0.7, color: 'rgb(255, 255, 0)' }, // Gelb
      { value: 0.8, color: 'rgb(255, 165, 0)' }, // Orange
      { value: 1, color: 'rgb(255, 0, 0)' }   // Rot
  ];

  // Wähle den passenden Gradient basierend auf dem Kontrastlevel
  switch (contrastLevel) {
      case 1: return gradient1;
      case 2: return gradient2;
      case 3: return gradient3;
      default: return fullGradient; // Standard: volle Palette
  }
}

/**
 * The function setGradient takes a level as input, gets a reduced gradient based on that level, and
 * then hides the gradient.
 * @param level - It looks like the `setGradient` function is missing some code inside it. The `level`
 * parameter seems to be used to determine the gradient level. You mentioned a function
 * `getReducedGradient(level)` which is likely used to calculate the gradient based on the level
 * provided.
 */
function setGradient(level){
  gradient = getReducedGradient(level)
  hide()
}

/**
 * The function `hide` hides all dropdown elements with the class 'uk-navbar-dropdown' using UIkit
 * library.
 */
function hide(){
  let all_dropdown = document.getElementsByClassName('uk-navbar-dropdown');
  console.log(all_dropdown);

  for (let index = 0; index < all_dropdown.length; index++) {
    const element = all_dropdown[index];
    UIkit.dropdown(element).hide(0);
  }
}

/**
 * The function `convertInInch` converts centimeters to inches and returns the result rounded to 2
 * decimal places.
 * @param cm - Centimeters
 * @returns The function `convertInInch` takes a value in centimeters and converts it to inches by
 * dividing it by 2.54. The result is then returned with two decimal places using the `toFixed` method.
 */
function convertInInch(cm) {
  return (cm / 2.54).toFixed(2);
}

/**
 * The function `convertInMM` converts centimeters to millimeters by multiplying the input by 10.
 * @param cm - The parameter `cm` represents the length in centimeters that you want to convert to
 * millimeters. The `convertInMM` function takes this length in centimeters as input and returns the
 * equivalent length in millimeters by multiplying the input value by 10.
 * @returns The function `convertInMM` takes a value in centimeters and returns the equivalent value in
 * millimeters by multiplying the input value by 10.
 */
function convertInMM(cm) {
  return (cm * 10);
}

/**
 * The function calculates the disbalance between two weights and categorizes it as "Keine Disbalance",
 * "Leichte Disbalance", or "Starke Disbalance" based on the percentage difference.
 * @param weight1 - Thank you for providing the function `calculateDisbalance` for me to assist you
 * with. Could you please provide me with the value for `weight1` so that I can help you calculate the
 * disbalance based on the given parameters?
 * @param weight2 - Thank you for providing the `calculateDisbalance` function. Could you please
 * clarify what the `weight2` parameter represents or provide more context so I can assist you further?
 * @returns The function `calculateDisbalance` returns a string indicating the level of disbalance
 * between two weights. The possible return values are:
 * - "Keine Daten" if the total weight is 0
 * - "Keine Disbalance" if the difference between the weights is less than 5% of the total weight
 * - "Leichte Disbalance" if the difference between the weights is between
 */
function calculateDisbalance(weight1, weight2) {
  const totalWeight = weight1 + weight2;
  if (totalWeight === 0) return "Keine Daten";

  const diff = Math.abs(weight1 - weight2) / totalWeight * 100;

  if (diff < 5) {
      return "Keine Disbalance";
  } else if (diff < 10) {
      return "Leichte Disbalance";
  } else {
      return "Starke Disbalance";
  }
}

/**
 * The function "sendMatte" sends parameters to the "sitzknochen" object.
 * @param parameters - I'm sorry, but the code snippet you provided doesn't include any information
 * about the parameters that are expected by the `sendMatte` function. Can you please provide more
 * context or code so I can better understand what the function does and what parameters it expects?
 */
function sendMatte(parameters) {
  sitzknochen.send(parameters)
}

// Funktion zum Verarbeiten eingehender Nachrichten
var state1 = false;
var state2 = false;
var x=0;
function handleMessage(e) {
  const data = JSON.parse(e.data);
  console.log(1,data);

  //if (data.v_sum === 0.0) {
  //  vsum = 0;
  //}

  if (data.wsevent === 'ttystate' && data.state === 'active') {
    //handleActiveState();
    cancelReloadTimer();
    matte_con.style.color = 'var(--primary)'
    state1 = true;
    x++
  }

  if (data.wsevent === 'ttystate' && data.state === 'inactive') {
   state1 = false; 
   scheduleReloadIfNoState();
  // sitzknochen.close()
  }

  if (data.wsevent === 'sitzknochenabstand') {

    sendMatte('sound ready')
    const disbalance = calculateDisbalance(data.gewicht1, data.gewicht2);
    document.getElementById('distance').innerHTML = `${data.sitzknochenabstand}`;
    document.getElementById('distance_mm').innerHTML = `${convertInMM(data.sitzknochenabstand)}`;
    document.getElementById('distance_inch').innerHTML = `${convertInInch(data.sitzknochenabstand)}`;
    document.getElementById('balance').innerHTML = `${data.gewicht1} | ${data.gewicht2}`;


    if(document.getElementById('sitzknochenabstand')){
      document.getElementById('sitzknochenabstand').value = data.sitzknochenabstand
      userdata['sitzknochenabstand'] = data.sitzknochenabstand
    }

    const overlayCanvas = document.getElementById('overlayCanvas');
    const ctx = overlayCanvas.getContext('2d');
    overlayCanvas.width = canvas.width;
    overlayCanvas.height = canvas.height;
    ctx.clearRect(0, 0, overlayCanvas.width, overlayCanvas.height);


    /**
     * The function `drawCross` draws a cross shape centered at the specified coordinates using white
     * color and a specific size.
     * @param x - The `x` parameter in the `drawCross` function represents the x-coordinate of the
     * center point where you want to draw the cross.
     * @param y - The `y` parameter in the `drawCross` function represents the vertical position where
     * the center of the cross will be drawn on the canvas.
     */
    function drawCross(x, y) {
        const crossSize = 10;
        ctx.strokeStyle = 'white';
        ctx.lineWidth = 2;
        ctx.beginPath();
        ctx.moveTo(x - crossSize, y - crossSize);
        ctx.lineTo(x + crossSize, y + crossSize);
        ctx.moveTo(x + crossSize, y - crossSize);
        ctx.lineTo(x - crossSize, y + crossSize);
        ctx.stroke();
    }

    const scaleX = overlayCanvas.width / cols;
    const scaleY = overlayCanvas.height / rows;
    drawCross(data.schwerpunkt1_x * scaleX, (rows - data.schwerpunkt1_y) * scaleY);
    drawCross(data.schwerpunkt2_x * scaleX, (rows - data.schwerpunkt2_y) * scaleY);

    // Disbalance einfärben
    if (disbalance !== "Keine Disbalance") {
        ctx.globalAlpha = 0.3; // Transparenz setzen
        ctx.fillStyle = disbalance === "Leichte Disbalance" ? 'green' : 'orange';
        ctx.globalAlpha = 0.3;

        if (data.gewicht1 > data.gewicht2) {
            ctx.fillRect(0, 0, overlayCanvas.width / 2, overlayCanvas.height);
        } else if (data.gewicht2 > data.gewicht1) {
            ctx.fillRect(overlayCanvas.width / 2, 0, overlayCanvas.width / 2, overlayCanvas.height);
        }
        ctx.globalAlpha = 1.0; // Transparenz zurücksetzen
    }
}

  if (data.wsevent === "hockernorm" && state1 === true) {
    //resetTimer()
    rows = data.n_rows;
    cols = data.n_cols;
    hockerNormData = data.values
    var upscale = upscaleMatrixWithOffset(hockerNormData, rows, cols, rows * scale_norm, cols * scale_norm, 2);
    drawHeatmap(upscale, rows * scale_norm, cols * scale_norm, canvas, container, gradient);
    updateChart(hockerNormData, rows, cols); // Neues Chart generieren
    //document.getElementById("images_count").innerHTML = x

  }
}

function handleMessage2(e) {
  const data = JSON.parse(e.data);
  console.log(2,data);

  //if (data.v_sum === 0.0) {
  //  vsum = 0;
  //}

  if (data.wsevent === 'ttystate' && data.state === 'active') {
    cancelReloadTimer();
    matte_con.style.color = 'var(--primary)'
    state2 = true;
    x++
  }

  if (data.wsevent === 'ttystate' && data.state === 'inactive') {
    state2 = false;
    scheduleReloadIfNoState();
    //sitzkonochen2.close()
   }

  if (data.wsevent === 'sitzknochenabstand') {
    const disbalance = calculateDisbalance(data.gewicht1, data.gewicht2);
    document.getElementById('distance').innerHTML = `${data.sitzknochenabstand}`;
    document.getElementById('distance_mm').innerHTML = `${convertInMM(data.sitzknochenabstand)}`;
    document.getElementById('distance_inch').innerHTML = `${convertInInch(data.sitzknochenabstand)}`;
    document.getElementById('balance').innerHTML = `${data.gewicht1} | ${data.gewicht2}`;

    resetAllCheckboxes()

    if(document.getElementById('sitzknochenabstand')){
      document.getElementById('sitzknochenabstand').value = data.sitzknochenabstand
      userdata['sitzknochenabstand'] = data.sitzknochenabstand
    }


    const overlayCanvas = document.getElementById('overlayCanvas');
    const ctx = overlayCanvas.getContext('2d');
    overlayCanvas.width = canvas.width;
    overlayCanvas.height = canvas.height;
    ctx.clearRect(0, 0, overlayCanvas.width, overlayCanvas.height);

/**
 * The function `drawCross` draws a white cross shape centered at the specified coordinates (x, y) with
 * a size of 10.
 * @param x - The `x` parameter in the `drawCross` function represents the x-coordinate of the center
 * point where you want to draw the cross.
 * @param y - The `y` parameter in the `drawCross` function represents the vertical position where the
 * center of the cross will be drawn on the canvas.
 */
    function drawCross(x, y) {
        const crossSize = 10;
        ctx.strokeStyle = 'white';
        ctx.lineWidth = 2;
        ctx.beginPath();
        ctx.moveTo(x - crossSize, y - crossSize);
        ctx.lineTo(x + crossSize, y + crossSize);
        ctx.moveTo(x + crossSize, y - crossSize);
        ctx.lineTo(x - crossSize, y + crossSize);
        ctx.stroke();
    }

    const scaleX = overlayCanvas.width / cols;
    const scaleY = overlayCanvas.height / rows;
    drawCross(data.schwerpunkt1_x * scaleX, (rows - data.schwerpunkt1_y) * scaleY);
    drawCross(data.schwerpunkt2_x * scaleX, (rows - data.schwerpunkt2_y) * scaleY);

    // Disbalance einfärben
    if (disbalance !== "Keine Disbalance") {
        ctx.globalAlpha = 0.3; // Transparenz setzen
        ctx.fillStyle = disbalance === "Leichte Disbalance" ? 'green' : 'orange';
        ctx.globalAlpha = 0.3;

        if (data.gewicht1 > data.gewicht2) {
            ctx.fillRect(0, 0, overlayCanvas.width / 2, overlayCanvas.height);
        } else if (data.gewicht2 > data.gewicht1) {
            ctx.fillRect(overlayCanvas.width / 2, 0, overlayCanvas.width / 2, overlayCanvas.height);
        }
        ctx.globalAlpha = 1.0; // Transparenz zurücksetzen
    }
}

  if (data.wsevent === "hockernorm" && state2 === true) {
    //resetTimer()
    rows = data.n_rows;
    cols = data.n_cols;
    hockerNormData = data.values
    var upscale = upscaleMatrixWithOffset(hockerNormData, rows, cols, rows * scale_norm, cols * scale_norm, 2);
    drawHeatmap(upscale, rows * scale_norm, cols * scale_norm, canvas, container, gradient);
    updateChart(hockerNormData, rows, cols); // Neues Chart generieren
    //document.getElementById("images_count").innerHTML = x

  }
}


//!CHART


/**
 * The function `calculateSums` calculates the sum of each column in a two-dimensional array.
 * @param data - The `data` parameter represents a one-dimensional array containing the elements of a
 * two-dimensional matrix, where the matrix has `rows` rows and `cols` columns. Each element in the
 * `data` array corresponds to a cell in the matrix, with the elements arranged in row-major order.
 * @param rows - The `rows` parameter in the `calculateSums` function represents the number of rows in
 * the data matrix. It is used to determine the number of iterations in the outer loop that iterates
 * over the rows of the data matrix.
 * @param cols - The `cols` parameter in the `calculateSums` function represents the number of columns
 * in the data matrix. It is used to determine the size of the array `sums` that will store the sum of
 * each column in the data matrix.
 * @returns The function `calculateSums` returns an array containing the sums of each column in the
 * provided data array.
 */
function calculateSums(data, rows, cols) {
    let sums = Array(cols).fill(0);
    for (let col = 0; col < cols; col++) {
        for (let row = 0; row < rows; row++) {
            sums[col] += data[row * cols + col];
        }
    }
    return sums;
}

/**
 * The function getColor generates an RGB color based on a given value within a specified range.
 * @param value - The `value` parameter represents the numerical value for which you want to determine
 * the color based on its position between `minValue` and `maxValue`.
 * @param minValue - The `minValue` parameter represents the minimum value in the range of values you
 * are working with. It is the lower bound of the scale against which you are comparing the `value`
 * parameter.
 * @param maxValue - The `maxValue` parameter represents the maximum possible value in the range of
 * values you are working with. It is used to determine the scaling of the color based on the input
 * `value`.
 * @returns The function `getColor` returns a string representing an RGB color based on the input
 * `value`, `minValue`, and `maxValue`. The color is determined based on the value's position between
 * the minimum and maximum values.
 */
function getColor(value, minValue, maxValue) {
    let ratio = (value - minValue) / (maxValue - minValue); // Skaliere auf 0 - 1

    let r, g, b;
    if (ratio < 0.25) {
        // GRÜN → BLAU
        r = 0;
        g = Math.round(255 * (1 - 4 * ratio)); // 255 → 0
        b = 255;
    } else if (ratio < 0.5) {
        // BLAU → GELB
        r = Math.round(255 * (4 * (ratio - 0.25))); // 0 → 255
        g = 255;
        b = Math.round(255 * (1 - 4 * (ratio - 0.25))); // 255 → 0
    } else if (ratio < 0.75) {
        // GELB → ORANGE
        r = 255;
        g = Math.round(255 * (1 - 4 * (ratio - 0.5))); // 255 → 127
        b = 0;
    } else {
        // ORANGE → ROT
        r = 255;
        g = Math.round(127 * (1 - 4 * (ratio - 0.75))); // 127 → 0
        b = 0;
    }

    return `rgb(${r},${g},${b})`;
}

/**
 * The function `updateChart` takes data, rows, and columns as input, calculates sums, determines min
 * and max values, assigns colors to bars based on values, and updates a chart with the new data.
 * @param data - The `data` parameter in the `updateChart` function represents the raw data that will
 * be used to update the chart. This data is typically in the form of a two-dimensional array where
 * each row represents a set of values for a specific category or series, and each column represents a
 * different data point
 * @param rows - The `rows` parameter in the `updateChart` function represents the number of rows in
 * the data matrix that you are working with. It is used along with the `cols` parameter to calculate
 * the sums of each "Bahn" in the data matrix. The `calculateSums` function likely
 * @param cols - The `cols` parameter in the `updateChart` function represents the number of columns in
 * your chart. It is used to determine the length of the x-axis labels and to calculate the sums for
 * each "Bahn" based on the data provided.
 */
function updateChart(data, rows, cols) {
    let bahnSums = calculateSums(data, rows, cols);
    let minValue = Math.min(...bahnSums);
    let maxValue = Math.max(...bahnSums);
    let barColors = bahnSums.map(value => getColor(value, minValue, maxValue));

    chart.setOption({
        xAxis: { type: 'category', show: false, data: Array.from({ length: cols }, (_, i) => `Bahn ${i+1}`) },
        yAxis: { type: 'value', show: true, splitLine: { show: true, lineStyle: { type: 'dashed', color: '#aaa' } } },
        series: [{
            type: 'bar',
            data: bahnSums,
            itemStyle: { color: (params) => barColors[params.dataIndex] }
        }],
        grid: { left: '5%', right: '5%', top: '5%', bottom: '5%', containLabel: false }
    }, true);
}

function handleHockerNormEvent(data, state2) {
    if (data.wsevent === "hockernorm" && state2 === true) {
        updateChart(data.values, data.n_rows, data.n_cols);
    }
}

// Resize-Event für Responsivität
window.addEventListener('resize', () => {
    chart.resize();
});

//!CHART END

/**
 * The function `resetAllCheckboxes` resets all radio input checkboxes, hides a button with the id
 * 'sendBTN', and shows a slider with the id 'uk_slider' at the first slide.
 */
function resetAllCheckboxes() {
  document.querySelectorAll('input[type="radio"]').forEach(checkbox => {
      checkbox.checked = false;
  });
  userdata= new Object()
  let btn = document.getElementById('sendBTN')
  btn.classList.add('hidden')
  UIkit.slider('#uk_slider').show(0)
}

const myTime = new Date()
var PingDate;
// FETCH DATA
Fetch_Ping()

/**
 * The Fetch_Ping function sends a GET request to a specific endpoint, processes the response data, and
 * handles different scenarios based on the received data.
 */
function Fetch_Ping() {
  fetch(`/vlbservice/ping`, {
          method: 'GET',
          credentials: 'include' // Entspricht withCredentials: true bei Axios
      })
      .then(response => response.text()) // Da du `response.data` erwartest, nehme ich an, es ist reiner Text
      .then(data => {
          if (data === '12 forbidden') {
              // TODO: ERROR HANDLING
              cloud.style.backgroundColor = 'var(--error)'; // Farbe setzen
              cloud_icon.classList.add('mdi','font_xl','mdi-cloud-off-outline')
              cloud_con.innerHTML = 'disconected'
              cloud_con.setAttribute('key','sitbone_cloud_no_con')
              return;
          }

          console.log('ping', data);
          data = JSON.parse(data)
          if(data.lang && !getFromLocalStorage('lang')){
            lang = data.lang.substring(2,0)
            translatejs()
          }
          if(data.optionen['sattel.beratung']){
            PingDate = new Date(data.optionen['sattel.beratung']);

            if(myTime < PingDate){
              //cloud.style.color = 'var(--primary)'; // Farbe setzen
              //cloud_h.style.color = 'var(--primary)'; // Farbe setzen
              cloud_icon.classList.add('mdi','font_xl','mdi-cloud-outline')
              cloud_con.innerHTML = 'connected'
              cloud_con.setAttribute('key','sitbone_cloud_con')
              //!hier kommt die get tpfs Daten
              getQuestions()
            } else {
              const day = PingDate.getDate();
              const month = PingDate.getMonth() + 1; // Monate sind 0-basiert, daher +1
              const year = PingDate.getFullYear();
              cloud.style.backgroundColor = 'var(--warn)'; // Farbe setzen
              //cloud_h.style.color = 'var(--warn)'; // Farbe setzen
              cloud_icon.classList.add('mdi','font_xl','mdi-cloud-off-outline')
              cloud_con.innerHTML = `${year}-${month}-${day}`

              //!TEST DEV ENTFERNEN
              getQuestions()
            }
            

          }
          translatejs()

      })
      .catch(err => {
          // TODO: ERROR HANDLING
      });
}

/* The above code is attempting to fetch data from a JSON file located at "/htdocs.json" using the
Fetch API in JavaScript. The fetch request is set to "no-cors" mode, which means that the response
will not be blocked by CORS (Cross-Origin Resource Sharing) restrictions. */
try {
  fetch("/htdocs.json", {
    mode: "no-cors",
  })
  .then((res)=> res.json())
  .then((data)=>htdocs(data)) 
} catch (error) {
  getError(error)
}

/**
* The function htdocs takes a JSON object as input and updates the innerHTML of all elements with the
* class 'version' to the value of the VERSION property in the JSON object.
* @param jsn - The parameter `jsn` is expected to be a JSON object containing information about the
* `htdocs` version.
*/
function htdocs (jsn){
htdocsInfo = jsn
for (const ele of document.getElementsByClassName('version')) {
  ele.innerHTML = htdocsInfo.VERSION
}
}



/**
 * It fetches the JSON file, then calls the _Translate function with the JSON file as an argument.
 */
function translatejs() {
  try {
    fetch("/production/json/lang.json?v=1", {
      mode: "no-cors",
    }) // disable CORS because path does not contain http(s)
      .then((res) => res.json())
      .then((data) => (_Translate(data)));
  } catch (error) {
    getError(error)
  }
}

/**
 * It takes a JSON object as a parameter, then loops through all the elements with the attribute "key"
 * and replaces the innerHTML with the value of the key attribute in the JSON object
 * @param params - The object that contains the language keys and their values.
 */
function _Translate(params) {
  console.log('%c init translatejs','background:#222;color:white;padding: 1em;');
  aLangKeys = params
      if(getFromLocalStorage('lang')){
          lang = getFromLocalStorage('lang')
      }
  if(document.getElementById('lang_list')){
  let lang_list = document.getElementById('lang_list');
  lang_list.innerHTML="";
  
  let zusatzlang = params.zusatzlang;
  let primarylang = params.lang;
  //let li_pl = document.createElement('div');
  let lang_card = newElement({element:'div',cls:['uk-card','uk-card-default','cur_pointer','lang-card'],attr:[['onclick',`langSelected('${primarylang.split(' ')[0]}_${primarylang.split(' ')[0]}.UTF-8')`]]},lang_list)
  let lang_head = newElement({element:'div',cls:['uk-card-header','flex-column-center']},lang_card)
  let lang_img  = newElement({element:'img',cls:['sprachwahl'],attr:[['src',`images/${primarylang.split(' ')[0]}.png`]]},lang_head)
  let lang_body = newElement({element:'div',cls:['uk-card-body','uk-padding-small','uk-text-center']},lang_card).innerHTML = `${primarylang.split(' ')[1]}`
  zusatzlang.forEach(langs => {
  let lang_card = newElement({element:'div',cls:['uk-card','uk-card-default','cur_pointer','lang-card'],attr:[['onclick',`langSelected('${langs.split(' ')[0]}_${langs.split(' ')[0]}.UTF-8')`]]},lang_list)
  let lang_head = newElement({element:'div',cls:['uk-card-header','flex-column-center']},lang_card)
  let lang_img  = newElement({element:'img',cls:['sprachwahl'],attr:[['src',`images/${langs.split(' ')[0]}.png`]]},lang_head)
  let lang_body = newElement({element:'div',cls:['uk-card-body','uk-padding-small','uk-text-center']},lang_card).innerHTML = `${langs.split(' ')[1]}`
  });
}
/* The above code is used to change the placeholder of the input fields. */
  for(const key3 in document.querySelectorAll('[key-place]')){
    const element3 = document.querySelectorAll('[key-place]')[key3];
      if(element3.tagName){
       let ele = element3.getAttribute('key-place')
       element3.setAttribute('placeholder',`${getTranslation(ele)}`)
      }
  }
  /* The above code is setting the title attribute of the element with the key-title attribute to the
  value of the key in the params object. */
  for(const key2 in document.querySelectorAll('[key-title]')){
    const element2 = document.querySelectorAll('[key-title]')[key2];
      if(element2.tagName){
       let ele = element2.getAttribute('key-title')
       element2.setAttribute('title',`${getTranslation(ele)}`)
      }
  }
/* Adding a class to the element and then creating a modal for the element. */
  for(const key4 in document.querySelectorAll('[key-readme]')){
    const readmeElement = document.querySelectorAll('[key-readme]')[key4];
    if(readmeElement.tagName){
      readmeElement.classList.add('readme','mdi','mdi-help-circle-outline')
      let varRead = readmeElement.getAttribute('key-readme');
      if(!help_array.includes(varRead)){
        CreateReadMeMod(varRead);
        help_array.push(varRead);
      }
      readmeElement.setAttribute('onclick',`OpenReadMe('${varRead}')`) //Z 634
    }
  }
/* Looping through all the elements with the attribute key and replacing the innerHTML with the value
of the key in the params object. */
  for (const key in document.querySelectorAll('[key]')) {
    const element = document.querySelectorAll('[key]')[key];
    if(element.innerHTML){
    element.innerHTML = `${getTranslation(element.getAttribute("key"))}`;
    }
  }
  $("#sprachwahl").attr("src", `images/${lang}.png`);
}

/**
 * The function `getTranslation` retrieves a translation for a given key from a language object,
 * displaying `[key]` if the translation is missing.
 * @param key - The `key` parameter in the `getTranslation` function is a string that represents the
 * key for the translation you want to retrieve. This key is used to look up the corresponding
 * translation in the `aLangKeys` object based on the current language (`lang`). If a translation is
 * found for the
 * @returns The function `getTranslation` is returning the translation of the given `key` in the
 * specified language `lang` from the `aLangKeys` object. If the translation for the key is not found,
 * it returns `[key]` as an indication that the translation is missing.
 */
function getTranslation(key) {
  return aLangKeys[lang][key] || `[${key}]`; // `[key]` zeigt an, dass die Übersetzung fehlt
}

/**
 * The function `saveToLocalStorage` saves a key-value pair to the browser's local storage.
 * @param key - The `key` parameter is a string that represents the name under which the `value` will
 * be stored in the browser's local storage.
 * @param value - The `value` parameter in the `saveToLocalStorage` function is the data that you want
 * to save to the local storage. It could be a string, number, object, array, or any other type of data
 * that you want to store locally in the browser.
 */
function saveToLocalStorage(key, value) {
  localStorage.setItem(key, value);
}

/**
 * The function `getFromLocalStorage` retrieves a value from the browser's local storage based on a
 * specified key.
 * @param key - The `key` parameter is a string that represents the key of the item you want to
 * retrieve from the localStorage.
 * @returns The value stored in the localStorage with the specified key is being returned.
 */
function getFromLocalStorage(key) {
  return localStorage.getItem(key);
}

let timeout;
let isScreensaverActive = false;

/**
 * The function `resetTimer` clears a timeout, hides a screensaver element if active, and sets a new
 * timeout to show the screensaver after 1 minute of inactivity.
 */
function resetTimer() {
    clearTimeout(timeout);
    if (isScreensaverActive) {
        document.getElementById('screensaver').style.display = 'none';
        isScreensaverActive = false;
    }
    timeout = setTimeout(showScreensaver, 60000); // 1 Minute Inaktivität
}

/**
 * The function `showScreensaver` hides a modal, displays a screensaver element, sets a flag to
 * indicate the screensaver is active, and starts a logo animation.
 */
function showScreensaver() {
    UIkit.modal('#modal-tpfs').hide();
    UIkit.modal('#modal-products').hide();
    UIkit.modal('#modal-langselect').hide();
    document.getElementById('screensaver').style.display = 'block';
    isScreensaverActive = true;
    startLogoAnimation();
}

// Events zum Zurücksetzen des Timers
//document.addEventListener('mousemove', resetTimer);
//document.addEventListener('keydown', resetTimer);
//document.addEventListener('touchstart', resetTimer);

//resetTimer(); // Timer beim Start setzen

// Bewegung des Logos
let logo = document.getElementById('logo');
let posX = 50, posY = 50;
let speedX = 2, speedY = 2;
let screenWidth = window.innerWidth;
let screenHeight = window.innerHeight;

/**
 * The function `updateScreenSize` retrieves and stores the current width and height of the browser
 * window.
 */
function updateScreenSize() {
    screenWidth = window.innerWidth;
    screenHeight = window.innerHeight;
}

window.addEventListener('resize', updateScreenSize);

/**
 * The function `moveLogo` animates the movement of a logo on the screen, bouncing off the edges when
 * it reaches them.
 * @returns If the `isScreensaverActive` variable is false, the function `moveLogo` will return early
 * and not execute the rest of the code.
 */
function moveLogo() {
    if (!isScreensaverActive) return;
    
    posX += speedX;
    posY += speedY;

    // Kollision mit den Rändern
    if (posX + 100 >= screenWidth || posX <= 0) {
        speedX *= -1; // Richtung umkehren
    }
    if (posY + 100 >= screenHeight || posY <= 0) {
        speedY *= -1; // Richtung umkehren
    }

    logo.style.left = posX + 'px';
    logo.style.top = posY + 'px';

    requestAnimationFrame(moveLogo);
}

/**
 * The function `startLogoAnimation` initializes random positions and speeds for a logo and then calls
 * `moveLogo` to animate its movement.
 */
function startLogoAnimation() {
    posX = Math.random() * (screenWidth - 100);
    posY = Math.random() * (screenHeight - 100);
    speedX = (Math.random() > 0.5 ? 1 : -1) * (2 + Math.random() * 2);
    speedY = (Math.random() > 0.5 ? 1 : -1) * (2 + Math.random() * 2);
    moveLogo();
}


//quesrions

/**
 * The function `getQuestions` fetches data from a specific URL with language and product parameters,
 * processes the response, and creates blocks based on the data.
 */
function getQuestions (){
  const lang = 'deu'
  const temp = '&produktart=sattel'

  fetch(`/vlbservice/start?lang=${ lang }${ temp }`, {
    method: 'GET',
    credentials: 'include' // Entspricht withCredentials: true bei Axios
  })
  .then(response => response.text()) // Da du `response.data` erwartest, nehme ich an, es ist reiner Text
  .then(data => {
      if (data === '12 forbidden') {
          // TODO: ERROR HANDLING
        
      }

      data = JSON.parse(data)
      console.log("data full",data);
      
      for (const key in data) {
        const element = data[key];
        //TODO Create Block
        create_block(element)                   
      }

  })
  .catch(err => {
      // TODO: ERROR HANDLING
      console.log(err);
      
  });
}

let data_index = 1

/**
 * The function `create_block` creates a block of HTML elements based on a JSON object and appends it
 * to the 'questions' element in the document.
 * @param jsn - The `jsn` parameter is an object that contains the following properties:
 */
function create_block(jsn) {
  let ins = document.getElementById('tpfs_container');
  console.log(jsn);

  jsn.fragen.forEach(element => {
    console.log(element);
    let block   = newElement({element:"div",id:`${jsn.code}`,cls:['uk-width-1-1', 'uk-grid-collapse', 'uk-child-width-1-2@s'],attr:[['style','display:flex;']]},ins)
    let img = newElement({element:"div",cls:['uk-background-cover'],attr:[['style','background-image: url("/production/images/bg/background_1.jpg");'],['uk-height-viewport','']]},block)
    let content = newElement({element:"div",cls:['uk-padding-large','uk-flex-middle'],attr:[['uk-grid','']]},block)
    let h2 = newElement({element:'h2',attr:[['key',`tpfs_${element.code}`],['style','color:black;text-align: center;background-color: var(--secondary-back);']]},img).innerHTML = jsn.code
    if(element.vorgaben === null){
      let inp = newElement({element:"input",cls:["uk-input"],id:`${element.code}`,attr:[['oninput','changeEventHandler(event)'],['name',element.code],['required','true'],['data-index',data_index],['disabled','']]},content)
    } else {
      let gruppe = newElement({element:"div",cls:["uk-button-group"]},content)
      genSelect(element.vorgaben,gruppe,element.code,element.pflicht)
    }
  });

  translatejs();
}

/**
 * The function `genSelect` generates a select element with options based on a given JSON object.
 * @param jsn - The `jsn` parameter is a JSON object that contains the data for generating the select
 * options.
 * @param to - The "to" parameter is the element where the generated select options will be appended
 * to. It can be a DOM element or a selector string.
 * @param name - The `name` parameter is a string that represents the name of the select element.
 * @param pflicht - The parameter "pflicht" is a boolean value that determines whether the select
 * options are required or not. If "pflicht" is true, the select options will be marked as required and
 * will have a data-progress attribute set to 1. If "pflicht" is false, the select options
 */
function genSelect(jsn,to,name,pflicht) {
  data_index++
  for (const key in jsn) {
          const e = jsn[key];

          let card    = newElement({element:"div",cls:['radio-btn']},to)
          if(pflicht===true){
              isrequired[name] = true
              progressMax(Object.keys(isrequired).length+1)
              if(e.code != null){
                  newElement({element:'input',id:`${name}_${e.code}`,attr:[['data-index',data_index],['type','radio'],['name',`${name}`],['value',`${e.code}`],['required','true'],['onclick','changeEventHandler(event)']]},card)
                  newElement({element:'label',cls:['question_label'],attr:[['key',`title_${name}${e.code}`],['for',`${name}_${e.code}`]]},card).innerHTML = "key"
              }
          } else {
              if(e.code != null){
                  newElement({element:'input',id:`${name}_${e.code}`,attr:[['data-index',data_index],['type','radio'],['name',`${name}`],['value',`${e.code}`],['onclick','changeEventHandler(event)']]},card)
                  if(e.code == 'ja'||e.code == 'nein'||e.code == 'egal'){
                      newElement({element:'label',attr:[['key',`title_${name}${e.code}`],['for',`${name}_${e.code}`]]},card).innerHTML = "key"
                  } else {
                      newElement({element:'label',attr:[['key',`title_${name}${e.code}`],['for',`${name}_${e.code}`]]},card).innerHTML = "key"
                  }
              }
          }

         
  }
}

/**
 * The function `progressMax` sets the maximum value of a progress bar element.
 * @param add - The `add` parameter is the value that you want to set as the maximum value for the
 * progress bar.
 */
function progressMax(add) {
  //let p = $('#mybar')[0];
  //p.setAttribute('max',add) 
}


/**
 * The function `changeEventHandler` handles changes in form input fields, logs the changed value and
 * parent element, checks if the field is required and if it already exists in `userdata`, updates the
 * progress, validates the input, and updates the `userdata` object accordingly.
 * @param event - The `event` parameter is an object that represents the event that triggered the
 * change event handler. It contains information about the event, such as the target element that
 * triggered the event, the type of event, and any additional data associated with the event. In this
 * case, the event is a change event
 */
function changeEventHandler(event) {
  console.log(`${event.target.name} -> ${event.target.value.replace('_',' ')}`);
  console.log(event.target.dataset.index);
  if (event.target.required){
      if (event.target.name in userdata) {
          console.log('schon vorhanden');
      }
  } 
  let obj = event.target;
  let name = event.target.name;
  let check;
  if (obj.checkValidity()) {
      if (event.target.type === 'checkbox') {
          check = event.target.checked;
          console.log('checkbox',check);
          userdata[name] = check;
      } else {
          check = event.target.value.replace(' ', '_');
          console.log('else',check);
          userdata[name] = check;
      }
      if (obj.classList.item('is-invalid'))
          obj.classList.remove('is-invalid');
      obj.classList.add('is-valid');
  } else {
      if (obj.classList.item('is-valid'))
          obj.classList.remove('is-valid');
      obj.classList.add('is-invalid');
  }
  ergebnisse();
  checkRequiredFields(isrequired, userdata);
  let index = Number(event.target.dataset.index);
  UIkit.slider('#uk_slider').show(index+1)
}

/**
 * The function "ergebnisse" checks if all required input fields have been filled out and if so, it
 * displays the "products" element.
 */
function ergebnisse() {
  let name;
  let x = false;
  for (let index = 0; index < $('input').length; index++) {
      const element = $('input')[index];
      if (name !== element.name && element.required) {
          if (element.name in userdata && Object.keys(userdata).length-1 >= Object.keys(isrequired).length) {
              x = true;
          } else {
              //TODO Was wenn nicht
          }
      }
      name = element.name;
  }
  if (x) {
  }
}

/**
 * The function `checkRequiredFields` checks for missing keys in a user data object based on a
 * specified set of required keys and either executes an action if all required keys are present or
 * logs the missing keys.
 * @param isRequired - The `isRequired` parameter is an object that contains the keys of the fields
 * that are required for the `userData` object.
 * @param userData - I see that you have provided the function `checkRequiredFields` which takes two
 * parameters `isRequired` and `userData`. However, you have not provided the content of the `userData`
 * object. Could you please provide the content of the `userData` object so that I can assist you
 * further with testing
 */
function checkRequiredFields(isRequired, userData) {
  // Prüfen, welche Schlüssel fehlen
  const missingKeys = Object.keys(isRequired).filter(key => !(key in userData));

  if (missingKeys.length === 0) {
      showBTN(); // Falls alle Keys vorhanden sind, Aktion ausführen
  } else {
      console.log("Fehlende Schlüssel:", missingKeys); // Alternativ Fehlerbehandlung
  }
}

/**
 * The function `showBTN` selects an element with the id 'sendBTN' and removes the 'hidden' class from
 * it.
 */
function showBTN() {
  let btn = document.getElementById('sendBTN')
  btn.classList.remove('hidden')
}

/**
 * The `showSaddle` function sends a GET request to a specific URL with parameters, processes the
 * response data, and dynamically creates product cards based on the retrieved information.
 */
function showSaddle() {
  let params = new URLSearchParams();

  params.append('lang', 'deu');
  params.append('#artcode', 'sattel'); 
  params.append('#max_produkte', '3');

  for (const key in userdata) {
      let paramName = key.replaceAll(' ', '_');
      if (!params.has(paramName)) { // Verhindert doppelte Einträge
          params.append(paramName, userdata[key]);
      }
  }

  console.log('Load prod URL:', `/vlbservice/bewerten?${params.toString()}`);

  fetch(`/vlbservice/bewerten?${params.toString()}`, {
      method: 'GET',
      credentials: 'include'
  })
  .then(response => response.text()) // Erst als Text parsen
  .then(text => {
      console.log("Raw response:", text); // Zeigt den ungefilterten API-Response
      
      try {
          let data = JSON.parse(text); // Dann JSON parsen
          if (data === '12 forbidden') return;
          
          products = data;

          let container = document.getElementById('products_container')
          container.innerHTML = ""
          let content = newElement({element:"div",cls:['uk-width-1-1', 'uk-grid-collapse', 'uk-child-width-1-2@s', 'uk-flex-middle'],attr:[['uk-grid',''],['style','height: 100vh;flex-direction: column;justify-content: center;']]},container)
          let imgContainer = newElement({element:"div"},content)
          let img = newElement({element:'img',attr:[['src',`/production/images/Logo-mit-Schriftzug.png`],['width','600'],['height','400']]},imgContainer)
          let details = newElement({element:'div',cls:['uk-padding-large']},content)
          let h1   = newElement({element:'h1',attr:[['key','sitbone_auswahl'],['style','margin: 0;text-align: center;']]},details).innerHTML = "Deine Auswahl"

          for (const i of products) {
            createProductCard(i);
          }
          translatejs()
          UIkit.modal('#modal-products').show();
      } catch (err) {
          console.error("Fehler beim JSON-Parsen:", err, "Rohdaten:", text);
      }
  })
  .catch(err => {
      console.error("Fetch-Fehler:", err);
  });
}

/**
 * The function `createProductCard` generates a product card with image and details based on the
 * provided JSON data.
 * @param jsn - The `jsn` parameter in the `createProductCard` function seems to represent a JSON
 * object containing information about a product. This information includes properties like `vmkid`,
 * `herst`, and `typ`. The function uses this information to dynamically create a product card in the
 * HTML document.
 */
function createProductCard(jsn){
  let container = document.getElementById('products_container')

  let content = newElement({element:"div",cls:['uk-width-1-1', 'uk-grid-collapse', 'uk-child-width-1-2@s', 'uk-flex-middle'],attr:[['uk-grid','']]},container)
  let imgContainer = newElement({element:"div"},content)
  let img    = newElement({element:'img',attr:[['src',`${imgURL}${jsn.vmkid}.jpg`],['width','600'],['height','400']]},imgContainer)
  let details = newElement({element:'div',id:`info_${jsn.vmkid}`,cls:['uk-padding-large']},content)

  let h3   = newElement({element:'h3',attr:[['style','margin: 0']]},details).innerHTML = jsn.herst
  let h3_2 = newElement({element:'h3',attr:[['style','margin: 0']]},details).innerHTML = jsn.typ
}

/**
 * The function `Load_Details` fetches product details based on a given ID, processes the data, and
 * dynamically creates a table to display the information on a webpage.
 * @param vmkid - The function `Load_Details(vmkid)` is a JavaScript function that makes a GET request
 * to a specific URL to load product details based on the `vmkid` parameter. It then processes the
 * response data and dynamically creates a table to display the product details on the webpage.
 */
function Load_Details(vmkid) {
  let url = `/vlbservice/produkt?lang=deu&vmkid=${vmkid}`;

  fetch(url, {
      method: 'GET',
      credentials: 'include'
  })
  .then(response => response.json()) // Erwartet JSON-Daten
  .then(data => {
      if (data === '12 forbidden') {
          console.log('error');
          return;
      }

      produktdetails = data;
      console.log(produktdetails);

      let to = document.getElementById(`info_${vmkid}`);
      let table = newElement({ element: 'table', cls: ['uk-table', 'uk-table-striped'], attr: [['style', 'font-size: x-small; color:black;']] }, to);
      let tbody = newElement({ element: 'tbody' }, table);
      
      let inter = setInterval(() => {
          for (const i of produktdetails) {
              let tr = newElement({ element: 'tr' }, tbody);
              for (const key in i) {
                  const element = i[key];
                  if (key === 'eigenschaft') {
                      newElement({ element: 'td', attr: [['key', `${element.replaceAll(' ', '_')}`], ['style', 'padding:1em;']] }, tr).innerHTML = element || "";
                  } else {
                      if (element) {
                          if (/[aeiou]/i.test(element)) { // Enthält Vokale
                              newElement({ element: 'td', attr: [['key', `${element.replaceAll(' ', '_')}`], ['style', 'padding:1em;']] }, tr).innerHTML = element || "";
                          } else {
                              newElement({ element: 'td', attr: [['style', 'padding:1em;']] }, tr).innerHTML = element || "";
                          }
                      }
                  }
              }
          }
          translatejs();
          //to.classList.remove('uk-hidden');
          clearInterval(inter);
      }, 0);
  })
  .catch(err => {
      getError(err);
  });
}


/**
 * The function `selectLang` opens a modal dialog for selecting a language.
 */
function selectLang (){
  UIkit.modal('#modal-langselect').show();
}

/**
 * The function `langSelected` takes a selected language code as input, extracts the language code,
 * calls the `translatejs` function, and hides a modal with the ID `modal-langselect`.
 * @param select - The `select` parameter in the `langSelected` function is likely a string
 * representing the selected language. The function extracts the first two characters from this string
 * using the `substring` method and assigns it to the `lang` variable. After that, it calls the
 * `translatejs` function and hides
 */
function langSelected(select){
  lang = select.substring(2,0)
  saveToLocalStorage('lang',lang)
  translatejs()
  UIkit.modal('#modal-langselect').hide();
  if(document.getElementById('lang_sel_hocker')){
      let x = document.getElementById('lang_sel_hocker')
      x.src = `images/${lang}.png` 
  }
}

/**
 * It creates a new element with the given parameters and appends it to the given element
 *
 * @function
 * @name newElement
 * @kind function
 * @param {Object<JSON>} jsn - JSON object
 * @param {String} jsn.element    - HTML element name
 * @param {String} jsn.id    - ID of the element
 * @param {Array<String>} jsn.cls - classes of the element
 * @param {Array<Array<String>>} jsn.attr - Attriburtes of the HTML element
 * @param {HTMLElement} DOM_Element - the complete element
 * @returns {HTMLElement}
 */
function newElement(jsn, DOM_Element) {
  let e = document.createElement(jsn.element)
  if(jsn.cls){
      jsn.cls.forEach(element => {
          e.classList.add(element)
      });
  }
  if(jsn.id){
      e.id = jsn.id
  }
  if(jsn.attr){
      jsn.attr.forEach(element=>{
          e.setAttribute(element[0],element[1])
      });
  }
  //console.log(`%c New Element -> ${JSON.stringify(jsn)}`,'background: #222;color:white;padding: 1em');
  DOM_Element.append(e)
  return e;
}

// --- Watchdog für Reload, wenn keine Matte aktiv ist ---

function scheduleReloadIfNoState() {
  // Schon geplant? Dann nichts tun.
  if (reloadTimer) return;

  reloadTimer = setTimeout(() => {
    // Nur wirklich reloaden, wenn beide weiterhin false sind
    if (!state1 && !state2) {
      location.reload();
    } else {
      // sonst freigeben für zukünftige Checks
      reloadTimer = null;
    }
  }, 1000); // 1 Sekunde
}

function cancelReloadTimer() {
  if (reloadTimer) {
    clearTimeout(reloadTimer);
    reloadTimer = null;
  }
}

translatejs()