
// Funktion zur Umwandlung in eine Matrix
function arrayToMatrix(array, rows, cols) {
  if (array.length !== rows * cols) {
    throw new Error('Die Arraylänge stimmt nicht mit der Matrixgröße überein.');
  }

  const matrix = [];
  for (let i = 0; i < rows; i++) {
    matrix.push(array.slice(i * cols, (i + 1) * cols));
  }
  return matrix;
}
// Umwandlung in eine 16x28-Matrix
//const matrix = arrayToMatrix(array, 16, 28);
function calculateCenter(matrix) {
  var rows = matrix.length;
  var cols = matrix[0].length;
  var leftTotalSum = 0;
  var leftRowSum = 0;
  var leftColSum = 0;
  var rightTotalSum = 0;
  var rightRowSum = 0;
  var rightColSum = 0;

  for (var i = 0; i < rows; i++) {
    for (var j = 0; j < cols; j++) {
      if (j < cols / 2) {
        leftTotalSum += matrix[i][j];
        leftRowSum += i * matrix[i][j];
        leftColSum += j * matrix[i][j];
      } else {
        rightTotalSum += matrix[i][j];
        rightRowSum += i * matrix[i][j];
        rightColSum += (j - cols / 2) * matrix[i][j];
      }
    }
  }

  var leftCenterX = leftRowSum / leftTotalSum;
  var leftCenterY = leftColSum / leftTotalSum;
  var rightCenterX = rightRowSum / rightTotalSum;
  var rightCenterY = rightColSum / rightTotalSum;

  return {
    leftCenter: [leftCenterX, leftCenterY],
    rightCenter: [rightCenterX, rightCenterY],
  };
}

// Funktion zum Berechnen des Abstands zwischen zwei Punkten
function calculateDistance(point1, point2) {
  var dx = point2[0] - point1[0];
  var dy = point2[1] - point1[1];
  return Math.sqrt(dx * dx + dy * dy);
}

// Funktion zum Berechnen des Winkels zwischen zwei Punkten in Grad
function calculateAngle(point1, point2) {
  var dx = point2[0] - point1[0];
  var dy = point2[1] - point1[1];
  return Math.atan2(dy, dx) * (180 / Math.PI);
}

// Beispielaufruf
var matrix = [
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, 3645, 3612, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, 3842, 3362, 3769, 3917, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, 4719, 2964, 3497, 4433, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, 4494, 2340, 2887, 4655, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, 3978, 1556, 2177, 4286, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, 2638, 3927, 3102, 1058, 1524, 3889, 4128, 2274, -1, -1, -1, -1],
  [-1, -1, -1, -1, 2757, 3253, 2426, 664, 972, 3211, 4279, 3292, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, 3150, 2785, 1590, 422, 555, 2373, 4235, 4270, -1, -1, -1, -1, ],
  [-1, -1, -1, 3263, 3299, 2184, 870, 0, 223, 1402, 3272, 4928, 4328, -1, -1, -1, ],
  [-1, -1, -1, 4110, 3228, 1623, 291, 0, 0, 722, 2267, 4779, 5587, -1, -1, -1, ],
  [-1, -1, -1, 4831, 3374, 1343, 211, 0, 0, 440, 1678, 3785, 5506, -1, -1, -1, ],
  [-1, -1, 4454, 3528, 1996, 888, 0, 0, 0, 302, 1210, 2914, 4696, 4786, -1, -1, ],
  [-1, -1, 4115, 2997, 1617, 713, 0, 0, 0, 61, 853, 1952, 3605, 4572, -1, -1, ],
  [-1, 3311, 3169, 2432, 1336, 596, 0, 0, 0, 250, 862, 1521, 2424, 3656, 3455, -1],
  [-1, 2125, 2279, 2020, 1286, 435, 0, 0, 0, 465, 909, 1704, 1925, 2829, 3800, -1],
  [-1, 2762, 1626, 1438, 753, 330, 106, 0, 0, 63, 820, 1140, 1427, 2117, 3767, -1, ],
  [-1, 4715, 1997, 707, 174, 94, 162, 0, 0, 0, 49, 625, 586, 1695, 5034, -1, ],
  [-1, 5427, 1672, 161, 0, 0, 0, 0, 0, 0, 0, 0, 306, 1841, 3483, -1, ],
  [-1, -1, 1814, 0, 0, 0, 0, 0, 0, 0, 0, 0, 302, 849, -1, -1, ],
  [-1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 472, 592, -1, -1, ],
  [-1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, ],
  [-1, -1, -1, -1, 0, 0, 660, -1, -1, 0, 0, 0, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
];
let stringMatrix = "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 39 0 0 0 0 0 0 0 0 0 0 0 88 96 71 70 0 0 0 0 0 0 0 0 0 0 5 55 77 61 5 0 0 0 0 0 0 0 0 59 105 123 126 113 71 11 0 0 0 0 0 0 0 11 83 104 126 79 15 0 0 0 0 0 0 0 0 57 109 144 149 141 102 79 56 0 0 0 0 54 56 74 115 122 131 97 46 0 0 0 0 0 0 0 0 39 105 135 157 146 121 86 52 0 0 0 0 62 81 100 120 126 122 103 49 0 0 0 0 0 0 0 0 0 94 121 141 139 124 86 55 0 0 0 32 89 114 116 128 125 109 67 5 0 0 0 0 0 0 0 0 0 45 87 118 112 111 84 10 0 0 0 52 92 112 111 125 101 60 0 0 0 0 0 0 0 0 0 0 0 0 32 64 74 47 0 0 0 0 0 32 77 97 95 101 72 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 48 46 71 20 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"


var centers = calculateCenter(arrayToMatrix(stringMatrix.split(' '), 16, 28));
console.log("Schwerpunkt links:", centers.leftCenter);
console.log("Schwerpunkt rechts:", centers.rightCenter);

var distance = calculateDistance(centers.leftCenter, centers.rightCenter);
console.log("Abstand der Schwerpunkte:", distance);

var angle = calculateAngle(centers.leftCenter, centers.rightCenter);
console.log("Winkel (in Grad) zwischen den Schwerpunkten:", angle);

