/**
    messages.js
**/

document.getElementById("ws_url").value = `ws://${window.location.hostname}:${window.location.port}/messages`


/**
 * Eingegangene Meldung anzeigen
 */
function handleWSMessage (wsmessage) {
    var msg;

    try {
         msg = JSON.parse (wsmessage);
    } catch (error) {
        console.log (`Kein gültiger JSON-String: "${wsmessage}"`);
        return;
    }
	document.getElementById("message").innerHTML = wsmessage.replace(/</g,"&lt;").replace(/>/g,"&gt;");
}


var conn;

/**
 * Websocket Verbindung zur Domäne herstellen
 */
function connect () { //{{{
    if (window.WebSocket) {
        // Evtl. bestehende Verbindung schließen
        if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) conn.close();

        // Verbindung herstellen
        try {
            // Der Server erwartet wenigstens ein (Sub)Protokoll, auch wenn das nicht benutzt wird.
            conn = new WebSocket(document.getElementById("ws_url").value, "dummy");
        } catch (error) {
            //??? nur SECURITY_ERROR
            document.getElementById("statusinfo").innerHTML = "Wenn das 'mal kein Fehler ist.";
        }
        switch (conn.readyState) {
            case WebSocket.CONNECTING: // Die Verbindung ist noch nicht hergestellt.
                document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung wird hergestellt.";
                conn.onopen = function (evt) {
                    document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung ist hergestellt.";
                    conn.onclose = function (evt) {
                        document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung wurde geschlossen.";
                        document.getElementById("message").innerHTML = "";
                    };
                };
                conn.onclose = function (evt) {
                    document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung konnte nicht hergestellt werden.";
                };
                break;
            case WebSocket.OPEN:       // Verbindung ist hergestellt und bereit darüber zu kommunizieren.
                document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung ist hergestellt.";
                break;
            case WebSocket.CLOSING:    // Verbindung ist im Prozess des Schließens.
            case WebSocket.CLOSED:     // Die Verbindung konnte nicht hergestellt werden.
                document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung konnte nicht hergestellt werden.";
                break;
        }
        // Eingetroffene Meldung vom Server bearbeiten
        conn.onmessage = function (evt) {
            handleWSMessage (evt.data);
        };
        
        return;
    } // WebSocket verfügbar
	document.getElementById("statusinfo").innerHTML = "WebSocket ist in diesem Browser nicht verfügbar";
    //}}}
} // connect()


/**
 * Websocket Verbindung trennen
 */
function disconnect () {//{{{
    if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) {
		conn.close();
	}
    //}}}
} // disconnect()

