# HTTP-Domäne /db_buprest
#
# Sqlite3 Datenbank Backup und Restore
#

namespace eval db_buprest {

    # query Key/Value Liste: [bup {Clients|Settings}]
    #           default: bup=Clients
    proc handleClientRequest {clientsocket {query {}} } {
        upvar #0 clientcontext$clientsocket context
        
        if {$context(method) == "POST"} {; #{{{ restore
            if {$::LOGLEVEL == "debug2"} {
                catch {
                    set fd [open "/var/local/log/restoredata" w]
                    fconfigure $fd -translation binary
                    puts -nonewline $fd $context(postdata)
                    close $fd
                    srvLog $clientsocket Info "POST data stored in /var/local/log/restoredata"
                }
            }
	        set content_type [dict get $context(request_headers) "Content-Type"]
            set context(contenttype) "text/plain; charset=utf-8"
            if {![string match "multipart/form-data*" $content_type]} {
                srvLog $clientsocket Error "Invalid Content-Type for restore: $content_type"
                set context(responsecode) "400 Bad Request"
                return "Error: Content-Type must be multipart/form-data"
            }
            set boundary [lindex [split [lindex $content_type 1] {=}] 1]
            srvLog $clientsocket Debug "boundary: '$boundary'"
            # (Vor dem Lesen der POST-Daten wurde auf binary umgeschaltet.)
            ### Beginn eines Multiparts
            # Jede neue Datei beginnt mit --${boundary}[\r]\n
            set offset [string length "--${boundary}"]
            if {![string match "--${boundary}*" $context(postdata)]} {
                set context(responsecode) "400 Bad Request"
                return "Error: 1st boundary not found"
            }
            # Zeilenende mit CRLF ?
            # (Lt. RFC 7230 (abschn. 3.) muß das so sein. Wir belassen es trotzdem beim ursprünglichen Kode.)
            set CRLF [expr [string compare [string index $context(postdata) $offset] "\r"] == 0]
            srvLog $clientsocket Debug "CRLF $CRLF"
            incr offset [expr $CRLF ? 2 : 1]
            # Es folgt ein Subheader, der mit einer Leerzeile endet.
            # Beispiel:
            #   'Content-Disposition: form-data; name="bupdata"; filename="VeloboxBup_20221017"'
            #   'Content-Type: application/octet-stream'
            while {1} {; # subheader
                set n [string first "\n" $context(postdata) $offset]
                if {$n < 0} {
                    set context(responsecode) "400 Bad Request"
                    return "Error: Invalid multipart subheader"
                }
                set shdrline [string range $context(postdata) $offset [expr $n - ($CRLF ? 2 : 1)]]
                srvLog $clientsocket Debug "'$shdrline'"
                set offset [expr $n + 1]
                # Folgt eine Leerzeile ?
                if {[string index $context(postdata) [expr $offset + ($CRLF ? 1 : 0)]] == "\n"} {
                    srvLog $clientsocket Debug "End of subheader at $offset"
                    break;
                }
            }; # while subheader
            incr offset [expr $CRLF ? 2 : 1]
            # Die Daten enden mit [\r]\n--irgendwas[\r]\n
            set offset2 [string first "\n--${boundary}" $context(postdata) $offset]
            if {$offset2 < 0} {
                srvLog $clientsocket Error "\\n--boundary (\\n--${boundary}) not found in POST data"
                catch {
                    set fd [open "/var/local/log/postdata.err" w]
                    fconfigure $fd -translation binary
                    puts -nonewline $fd $context(postdata)
                    close $fd
                    srvLog $clientsocket Info "POST data stored in /var/local/log/postdata"
                }
                set context(responsecode) "400 Bad Request"
                return "Error: Invalid data"
            }
            incr offset2 [expr $CRLF ? -2 : -1]; # Auf das letzte Datenbyte zurückgehen.
            srvLog $clientsocket Debug [format "Filedata %x ... %x" $offset $offset2]
            set fd [open /tmp/restoredata.gz wb]
            puts -nonewline $fd [string range $context(postdata) $offset $offset2]
            close $fd
            # Datei entpacken
            if {[catch {
                    # Ursprünglichen Namen ermitteln:
                    # (Pfadangabe wird entfernt.)
                    set dbfname [regsub {.*/} [exec gunzip -N -l /tmp/restoredata.gz | sed {s/  */\t/g} | cut -f 5 | tail -1] ""]
                    # Mit ursprünglichem Namen entpacken:
                    srvLog $clientsocket Debug "Unpack $dbfname ..."
                    exec gunzip -N --force /tmp/restoredata.gz
                } msg]} {
                    srvLog $clientsocket Error "gunzip /tmp/restoredata.gz: $msg"
                    set context(responsecode) "400 Bad Request"
                    return "Error: Invalid archivefile"
            }
            # Datei prüfen
            # Dazu den Dateianfang lesen und prüfen.
            set fd [open /tmp/$dbfname rb]
            set fstart [read $fd 16]
            close $fd
            if {[string compare $fstart "SQLite format 3\x00"] != 0} {
                srvLog $clientsocket Error "Restored file is not 'SQLite format 3'"
                set context(responsecode) "400 Bad Request"
                return "Error: Invalid datafile"
            }
            # Backup alte Datei nach /var/local/db/bachup/${dbfname}-<timestamp>
            if {[catch {
                if {![file exists "/var/local/db/backup"]} {
                    file mkdir "/var/local/db/backup"
                }
                set bupfname "/var/local/db/backup/${dbfname}-[clock seconds]"
                file copy "/var/local/db/${dbfname}" $bupfname
                srvLog $clientsocket Info "DB-backup created: '$bupfname'"
                } msg]} {
                srvLog $clientsocket Warn "DB-backup failed: '$msg'"
            }
            # Datenbankverbindung schließen
            ::kernel::DB::disconnect
            # Datei nach /var/local/db
            file copy -force "/tmp/$dbfname" "/var/local/db/${dbfname}"
            # Datenbank wieder verbinden
            ::kernel::DB::reconnect
            srvLog $clientsocket Info "Restored: /var/local/db/${dbfname}"
            ### Ende eines Multiparts
            return "Restore finished"
            #}}}
        } elseif {$context(method) == "GET"} {; #{{{ backup
	        set context(contenttype) "application/gzip"
            set dbname vlbclients; # default
            if {"[lindex $query 0]" == "bup"} {
                switch "[lindex $query 1]" {
                    "Clients" {}
                    "Settings" {set dbname "vlbsettings"}
                    default {srvLog $clientsocket Warn "Queryparameter bup=[lindex $query 1] ignoriert."}
                }
            }
            # Gibt es die Datenbank ?
            if {[file exists /var/local/db/${dbname}.sl3db]} {
                srvLog $clientsocket Info "Backup /var/local/db/${dbname}.sl3db"
                # Datenbankverbindung schließen (evtl. gibt es ungesicherte Daten)
                ::kernel::DB::disconnect
                file copy -force /var/local/db/${dbname}.sl3db /tmp/${dbname}.sl3db
                # Datenbank wieder verbinden
                ::kernel::DB::reconnect
                # Archiv erstellen und zum Versand holen
                exec gzip -f /tmp/${dbname}.sl3db
                set fd [open /tmp/${dbname}.sl3db.gz rb]
                set dbdata [read $fd]
                close $fd
                return $dbdata
            } else {
                srvLog $clientsocket Error "/var/local/db/${dbname}.sl3db existiert nicht."
                return ""
            }
            #}}}
        } elseif {$context(method) == "HEAD"} {; # backup
            #TODO Müssen wir das implementieren?
        }
        return ""
    }; # proc handleClientRequest 

}; # namespace eval db_buprest 
