#!/bin/bash
#
# velobox_update_3.1.0
# Einspielen aller Dateien in /usr/local/vmkstationd3/
# Velometrik-GmbH
# Breunsdorfer Str. 48a
# 04575 Neukieritzsch
#
# www.velometrik.com
# support@velometrik.de
#
# Historie:
# 12.07.2023    Peter Bauer    erstellt
# 10.12.2024    Peter Bauer    überarbeitet
# 19.12.2024    Peter Bauer    überarbeitet

LAST_VERSION="3.1.0"
CURRENT_VERSION="3.1.1"
JSON_PATH="/usr/local/vmkstationd/htdocs/htdocs.json"
SYMLINK="/usr/local/vmkstationd"
NEW_FOLDER="/usr/local/vmkstationd_V3.4.0"
BACKUP_FOLDER="/usr/local/vmkstationd_old_V3.3.0"

if [ "$(whoami)" != "root" ]; then
    echo "ERROR"
    echo "The script must be executed by root!"
    exit 1
fi

# Extrahiere die Version aus htdocs.json und ignoriere '_dev' falls vorhanden
if [ ! -f "$JSON_PATH" ]; then
  echo "ERROR: JSON file $JSON_PATH not found!"
  exit 1
fi

VERSION=$(grep -oP '(?<="VERSION": ")[^"]*' "$JSON_PATH" | sed 's/_dev//')

# Überprüfen, ob die Version entweder LAST_VERSION oder CURRENT_VERSION entspricht
if [ "$VERSION" != "$LAST_VERSION" ] && [ "$VERSION" != "$CURRENT_VERSION" ]; then
    echo "ERROR"
    echo "Update requires VERSION $LAST_VERSION or $CURRENT_VERSION in htdocs.json"
    exit 1
fi

# Benenne den ursprünglichen Ordner um und lösche den symbolischen Link
if [ -L "$SYMLINK" ]; then
    ORIGINAL_FOLDER=$(readlink "$SYMLINK")
    
    # Lösche das Backup-Verzeichnis, falls es bereits existiert
    if [ -d "$BACKUP_FOLDER" ]; then
        echo "Backup folder $BACKUP_FOLDER already exists. Deleting it..."
        rm -rf "$BACKUP_FOLDER"
        if [ $? -ne 0 ]; then
            echo "ERROR: Could not delete the existing backup folder $BACKUP_FOLDER!"
            exit 1
        fi
    fi

    mv "$ORIGINAL_FOLDER" "$BACKUP_FOLDER"
    if [ $? -ne 0 ]; then
        echo "ERROR: Could not rename the original folder to $BACKUP_FOLDER!"
        exit 1
    fi

    rm "$SYMLINK"
    if [ $? -ne 0 ]; then
        echo "ERROR: Could not delete the symbolic link $SYMLINK!"
        exit 1
    fi
else
    echo "ERROR: $SYMLINK is not a symbolic link or does not exist!"
    exit 1
fi

# Entpacke die neue Version
echo "Files in / will be installed."
if [ ! -r velobox_update_$CURRENT_VERSION.tar.gz ]; then
    echo "ERROR"
    echo "velobox_update_$CURRENT_VERSION.tar.gz not found"
    exit 1
fi

cp velobox_update_$CURRENT_VERSION.tar.gz /
if [ $? -ne 0 ]; then
    echo "ERROR"
    echo "Can't copy velobox_update_$CURRENT_VERSION.tar.gz to /."
    exit 1
fi

cd /
if [ $? -ne 0 ]; then
    exit 1
fi

tar xf velobox_update_$CURRENT_VERSION.tar.gz
if [ $? -ne 0 ]; then
    exit 1
fi

rm -f velobox_update_$CURRENT_VERSION.tar.gz

# Erstelle den neuen symbolischen Link
ln -s "$NEW_FOLDER" "$SYMLINK"
if [ $? -ne 0 ]; then
    echo "ERROR: Could not create symbolic link $SYMLINK pointing to $NEW_FOLDER!"
    exit 1
fi

# Setze Rechte für den neuen Ordner
chmod -R u+rwx,g+rwx,o+rwx "$NEW_FOLDER"
if [ $? -ne 0 ]; then
    echo "ERROR: Could not set permissions for $NEW_FOLDER!"
    exit 1
fi

###############################
### aktuelle Version setzen ###
echo "Correct user rights in htdocs"
chown -R root:root /usr/local
if [ $? -ne 0 ]; then
    echo "ERROR"
    echo "User rights could not be corrected!"
    exit 1
fi

history -c

echo "Done!"
