/**
 * It creates a new element with the given parameters and appends it to the given element
 * 
 * @function
 * @name newElement
 * @kind function
 * @param {Object<JSON>} jsn - JSON object
 * @param {String} jsn.element    - HTML element name
 * @param {String} jsn.id    - ID of the element
 * @param {Array<String>} jsn.cls - classes of the element
 * @param {Array<Array<String>>} jsn.attr - Attriburtes of the HTML element
 * @param {HTMLElement} DOM_Element - the complete element
 * @returns {HTMLElement} 
 */
function newElement(jsn, DOM_Element) {
  let e = document.createElement(jsn.ele);
  if (jsn.cls) {
    jsn.cls.forEach((el) => {
      e.classList.add(el);
    });
  }
  if (jsn.id) {
    e.id = jsn.id;
  }
  if (jsn.attr) {
    jsn.attr.forEach((el) => {
      e.setAttribute(el[0], el[1]);
    });
  }
  DOM_Element.append(e);
  return e;
}
