/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/*
    Created on : 12.06.2021, 15:08:29
    Author     : Peter Bauer
*/


//TODO aufräumen Funktionen prüfen und wenn entfernen bei nicht nutzung

const host = location.origin;
const ws = host.replace('http','ws');
const apps= "satteldruckanalyse";
UIkit.modal('#modal_load_side').show();
const baseURL ="https://www.the-perfect-fit-system.com/"

SystemCards()

const restoreForm = document.forms.namedItem("restore2");
restoreForm.addEventListener(
    "submit",
    (event) => {
        const formData = new FormData(restoreForm);
        const request = new XMLHttpRequest();
        request.open("POST", "/db_buprest", true);
        request.onload = () => {
            if (request.status === 200) {
                OpenModDialog({type:'warn',title:["config_reinit"],msg:`${aLangKeys[lang]['new_init']}`,master_btn:['button_ok','reinit()']})
            } else {
                OpenModDialog({type:'error',title:["db_upload_err"],msg:`${request.responseText}`,master_btn:['button_ok']})
            }
        };
        request.send(formData);
        event.preventDefault();
    },
    false
);

const api = new WebSocket(`${ws}/apps/${apps}`, ["soap", "wamp"]);

var onsqlresult = getLog();
var setting = new Object();

api.onmessage = (msg) => {
    let data = new Object();
    try {
        data = JSON.parse(msg.data)   
    } catch (error) {
        getError(error)
    }
    
    if (data.wsevent === "sqlresult"){
        try {
            onsqlresult (data.rows);           
        } catch (error) {
            getError(error)
        }
    }

}

/**
 * The function `getLog` logs the value of the `params` parameter to the console, or logs 'no SQL' if
 * `params` is falsy.
 * @param params - The `params` parameter is a variable that represents the SQL query or statement. It
 * is an optional parameter, meaning it can be omitted when calling the `getLog` function. If `params`
 * is provided, it will be logged to the console. If `params` is not provided, the
 */
function getLog(params) {
    console.log(params||'no SQL');
}


/**
 * !TODO Entfernen
 * It sends a request to the server to change the language file
 */
//function setLanguagefile() {
//    console.log('WERDE ICH GENUTZT?');
//    var systemsprache = document.getElementById("systemsprache").value;

//    var url = "/production/setlanguagefile.tcls?systemsprache=" + systemsprache;

//    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_system_hilfe\"><!--Einstellungen übernehmen und rebooten--></span></p>";

//    /* Sending a request to the server. */
//    httpSetconfig.open("GET", url, true);
//    httpSetconfig.send();

//    translatejs();
//}

/**
 * It sends a request to the server to set the configuration file
 */
function setConfigfile() {
    let stationsnummer = document.getElementById("stationsnummer").value;
    
    /*The "encodeURIComponent()" function is used to encode the value of the input to make it safe to be used in a URL. */
    let farbe = encodeURIComponent(document.getElementById("farbe").value);
    let empfindlichkeit = document.getElementById("empfindlichkeit").value;
    let webservice = document.getElementById("webservice").value;
    let url_smartcube = document.getElementById("url_smartcube").value;
    let login_mail = document.getElementById('system_login_mail').value;
    let login_pass = document.getElementById('system_login_pass').value;
    let url_logo = document.getElementById('url_logo').value;

    saveToLocalStorage('url_logo',url_logo);
    /* The above code is checking if the variable `url_smartcube` contains the string "http://". If it
    does, it splits the string at "http://" and takes the second part of the split (i.e. the part after
    "http://"). Then it replaces all forward slashes ("/") in that part with an empty string and assigns
    the resulting string back to `url_smartcube`. Essentially, it is removing the "http://" and any
    forward slashes from the URL. */
    if(url_smartcube.includes('http://')){
        let url = url_smartcube.split('http://')[1]
        url_smartcube = url.replaceAll('/','')
    }
    script_setting.smartcube = url_smartcube
    script_setting.LoginMail = login_mail
    script_setting.LoginPass = login_pass
    script_setting.url_logo = url_logo
    saveConfig()
    //var url = "/production/setconfigfile.tcls?stationsnummer=" + stationsnummer + "&farbe=" + farbe + "&empfindlichkeit=" + empfindlichkeit + "&webservice=" + webservice + "&url_smartcube=" + url_smartcube;
    const url = `/production/setconfigfile.tcls?stationsnummer=${stationsnummer}&farbe=${farbe}&empfindlichkeit=${empfindlichkeit}&webservice=${webservice}`;//&url_smartcube=${url_smartcube}`;

    /* Sending a request to the server. */
    httpSetconfig.open("GET", url, true);
    httpSetconfig.send();


    OpenModDialog({type:'warn',title:["config_reinit"],msg:`${aLangKeys[lang]['new_init']}`,master_btn:['button_ok','reinit()']})

}


/**
 * The function `downloadFile` is used to download a file and display a message based on the response.
 * @returns The function does not explicitly return a value.
 */
function downloadFile() {

    if(box_status.includes('INET')||box_status.includes('LOGGED_IN')||box_status.includes('WEBSERVICE')){

    const updatefile = document.getElementById("updatefile").value;
    
    /* The above code is a JavaScript function that is triggered when a file update is requested. */
    if (updatefile) {
        gears_on()
        const url = `vlbupdate.tcls?updatefile=${updatefile}`;
        const oReq = new XMLHttpRequest();

        oReq.open("GET", url, true);
        oReq.send();

     /* The above code is handling the response from an XMLHttpRequest (AJAX) request. */
        oReq.onload = (e) => {
            if(oReq.status === 500){
                setTimeout(()=>{gears_off()},1000)
            }
            const arraybuffer = oReq.response; 
            if (arraybuffer.includes("Error: 500")) {
                document.getElementById("updatemassage").value = aLangKeys[lang]["update_fail"]//"UPDATE FAILED"
                return;
            }
            document.getElementById('updatemassage').value = arraybuffer
            setTimeout(()=>{gears_off()}, 500);
            setTimeout(()=>{setReboot()},1500)
        }
        translatejs();
        return;
    }
    document.getElementById("updatefile").style.border = "1px solid red";
    document.getElementById("updatefile").style.background = "#ffd6d6";
    document.getElementById("updatefile").setAttribute("placeholder", "e.g. vlbupdate-XXX.tar.gz");
    
    } else{
        UIkit.modal('#modal-system_no_inet').show();
    }
}

/**
 * "When the user clicks on the gear icon, show the gear modal."
 * 
 * The `console.log` statement is a debugging tool. It's a way to print out a message to the browser's
 * console
 */
function gears_on() {
    console.log('show gear');
    $('#gear').modal('show');
}

/**
 * "When the user clicks the gear icon, hide the gear modal."
 * 
 * The first line of the function is a console.log statement. This is a debugging tool that will print
 * the text "hide gear" to the console
 */
function gears_off() {
    $('#gear').modal('hide');
}
/**
 * It shows a modal dialog with a message
 */
function setReboot() {

    // Request starten
    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_rebootvelobox\"><!--Reboot Velobox--></span></p>";

    translatejs();

    $("#reboot").modal('show');
}

/* The above code is checking the value of `script_setting.bg` and applying different CSS classes to
elements with the class name 'back' based on that value. If the value matches the class value of the
second child node of the element, it adds the class 'mdi-checkbox-marked-circle-outline' and removes
the class 'mdi-checkbox-blank-circle-outline'. If the value does not match, it removes the class
'mdi-checkbox-marked-circle-outline' and adds the class 'mdi-checkbox-blank-circle-outline'. */
if(script_setting.bg){
    for (let name of document.getElementsByClassName('back')) {
        if(name.childNodes[1].classList.value === script_setting.bg){
            name.classList.remove('mdi-checkbox-blank-circle-outline');
            name.classList.add('mdi-checkbox-marked-circle-outline');
        } else{
            name.classList.remove('mdi-checkbox-marked-circle-outline');
            name.classList.add('mdi-checkbox-blank-circle-outline');
        }
    }
} 

/**
 * The function `selectBack` updates the background color of an element and sends the updated settings
 * to a WebSocket server.
 * @param params - params is a parameter that represents the selected element. It is expected to be a
 * DOM element that contains child nodes.
 */
function selectBack(params) {
    script_setting.bg = params.childNodes[1].classList.value
    script_websocket.send(`set clientsettings ${JSON.stringify(script_setting)}`)

    let b = document.getElementsByClassName('right_col')[0]
    b.removeAttribute('class');
    b.classList.add(params.childNodes[1].classList.value,'right_col');

    console.log(params.childNodes[1].classList.value);

    if(params.childNodes[1].classList.value == "img_own"){
        b.style.backgroundImage = `url(${script_setting.own_bg})`
    }

    for (let n of document.getElementsByClassName('back')) {
        if(n.childNodes[1].classList.value === script_setting.bg){
            n.classList.remove('mdi-checkbox-blank-circle-outline');
            n.classList.add('mdi-checkbox-marked-circle-outline');
        } else{
            n.classList.remove('mdi-checkbox-marked-circle-outline');
            n.classList.add('mdi-checkbox-blank-circle-outline');
        }
    }
    //setting.bgImage = params.childNodes[1].classList.value;
}

/**
 * If the parameter is 'on', set the local storage item 'DarkMode' to 0, otherwise remove the local
 * storage item 'DarkMode' and reload the page.
 * @param params - The parameter that is passed to the function.
 */
if(getFromLocalStorage('DarkMode')){
    document.getElementById('system_dark').setAttribute('checked','')
}

/**
 * The function toggles the dark mode setting by saving or clearing a value in local storage and then
 * reloading the page.
 */
function DarkMode() {
    if(getFromLocalStorage('DarkMode')){
      clearFromLocalStorage(['DarkMode'])
    } else {
      saveToLocalStorage('DarkMode',1)
    }
    location.reload()
    }

/**
 * The function creates a list of settings with icons and labels using HTML and CSS classes.
 * @param list - The `list` parameter is an array of arrays, where each inner array contains two
 * elements: the first element is a string representing the setting name, and the second element is a
 * string representing the icon to be displayed for that setting.
 */
function Setting_List(list) {
    let append = document.getElementById('system-card-holder');
    list.forEach(element => {
        console.log(element);
        let div = newElement({element:'div'},append)
        let uk_card;
        if(element[0]=="system_adv"){
            uk_card = newElement({element:'div',cls:['uk-card','uk-card-default','cur_pointer','dash-card','adba','basicview'],attr:[['onclick',`OpenSetting('${element[0]}')`],['key-title',`${element[0]}`]]},div)
        } else {
            let i = newElement({element:'i',cls:['readme_card','readme','mdi','mdi-help-circle-outline'],attr:[['key-title','ReadMe_title_help'],['key-readme',`Help_${element[0]}`],['onclick',`OpenReadMe('Help_${element[0]}')`]]},div)
            uk_card = newElement({element:'div',cls:['uk-card','uk-card-default','cur_pointer','dash-card'],attr:[['onclick',`OpenSetting('${element[0]}')`],['key-title',`${element[0]}`]]},div)
        }
        let uk_card_header = newElement({element:'div',cls:['uk-card-header','flex-column-center']},uk_card)
        let mdi = newElement({element:'div',cls:['mdi',`${element[1]}`],attr:[['style','font-size: 100px;']]},uk_card_header)
        let uk_card_body = newElement({element:'div',cls:['uk-card-body','uk-padding-small','uk-text-center'],attr:[['key',`${element[0]}`]]},uk_card).innerHTML = `<!--${element[0]}-->`
    }); 
    translatejs()
}

AXIOS_Ping();

/**
 * The function opens a UIkit modal with the ID corresponding to the input SettingName.
 * @param {String}SettingName - The parameter `SettingName` is a string that represents the name of the setting
 * that needs to be accessed or modified. It is used as a reference to open the corresponding modal
 * window with the settings options.
 */
function OpenSetting(SettingName) {
    if(SettingName == 'system_costom_protocol'){
        //AXIOS_Login();
        AXIOS_Ping();
    }
    UIkit.modal(`#modal-${SettingName}`).show();
}

/**
 * The function "addDate" sets the download attribute of an element with the id "startBackup" to a
 * formatted date string.
 */
function addDate() {
    const d = new Date();
    document.getElementById("startBackup").download = `VeloboxBup_${d.getFullYear() * 10000 + (d.getMonth() + 1) * 100 + d.getDate()}`;
}

/**
 * The function `SystemCards` fetches a JSON file containing system cards and passes the data to the
 * `Setting_List` function, while handling any errors with the `getError` function.
 */
function SystemCards() {
    try {
      fetch("/production/json/cards.json", {
        mode: "no-cors",
      }) // disable CORS because path does not contain http(s)
      .then((res) => res.json())
      .then((data) => (Setting_List(data.systemcards)));
    } catch (error) {
      getError(error)
    }
}


try {
    fetch("https://downloads.velometrik.de/version.json")
    .then((res)=> res.json())
    .then((data)=> update_jsn(data))
  } catch (error) {
    console.error(error);
  }
/**
 * The function `update_jsn` checks for updates in a JSON object and updates a file input element with
 * the latest version name if an update is available.
 * @param jsn - The parameter `jsn` is expected to be an object that contains information about
 * different versions of a software. It should have a property called `versionen`, which is an array of
 * objects. Each object in the `versionen` array should have properties `version` and `name`,
 * representing the
 */
  function update_jsn(jsn) {
    let comp = setInterval(()=> {
    jsn.versionen.forEach(element => {
        console.log(`%cVersion ${element.version} found \n${element.name}`,'background: #222;color:white;padding:1em');
    });
    let aV = htdocsInfo.VERSION.replaceAll('.','')
    var i = 0
    if(document.getElementById('updatefile')){
      var t = document.getElementById('updatefile')
      jsn.versionen.forEach(e => {
        let nV = e.version.replaceAll('.','')
        if (aV < nV && i==0) {
            i++;
            t.value = e.name;
            return;
        }
      });
    }
    clearInterval(comp);
    }, 500);

  }

  var user = document.getElementById('stnr').value;



/**
 * The function AXIOS_Login sends a GET request to a login endpoint with user credentials and saves the
 * response data to session storage.
 */
function AXIOS_Login() {
    axios.get(`${ baseURL }vmkservice/login`, {
            params: {
                portaluser: user,
                passwd: 'velopasswort'
            },
            method: 'GET',
            withCredentials: true
        })
        .then(response => {
            if (response.data === '12 forbidden' || response.data === '13 login failed') {
                //TODO ERROR HANDLING
                OpenModDialog({type:'error',title:["error"],msg:`${response.data}`,master_btn:['button_ok']})
                return;
            }
            AXIOS_Ping();
            AXIOS_logout();
        })
        .catch(err => {
            OpenModDialog({type:'error',title:["error"],msg:`${err}`,master_btn:['button_ok']})
        });
}

/**
 * The function `AXIOS_Ping` makes a GET request using Axios to retrieve data, handles the response
 * data, and performs various operations based on the data received.
 */
function AXIOS_Ping() {
    axios.get(`/vlbservice/ping `, { // ${ baseURL }vmkservice/ping
            method: 'GET',
            withCredentials: true
        })
        .then(response => {
            if (response.data === '12 forbidden') {
                //TODO ERROR HANDLING
                OpenModDialog({type:'error',title:["error"],msg:`${response.data}`,master_btn:['button_ok']})
                
                console.log('error');
                return;
            }
            Stationsinfo = response.data;
            //console.log(Stationsinfo);
            if(Stationsinfo.optionen['protokoll.beratung'] && new Date(Stationsinfo.optionen['protokoll.beratung'])>new Date()){
                console.log(`%c Custom Protokol til ${Stationsinfo.optionen['protokoll.beratung']}`,'background: #222;color: #5cbc40;padding:1em');
                script_setting.custom_protocol = new Date(Stationsinfo.optionen['protokoll.beratung'])
                saveConfig()
                getCustomProtocol(true)
            } else {
                script_setting.custom_protocol = new Date()
                saveConfig()
                getCustomProtocol(false)
            }
            //console.log(Stationsinfo.optionen);
            for (const key in Stationsinfo.optionen) {
                if (Object.prototype.hasOwnProperty.call(Stationsinfo.optionen, key)) {
                    const element = Stationsinfo.optionen[key];
                    
                    // Check if the key includes 'beratung'
                    if (key.includes('beratung') && key != 'protokoll.beratung') {
                        // Select the table element by ID
                        const table = document.getElementById('sys_adv');
                        let keysplit = key.split('.')[0]
                        // Create a new table row (tr)
                        if(keysplit==='lenker'||keysplit==='vorbauten'||keysplit==='sattelstuetzen'){
                        var row = newElement({ element: 'tr',attr:[['onclick',`openTPFS('${keysplit}')`],['style','background:var(--warn)']] }, table);

                        } else {
                        var row = newElement({ element: 'tr',attr:[['onclick',`openTPFS('${keysplit}')`]] }, table);
                        }
                        // Create the first cell (td) for the key
                        newElement({ element: 'td', cls: [], id: '', attr: [] }, row).textContent = key.split('.')[0];
                        
                        // Create the second cell (td) for the element
                        newElement({ element: 'td', cls: [], id: '', attr: [] }, row).textContent = element;
                    }
                }
            }
            translatejs();
        })
        .catch(err => {
            //TODO ERROR HANDLING
            //console.log('ping err ->',err);
            //if()
            OpenModDialog({type:'error',title:["error"],msg:`${err}`,master_btn:['button_ok']})
        });
}

/**
 * The function `openTPFS` saves the provided parameters to local storage and then links to a file
 * named `tpfs.tcls`.
 * @param params - It looks like the `openTPFS` function is saving the `params` to the local storage
 * with the key 'tpfs' and then linking to 'tpfs.tcls'.
 */
function openTPFS(params) {
    saveToLocalStorage('tpfs',params)
    LinkTo('tpfs.tcls')
}

/**
 * The function AXIOS_logout sends a GET request to the specified URL for logging out and handles the
 * response or error accordingly.
 */
function AXIOS_logout() {
    axios.get(`${ baseURL }vmkservice/logout`)
        .then(response => {
        })
        .catch(err => {
            OpenModDialog({type:'error',title:["error"],msg:`${err}`,master_btn:['button_ok']})
        });
}

/**
 * The function `getCustomProtocol` updates the HTML elements based on the value of the `param`
 * parameter.
 * @param param - It looks like the `getCustomProtocol` function is designed to handle a parameter
 * called `param`. This parameter is used to determine whether certain elements on the page should be
 * hidden or modified based on its value.
 */
function getCustomProtocol(param) {
    console.log('getCustomProtocol',param);
    
    let holder = document.getElementById('no_custom');
    holder.innerHTML = ""
    if(param === false){
        let h3 = newElement({element:'h3',attr:[['key','custom_header_false']]},holder).innerHTML = '<!---->'
        //let ct = document.getElementById('custom_table')
        //ct.classList.add('hidden')
        let cph = document.getElementById('costom_protocol_holder')
        cph.classList.add('hidden')
        //let sc = document.getElementById('save_custom')
        //sc.classList.add('hidden')
    }
}

/* The above code is using JavaScript to create a setInterval function that runs every 1000
milliseconds (1 second). Within the setInterval function, it calls a function genCustom(), then
selects an element with the id 'CatTable' from the document. It clears the inner HTML of the
'CatTable' element. */
let inter = setInterval(()=> {
    renderCategoryView()
    clearInterval(inter);
  }, 1000);


let uploadedImageBase64 = '';

/**
 * The function `handleFileUpload` reads a file uploaded by the user, converts it to Base64 format, and
 * stores the Base64 data in a variable.
 * @param event - The `event` parameter in the `handleFileUpload` function typically represents the
 * event that triggered the file upload action, such as a user selecting a file using a file input
 * element. In this case, it is likely an event object that contains information about the file that
 * was selected by the user.
 */
function handleFileUpload(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            uploadedImageBase64 = e.target.result;
            //showImagePreview(uploadedImageBase64);
        };
        reader.readAsDataURL(file); // Konvertiert die Datei zu Base64
    }
}

/**
 * The function `showImagePreview` displays a base64 image as a background image in a specified
 * element.
 * @param base64Image - Base64Image is a string that represents an image encoded in base64 format. It
 * can be used to display the image preview on a web page.
 */
function showImagePreview(base64Image) {
    let d = document.getElementById('own_back');
    d.classList.remove('hidden');
    let x = document.getElementById('preview');
    x.style.backgroundImage = `url(${base64Image})`;
    //const previewDiv = document.getElementById('preview');
    //previewDiv.innerHTML = `<img src="${base64Image}" alt="Preview" style="max-width: 300px; max-height: 300px;">`;
}

/**
 * The function `saveImageToLocalStorage` checks if an image has been uploaded, shows a preview of the
 * image, and then saves the image data to local storage.
 */
function saveImageToLocalStorage() {
    if (uploadedImageBase64) {
        showImagePreview(uploadedImageBase64);
        script_setting.own_bg = uploadedImageBase64
        script_websocket.send(`set clientsettings ${JSON.stringify(script_setting)}`)
    } else {
        OpenModDialog({type:'warn',title:["config_image"],msg:`${aLangKeys[lang]['new_img']}`,master_btn:['button_ok']})
    }
}
  
let comp = setInterval(() => {
    console.log(script_setting.custom_protocol);
    if(script_setting.custom_protocol != false){
        document.getElementById('fileInput').addEventListener('change', handleFileUpload);
        document.getElementById('saveButton').addEventListener('click', saveImageToLocalStorage);
        let d = document.getElementById('upload_img')
        d.classList.remove('hidden')
    }
    if (script_setting.own_bg) {
        let d = document.getElementById('own_back');
        d.classList.remove('hidden');
        let x = document.getElementsByClassName('img_own')
        for (const element of x) {
        element.style.backgroundImage = `url(${script_setting.own_bg})`;
            
        }
        //x.src = script_setting.own_bg; // Base64-URL einfügen
    }
    clearInterval(comp);
  }, 1500);



  //SORT AND EDIT CUSTOM PROTOCOL INFORMATIONEN
  function renderCategoryView() {
    let container = document.getElementById("costom_protocol_holder");
    container.innerHTML = "";

    newElement({ element: "h2", cls: ["uk-modal-title"], attr: [["key", "my_cat"]] }, container).innerHTML = "<!--Cat-->";
    
    let divControls = newElement({ element: "div", cls: ["uk-margin"], attr: [["style", "display: flex;justify-content: space-between;align-items: center;align-content: flex-start;flex-direction: row;"]] }, container);
    newElement({ element: "input", id: "new-category", cls: ["uk-input"], attr: [["key-place", "sys_set_cat_name"]] }, divControls);
    newElement({ element: "button", cls: ["uk-button", "uk-button-primary", "mdi", "mdi-24px", "mdi-plus-box-outline"], attr: [["onclick", "addCategory()"]] }, divControls);
    newElement({ element: "button", cls: ["uk-button", "uk-button-secondary", "mdi", "mdi-24px", "mdi-content-save"], attr: [["onclick", "saveCategoryOrder()"]] }, divControls);
    
    let ul = newElement({ element: "ul", id: "category-list", cls: ["uk-grid-small", "uk-child-width-1-1"], attr: [["uk-sortable", "handle: .uk-card"], ["uk-grid", ""]] }, container);
    
    Object.keys(customJSN).forEach(category => {
        let li = newElement({ element: "li" }, ul);
        let div = newElement({ element: "div", cls: ["uk-card", "uk-card-default", "uk-card-body", "uk-text-center", "flex-between"] }, li);
        newElement({ element: "span", cls: ["uk-sortable-handle"], attr: [["uk-icon", "icon: table"]] }, div);
        newElement({ element: "a", attr: [["onclick", `renderFieldView('${category}')`]] }, div).innerHTML = category;
        let divButtons = newElement({ element: "div" }, div);
        newElement({ element: "button", cls: ["uk-button", "uk-button-default", "uk-button-small", "uk-margin-small-right", "mdi", "mdi-24px", "mdi-pencil-box-outline"], attr: [["onclick", `renderFieldView('${category}')`]] }, divButtons);
        newElement({ element: "button", cls: ["uk-button", "uk-button-error", "uk-button-small", "uk-margin-small-right", "mdi", "mdi-24px", "mdi-trash-can-outline"], attr: [["onclick", `deleteCategory('${category}')`]] }, divButtons);
    });

    translatejs();
    setupSortableCategory(); // Event-Listener für Sortierung aktivieren
}

function renderFieldView(category) {
    let container = document.getElementById("costom_protocol_holder");
    container.innerHTML = "";
    
    let title = newElement({ element: "h2", cls: ["uk-modal-title"], attr: [["style", "display:flex;"]] }, container);
    let input = newElement({ element: "input", cls: ["uk-input", "uk-form-width-medium"], attr: [["type", "text"], ["value", category], ["onchange", `renameCategory('${category}', this.value)`]] }, title);
    newElement({ element: "button", cls: ["uk-button", "uk-button-default", "mdi", "mdi-24px", "mdi-pencil-box-outline"] }, title);

    let divControls = newElement({ element: "div", cls: ["uk-margin"], attr: [["style", "display: flex;justify-content: space-between;align-items: center;align-content: flex-start;flex-direction: row;"]] }, container);
    newElement({ element: "input", id: "new-field", cls: ["uk-input"], attr: [["key-place", "sys_new_field"], ["placeholder", "Neues Feld"]] }, divControls);
    newElement({ element: "button", cls: ["uk-button", "uk-button-primary", "uk-margin-small-right", "mdi", "mdi-24px", "mdi-plus-box-outline"], attr: [["onclick", `addField('${category}')`]] }, divControls);
    newElement({ element: "button", cls: ["uk-button", "uk-button-secondary", "uk-margin-small-right", "mdi", "mdi-24px", "mdi-content-save"], attr: [["onclick", `saveFieldOrder('${category}')`]] }, divControls);
    newElement({ element: "button", cls: ["uk-button", "uk-button-secondary", "uk-margin-small-right"], attr: [["key", "btn_back"], ["onclick", "renderCategoryView()"]] }, divControls).innerHTML = "<!--back-->";

    let ul = newElement({ element: "ul", id: "field-list", cls: ["uk-grid-small", "uk-child-width-1-2"], attr: [["uk-sortable", "handle: .uk-card"], ["uk-grid", ""]] }, container);
    
    customJSN[category].forEach((field, index) => {
        let li = newElement({ element: "li" }, ul);
        let div = newElement({ element: "div", cls: ["uk-card", "uk-card-default", "uk-card-body", "uk-text-center", "flex-between"] }, li);
        newElement({ element: "span", cls: ["uk-sortable-handle"], attr: [["uk-icon", "icon: table"]] }, div);
        newElement({ element: "input", cls: ["uk-input", "uk-form-width-medium"], attr: [["type", "text"], ["value", field], ["style", "width: 20em;"], ["onchange", `renameField('${category}', ${index}, this.value)`]] }, div);
        newElement({ element: "button", cls: ["uk-button", "uk-button-error", "uk-button-small", "mdi", "mdi-24px", "mdi-trash-can-outline"], attr: [["onclick", `deleteField('${category}', ${index})`]] }, div);
    });

    translatejs();
    setupSortableFields(category);
}


/**
 * The function `renameCategory` renames a category in a JavaScript object if certain conditions are
 * met, otherwise it displays a warning notification.
 * @param oldName - The `oldName` parameter in the `renameCategory` function represents the current
 * name of the category that you want to rename.
 * @param newName - The `newName` parameter in the `renameCategory` function represents the new name
 * that you want to assign to a category. This parameter is used to update the name of a category in a
 * data structure (`customJSN` in this case) and perform related operations such as updating the UI and
 */
function renameCategory(oldName, newName) {
    if (newName.trim() && newName !== oldName && !customJSN[newName]) {
        customJSN[newName] = customJSN[oldName];
        delete customJSN[oldName];
        saveCostomJSN()
        renderFieldView(newName);
    } else{
        UIkit.notification({
            message: `${newName} ${aLangKeys[lang]['sys_exist']}`,
            status: 'warning',
            pos: 'top-right',
            timeout: 2500
        });
    }
}

/**
 * The function `renameField` renames a field in a specified category with a new value after performing
 * some validations.
 * @param category - Category refers to the group or type of data that the field belongs to. It could
 * be a specific category such as "colors", "sizes", "products", etc.
 * @param index - The `index` parameter in the `renameField` function represents the position of the
 * field within the specified `category` that you want to rename. It is used to access and update the
 * specific field in the `customJSN` object.
 * @param newValue - The `newValue` parameter in the `renameField` function represents the new value
 * that you want to assign to a specific field in the `customJSN` object. This value is trimmed to
 * remove any leading or trailing whitespace before being checked and updated in the `customJSN`
 * object. If
 * @returns If the `newValue` is empty after trimming or if the new name already exists in the
 * `customJSN[category]` array, a warning notification message will be displayed and the function will
 * return without making any changes. Otherwise, the function will update the value at the specified
 * index in the `customJSN[category]` array with the new value, update the
 * `script_setting.customprotocol
 */
function renameField(category, index, newValue) {
    newValue = newValue.trim();
    if (!newValue) return;
    // Prüfen, ob der neue Name bereits existiert
    if (customJSN[category].includes(newValue)) {
        UIkit.notification({
            message: `${newValue} ${aLangKeys[lang]['sys_exist']}`,
            status: 'warning',
            pos: 'top-right',
            timeout: 2500
        });
        return;
    }
    customJSN[category][index] = newValue;
    saveCostomJSN()
}

/**
 * The function `saveCategoryOrder` saves the order of categories based on their names in a custom JSON
 * object.
 */
function saveCategoryOrder() {
    let newOrder = [];
    document.querySelectorAll("#category-list li a").forEach(item => newOrder.push(item.innerText));
    let sortedJSN = {};
    newOrder.forEach(key => sortedJSN[key] = customJSN[key]);
    customJSN = sortedJSN;
    saveCostomJSN()
}

/**
 * The function `saveFieldOrder` saves the order of input fields within a specified category.
 * @param category - The `category` parameter in the `saveFieldOrder` function likely represents the
 * category or section to which the field order belongs. This function seems to be saving the order of
 * fields within a specific category by retrieving the values of input fields in a list and updating
 * the order in the `customJSN
 */
function saveFieldOrder(category) {
    let newOrder = [];
    document.querySelectorAll("#field-list li input").forEach(item => newOrder.push(item.value));
    customJSN[category] = newOrder;
    saveCostomJSN()
}

// Automatische Speicherung nach Sortierung aktivieren
/**
 * The function `setupSortableCategory` initializes a sortable feature for a list of categories and
 * triggers a function to save the category order when an item is moved.
 */
function setupSortableCategory() {
    setTimeout(() => {
        UIkit.sortable('#category-list'); // Neu initialisieren
        UIkit.util.on('#category-list', 'moved', function () {
            saveCategoryOrder();
        });
    }, 100);
}

/**
 * The function `setupSortableFields` initializes a sortable UI element for a field list and triggers a
 * function to save the field order when a field is moved.
 * @param category - Category is a variable that represents the category of fields being sorted. It is
 * used in the `saveFieldOrder` function to save the order of the fields within that specific category.
 */
function setupSortableFields(category) {
    setTimeout(() => {
        UIkit.sortable('#field-list'); // Neu initialisieren
        UIkit.util.on('#field-list', 'moved', function () {
            saveFieldOrder(category);
        });
    }, 100);
}

/**
 * The function `addCategory` adds a new category to a custom JavaScript object if it does not already
 * exist.
 */
function addCategory() {
    let newCategory = document.getElementById("new-category").value.trim();
    if (newCategory && !customJSN[newCategory]) {
        customJSN[newCategory] = [];
        renderCategoryView();
    }
}

/**
 * The function `deleteCategory` deletes a category from a JavaScript object and then renders the
 * updated category view.
 * @param category - The `category` parameter in the `deleteCategory` function represents the category
 * key that you want to delete from the `customJSN` object. If the `category` key exists in the
 * `customJSN` object, it will be deleted, and then the `renderCategoryView` function
 */
function deleteCategory(category) {
    if (customJSN[category]) {
        delete customJSN[category];
        renderCategoryView();
    }
}

/**
 * The `addField` function checks if a new field already exists in a specific category, displays a
 * warning message if it does, and adds the new field to the category if it doesn't.
 * @param category - The `category` parameter in the `addField` function represents the category to
 * which the new field will be added. It is used to determine where in the `customJSN` object the new
 * field should be stored and how the field view should be rendered after adding the new field.
 * @returns If the `newField` variable is empty (i.e., falsy), the function will return early and not
 * proceed with adding the field. If the new name already exists in the `customJSN[category]` array, a
 * warning notification will be displayed, and the function will return without adding the field.
 * Otherwise, if the new field is successfully added to the `customJSN[
 */
function addField(category) {
    let newField = document.getElementById("new-field").value.trim();
    if (!newField) return;
    
    // Prüfen, ob der neue Name bereits existiert
    if (customJSN[category].includes(newField)) {
        UIkit.notification({
            message: `${newField} ${aLangKeys[lang]['sys_exist']}`,
            status: 'warning',
            pos: 'top-right',
            timeout: 2500
        });
        return;
    }
    
    customJSN[category].push(newField);
    renderFieldView(category);
}


/**
 * The function `deleteField` removes an element at a specified index from an array within a specific
 * category in the `customJSN` object and then renders the updated view.
 * @param category - Category is a string representing the category of fields in the customJSN object
 * that you want to delete from.
 * @param index - The `index` parameter in the `deleteField` function represents the position of the
 * element within the array of the specified `category` that you want to delete. It is used to identify
 * which element to remove from the array.
 */
function deleteField(category, index) {
    if (customJSN[category] && customJSN[category].length > index) {
        customJSN[category].splice(index, 1);
        renderFieldView(category);
    }
}


function saveCostomJSN(){
    script_setting.customprotocol = customJSN;
    saveConfig();

    UIkit.notification({
        message: `${aLangKeys[lang]['save_data']}`,
        status: 'primary',
        pos: 'top-right',
        timeout: 2500
    });
}

//END SORT AND EDIT CUSTOM PROTOCOL


$( document ).ready(function() {
    
  });  