try {
    fetch("https://downloads.velometrik.de/infos.json")
    .then((res) => res.json())
    .then((data) => (Infos(data)));
    translatejs()
  } catch (error) {
    console.error(error);
  }

/**
 * The function `Infos` iterates through elements in a JSON object, checks if they are visible, and if
 * so, logs the element and fetches content from a provided link to display in a container.
 * @param jsn - The `jsn` parameter is expected to be an object containing an `infos` property, which
 * is an array of objects. Each object in the `infos` array should have a `visible` property that is a
 * string representing a boolean value ("true" or "false"), and a `link
 */
  function Infos(jsn){
    jsn.infos.forEach(element => {
        if(element.visible == "true"){
            console.log(element);
            var container = newElement({"element":"div","cls":["uk-container"]},document.getElementById('info-list'))
            try {
            fetch(element.link).then((res)=> res.text()).then((data)=>container.innerHTML = data)
            } catch (error) {
                console.error(error);
            }
        }
    });
  }

