"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* 
    Created on : 04.06.2021, 21:08:29
    Author     : Peter Bauer
*/
var host = location.origin;
var ws = host.replace('http', 'ws');
var apps = "satteldruckanalyse";
var client_name = localStorage.getItem('client_name');
var sessionID;

if (localStorage.getItem('session')) {
  if (localStorage.getItem('session').split(" ")[0] == 'restart') {
    sessionID = localStorage.getItem('session').split(" ")[1];
  }
} else {
  sessionID = localStorage.getItem('new_session');
}

if (localStorage.getItem('sessionID')) {
  sessionID = localStorage.getItem('sessionID');
}

var onsqlresult = null;
var load_num;
var galerie_image_info = {};
var recID;
var recData = {};
var gal = [];
var img1;
var img2;
var chk1;
var chk1;
var ch, cw;
var chart_a;
var chart_b;
var max = 0;
ch = document.getElementsByClassName("frameX")[0].offsetHeight;
cw = document.getElementsByClassName("frameX")[0].offsetWidth;
var sda_frame1 = "".concat(host, "/sattelbild?image=blank");
var sda_frame2 = "".concat(host, "/sattelbild?image=blank");
var sda_frame3 = "".concat(host, "/sattelbild?image=blank");
var canvas1 = new fabric.Canvas("canvas_1");
var canvas2 = new fabric.Canvas("canvas_2");
var mail = document.getElementById('mail'); //if(localStorage.getItem('client_mail') != "" && localStorage.getItem('client_mail').includes('@')){
//    mail.classList.remove('hidden')
//}

createCanvas(canvas1);
createCanvas(canvas2);
var BigImage = {}; // translatejs();

/**
 * This function takes a fabric.js canvas object and an image URL, and adds the image to the canvas.
 * @param params - the canvas object
 * @param img - The image to be loaded
 */

function setImage(params, img) {
  fabric.Image.fromURL(img, function (oImg) {
    oImg.scaleToWidth(cw);
    oImg.hasControls = false;
    oImg.set("selectable", false);
    params.add(oImg);
  });
}
/**
 * `createCanvas` is a function that takes a parameter called `params` and sets the `params.selection`
 * to `false`, `params.hasControls` to `false`, `params.lockMovement` to `false`, `params.setHeight` to
 * `ch`, and `params.setWidth` to `cw`
 * @param params - The object that contains the parameters for the canvas.
 */


function createCanvas(params) {
  params.selection = false; // disable group selection

  params.hasControls = false;
  params.lockMovement = false;
  params.setHeight(ch);
  params.setWidth(cw);
}

try {
  var sattelanalyse = new WebSocket("".concat(ws, "/apps/").concat(apps), ["soap", "wamp"]);
} catch (error) {
  getError(error);
}

_name(); // _sitzknochen();


_satteldruckanalyse();
/**
 * It gets the name from local storage and puts it in the right places
 */


function _name() {
  var auswertung_h3 = document.getElementsByClassName('headliner')[0];
  auswertung_h3.removeAttribute('key');
  auswertung_h3.innerHTML = "".concat(localStorage.getItem('client_forenames'), " ").concat(localStorage.getItem('client_surename'));
  document.getElementById('name_vorname').innerHTML = "".concat(localStorage.getItem('client_forenames'), " ").concat(localStorage.getItem('client_surename')); //document.getElementById('name_vorname').innerHTML = name[0]+', '+name[1] 
}
/**
 * It gets the data from the local storage and puts it into the HTML
 */


function _sitzknochen() {
  var sitzkochen = JSON.parse(localStorage.getItem('smartcube'));
  var sk = 0;

  if (!script_setting.UserUnit || script_setting.UserUnit === "cm") {
    sk = sitzkochen.sitzknochenabstand;
  }

  if (script_setting.UserUnit === "in") {
    sk = (sitzkochen.sitzknochenabstand / 2.54).toFixed(2);
  }

  document.getElementById('sitzknochenabstand').innerHTML = sk;
  document.getElementById('disbalance').innerHTML = sitzkochen.disbalance;
  document.getElementById('einsatzbereich').innerHTML = sitzkochen.einsatzbereich;
  document.getElementById('fahrgewohnheit').innerHTML = sitzkochen.fahrgewohnheit;
  document.getElementById('sitzposition').innerHTML = sitzkochen.sitzposition;
  document.getElementById('IMG').src = sitzkochen.img;
}
/**
 * It opens a websocket connection to the server, and sends a few commands to it
 */


function _satteldruckanalyse() {
  sattelanalyse.onopen = function (e) {
    rec_cancel(1);
    rec_cancel(2);
    onsqlresult = RowImg;
    sattelanalyse.send("sql select * from recordings where session_id=".concat(sessionID, " and analysis='2'")); // sattelanalyse.send(`session retrieve ${sessionID}`)

    sattelanalyse.send("session restart ".concat(sessionID));
    sattelanalyse.send('set compare on'); // sattelanalyse.send('get appquestions')

    sattelanalyse.send("analysis [\"sitbones\",\"anamnesis\",\"x1\"]");
    PrintLog(['_satteldruckanalyse', "sql select * from recordings where session_id=".concat(sessionID, " and analysis='2'")]);
    PrintLog(['_satteldruckanalyse', "session restart ".concat(sessionID)]);
    PrintLog(['_satteldruckanalyse', "set compare on"]);
    PrintLog(['_satteldruckanalyse', "analysis [\"sitbones\",\"anamnesis\",\"x1\"]"]);
  };
}
/**
 * The function `rec_cancel` sends a recording cancel command with a specified number and logs the
 * action.
 * @param num - The `num` parameter in the `rec_cancel` function represents the number associated with
 * the recording that you want to cancel. This number is used to identify the specific recording that
 * needs to be canceled.
 */


function rec_cancel(num) {
  sattelanalyse.send("recording cancel ".concat(num));
  PrintLog(["recording cancel ".concat(num)]);
} //var analysis = new Object();
//analysis.sitbones = new Object();
//analysis.anamnesis = new Object();
//analysis.x1 = new Object();
//{"sitbones":{"sitzknochenabstand":"","asymmetrie":""}}


var analysis = sessionStorage.getItem('analysis') ? JSON.parse(sessionStorage.getItem('analysis')) : {
  sitbones: {},
  anamnesis: {},
  x1: {}
};
var a = setInterval(function () {
  for (var key in analysis) {
    var element = analysis[key];
    console.log(element, key);

    for (var k in element) {
      var e = element[k];
      console.log(e, k);
      document.getElementById(k).value = e;
    }

    if (element.sitzknochenabstand) {}
  }

  clearInterval(a);
}, 1000);
sessionStorage.removeItem('analysis');
/**
 * The function `store` takes in a value, a key, and an analysis object, and stores the value in the
 * analysis object using the key. It then sends the updated analysis object to a server and logs the
 * action if the `log` variable is true.
 * @param val - The `val` parameter represents the value that you want to store in the `analysis`
 * object.
 * @param key - The `key` parameter is a string that represents the key or property name in the
 * `analysis` object. It is used to access and modify the value associated with that key in the
 * `analysis` object.
 * @param a - The parameter 'a' is used as an index to access a specific element in the 'analysis'
 * array.
 */

function store(val, key, a) {
  PrintLog(['store', val]);
  PrintLog(['store', key]);
  PrintLog(['store', a]);
  PrintLog(['store', analysis[a][key]]);
  analysis[a][key] = val;

  for (var _key in analysis) {
    var element = analysis[_key];
    sattelanalyse.send("analysis {\"".concat(_key, "\":").concat(JSON.stringify(element), "}"));
    if (log) console.log('store', "analysis {\"".concat(_key, "\":").concat(JSON.stringify(element), "}"));
  }
}
/**
 * The function `bigImage` adds a class to a canvas element and its parent element, and attaches a
 * click event listener to the canvas element.
 * @param num - The parameter `num` is used to identify the specific canvas element that needs to be
 * manipulated. It is used to generate the id of the canvas element by concatenating it with the string
 * "canvas_".
 */


function bigImage(num) {
  BigImage = document.getElementById("canvas_".concat(num));
  BigImage.classList.add('bigCanvas');
  BigImage.parentElement.classList.add('imgageBefore');
  document.getElementById("canvas_".concat(num)).addEventListener('click', imageBig);
}
/**
 * The function toggles the class of an image element to make it bigger or smaller when clicked.
 */


function imageBig() {
  console.log('click');

  if (BigImage.classList.contains("bigCanvas")) {
    BigImage.classList.toggle('bigCanvas');
    BigImage.parentElement.classList.toggle('imgageBefore');
    BigImage = {};
  }
}
/**
 * It takes a parameter, and logs it to the console
 * @param params - {
 */


function getLog(params) {
  console.log(params);
}
/**
 * `ClientInfo` is a function that takes a single parameter, `params`, and stores it in local storage
 * @param params - {
 */


function ClientInfo(params) {
  onsqlresult = getLog;
  saveToLocalStorage('client_info', JSON.stringify(params));
}
/**
 * It takes three arguments, sends a query to the database, and then creates a table with the results
 * of the query
 * @param {number}client_id - The client's ID
 * @param {string}name - The name of the client
 * @param {string}mail - The email address of the user.
 */


function info(client_id, name, fname, lname, mail, fc) {
  onsqlresult = ClientInfo;
  sattelanalyse.send("sql select * from sessions where client_id=".concat(client_id));
  append1 = document.getElementById('imagelist');
  append1.innerHTML = "";
  var inter = setInterval(function () {
    saveToLocalStorage('client_fc', fc);
    saveToLocalStorage('client_name', name);
    saveToLocalStorage('client_mail', mail);
    saveToLocalStorage('client_id', client_id);
    saveToLocalStorage('client_forenames', fname);
    saveToLocalStorage('client_surename', lname);
    location.href = "/production/client.tcls";
    clearInterval(inter);
  }, 500);
}

sattelanalyse.onmessage = function (e) {
  var data = JSON.parse(e.data);
  if (log) console.log('sattelanalyse.onmessage', data); // console.log(data);

  if (data.wsevent === "sda_int1") {
    // console.log("sda_init1",data);
    sda_frame1 = "".concat(host, "/sattelbild?image=sda_int1&rnd=").concat(new Date().getTime()); // document.getElementById('sda1').src = sda_frame1

    setImage(canvas1, sda_frame1);
  }

  if (data.wsevent === "sda_int2") {
    // console.log(data);
    sda_frame2 = "".concat(host, "/sattelbild?image=sda_int2&rnd=").concat(new Date().getTime()); // document.getElementById('sda2').src = sda_frame2

    setImage(canvas2, sda_frame2);
  }

  if (data.wsevent === "result1") {
    // console.log(data);
    result_1(data);
  }

  if (data.wsevent === "result2") {
    // console.log(data);
    result_2(data);
  }

  if (data.wsevent === "result3") {
    // console.log(data)
    galerie_image_info = data;
  }

  if (data.wsevent === "sqlresult") {
    // console.log(data)
    try {
      onsqlresult(data.rows);
    } catch (error) {
      getError(error);
    }
  }

  if (data.wsevent === "analyses") {
    var d = data.analyses;

    var _loop = function _loop(key) {
      var element = d[key];

      var _loop2 = function _loop2(key2) {
        var wait1 = setInterval(function () {
          var element2 = element[key2];
          var ele = document.getElementById(key2);

          if (ele) {
            ele.value = element2; // console.log(key,key2,element2);

            analysis[key][key2] = element2;
          }

          clearInterval(wait1);
        }, 1000);
      };

      for (var key2 in element) {
        _loop2(key2);
      }
    };

    for (var key in d) {
      _loop(key);
    }
  }

  if (data.wsevent === "sda_int3") {
    // console.log('sda_int3');
    var img = document.getElementsByClassName('imgGal1')[fi - 1];
    var _a = document.getElementsByClassName('imgGal2')[fi - 1];
    sda_frame3 = "".concat(host, "/sattelbild?image=sda_int3&rnd=").concat(new Date().getTime());
    img.src = sda_frame3;

    _a.setAttribute('onclick', "getImgData(".concat(fi - 1, ",this)"));

    gal[fi - 1] = JSON.stringify(galerie_image_info);
    recData[recID[fi - 1]] = JSON.stringify(galerie_image_info); //a.setAttribute('onclick',`sattelanalyse.send('recording retrieve ${recID[fi-1]} ${load_num}')`)

    if (galerie_image_info.pelvisrotation) pel = "".concat(galerie_image_info.pelvisrotation.width || "", ":").concat(galerie_image_info.pelvisrotation.height || "");else pel = "-";
    document.getElementsByClassName('info_img')[fi - 1].innerHTML = "\n            <ul class=\"uk-list uk-list-collapse\">\n            <li key=\"pro_satteldruck_veloscore\">Veloscore</li>\n            <li key=\"pro_satteldruck_becken\">Rotation</li>\n            <li key=\"pro_satteldruck_leftright\">Lins/Rechts</li>\n            <li key=\"pro_satteldruck_frontback\">Vorn/Hinten</li>\n            </ul>\n            <ul class=\"uk-list uk-list-collapse\">\n            <li>".concat(galerie_image_info.veloscore, "</li>\n            <li>").concat(pel, "</li>\n            <li>").concat(galerie_image_info.left_right, "</li>\n            <li>").concat(galerie_image_info.front_rear, "</li>\n            </ul>\n            <textarea readonly class=\"uk-textarea\" style=\"width:150px;height: 60px;margin-left:30px \">").concat(galerie_image_info.notes, "</textarea>");
    document.getElementsByClassName('name_img')[fi - 1].innerHTML = "\n           <h2 class=\"uk-text-center\">".concat(galerie_image_info.product_label || aLangKeys[lang]['sda_marke'], "</h2>\n           <p class=\"uk-text-center\"><small>").concat(galerie_image_info.product || aLangKeys[lang]['sda_typ'], "</small></p>");
    /* Sending a message to the sattelanalyse object. */

    if (recID[fi]) {
      sattelanalyse.send("recording retrieve ".concat(recID[fi], " 3"));
      fi++;
    }
  }

  if (data.wsevent === "appquestions") {
    console.log(data.appquestions);
  }
};
/**
 * It sends a SQL query to the server, and when the server responds, it calls the function RowImg
 * @param num - the number of the recording to load
 */


function load_rec(num) {
  load_num = num;
  var btn = document.getElementById('img_select_btn');
  btn.setAttribute('disabled', ''); // console.log('load ',num);
  //if(localStorage.getItem('sessionID')){

  onsqlresult = RowImg;
  sattelanalyse.send("sql select * from recordings WHERE analysis=2 AND session_id=".concat(sessionID)); //}
  //if(!localStorage.getItem('sessionID')){
  // onsqlresult = getSession
  // sattelanalyse.send(`sql SELECT next_id from nextids n WHERE table_name = 'sessions'`)
  // let getrow = setInterval(function () {
  //  onsqlresult = RowImg
  //  sattelanalyse.send(`sql select * from recordings WHERE analysis=2 AND session_id=${localStorage.getItem('new_session')}`)
  //  clearInterval(getrow);
  //}, 1000);
  //}

  UIkit.modal($('#modal-center-load1')).show();
}

var sess;
/**
 * This function is called when the database returns a result from the query. It takes the result as a
 * parameter and sets the local storage variable 'new_session' to the next available session id
 * @param params - [{next_id: 1}]
 */

function getSession(params) {
  onsqlresult = getLog; // console.log(params);

  params.forEach(function (element) {
    // console.log(element.next_id-1);
    sess = element.next_id - 1;
    console.log(sess);
    saveToLocalStorage('new_session', element.next_id - 1);
  });
}
/**
 * The function `getImgData` retrieves image data, updates styles, sets button functionality, sends
 * data to a server, and triggers a chart display.
 * @param num - The `num` parameter in the `getImgData` function is used to specify the index or
 * identifier of the image data that you want to retrieve and display. It is likely used to access
 * specific data or elements related to a particular image in a gallery or collection.
 * @param ele - The `ele` parameter in the `getImgData` function represents the HTML element that
 * triggered the function. It is typically an image element that the user interacts with, such as
 * clicking on an image in a gallery.
 */


function getImgData(num, ele) {
  galerie_image_info = JSON.parse(gal[num]);
  var noselect1 = document.getElementsByClassName('imgGal2');
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = noselect1[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var iterator = _step.value;
      iterator.removeAttribute('style');
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator["return"] != null) {
        _iterator["return"]();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  var noselect2 = document.getElementsByClassName('flex-column-center');
  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = noselect2[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      var _iterator3 = _step2.value;

      _iterator3.removeAttribute('style');
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
        _iterator2["return"]();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }

  ele.setAttribute('style', 'scale:1.2;transition: all 0.3s linear;');
  ele.firstChild.setAttribute('style', 'box-shadow:0 0 1em var(--primary);border-radius:0.5em;transition: all 0.3s linear;');
  var btn = document.getElementById('img_select_btn');
  btn.setAttribute('onclick', "sattelanalyse.send('recording retrieve ".concat(recID[num], " ").concat(load_num, "')"));
  btn.removeAttribute("disabled");
  sattelanalyse.send("recording retrieve ".concat(recID[num], " ").concat(load_num));
  var chart_a = document.getElementById("canvas".concat(load_num, "_3d")); //   chart_b = document.getElementById('canvas2_3d')

  chart_a.setAttribute('onclick', "OpenChart(".concat(recID[num], ")")); //   chart_b.setAttribute('onclick',`OpenChart(${recID[recID.length-1]})`)

  translatejs();
}

check_img_detail.addEventListener('change', function () {
  var detail = document.getElementsByClassName('detail');

  if (this.checked) {
    var _iteratorNormalCompletion3 = true;
    var _didIteratorError3 = false;
    var _iteratorError3 = undefined;

    try {
      for (var _iterator4 = detail[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator4.next()).done); _iteratorNormalCompletion3 = true) {
        var iterator = _step3.value;
        iterator.classList.remove('hidden');
      }
    } catch (err) {
      _didIteratorError3 = true;
      _iteratorError3 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion3 && _iterator4["return"] != null) {
          _iterator4["return"]();
        }
      } finally {
        if (_didIteratorError3) {
          throw _iteratorError3;
        }
      }
    }
  } else {
    var _iteratorNormalCompletion4 = true;
    var _didIteratorError4 = false;
    var _iteratorError4 = undefined;

    try {
      for (var _iterator5 = detail[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator5.next()).done); _iteratorNormalCompletion4 = true) {
        var _iterator6 = _step4.value;

        _iterator6.classList.add('hidden');
      }
    } catch (err) {
      _didIteratorError4 = true;
      _iteratorError4 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion4 && _iterator5["return"] != null) {
          _iterator5["return"]();
        }
      } finally {
        if (_didIteratorError4) {
          throw _iteratorError4;
        }
      }
    }
  }
});
/**
 * The function `open_img` displays a modal centered on the screen with the specified parameters.
 * @param params - The `params` parameter in the `open_img` function is used to specify the ID of the
 * image modal that you want to open.
 */

function open_img(params) {
  UIkit.modal($('#modal-center-load' + params)).show();
}
/**
 * The function "load" sends a request to retrieve a recording with specific parameters and logs the
 * action if the "log" variable is true.
 * @param params - The `params` variable in the `load` function likely contains additional information
 * or settings needed for retrieving a recording with a specific `id`. It could include things like
 * authentication tokens, query parameters, or any other data required to successfully retrieve the
 * recording.
 * @param id - The `id` parameter in the `load` function is used to specify the identifier of the
 * recording that needs to be retrieved.
 */


function load(params, id) {
  sattelanalyse.send("recording retrieve ".concat(id, " ").concat(params));

  if (log) {
    console.log('load', "recording retrieve ".concat(id, " ").concat(params));
  }
}

var DelImg;
/**
 * The function `openDelDialog` opens a modal dialog box to confirm deletion of an image.
 * @param params - It seems like the `params` variable is being used to pass some data to the
 * `openDelDialog` function. In this case, `params` likely contains information about the image that is
 * going to be deleted. This information could include details such as the image name, size, or any
 * other
 */

function openDelDialog(params) {
  DelImg = params;
  OpenModDialog({
    type: 'warn',
    title: ["del_img_title"],
    msg: ["del_img"],
    master_btn: ['button_delete', 'del_img()'],
    slave_btn: ['button_cancel']
  }); //UIkit.modal($('#modal-mod_DelImg')).show();
}
/**
 * The function `del_img` sends a SQL query to delete a record from a table, logs the action if a
 * condition is met, and then reloads the page.
 */


function del_img() {
  sattelanalyse.send("sql DELETE FROM recordings WHERE recording_id=".concat(DelImg));

  if (log) {
    console.log('del img', "sql DELETE FROM recordings WHERE recording_id=".concat(DelImg));
  }

  location.reload();
}
/**
 * The function result_1 takes in parameters and updates specific elements in the HTML document based
 * on the values of those parameters.
 * @param params - The `params` object contains the following properties:
 */


function result_1(params) {
  if (log) console.log('result_1', params);
  document.getElementById('S1').innerHTML = params.product;
  document.getElementById('T1').innerHTML = params.product_label;
  document.getElementById('v1').innerHTML = params.front_rear;
  document.getElementById('l1').innerHTML = params.left_right;
  document.getElementById('V1').innerHTML = params.veloscore;
  if (params.pelvisrotation) document.getElementById('B1').innerHTML = "".concat(params.pelvisrotation.center.x || "", "x").concat(params.pelvisrotation.center.y || "") || "";
  document.getElementById('N1').innerHTML = params.notes;
}
/**
 * The function result_2 takes in a parameter object and updates specific elements in the HTML document
 * with values from the parameter object.
 * @param params - It looks like you haven't provided the actual parameters for the `result_2`
 * function. Could you please provide the values for `params` so that I can assist you further with
 * this function?
 */


function result_2(params) {
  if (log) console.log('result_2', params);
  document.getElementById('S2').innerHTML = params.product;
  document.getElementById('T2').innerHTML = params.product_label;
  document.getElementById('v2').innerHTML = params.front_rear;
  document.getElementById('l2').innerHTML = params.left_right;
  document.getElementById('V2').innerHTML = params.veloscore;
  if (params.pelvisrotation) document.getElementById('B2').innerHTML = "".concat(params.pelvisrotation.center.x || "", "x").concat(params.pelvisrotation.center.y || "") || "";
  document.getElementById('N2').innerHTML = params.notes;
}

var edit = false;
/**
 * The Edit_rec function in JavaScript allows users to edit and save records by replacing text content
 * with input fields.
 * @param num - The `Edit_rec` function takes a parameter `num`, which is used to identify the specific
 * record that needs to be edited. This parameter is used to target elements with corresponding IDs in
 * the HTML document.
 */

function Edit_rec(num) {
  if (edit === false) {
    var save = document.getElementById("save_rec_".concat(num));
    var prod = document.getElementById("S".concat(num));
    var prod_T = document.getElementById("S".concat(num)).innerHTML;
    var label = document.getElementById("T".concat(num));
    var label_T = document.getElementById("T".concat(num)).innerHTML;
    var note = document.getElementById("N".concat(num));
    var note_T = document.getElementById("N".concat(num)).innerHTML;
    var save_btn = newElement({
      element: 'button',
      cls: ['uk-button', 'uk-button-primary'],
      attr: [['onclick', "Save_rec(".concat(num, ")")]]
    }, save).innerHTML = 'save';
    prod.innerHTML = "";
    label.innerHTML = "";
    note.innerHTML = "";
    var E_prod = newElement({
      element: 'input',
      id: "e_prod_".concat(num),
      cls: ['uk-input'],
      attr: [['value', prod_T]]
    }, prod);
    var E_label = newElement({
      element: 'input',
      id: "e_label_".concat(num),
      cls: ['uk-input'],
      attr: [['value', label_T]]
    }, label);
    var E_note = newElement({
      element: 'textarea',
      id: "e_note_".concat(num),
      cls: ['uk-textarea'],
      attr: [['value', note_T]]
    }, note).innerHTML = note_T;
    edit = true;
  }
}
/**
 * The function `Save_rec` saves input values for product, product label, and notes into designated
 * elements and logs a message with the saved data.
 * @param num - The `num` parameter in the `Save_rec` function represents the store number that is
 * being recorded. It is used to identify and save the product information, product label, and notes
 * for that specific store.
 */


function Save_rec(num) {
  //recording store 1 {"product":"(Marke)","product_label":"(Typ)","notes":" "}
  var save = document.getElementById("save_rec_".concat(num));
  save.innerHTML = "";
  var prod = document.getElementById("e_prod_".concat(num)).value;
  var label = document.getElementById("e_label_".concat(num)).value;
  var note = document.getElementById("e_note_".concat(num)).value;
  var prod_T = document.getElementById("S".concat(num)).innerHTML = prod;
  var label_T = document.getElementById("T".concat(num)).innerHTML = label;
  var note_T = document.getElementById("N".concat(num)).innerHTML = note;
  console.log("recording store ".concat(num, " {\"product\":\"").concat(prod, "\",\"product_label\":\"").concat(label, "\",\"notes\":\"").concat(note, "\"}"));
  sattelanalyse.send("recording store ".concat(num, " {\"product\":\"").concat(prod, "\",\"product_label\":\"").concat(label, "\",\"notes\":\"").concat(note, "\"}"));
  edit = false;
}
/**
 * The function `RowImg` creates and appends elements to display a list of images with associated
 * information, and sets click events on charts based on the data provided.
 * @param params - It looks like the code snippet you provided is a JavaScript function called `RowImg`
 * that takes in a parameter `params` and performs some operations based on the elements in `params`.
 */


function RowImg(params) {
  console.log(params);
  fi = 0;
  recID = [];
  onsqlresult = getLog;
  var append1 = document.getElementById('img_list2'); //('img_gal')

  append1.innerHTML = "";
  params.forEach(function (element) {
    if (fi === 0) {
      sattelanalyse.send("recording retrieve ".concat(element.recording_id, " 3"));
      fi++;
    }

    recID.push(element.recording_id);
    var master = newElement({
      element: 'div',
      id: "img_".concat(element.recording_id),
      cls: ['imgGal2']
    }, append1);
    var div = newElement({
      element: 'div',
      id: "sel_".concat(element.recording_id),
      cls: ['flex-column-center']
    }, master);
    var date = newElement({
      element: 'p',
      cls: ['uk-text-center']
    }, master).innerHTML = element.finished;
    var div_name = newElement({
      element: 'div',
      cls: ['name_img']
    }, div);
    var img = newElement({
      element: 'img',
      cls: ['imgGal1'],
      attr: [['width', '100'], ['height', '100']]
    }, div);
    var div2 = newElement({
      element: 'div',
      attr: [['style', 'width: 150px']]
    }, div);
    var div_info = newElement({
      element: 'div',
      cls: ['uk-grid', 'uk-child-width-1-2', 'info_img', 'detail', 'hidden'],
      attr: [['style', 'margin: 0 -30px;']]
    }, div2);
    var chk = document.getElementById('check_img_detail');

    if (chk.checked) {
      div_info.classList.remove('hidden');
    }
  });
  var chart_a = document.getElementById('canvas1_3d');
  var chart_b = document.getElementById('canvas2_3d');

  if (load_num == 1) {
    chart_a.setAttribute('onclick', "OpenChart(".concat(recID[0], ")"));
  } else {
    if (load_num == 2) {} else {
      chart_a.setAttribute('onclick', "OpenChart(".concat(recID[0], ")"));
    }

    chart_b.setAttribute('onclick', "OpenChart(".concat(recID[recID.length - 1], ")"));
  }
}
/**
 * The function `selectImg` is used to handle the selection and deselection of images based on certain
 * conditions and update corresponding values and classes accordingly.
 * @param params - The `params` object seems to contain information related to an image element. The
 * function `selectImg` is designed to handle the selection and deselection of images based on certain
 * conditions and user interactions.
 * @returns The `selectImg` function returns different actions based on the conditions met within the
 * function. Here are the possible return scenarios:
 */


function selectImg(params) {
  var id = params.id.split('_')[1];

  if (chk1.value === "0") {
    if (params.classList.contains('selected')) {
      return;
    }

    console.log("".concat(id, " selected 1"));
    sattelanalyse.send("recording retrieve ".concat(id, " 1"));
    chart_a.setAttribute('onclick', "OpenChart(".concat(id, ")"));
    chk1.value = id;
    params.classList.add('selected', 'mdi-checkbox-marked-circle-outline');
    params.classList.remove('unselect', 'mdi-checkbox-blank-circle-outline');
    return;
  }

  if (chk2.value === "0") {
    if (params.classList.contains('selected')) {
      return;
    }

    console.log("".concat(id, " selected 2"));
    sattelanalyse.send("recording retrieve ".concat(id, " 2"));
    chart_b.setAttribute('onclick', "OpenChart(".concat(id, ")"));
    chk2.value = id;
    params.classList.add('selected', 'mdi-checkbox-marked-circle-outline');
    params.classList.remove('unselect', 'mdi-checkbox-blank-circle-outline');
    return;
  }

  if (chk1.value === id) {
    console.log("".concat(id, " deselected 1"));
    chk1.value = 0;
    params.classList.add('unselect', 'mdi-checkbox-blank-circle-outline');
    params.classList.remove('selected', 'mdi-checkbox-marked-circle-outline');
    return;
  }

  if (chk2.value === id) {
    console.log("".concat(id, " deselected 2"));
    chk2.value = 0;
    params.classList.add('unselect', 'mdi-checkbox-blank-circle-outline');
    params.classList.remove('selected', 'mdi-checkbox-marked-circle-outline');
    return;
  }
}
/**
 * The function `generateData` processes a 2D array to generate data points and find the maximum value
 * within the array.
 * @param dd - It looks like the code snippet you provided is a function called `generateData` that
 * takes a parameter `dd`. The function iterates over a 2D array `kuenzel2` and pushes elements into a
 * new array `data`. It also calculates the maximum value found in the 2
 * @returns The function `generateData` is returning an array of data that is generated based on the
 * input `dd`. The data consists of arrays containing three elements: the indices `i` and `j`, and the
 * value at that position in the `kuenzel2` array. The function also logs the `ArrayData` and the `MAX`
 * value to the console.
 */


function generateData(dd) {
  max = 0;
  console.log('ArrayData', dd);
  var data = [];
  var kuenzel2 = dd;

  for (var i = 0; i < 28; i++) {
    for (var j = 15; j >= 0; j--) {
      if (Number(kuenzel2[i][j]) > max) max = kuenzel2[i][j];
      data.push([i, j, "".concat(kuenzel2[i][j])]);
    }
  }

  console.log('MAX', max);
  return data;
}

var SetMax = false;
var newMax = 0;
/**
 * The function setMax sets a new maximum value based on the input parameter.
 * @param params - It looks like the `setMax` function is intended to set a maximum value. The `params`
 * variable should contain the value that you want to set as the new maximum. You can call the `setMax`
 * function with the desired value as the argument for `params`. For example, `setMax(
 */

function setMax(params) {
  SetMax = true;
  newMax = params;
}

var dom = document.getElementById('chart-container');
var myChartX = echarts.init(dom, 'dark', {
  renderer: 'canvas',
  useDirtyRect: false
});
/**
 * The function `setChartType` sets the type of chart and its options based on the parameters provided.
 * @param params - The `params` variable in the `setChartType` function represents the type of chart
 * that you want to set. It could be a string value such as 'line', 'bar', 'pie', 'scatter', etc.,
 * depending on the type of chart you want to display.
 */

function setChartType(params) {
  myChartX.setOption(option = {
    series: [{
      type: params,
      data: Cdata,
      symbolSize: 15,
      shading: 'realistic',
      //color,lambert,realistic
      animation: false,
      label: {
        fontSize: 16,
        borderWidth: 1
      },
      emphasis: {
        label: {
          fontSize: 20,
          color: '#00000000'
        },
        itemStyle: {
          color: '#000000'
        }
      }
    }]
  });
}
/**
 * The function setView adjusts the view control settings of a 3D chart in JavaScript.
 * @param x - The `x` parameter in the `setView` function represents the alpha value for the view
 * control in a 3D chart. It determines the horizontal rotation angle of the chart view.
 * @param y - The parameter `y` in the `setView` function corresponds to the beta angle in the
 * `viewControl` option of the 3D chart. It controls the vertical rotation of the chart view. Changing
 * the `y` value will adjust the vertical angle at which the chart is viewed.
 */


function setView(x, y) {
  myChartX.setOption(option = {
    grid3D: {
      boxWidth: 28 * 10,
      boxDepth: 16 * 10,
      axisLine: {
        lineStyle: {
          color: '#99999900'
        }
      },
      axisPointer: {
        lineStyle: {
          color: '#99999900'
        }
      },
      viewControl: {
        distance: 300,
        alpha: x,
        beta: y
      },
      //light: {
      //  main: {
      //    shadow: true,
      //    intensity: 1
      //  }
      //}
      light: {
        main: {
          intensity: 1.2,
          shadow: true
        },
        ambient: {
          intensity: 0.3
        }
      }
    }
  });
}

var Cdata;
/**
 * The `heatchart` function generates a 3D bar chart visualization using input data and various
 * configurations.
 * @param data - It looks like the code you provided is a function called `heatchart` that generates a
 * 3D bar chart using ECharts library based on the input data. The function processes the input data,
 * sets up the chart configuration, and then renders the chart.
 * @returns The `heatchart` function does not explicitly return any value. It is primarily responsible
 * for generating a 3D bar chart visualization using the provided data and rendering it on a web page
 * using ECharts library. The function processes the input data, sets various chart options, and then
 * renders the chart.
 */

function heatchart(data) {
  var saddle = JSON.parse(recData[open_chartID]); //console.log('Sattel',saddle);

  var dd = [];
  data.forEach(function (element) {
    var d = element.pressure_values.split(' ');
    var tmp = [];

    for (var i = 0; i < d.length; i++) {
      tmp.push(d[i]);

      if (tmp.length == 16) {
        dd.push(tmp);
        tmp = [];
      }
    } // console.log(dd);

  }); //var dom = document.getElementById('chart-container');
  //var myChartX = echarts.init(dom, 'dark', {
  //  renderer: 'canvas',
  //  useDirtyRect: false
  //});
  //inRange: {
  //    color: [
  //      '#00000000',
  //      '#0000ff',
  //      '#00ff00',
  //      '#ffff00',
  //      '#ff0000'
  //    ]
  //  }

  var option;
  var ColorRange = ['#00000000', '#0000ff', '#00ff00', '#ffff00', '#ff0000']; //var ColorRange = ['#00000000','#00ff00', '#33cc33', '#66aa66', '#999999', '#cc6666', '#ff3333', '#ff0000'];
  //var ColorRange = ['#ff0000','#ffff00','#00000000','#00ff00','#0000ff',] //negative

  $.getScript('/production/js/chart/simplex-noise.js').done(function () {
    //  max = 0;
    Cdata = generateData(dd);
    myChartX.setOption(option = {
      backgroundColor: '#ffffffff',
      visualMap: {
        show: false,
        //true
        calculable: true,
        min: 0,
        max: max,
        inRange: {
          color: ColorRange
        }
      },
      xAxis3D: {
        type: 'category'
      },
      yAxis3D: {
        type: 'category'
      },
      zAxis3D: {
        type: 'value',
        max: 0,
        min: max * 2
      },
      toolbox: {
        show: true,
        orient: 'vertical',
        itemsize: 16,
        iconStyle: {
          //color: '#000'
          borderColor: '#999',
          borderWidth: 1
        },
        left: 10,
        feature: {
          //magicType: {
          //    type: ["line3D", "bar3D","scatter3D","surface"]
          //}, 
          //dataZoom: { show: true }, 
          //dataView: { show: true },
          saveAsImage: {
            show: true,
            name: "".concat(saddle.product || 'NO_PRODUCT', "-").concat(saddle.product_label || 'NO_TYPE'),
            type: 'png',
            pixelRatio: 2
          }
        }
      },
      grid3D: {
        boxWidth: 28 * 10,
        boxDepth: 16 * 10,
        axisLine: {
          lineStyle: {
            color: '#99999900'
          }
        },
        axisPointer: {
          lineStyle: {
            color: '#99999900'
          }
        },
        viewControl: {
          distance: 300,
          alpha: 35,
          beta: 120
        },
        //light: {
        //  main: {
        //    shadow: true,
        //    intensity: 1
        //  }
        //}
        light: {
          main: {
            intensity: 1.2,
            shadow: true
          },
          ambient: {
            intensity: 0.3
          }
        }
      },
      series: [{
        type: 'bar3D',
        //line3D, bar3D,scatter3D,surface
        data: Cdata,
        shading: 'lambert',
        //color,lambert,realistic
        symbolSize: function symbolSize(value) {
          // Customize the size of the data points based on the values
          return Math.abs(value[2]) + 10; // Use the absolute value of the Z coordinate
        },
        //  animation:false,
        label: {
          fontSize: 16,
          borderWidth: 1,
          show: false
        },
        emphasis: {
          label: {
            fontSize: 20,
            color: '#00000000',
            show: true
          },
          itemStyle: {
            color: '#000000'
          }
        }
      }]
    });
  });

  if (option && _typeof(option) === 'object') {
    myChartX.setOption(option);
  }

  window.addEventListener('resize', myChartX.resize);
}

var open_chartID;
/**
 * The function `OpenChart` logs the loaded `id` and sends a SQL query to retrieve pressure values for
 * a specific recording ID, then displays a chart modal.
 * @param id - The `id` parameter in the `OpenChart` function is used to specify the ID of the chart
 * that you want to open. This function logs a message indicating that a specific ID has been loaded,
 * sets the `open_chartID` variable to the provided ID, specifies the `onsqlresult
 */

function OpenChart(id) {
  console.log("%c loaded id = ".concat(id), 'background: #222;color:#5cbc40;padding:1em');
  open_chartID = id;
  onsqlresult = heatchart;
  sattelanalyse.send("sql select pressure_values from recordings where recording_id = ".concat(id));
  UIkit.modal('#chart_modal').show();
}

var line_length = 532;
/**
 * The function `PDFgenGal` generates a PDF document containing a gallery of images based on the
 * client's name and image elements on the webpage.
 */

function PDFgenGal() {
  var name = localStorage.getItem('client_name').split(' ');
  var content = [{
    text: "".concat(aLangKeys[lang]['pro_tab_galerie'], " - ").concat(name[1], " ").concat(name[0]),
    style: 'header'
  }, '\n', {
    canvas: [{
      type: 'line',
      x1: 0,
      y1: 0,
      x2: line_length,
      y2: 0,
      lineWidth: 1
    }]
  }, '\n'];
  var contentObj = {};
  var columns = [];
  var tmp = {};
  var _iteratorNormalCompletion5 = true;
  var _didIteratorError5 = false;
  var _iteratorError5 = undefined;

  try {
    var _loop3 = function _loop3() {
      var i = _step5.value;
      // let canvasGal = new fabric.Canvas("canvas_3");
      // createCanvas(canvasGal)
      var image = i;

      var toDataURL = function toDataURL() {
        var canvas = document.createElement('canvas'); // We use naturalWidth and naturalHeight to get the real image size vs the size at which the image is shown on the page

        canvas.width = image.naturalWidth;
        canvas.height = image.naturalHeight; // We get the 2d drawing context and draw the image in the top left

        canvas.getContext('2d').drawImage(image, 0, 0); // Convert canvas to DataURL and log to console

        var dataURL = canvas.toDataURL(); // console.log(dataURL);
        // logs data:image/png;base64,wL2dvYWwgbW9yZ...

        var x = new Object();
        x.image = dataURL;
        x.width = 150;
        columns.push(x);
        console.log(columns.length);

        if (columns.length % 3 == 0) {
          tmp.alignment = "justify";
          tmp.columns = columns;
          content.push(tmp);
          content.push("\n");
          tmp = {};
          columns = [];
        }
      }; // If the image has already loaded, let's go!


      if (image.complete) toDataURL(image); // Wait for the image to load before converting
      else image.onload = toDataURL;
    };

    for (var _iterator7 = document.getElementsByClassName('imgGal1')[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator7.next()).done); _iteratorNormalCompletion5 = true) {
      _loop3();
    }
  } catch (err) {
    _didIteratorError5 = true;
    _iteratorError5 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion5 && _iterator7["return"] != null) {
        _iterator7["return"]();
      }
    } finally {
      if (_didIteratorError5) {
        throw _iteratorError5;
      }
    }
  }

  contentObj.alignment = "justify";
  contentObj.columns = columns;
  console.log("A", content);
  content.push(contentObj);
  console.log("B", content); // console.log(content);

  var dd = {
    content: content,
    styles: {
      header: {
        fontSize: 18,
        bold: true
      },
      bigger: {
        fontSize: 15,
        italics: true
      },
      small: {
        fontSize: 10
      }
    },
    defaultStyle: {
      columnGap: 20
    }
  };
  pdfMake.createPdf(dd).open();
}

var content = [];
var dd = {};
var zweispalten = 'true';

function PDFgen() {
  var content = [];
  var dd = {};
  var sk_text = "";
  var sk = document.getElementById('sitzknochenabstand').value || "0";

  if (!script_setting.UserUnit || script_setting.UserUnit === "cm") {
    sk_text = "".concat(sk, " cm");
  }

  if (script_setting.UserUnit === "in") {
    sk_text = "".concat((sk / 2.54).toFixed(2), " in");
  }

  var img1 = canvas1.toDataURL({
    format: "png",
    quality: 100,
    width: cw,
    height: ch,
    crossOriginIsolated: false
  });
  var img2 = canvas2.toDataURL({
    format: "png",
    quality: 100,
    width: cw,
    height: ch,
    crossOriginIsolated: false
  });
  var name = localStorage.getItem('client_name').split(' ');
  var text = script_setting.UserEinleitung && script_setting.UserEinleitung !== "" ? script_setting.UserEinleitung : aLangKeys[lang]['pro_einleitung']; //DECKBLATT

  content.push({
    text: "".concat(aLangKeys[lang]['pro_bikefit']),
    style: ['header', 'bold', 'center']
  });
  content.push({
    text: "".concat(aLangKeys[lang]['pro_head']),
    style: ['header', 'bold', 'center']
  });
  content.push('\n');
  content.push({
    text: "".concat(localStorage.getItem('client_forenames'), " ").concat(localStorage.getItem('client_surename')),
    style: ['XXL', 'bold', 'center']
  });

  if (localStorage.getItem('session_note') !== '') {
    content.push({
      text: "".concat(localStorage.getItem('session_note')),
      style: ['bigger', 'bold', 'center']
    });
  }

  content.push({
    text: "".concat(new Date().toISOString().split('T')[0]),
    style: ['small', 'center']
  });
  content.push('\n');
  content.push({
    text: "".concat(text)
  });
  content.push('\n');

  if (script_setting.UserCompany) {
    content.push({
      text: "".concat(script_setting.UserCompany),
      style: ['center', 'bigger', 'bold']
    });
  }

  if (script_setting.UserStreet || script_setting.UserCity) {
    content.push('\n');
  }

  if (script_setting.UserStreet) {
    content.push({
      text: "".concat(script_setting.UserStreet),
      style: 'center'
    });
  }

  if (script_setting.UserCity) {
    content.push({
      text: "".concat(script_setting.UserCity),
      style: 'center'
    });
  }

  if (script_setting.UserMail || script_setting.UserWeb) {
    content.push('\n');
  }

  if (script_setting.UserMail) {
    content.push({
      text: "".concat(script_setting.UserMail),
      style: 'center'
    });
  }

  if (script_setting.UserWeb) {
    content.push({
      text: "".concat(script_setting.UserWeb),
      style: 'center'
    });
    content.push('\n');
    content.push({
      qr: "".concat(script_setting.UserWeb),
      fit: 50,
      style: 'center'
    });
  }

  content.push({
    text: "",
    pageBreak: 'after'
  }); // // DECKBLATT

  if ($('#check_anamnesis').is(':checked')) {
    content.push({
      text: "".concat(aLangKeys[lang]['pro_anamnese']),
      style: 'bigger',
      bold: true,
      pageNumbers: [1]
    });
    content.push('\n');
    content.push({
      canvas: [{
        type: 'line',
        x1: 0,
        y1: 0,
        x2: line_length,
        y2: 0,
        lineWidth: 1
      }],
      pageNumbers: [1]
    });
    content.push('\n'); //  content.push({
    //    alignment: 'justify',
    //    columns:[
    //        {
    //            text:   `${aLangKeys[lang]['pro_name_vorname']}\n
    //                     ${aLangKeys[lang]['pro_sitzknochenabstand']}\n
    //                     ${aLangKeys[lang]['pro_disbalance']}`
    //            ,style:  'small'
    //        },
    //        {
    //            text:   `${localStorage.getItem('client_name')}\n
    //                     ${sk_text}\n
    //                     ${aLangKeys[lang]['pro_dis_'+document.getElementById('asymmetrie').value]}`
    //                     ,style:  'small'
    //        },
    //        {
    //            text:   `${aLangKeys[lang]['pro_einsatz']}\n
    //                     ${aLangKeys[lang]['pro_fahrgewohnheit']}\n
    //                     ${aLangKeys[lang]['pro_Sitzpos']}`
    //                     ,style:  'small'
    //        },
    //        {
    //            text:   `${aLangKeys[lang]['pro_einsatz_'+document.getElementById('einsatzbereich').value]}\n
    //                     ${aLangKeys[lang]['pro_fahrgewohnheit_'+document.getElementById('fahrleistung').value]}\n
    //                     ${aLangKeys[lang]['pro_Sitzpos_'+document.getElementById('sitzposition').value]}`
    //                     ,style:  'small'
    //        }
    //    ],pageNumbers:[2]
    //    })

    content.push({
      layout: 'noBorders',
      // optional *noBorders *headerLineOnly *lightHorizontalLines
      table: {
        // headers are automatically repeated if the table spans over multiple pages
        // you can declare how many rows should be treated as headers
        //  headerRows: 1,
        //  widths: [ '*', 'auto', 100, '*' ],
        widths: ['*', '*', '*', '*'],
        body: [[{
          text: "".concat(aLangKeys[lang]['pro_name_vorname']),
          bold: true
        }, {
          text: "".concat(localStorage.getItem('client_name')),
          style: 'small'
        }, {
          text: "".concat(aLangKeys[lang]['pro_einsatz']),
          bold: true
        }, {
          text: "".concat(aLangKeys[lang]['pro_einsatz_' + document.getElementById('einsatzbereich').value]),
          style: 'small'
        }], [{
          text: "".concat(aLangKeys[lang]['pro_sitzknochenabstand']),
          bold: true
        }, {
          text: "".concat(sk_text),
          style: 'small'
        }, {
          text: "".concat(aLangKeys[lang]['pro_fahrgewohnheit']),
          bold: true
        }, {
          text: "".concat(aLangKeys[lang]['pro_fahrgewohnheit_' + document.getElementById('fahrleistung').value]),
          style: 'small'
        }], [{
          text: "".concat(aLangKeys[lang]['pro_disbalance']),
          bold: true
        }, {
          text: "".concat(aLangKeys[lang]['pro_dis_' + document.getElementById('asymmetrie').value]),
          style: 'small'
        }, {
          text: "".concat(aLangKeys[lang]['tpfs_sitzposition']),
          bold: true
        }, {
          text: "".concat(aLangKeys[lang]['pro_Sitzpos_' + document.getElementById('sitzposition').value]),
          style: 'small'
        }]]
      }
    });
    content.push('\n');
    content.push({
      canvas: [{
        type: 'line',
        x1: 0,
        y1: 0,
        x2: line_length,
        y2: 0,
        lineWidth: 1
      }]
    });
    content.push('\n');
  }

  if ($('#check_sattelanalyse').is(':checked')) {
    content.push({
      text: "".concat(aLangKeys[lang]['pro_satteldruck']),
      style: 'bigger',
      bold: true
    });
    content.push('\n');
    content.push({
      canvas: [{
        type: 'line',
        x1: 0,
        y1: 0,
        x2: line_length,
        y2: 0,
        lineWidth: 1
      }]
    });
    content.push('\n');
    content.push({
      alignment: 'justify',
      columns: [{
        image: img1,
        width: 100
      }, {
        layout: 'lightHorizontalLines',
        // optional *noBorders *headerLineOnly *lightHorizontalLines
        table: {
          // headers are automatically repeated if the table spans over multiple pages
          // you can declare how many rows should be treated as headers
          headerRows: 0,
          //  widths: [ '*', 'auto', 100, '*' ],
          widths: ['*', '*'],
          body: [[{
            text: "",
            bold: true
          }, {
            text: "".concat(aLangKeys[lang]['pro_table_wert']),
            bold: true
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_marke']),
            bold: true
          }, {
            text: "".concat(document.getElementById('S1').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_typ']),
            bold: true
          }, {
            text: "".concat(document.getElementById('T1').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_frontback']),
            bold: true
          }, {
            text: "".concat(document.getElementById('v1').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_leftright']),
            bold: true
          }, {
            text: "".concat(document.getElementById('l1').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_veloscore']),
            bold: true
          }, {
            text: "".concat(document.getElementById('V1').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_becken']),
            bold: true
          }, {
            text: "".concat(document.getElementById('B1').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_note']),
            bold: true
          }, {
            text: "".concat(document.getElementById('N1').innerHTML),
            style: 'small'
          }]]
        }
      }]
    });
    content.push('\n');
    content.push({
      canvas: [{
        type: 'line',
        x1: 0,
        y1: 0,
        x2: line_length,
        y2: 0,
        lineWidth: 1
      }]
    });
    content.push('\n');
    content.push({
      alignment: 'justify',
      columns: [{
        image: img2,
        width: 100
      }, {
        layout: 'lightHorizontalLines',
        // optional *noBorders *headerLineOnly *lightHorizontalLines
        table: {
          // headers are automatically repeated if the table spans over multiple pages
          // you can declare how many rows should be treated as headers
          headerRows: 0,
          //  widths: [ '*', 'auto', 100, '*' ],
          widths: ['*', '*'],
          body: [[{
            text: "",
            bold: true
          }, {
            text: "".concat(aLangKeys[lang]['pro_table_wert']),
            bold: true
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_marke']),
            bold: true
          }, {
            text: "".concat(document.getElementById('S2').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_typ']),
            bold: true
          }, {
            text: "".concat(document.getElementById('T2').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_frontback']),
            bold: true
          }, {
            text: "".concat(document.getElementById('v2').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_leftright']),
            bold: true
          }, {
            text: "".concat(document.getElementById('l2').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_veloscore']),
            bold: true
          }, {
            text: "".concat(document.getElementById('V2').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_becken']),
            bold: true
          }, {
            text: "".concat(document.getElementById('B2').innerHTML),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_satteldruck_note']),
            bold: true
          }, {
            text: "".concat(document.getElementById('N2').innerHTML),
            style: 'small'
          }]]
        }
      }]
    });
    content.push('\n');
    content.push({
      canvas: [{
        type: 'line',
        x1: 0,
        y1: 0,
        x2: line_length,
        y2: 0,
        lineWidth: 1
      }]
    });
    content.push('\n');
    content.push({
      text: "",
      pageBreak: 'after'
    });
  }

  if (script_setting.custom_protocol && script_setting.customprotocol) {
    if (new Date(script_setting.custom_protocol) > new Date()) {
      var body;
      var label;
      var value;
      var body;

      (function () {
        //let c = {alignment:'justify',columns:[{text:""},{text:""},{text:""},{text:""}]};
        var c = 0;

        for (var category in customJSN) {
          if (Object.hasOwnProperty.call(customJSN, category)) {
            (function () {
              var fields = customJSN[category];
              var categoryS = category.replaceAll(' ', '_').replaceAll('(', '').replaceAll(')', '').replaceAll('&', 'u').replaceAll('%', '');

              if ($("#check_".concat(categoryS)).is(':checked')) {
                if (c >= 20) {
                  content.push({
                    text: "".concat(category),
                    style: 'bigger',
                    bold: true,
                    pageBreak: 'before'
                  }); //

                  c = 0;
                } else {
                  content.push({
                    text: "".concat(category),
                    style: 'bigger',
                    bold: true
                  }); //,pageBreak: 'before'
                }

                content.push('\n');
                content.push({
                  canvas: [{
                    type: 'line',
                    x1: 0,
                    y1: 0,
                    x2: line_length,
                    y2: 0,
                    lineWidth: 1
                  }]
                });
                content.push('\n');
                var x = 0;

                if (zweispalten == 'true') {
                  if (fields.length % 2 == 1) {
                    fields.push('placeholder_tmp');
                  }

                  body = [[{
                    text: "",
                    bold: true
                  }, {
                    text: "".concat(aLangKeys[lang]['pro_table_wert']),
                    bold: true
                  }, {
                    text: "",
                    bold: true
                  }, {
                    text: "".concat(aLangKeys[lang]['pro_table_wert']),
                    bold: true
                  }]];
                  label = [];
                  value = [];
                  fields.forEach(function (field) {
                    c++;
                    console.log(c);

                    if (x == 0) {
                      label.push("".concat(field));
                      value.push("".concat(document.getElementById("pro_".concat(categoryS, "_").concat(field.replaceAll(' ', '_'))).value)); //c.columns[0].text = `${field}`
                      //c.columns[1].text = `${document.getElementById(`pro_${categoryS}_${field.replaceAll(' ','_')}`).value}`

                      x++;
                    } else {
                      if (field == 'placeholder_tmp') {
                        label.push("");
                        value.push(""); //c.columns[2].text = ``
                        //c.columns[3].text = ``
                      } else {
                        label.push("".concat(field));
                        value.push("".concat(document.getElementById("pro_".concat(categoryS, "_").concat(field.replaceAll(' ', '_'))).value)); //c.columns[2].text = `${field}`
                        //c.columns[3].text = `${document.getElementById(`pro_${categoryS}_${field.replaceAll(' ','_')}`).value}`
                      }

                      body.push([{
                        text: label[0],
                        bold: true
                      }, {
                        text: value[0],
                        style: 'small'
                      }, {
                        text: label[1],
                        bold: true
                      }, {
                        text: value[1],
                        style: 'small'
                      }]);
                      label = [];
                      value = []; //content.push(c)
                      //content.push('\n')
                      //c = {alignment:'justify',columns:[{text:""},{text:""},{text:""},{text:""}]};

                      x--;
                    }
                  });
                  content.push({
                    layout: 'lightHorizontalLines',
                    // optional *noBorders *headerLineOnly *lightHorizontalLines
                    table: {
                      // headers are automatically repeated if the table spans over multiple pages
                      // you can declare how many rows should be treated as headers
                      headerRows: 0,
                      //  widths: [ '*', 'auto', 100, '*' ],
                      widths: ['*', 'auto', '*', 'auto'],
                      body: body
                    }
                  });
                  content.push('\n');
                  content.push({
                    canvas: [{
                      type: 'line',
                      x1: 0,
                      y1: 0,
                      x2: line_length,
                      y2: 0,
                      lineWidth: 1
                    }]
                  });
                  content.push('\n');
                } else {
                  body = [[{
                    text: "",
                    bold: true
                  }, {
                    text: "".concat(aLangKeys[lang]['pro_table_wert']),
                    bold: true
                  }]];
                  fields.forEach(function (field) {
                    console.log(document.getElementById("pro_".concat(categoryS, "_").concat(field.replaceAll(' ', '_'))));
                    body.push([{
                      text: "".concat(field),
                      bold: true
                    }, {
                      text: "".concat(document.getElementById("pro_".concat(categoryS, "_").concat(field.replaceAll(' ', '_'))).value),
                      style: 'small'
                    }]);
                  });
                  content.push({
                    layout: 'lightHorizontalLines',
                    // optional *noBorders *headerLineOnly *lightHorizontalLines
                    table: {
                      // headers are automatically repeated if the table spans over multiple pages
                      // you can declare how many rows should be treated as headers
                      headerRows: 0,
                      //  widths: [ '*', 'auto', 100, '*' ],
                      widths: ['*', 'auto'],
                      body: body
                    }
                  });
                  content.push('\n');
                  content.push({
                    canvas: [{
                      type: 'line',
                      x1: 0,
                      y1: 0,
                      x2: line_length,
                      y2: 0,
                      lineWidth: 1
                    }]
                  });
                  content.push('\n');
                }
              }

              console.log('table body', body);
            })();
          }
        }
      })();
    }
  }

  if ($('#check_ergo').is(':checked')) {
    content.push({
      text: "".concat(aLangKeys[lang]['pro_ergodrei']),
      style: 'bigger',
      bold: true,
      pageBreak: 'before'
    });
    content.push('\n');
    content.push({
      canvas: [{
        type: 'line',
        x1: 0,
        y1: 0,
        x2: line_length,
        y2: 0,
        lineWidth: 1
      }]
    });
    content.push('\n');
    content.push({
      alignment: 'justify',
      columns: [{
        text: ""
      }, {
        svg: "<svg id=\"eK7vFUDaQ2O1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" viewBox=\"1000 0 30000 30000\" shape-rendering=\"geometricPrecision\" text-rendering=\"geometricPrecision\">\n            <g>\n                <g>\n                    <g>\n                        <g>\n                            <g>\n                                <g>\n                                    <path d=\"M18358,8497l325,734\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"400\" stroke-linejoin=\"round\"/>\n                                </g>\n                            </g>\n                            <g>\n                                <g>\n                                    <path d=\"M18464,8691l696-401\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"400\" stroke-linejoin=\"round\"/>\n                                </g>\n                            </g>\n                            <g>\n                                <g>\n                                    <path d=\"M19433,8247c0,36-10,73-28,105s-45,58-77,77c-32,18-68,28-104,28-37,0-73-10-105-28-32-19-59-45-77-77s-28-69-28-105c0-37,10-74,28-106s45-58,77-77c32-18,68-28,105-28c36,0,72,10,104,28c32,19,59,45,77,77s28,69,28,106v0Z\" fill=\"#383e42\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                    <path d=\"M19433,8247c0,36-10,73-28,105s-45,58-77,77c-32,18-68,28-104,28-37,0-73-10-105-28-32-19-59-45-77-77s-28-69-28-105c0-37,10-74,28-106s45-58,77-77c32-18,68-28,105-28c36,0,72,10,104,28c32,19,59,45,77,77s28,69,28,106Z\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"100\" stroke-linejoin=\"round\"/>\n                                </g>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <g>\n                                    <path d=\"M11081,10029l957,2788\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"400\" stroke-linejoin=\"round\"/>\n                                </g>\n                            </g>\n                            <g>\n                                <g>\n                                    <path d=\"M9994,9724l938,409l367-150-109-217-1196-42Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                </g>\n                            </g>\n                            <g>\n                                <g>\n                                    <g>\n                                        <path d=\"M10070,9681c37,20,37,33,171,29c248-21,495-42,742-64c41-4,234-2,589-220-528,4-946,117-1502,255Zm1667-426c-83,6,148,195,64,201-244,117-377,321-732,352-276,24-551,46-826,70-112-6-206,19-442-266-28-15,1949-346,1936-357Z\" fill-opacity=\"0.988\" fill-rule=\"evenodd\" stroke=\"#fff\" stroke-width=\"28.222\" stroke-opacity=\"0.988\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M10070,9680c-220-52-174-48-270-68-27-15-67-27-94-43-194-27-432-4-604-292-87-42-176-74-264-116c11-6-37-197,174-240c1271-29,2002,268,3280,221c470,3,327,262,323,249-102,4-202,9-304,13-36,65-148,45-222,68-13-12-26-23-39-35-83,7-166,13-249,20-558-66-1175,86-1731,223Z\" fill=\"#50595f\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M9720,9566c-191,1-445,0-618-289-87-42-176-74-264-116c11-5-37-198,175-240-283,195,1010,511,707,645Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M10236,9636c-59,21-90,18-168,47-160-29-333-98-362-113-299-230-260-164-603-293-89-42-177-74-265-116c11-6-37-197,174-240-102,142,1134,384,1224,715Z\" fill=\"#383e42\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M2947,15073c40-79,82-157,126-233c418-723,1018-1324,1741-1741s1543-637,2378-637s1655,220,2378,637s1323,1018,1741,1741c417,723,637,1543,637,2378c0,68-1,136-4,204\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M9012,13007c556,227,1051,560,1464,973s746,908,973,1464c227,551,352,1162,352,1811s-125,1260-352,1811c-227,556-560,1051-973,1464-413,414-908,745-1464,973-551,227-1162,352-1812,352-648,0-1259-125-1810-352-556-228-1051-559-1464-973-413-413-746-908-973-1464-227-551-352-1162-352-1811s125-1260,352-1811c227-556,560-1051,973-1464s908-746,1464-973c551-227,1162-352,1810-352c650,0,1261,125,1812,352Zm-380,7572c431-177,816-435,1136-756c322-321,580-705,757-1137c179-435,276-919,276-1431s-97-996-276-1431c-177-431-435-816-757-1136-320-322-705-580-1136-757-435-179-919-276-1432-276-511,0-995,97-1430,276-431,177-816,435-1136,757-322,320-580,705-757,1136-179,435-276,919-276,1431s97,996,276,1431c177,432,435,816,757,1137c320,321,705,579,1136,756c435,179,919,276,1430,276c513,0,997-97,1432-276Z\" fill=\"#383e42\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M6883,20160c1431-766,2863-1531,4294-2297c513,148,1038,213,1551,361c710,96,1275-1420,0-1612-2125,39-4249,33-6374,73c369,585,738,1172,1107,1755-337,406-674,810-1011,1215c144,168,290,337,433,505Z\" transform=\"translate(.000001 0)\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#50595f\" stroke-width=\"100\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M8496,17286c0,237-62,469-181,674-118,205-288,375-493,493-205,119-437,181-673,181-237,0-469-62-674-181-205-118-375-288-493-493-119-205-181-437-181-674c0-236,62-468,181-673c118-205,288-375,493-493c205-119,437-181,673-181c237,0,469,62,674,181c205,118,375,288,493,493c119,205,181,437,181,673v0Z\" fill=\"#383e42\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M10453,17431l2368,12\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"500\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M13798,12679l-68-148l1377-632l136,296-1377,633-68-149Z\" fill=\"#50595f\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M12378,12886l389-178l138,60l1066-485l124,30l171,373-56,117v0l-1065,488-45,145-389,178-333-728Z\" fill=\"#383e42\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M15371,12021c-28,306-973-120-2387,464l1755-912c0,0,721,222,632,448Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M12886,13144c0,86-65,150-150,150h-1l-290,150-48-154l191-125c0-7,0-14,0-21c0-59,30-108,77-132l-27-259l107-86l106,380c22,25,35,59,35,97Z\" fill=\"#5cbc40\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M24613,13008c556,227,1051,560,1464,973s746,908,973,1464c227,551,352,1162,352,1811s-125,1260-352,1811c-227,556-560,1051-973,1464-413,414-908,745-1464,973-551,227-1162,352-1812,352-648,0-1259-125-1810-352-556-228-1051-559-1464-973-413-413-746-908-973-1464-227-551-352-1162-352-1811s125-1260,352-1811c227-556,560-1051,973-1464s908-746,1464-973c551-227,1162-352,1810-352c650,0,1261,125,1812,352Zm-380,7572c431-177,816-435,1136-756c322-321,580-705,757-1137c179-435,276-919,276-1431s-97-996-276-1431c-177-431-435-816-757-1136-320-322-705-580-1136-757-435-179-919-276-1432-276-511,0-995,97-1430,276-431,177-816,435-1136,757-322,320-580,705-757,1136-179,435-276,919-276,1431s97,996,276,1431c177,432,435,816,757,1137c320,321,705,579,1136,756c435,179,919,276,1430,276c513,0,997-97,1432-276Z\" fill=\"#383e42\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M6984,17396l5706-4989l6049-2798l245,454-6218,7315-5197,339-477-416\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#5cbc40\" stroke-width=\"550\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M11609,11587l1670,5129\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#5cbc40\" stroke-width=\"550\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M18671,9227l631,1486\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#5cbc40\" stroke-width=\"550\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M19608,11120l2890,6370\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"800\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M12858,13148c0,21-6,42-16,60-11,18-26,33-44,44-18,10-39,16-60,16s-42-6-60-16c-18-11-33-26-44-44-10-18-16-39-16-60s6-42,16-60c11-18,26-33,44-44c18-10,39-16,60-16s42,6,60,16c18,11,33,26,44,44c10,18,16,39,16,60v0Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M15325,11990c0,19-5,37-14,53-10,16-23,29-39,39-16,9-34,14-53,14s-37-5-53-14c-16-10-29-23-39-39-9-16-14-34-14-53s5-37,14-53c10-16,23-29,39-39c16-9,34-14,53-14s37,5,53,14c16,10,29,23,39,39c9,16,14,34,14,53v0Z\" fill=\"#50595f\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M22997,17582c0,34-9,68-26,97s-42,54-71,71c-30,17-63,26-97,26-35,0-68-9-98-26-29-17-54-42-71-71s-26-63-26-97s9-68,26-97s42-54,71-71c30-17,63-26,98-26c34,0,67,9,97,26c29,17,54,42,71,71s26,63,26,97v0Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M7135,19793c0,67-18,132-51,190-33,57-81,105-138,138-58,33-123,51-190,51s-132-18-189-51c-58-33-106-81-139-138-33-58-51-123-51-190s18-132,51-189c33-58,81-106,139-139c57-33,122-51,189-51s132,18,190,51c57,33,105,81,138,139c33,57,51,122,51,189v0Z\" fill=\"#383e42\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M7301,18721c0,54-14,106-41,153-27,46-65,84-112,111-46,27-99,41-152,41-54,0-107-14-153-41-47-27-85-65-112-111-27-47-41-99-41-153s14-106,41-152c27-47,65-85,112-112c46-27,99-41,153-41c53,0,106,14,152,41c47,27,85,65,112,112c27,46,41,98,41,152v0Z\" fill=\"#383e42\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M7112,17358c-126,117-517,589-614,710c133,132,868,614,975,710-121,167-616,850-698,973\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#50595f\" stroke-width=\"300\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M13541,17438c0,138-37,275-106,395s-169,220-289,289-257,106-395,106c-139,0-276-37-396-106s-220-169-289-289-106-257-106-395c0-139,37-276,106-396s169-220,289-289s257-106,396-106c138,0,275,37,395,106s220,169,289,289s106,257,106,396Z\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"200\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M12753,17431l2368,12\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"500\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M19045,10818l520-216l409,355-722,346-207-485Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M18137,18357c-100-385-150-781-150-1178c0-831,220-1647,637-2366c417-720,1018-1317,1741-1733c723-415,1543-634,2378-634c750,0,1490,177,2159,516\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M22723,17147l2013-4227\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"53\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M22089,17377l-4055,345\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"53\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M6929,17157L3885,13811\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"53\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M7565,12518l-632,4643\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"53\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M3152,14594l661-735-588,103-73,632Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M3142,13950l-59,647\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#e72b2c\" stroke-width=\"159\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M19543,10748l264-337\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"81\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <g>\n                                <path d=\"M19716,10485l530-24l43-681-308,80-265,625Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                        <g>\n                            <text dx=\"0\" dy=\"0\" font-family=\"&quot;eK7vFUDaQ2O1:::Roboto&quot;\" font-size=\"1500\" font-weight=\"400\" transform=\"matrix(.191922-.225202 0.225202 0.191922 16527.067483 13198.179951)\" stroke-width=\"0\">\n                                <tspan y=\"0\" font-weight=\"400\" stroke-width=\"0\">\n                                    <![CDATA[\n        Velometrik\n        ]]>\n                                </tspan>\n                            </text>\n                            <g>\n                                <path d=\"M15000,30169h-15258v-30339h30516v30339h-15258Z\" fill=\"#fff\" fill-opacity=\"0.561\" fill-rule=\"evenodd\" stroke=\"#fff\" stroke-width=\"28.222\" stroke-opacity=\"0.561\" stroke-linejoin=\"round\"/>\n                            </g>\n                        </g>\n                    </g>\n                </g>\n            </g>\n            <g>\n                <g>\n                    <g>\n                        <g>\n                            <g>\n                                <g>\n                                    <g>\n                                        <path d=\"M10182,6614l8283-925\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M9670,6671l555,119-39-357-516,238Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M18976,5631l-555-118l40,357l515-239Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M9900,8726L9648,6473\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M19206,7686l-252-2253\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M10391,17727L7851,10215\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M10556,18215l-3-568-340,115l343,453Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M7686,9728l2,567l340-115-342-452Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M12687,17494l-2321,785\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M9817,9007L7496,9792\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g transform=\"translate(0 10)\">\n                                    <g>\n                                        <path d=\"M20833,9692l-5949,8637\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M21125,9268l-453,341l295,204l158-545Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M14592,18753l453-342-295-204-158,546Z\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M19275,7994l2015,1387\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M12742,17479l2015,1387\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M9876,8982l10000,1\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M15262,6190c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z\" fill=\"#5cbc40\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M15262,6190c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#fff\" stroke-width=\"212\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M9447,12555c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z\" fill=\"#5cbc40\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M9447,12555c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385Z\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#fff\" stroke-width=\"212\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M18318,14486c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z\" fill=\"#5cbc40\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M18318,14486c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385Z\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#fff\" stroke-width=\"212\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M9874,8983l9939-1110\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#000\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M17982,8294c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z\" fill=\"#5cbc40\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M17982,8294c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385Z\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#fff\" stroke-width=\"212\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M19394,7934c0,26-7,52-20,75s-32,42-55,55-49,20-75,20c-27,0-53-7-76-20s-42-32-55-55-20-49-20-75c0-27,7-53,20-76s32-42,55-55s49-20,76-20c26,0,52,7,75,20s42,32,55,55s20,49,20,76v0Z\" fill=\"#f29400\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M10069,8994c0,26-7,52-20,75s-32,42-55,55-49,20-75,20c-27,0-53-7-76-20s-42-32-55-55-20-49-20-75c0-27,7-53,20-76s32-42,55-55s49-20,76-20c26,0,52,7,75,20s42,32,55,55s20,49,20,76v0Z\" fill=\"#f29400\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M12913,17453c0,26-7,52-20,75s-32,42-55,55-49,20-75,20c-27,0-53-7-76-20s-42-32-55-55-20-49-20-75c0-27,7-53,20-76s32-42,55-55s49-20,76-20c26,0,52,7,75,20s42,32,55,55s20,49,20,76v0Z\" fill=\"#f29400\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <g opacity=\"0.298039\">\n                                            <path d=\"M12733,21764l-33-16969\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#f00\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        </g>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <g opacity=\"0.298039\">\n                                            <path d=\"M3267,9325l19126,1\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#f00\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        </g>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M18035,9324h-4784\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#f00\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M18550,9324l-538-179v359l538-180Z\" fill=\"#f00\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M12736,9324l539,180v-359l-539,179Z\" fill=\"#f00\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M18550,9148v376\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#f00\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M12736,9148v376\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#f00\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M12733,16931v-7086\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#f00\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M12733,17446l180-538h-359l179,538Z\" fill=\"#f00\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M12733,9330l-179,539h359l-180-539Z\" fill=\"#f00\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M12916,17446h-383\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#f00\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M12916,9330h-383\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#f00\" stroke-width=\"106\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M15673,9499c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z\" fill=\"#5cbc40\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M15673,9499c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385Z\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#fff\" stroke-width=\"212\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                                <g>\n                                    <g>\n                                        <path d=\"M13576,11622c0,135-36,268-103,385-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-385c0-136,36-269,103-386c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,386v0Z\" fill=\"#5cbc40\" fill-rule=\"evenodd\" stroke-width=\"28.222\" stroke-linejoin=\"round\"/>\n                                        <path d=\"M13576,11622c0,135-36,268-103,385-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-385c0-136,36-269,103-386c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,386Z\" fill=\"none\" fill-rule=\"evenodd\" stroke=\"#fff\" stroke-width=\"212\" stroke-linejoin=\"round\"/>\n                                    </g>\n                                </g>\n                            </g>\n                        </g>\n                    </g>\n                </g>\n            </g>\n            <text dx=\"0\" dy=\"0\" font-family=\"&quot;Ruda Bold&quot;\" font-size=\"1500\" font-weight=\"400\" transform=\"matrix(.5 0 0 0.5 8466.412568 12807.569367)\" fill=\"#fff\" stroke-width=\"0\">\n                <tspan y=\"0\" font-weight=\"400\" stroke-width=\"0\">\n                    <![CDATA[\n        B\n        ]]>\n                </tspan>\n            </text>\n            <text dx=\"0\" dy=\"0\" font-family=\"&quot;Ruda Bold&quot;\" font-size=\"1500\" font-weight=\"400\" transform=\"matrix(.5 0 0 0.5 16934.441743 8541.552185)\" fill=\"#fff\" stroke-width=\"0\">\n                <tspan y=\"0\" font-weight=\"400\" stroke-width=\"0\">\n                    <![CDATA[\n        D\n        ]]>\n                </tspan>\n            </text>\n            <text dx=\"0\" dy=\"0\" font-family=\"&quot;Ruda Bold&quot;\" font-size=\"1500\" font-weight=\"400\" transform=\"matrix(.5 0 0 0.5 14214.441742 6437.552185)\" fill=\"#fff\" stroke-width=\"0\">\n                <tspan y=\"0\" font-weight=\"400\" stroke-width=\"0\">\n                    <![CDATA[\n        A\n        ]]>\n                </tspan>\n            </text>\n            <text dx=\"0\" dy=\"0\" font-family=\"&quot;Ruda Bold&quot;\" font-size=\"1500\" font-weight=\"400\" transform=\"matrix(.5 0 0 0.5 14630.192749 9746.552185)\" fill=\"#fff\" stroke-width=\"0\">\n                <tspan y=\"0\" font-weight=\"400\" stroke-width=\"0\">\n                    <![CDATA[\n        E\n        ]]>\n                </tspan>\n            </text>\n            <text dx=\"0\" dy=\"0\" font-family=\"&quot;Ruda Bold&quot;\" font-size=\"1500\" font-weight=\"400\" transform=\"matrix(.5 0 0 0.5 12591.931931 11873.569367)\" fill=\"#fff\" stroke-width=\"0\">\n                <tspan y=\"0\" font-weight=\"400\" stroke-width=\"0\">\n                    <![CDATA[\n        F\n        ]]>\n                </tspan>\n            </text>\n            <text dx=\"0\" dy=\"0\" font-family=\"&quot;Ruda Bold&quot;\" font-size=\"1500\" font-weight=\"400\" transform=\"matrix(.5 0 0 0.5 17295.821122 14738.569367)\" fill=\"#fff\" stroke-width=\"0\">\n                <tspan y=\"0\" font-weight=\"400\" stroke-width=\"0\">\n                    <![CDATA[\n        C\n        ]]>\n                </tspan>\n            </text>\n            <style>\n                <![CDATA[\n        @font-face {font-family: 'eK7vFUDaQ2O1:::Roboto';font-style: normal;font-weight: 400;src: url(data:font/ttf;charset=utf-8;base64,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) format('truetype');}\n        ]]>\n            </style>\n        </svg>",
        width: 300
      }, {
        text: ""
      }]
    });
    content.push('\n'); //content.push({
    //    alignment:'justify',
    //    columns:[
    //        {text:`${aLangKeys[lang]['sda_frameA']}`,style:'bigger'},
    //        {text:`${aLangKeys[lang]['sda_vergleich']}`,style:'bigger'}
    //    ]
    //})

    content.push('\n');
    content.push({
      canvas: [{
        type: 'line',
        x1: 0,
        y1: 0,
        x2: 532,
        y2: 0,
        lineWidth: 1
      }]
    });
    content.push('\n');
    content.push({
      alignment: 'justify',
      columns: [{
        layout: 'lightHorizontalLines',
        // optional *noBorders *headerLineOnly *lightHorizontalLines
        table: {
          // headers are automatically repeated if the table spans over multiple pages
          // you can declare how many rows should be treated as headers
          headerRows: 0,
          //  widths: [ '*', 'auto', 100, '*' ],
          widths: ['*', 'auto'],
          body: [[{
            text: "".concat(aLangKeys[lang]['sda_frameA']),
            bold: true
          }, {
            text: "".concat(aLangKeys[lang]['pro_table_wert']),
            bold: true
          }], [{
            text: "".concat(aLangKeys[lang]['pro_A']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_a').value || '-', " cm"),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_B']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_b').value || '-', " cm"),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_C']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_c').value || '-', " cm"),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_D']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_d').value || '-', " \xB0"),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_E']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_e').value || '-', " cm"),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_F']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_f').value || '-', " cm"),
            style: 'small'
          }]]
        }
      }, {
        layout: 'lightHorizontalLines',
        // optional *noBorders *headerLineOnly *lightHorizontalLines
        table: {
          // headers are automatically repeated if the table spans over multiple pages
          // you can declare how many rows should be treated as headers
          headerRows: 0,
          //  widths: [ '*', 'auto', 100, '*' ],
          widths: ['*', 'auto'],
          body: [[{
            text: "".concat(aLangKeys[lang]['sda_vergleich']),
            bold: true
          }, {
            text: "".concat(aLangKeys[lang]['pro_table_wert']),
            bold: true
          }], [{
            text: "".concat(aLangKeys[lang]['pro_A']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_a_after').value || '-', " cm"),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_B']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_b_after').value || '-', " cm"),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_C']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_c_after').value || '-', " cm"),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_D']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_d_after').value || '-', " \xB0"),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_E']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_e_after').value || '-', " cm"),
            style: 'small'
          }], [{
            text: "".concat(aLangKeys[lang]['pro_F']),
            bold: true
          }, {
            text: "".concat(document.getElementById('pro_f_after').value || '-', " cm"),
            style: 'small'
          }]]
        }
      }]
    });
    content.push('\n');
    content.push({
      canvas: [{
        type: 'line',
        x1: 0,
        y1: 0,
        x2: line_length,
        y2: 0,
        lineWidth: 1
      }]
    });
    content.push('\n');
  }

  if ($('#check_note').is(':checked') && document.getElementById('pro_note').value !== "") {
    content.push({
      text: "",
      pageBreak: 'after'
    });
    content.push({
      text: "".concat(aLangKeys[lang]['pro_note']),
      style: 'bigger',
      bold: true
    });
    content.push('\n');
    content.push({
      canvas: [{
        type: 'line',
        x1: 0,
        y1: 0,
        x2: line_length,
        y2: 0,
        lineWidth: 1
      }]
    });
    content.push('\n');
    content.push({
      text: "".concat(document.getElementById('pro_note').value || '')
    });
  } //  console.log(content);


  var logo = "".concat(location.origin, "/production/images/Logo-mit-Schriftzug.png"); //if(localStorage.getItem("url_logo") && localStorage.getItem("url_logo") != ""){
  //    logo =localStorage.getItem("url_logo")
  //}

  dd = {
    // a string or { width: number, height: number }
    pageSize: 'LETTER',
    // by default we use portrait, you can change it to landscape if you wish
    pageOrientation: 'portrait',
    // [left, top, right, bottom] or [horizontal, vertical] or just a number for equal margins
    pageMargins: [40, 90, 40, 50],
    // watermark: { text: 'Velometrik Gmbh', fontSize: 20 },
    styles: {
      header: {
        fontSize: 18
      },
      center: {
        alignment: 'center'
      },
      left: {
        alignment: 'left'
      },
      right: {
        alignment: 'right'
      },
      XXL: {
        fontSize: 48
      },
      bold: {
        bold: true
      },
      bigger: {
        fontSize: 15,
        italics: true
      },
      small: {
        fontSize: 10
      },
      XXS: {
        fontSize: 7
      }
    },
    defaultStyle: {
      columnGap: 20
    },
    info: {
      title: "".concat(aLangKeys[lang]['pro_head'], " - ").concat(name[1], " ").concat(name[0], ".pdf"),
      filename: "".concat(aLangKeys[lang]['pro_head'], " - ").concat(name[1], " ").concat(name[0], ".pdf")
    },
    images: {
      Velologo: {
        //  url: `${location.origin}/production/images/Logo-mit-Schriftzug.png`,
        url: logo
      }
    },
    //background: function(currentPage, pageSize) {
    //    return `page ${currentPage} with size ${pageSize.width} x ${pageSize.height}`
    //  },
    header: function header(currentPage, pageCount, pageSize) {
      // computations...
      var company = "";
      var street = "";
      var city = "";
      var phone = "";
      var mail = "";
      var web = "";
      var name2 = "";

      if (script_setting.UserCompany) {
        company = script_setting.UserCompany;
      }

      if (script_setting.UserStreet) {
        street = script_setting.UserStreet;
      }

      if (script_setting.UserCity) {
        city = script_setting.UserCity;
      }

      if (script_setting.UserPhone) {
        phone = script_setting.UserPhone;
      }

      if (script_setting.UserMail) {
        mail = script_setting.UserMail;
      }

      if (script_setting.UserWeb) {
        web = script_setting.UserWeb;
      }

      if (script_setting.UserName) {
        name2 = script_setting.UserName;
      }

      if (currentPage === 1) {
        return;
      }

      return [{
        text: "\n"
      }, {
        text: "".concat(company),
        style: ['right', 'bigger'],
        margin: [40, 0]
        /* extra style attributes */

      }, {
        text: "".concat(street, " | ").concat(city, " | ").concat(phone),
        style: ['right', 'XXS'],
        margin: [40, 0]
      }, {
        text: "".concat(mail, " | ").concat(web),
        style: ['right', 'XXS'],
        margin: [40, 0]
      }, //  { text:"",style:['right'],margin:[40,0]},
      {
        text: "Bike Fitter: ".concat(name2),
        style: ['right', 'XXS'],
        margin: [40, 0]
      }, {
        text: "".concat(localStorage.getItem('client_forenames'), " ").concat(localStorage.getItem('client_surename')),
        style: ['left', 'bigger', 'bold'],
        margin: [40, 0]
      }, {
        text: "".concat(aLangKeys[lang]['pro_bikefit'], " ").concat(aLangKeys[lang]['pro_head'], " ").concat(new Date().toISOString().split('T')[0]),
        style: ['left', 'XXS'],
        margin: [40, 0]
      } //  {canvas: [ { type: 'line', x1: 40, y1: 0, x2: line_length, y2: 0, lineWidth: 1 } ]}
      //  { text:`${new Date().toISOString().split('T')[0]}`,style:['small','left'],margin:[40,0]}
      ]; //content.push({text:`${aLangKeys[lang]['pro_bikefit']}`,style:['header','bold','center']})
      //content.push({text:`${aLangKeys[lang]['pro_head']}`,style:['header','bold','center']})
    },
    background: function background(currentPage, pageSize) {
      return [{
        image: 'Velologo',
        style: ['left'],
        width: 150,
        margin: [40, pageSize.height - 60]
      }];
    },
    footer: function footer(currentPage, pageCount, pageSize) {
      return [{
        text: "Velometrik GmbH",
        style: ['bigger', 'bold', 'right'],
        margin: [40, 0]
      }, {
        text: "Breunsdorfer Str. 48a | 04575 Neukieritzsch | Germany | info@velometrik.de | www.velometrik.com",
        style: ['XXS', 'right'],
        margin: [40, 0]
      }, {
        text: "\n".concat(currentPage, "/").concat(pageCount),
        style: ['XXS', 'center'],
        margin: [40, 0]
      }];
    },
    //watermark: { text: 'unlicensed', color: 'blue', opacity: 0.3, bold: true, italics: false },
    content: content
  }; //pdfMake.createPdf(dd).open();

  pdfMake.createPdf(dd).download("".concat(aLangKeys[lang]['pro_head'], " - ").concat(name[1], " ").concat(name[0], ".pdf"));
}
/**
 * The function `OpenMail` generates a mailto link with recipient, subject, and body information and
 * opens the default email client with the generated link.
 */


function OpenMail() {
  //window.location.href = "mailto:mail@example.org";
  PDFgen();
  var user_company = "";
  var user_name = "";

  if (script_setting.UserCompany) {
    user_company = script_setting.UserCompany;
  }

  if (script_setting.UserName) {
    user_name = script_setting.UserName;
  }

  var recipient = localStorage.getItem('client_mail');
  var subject = "".concat(aLangKeys[lang]['pro_head'], " ").concat(localStorage.getItem('client_name'));
  var body = "".concat(aLangKeys[lang]['send_mail_protokoll_1']).concat(aLangKeys[lang]['send_mail_protokoll_2']).concat(user_company, "\n").concat(user_name);
  var mailtoLink = "mailto:".concat(recipient, "?subject=").concat(encodeURIComponent(subject), "&body=").concat(encodeURIComponent(body));
  window.open(mailtoLink);
} //var httpURL = new XMLHttpRequest();


var myWebServiceUrl = "/production/protokoll.tcls"; //CUSTOM PROTOCOL

var custom_placeholder = document.getElementById('custom_placeholder');
var interC = setInterval(function () {
  if (script_setting.custom_protocol && script_setting.customprotocol) {
    if (new Date(script_setting.custom_protocol) > new Date()) {
      time_to_use_custom_pro(script_setting.custom_protocol);

      for (var category in customJSN) {
        if (Object.hasOwnProperty.call(customJSN, category)) {
          (function () {
            var fields = customJSN[category];
            var categoryS = category.replaceAll(' ', '_').replaceAll('(', '').replaceAll(')', '').replaceAll('&', 'u').replaceAll('%', ''); //console.log(category,fields);

            var card = newElement({
              element: "div",
              cls: ['uk-card']
            }, custom_placeholder);
            var head = newElement({
              element: "div",
              cls: ['uk-card-header']
            }, card);
            var grid = newElement({
              element: "div",
              cls: ['uk-grid-small', 'uk-flex-middle'],
              attr: [['uk-grid', ' ']]
            }, head);
            var headG = newElement({
              element: "div",
              cls: ['uk-width-expand', 'flexCenter-R']
            }, grid);
            var h3 = newElement({
              element: "h3",
              cls: ['uk-card-title']
            }, headG).innerHTML = category;
            var inpchk = newElement({
              element: "input",
              cls: ['form-control', 'uk-checkbox', 'checkbox-A'],
              id: "check_".concat(categoryS),
              attr: [['checked', 'true'], ['type', 'checkbox'], ['name', "".concat(categoryS)]]
            }, headG);
            var hr = newElement({
              element: "hr"
            }, card);
            var body = newElement({
              element: "div",
              cls: ['uk-card-body']
            }, card);
            var grid2 = newElement({
              element: "div",
              attr: [['uk-grid', ' ']]
            }, body);
            var left = newElement({
              element: "div",
              cls: ['uk-width-1-2'],
              id: 'custom_left'
            }, grid2);
            var right = newElement({
              element: "div",
              cls: ['uk-width-1-2'],
              id: 'custom_right'
            }, grid2);
            var x = 0;
            fields.forEach(function (field) {
              if (x == 0) {
                var p = newElement({
                  element: "p",
                  cls: ['uk-margin-remove']
                }, left).innerHTML = field;
                var inline = newElement({
                  element: "div",
                  cls: ['uk-inline']
                }, left);
                var inp = newElement({
                  element: "input",
                  id: "pro_".concat(categoryS, "_").concat(field.replaceAll(' ', '_')),
                  cls: ['uk-input', 'uk-form-width-small'],
                  attr: [['type', 'text'], ['onchange', "store(this.value,\"pro_".concat(categoryS, "_").concat(field.replaceAll(' ', '_'), "\",\"x1\")")]]
                }, left);
                x++;
              } else {
                var _p = newElement({
                  element: "p",
                  cls: ['uk-margin-remove']
                }, right).innerHTML = field;

                var _inline = newElement({
                  element: "div",
                  cls: ['uk-inline']
                }, right);

                var _inp = newElement({
                  element: "input",
                  id: "pro_".concat(categoryS, "_").concat(field.replaceAll(' ', '_')),
                  cls: ['uk-input', 'uk-form-width-small'],
                  attr: [['type', 'text'], ['onchange', "store(this.value,\"pro_".concat(categoryS, "_").concat(field.replaceAll(' ', '_'), "\",\"x1\")")]]
                }, right);

                x = 0;
              }
            });
          })();
        }
      }
    }
  }

  clearInterval(interC);
}, 1000);
/**
 * The function calculates the number of days between a given date and the current date, and displays a
 * warning message if the difference is less than 60 days.
 * @param params - It looks like the `params` variable is missing its value in the code snippet you
 * provided. To use the `time_to_use_custom_pro` function properly, you need to pass a valid date
 * string as the `params` argument when calling the function.
 */

function time_to_use_custom_pro(params) {
  console.log(params);
  var date = new Date(params);
  var today = new Date();
  var days = "".concat(Math.floor((date - today) / (1000 * 60 * 60 * 24)), " ").concat(aLangKeys[lang]['tpfs_days']); //document.getElementById('time_beratung').innerHTML = `${aLangKeys[lang]['tpfs_use']} ${days}`

  if (Math.floor((date - today) / (1000 * 60 * 60 * 24)) < 60) {
    OpenModDialog({
      type: 'warn',
      title: ["custom_protocol_use"],
      msg: "".concat(days),
      master_btn: ['button_ok']
    });
  }
}