#!/bin/bash
#
# velobox_update_3.0.7
# Einspielen aller Dateien in /usr/local/vmkstationd3/
# Velometrik-GmbH
# Breunsdorfer Str. 48a
# 04575 Neukieritzsch
#
# www.velometrik.com
# support@velometrik.de
#
# Historie:
# 01.04.2024	Peter Bauer	erstellt

LAST_VERSION=3.0.6
CURRENT_VERSION=3.0.7

if [ `whoami` != "root" ]; then
echo "ERROR"
    echo "The script must be executed by root!"
    exit 1
fi

if [ `awk -F '=' '/VERSION/ {print $2}' /usr/local/etc/velobox.conf` != $LAST_VERSION ]; then
echo "ERROR"
echo "You need the Update $LAST_VERSION first!"
exit 1
fi

echo "htdocs leeren"
rm -r /usr/local/vmkstationd/htdocs/
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "The folder "htdocs" could not be deleted!"
    exit 1
fi


echo "rm spotyfi.lis"
rm /etc/apt/sources.list.d/spotify.lis
if [ $? -ne 0 ]; then
echo "WARN"
    echo "The spotify.lis could not be deleted!"
fi

echo "deactivate IPv6 & wlan0"
rm /boot/cmdline.txt
echo "console=serial0,115200 console=tty1 root=PARTUUID=cd9aa942-02 rootfstype=ext4 fsck.repair=yes rootwait ipv6.disable=1 net.ifnames=0 biosdevname=0" > /boot/cmdline.txt
if [ $? -ne 0 ]; then
echo "WARN"
    echo "The cmdline.txt could not be changed!"
fi

echo "Files in / will be installed."
if [ ! -r velobox_update_$CURRENT_VERSION.tar.gz ]; then
echo "ERROR"
    echo "velobox_update_$CURRENT_VERSION.tar.gz not found" 
    exit 1
fi

cp velobox_update_$CURRENT_VERSION.tar.gz /
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "Can't copy velobox_update_$CURRENT_VERSION.tar.gz to / ."
    exit 1
fi
#NUR htdocs
cd /
test $? -ne 0 && exit 1
tar xf velobox_update_$CURRENT_VERSION.tar.gz
test $? -ne 0 && exit 1
rm -f velobox_update_$CURRENT_VERSION.tar.gz

echo "Files in / were recorded."

echo "Delete current symbolic link to vmkstationd"
rm /usr/local/vmkstationd
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # rm /usr/local/vmkstationd"
    exit 1
fi
echo "done"

echo "Create symbolic link to vmkstationd"
ln -s /usr/local/vmkstationd_V3.3.0/ /usr/local/vmkstationd
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # ln -s /usr/local/vmkstationd_V3.3.0/ /usr/local/vmkstationd"
    exit 1
fi
echo "done"      

### Do not change anything from here on! ###

###############################
### aktuelle Version setzen ###
echo "Set current version"
sed -i s/VERSION=$LAST_VERSION/VERSION=$CURRENT_VERSION/g /usr/local/etc/velobox.conf
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "Can't set current version"
    exit 1
fi

###################################
### Ab hier nichts mehr ändern! ###
echo "Correct user rights in htdocs"
chown -R root:root /usr/local
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "User rights could not be corrected!"
    exit 1
fi

history -c

echo "Done!"