# utils.tcl
#
# Elementare Hilfsmittel für vmkstationd
#

# Loglevels (wie bei websocket zuzügl. debug2)
set ::LOGLEVELS [list "error" "warn" "notice" "info" "debug" "debug2"]
set ::LOGLEVEL notice

# Ausgabe von Logmeldungen
# @param sock       Socket-Handle (wird ausgegeben)
# @param loglevel   Loglevel wie bei ::websocket
# @param format     Einfacher oder (printf) Formatstring für TCL-format
# @param args       Argumente gemäß Formatstring
if {[info exists ::CONF_LOGFILE] && "$::CONF_LOGFILE" != ""} {
	proc ::srvLog {sock loglevel format args} {; #{{{
	    set i_loglevel [lsearch $::LOGLEVELS $::LOGLEVEL]
	    set i_msglevel [lsearch -nocase $::LOGLEVELS $loglevel]
	    if {$i_msglevel <= $i_loglevel} {
	        if {$i_msglevel < 0} {; # unbekanntes Loglevel
	            append loglevel " (unknown loglevel)"
	        }
	        if {[llength $args] == 0} {
	            set logmsg "[clock format [clock seconds]] $sock $loglevel: $format"
	        } else {
	            set logmsg "[clock format [clock seconds]] $sock $loglevel: [format $format {*}$args]"
	        }
            if {[catch {
                set fd [open $::CONF_LOGFILE "a"]
                puts $fd $logmsg
                close $fd
            } error]} {
                puts stderr $error
                puts stderr $logmsg
            }
	    }
	    #}}}
	}; # proc ::srvLog 
} else {
	proc ::srvLog {sock loglevel format args} {; #{{{
	    set i_loglevel [lsearch $::LOGLEVELS $::LOGLEVEL]
	    set i_msglevel [lsearch -nocase $::LOGLEVELS $loglevel]
	    if {$i_msglevel <= $i_loglevel} {
	        if {$i_msglevel < 0} {; # unbekanntes Loglevel
	            append loglevel " (unknown loglevel)"
	        }
	        if {[llength $args] == 0} {
	            puts stderr "[clock format [clock seconds]] $sock $loglevel: $format"
	        } else {
	            puts stderr "[clock format [clock seconds]] $sock $loglevel: [format $format {*}$args]"
	        }
	    }
	    #}}}
	}; # proc ::srvLog 
}


# Loglevel neu setzen
# @param loglevel   Bezeichnung des Loglevels (s. ::LOGLEVELS)
proc ::setLoglevel {loglevel} {
    if {!($loglevel in $::LOGLEVELS)} {
        error "Unknown loglevel: '$loglevel'\nMust be one of $::LOGLEVELS"
    }
    set ::LOGLEVEL $loglevel
    if {[namespace exists ::websocket]} {
        set ::websocket::loglevel $loglevel
    }
    srvLog {} Notice  "Loglevel auf $::LOGLEVEL gesetzt."
}; # proc ::setLogLevel


# Liste mit Key/Value Paaren in JSON umwandeln
# Zahlen mit Nachkommastellen werden auf eine Nachkommastelle gerundet.
# Achtung! Verschachtelungen sind nicht erlaubt.
# @param kvlist Liste mit Key/Value Paaren
# @return   Entsprechender JSON-String
proc ::kvlist2json {kvlist} {
    set start 1
    set json "{"
    foreach {key value} $kvlist {
        if {$start} {
            set start 0
        } else {
            append json ","
        }
        append json "\"$key\":"
        if {[string is double -strict "$value"] && ![string is integer -strict "$value"]} {
            append json [format "%.1f" $value]
        } else {
            append json "\"[string map {\" \\\" \\ \\\\ / \\/ \n \\n} $value]\""
        }
    }
    append json "}"
    return $json
}; # proc ::kvlist2json
