/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/* 
    Created on : 04.06.2021, 21:08:29
    Author     : Peter Bauer
*/
const client_id = localStorage.getItem('client_id');
const client_name = localStorage.getItem('client_name');
const client_mail = localStorage.getItem('client_mail')||'';
const client_fc = localStorage.getItem('client_fc');
const client_forenames = localStorage.getItem('client_forenames')
const client_surename = localStorage.getItem('client_surename')
const client_info =  JSON.parse(localStorage.getItem('client_info'));

var Nname = document.getElementById('pi_name');
var Vname = document.getElementById('pi_vorname');
var Email = document.getElementById('pi_email');

var LNname = document.getElementById('pi_name2')
var LVname = document.getElementById('pi_vorname2');
var LEmail = document.getElementById('pi_email2');

//document.getElementById('client_head').innerHTML = client_name;
document.getElementsByClassName('headliner')[0].removeAttribute('key');
document.getElementsByClassName('headliner')[0].innerHTML = `${client_forenames} ${client_surename}`;
Nname.innerHTML =  client_surename;
Vname.innerHTML =  client_forenames;
Email.innerHTML =  client_mail;
document.getElementById('pi_id').innerHTML = client_id;
document.getElementById('pi_fc').innerHTML = client_fc.split(' ')[0];

/* The `newElement` function is being called with several arguments to create a new HTML element and
append it to the element with the ID `pi_newSession`. */
document.getElementById("pi_newSession").setAttribute('onclick',`new_session_id(${client_id})`)
newElement({element:"button",cls:['quad-35','uk-button','uk-button-primary','mdi','mdi-24px','mdi-new-box','uk-button-small'],attr:[['key-title','cli_new_session'],['onclick',`new_session_id(${client_id})`]]},document.getElementById('pi_newSession'))

gen_session_list()

/**
 * The `gen_session_list` function generates a table of session information and appends it to the
 * specified element in the HTML document.
 */
function gen_session_list() {
    let into = document.getElementById('pi_sl');
    let head = ['Session','Datum','info','']
    let table = document.createElement('table')
    table.classList.add('uk-table', 'uk-table-hover', 'uk-table-divider')
    into.append(table)
    let thead = document.createElement('thead');
    table.append(thead)
    let tr_head = document.createElement('tr');
    thead.append(tr_head);
    head.forEach(e=>{
        let th_head = document.createElement('th');
        th_head.innerHTML = e;
        th_head.setAttribute('key',`cli_tablehead_${e}`)
        tr_head.append(th_head);
    })
    let tbody = document.createElement('tbody');
    table.append(tbody);

    client_info.forEach(e => {
        var tr_body = document.createElement('tr');
        tr_body.classList.add('suche')
        tr_body.setAttribute('suche',`${e.notes||""} ${e.date} ${e.session_id}`)
        // tr_body.setAttribute('uk-tooltip',`${aLangKeys[lang]['tooltip_session_retrive']}`)
        tr_body.classList.add('cur_pointer')
        tr_body.id = `cli_${e.session_id}`
        // tr_body.setAttribute('onclick',`rest_session(${e.session_id})`)
        tbody.append(tr_body);
        tr_body.innerHTML  = `<td onclick='session_img(${e.session_id},"${e.notes||""}")'>${e.session_id}</td>`;
        tr_body.innerHTML += `<td onclick='session_img(${e.session_id},"${e.notes||""}")'>${e.date}</td>`;
        tr_body.innerHTML += `<td onclick='session_img(${e.session_id},"${e.notes||""}")'>${e.notes||""}</td>`;
        // tr_body.innerHTML += `<td><button class="uk-button uk-button-default uk-button-small" onclick="toProtokoll(${e.session_id})" uk-icon="icon: copy"></button></td>`;
        tr_body.innerHTML += `<td><button class="ico-16 mdi mdi-trash-can-outline uk-button uk-button-default uk-button-small adba basicview" onclick="SessionDel(${e.session_id})"></button></td>`
    });
    ToggleViewMode(localStorage.getItem("viewmode"));
    translatejs()    
}

/**
 * The function "toProtokoll" sets a value in the local storage and redirects the user to a specific
 * page.
 * @param id - The `id` parameter is a unique identifier for a session.
 */
function toProtokoll(id){
  localStorage.setItem('session',`restart ${id}`);
  location.pathname = '/production/protokoll.tcls';
}

/**
 * The function "toGalerie" sets a value in the local storage and redirects the user to a specific
 * page.
 * @param id - The `id` parameter is a unique identifier for a specific gallery.
 */
function toGalerie(id){
  localStorage.setItem('session',`restart ${id}`);
  location.pathname = '/production/galerie.tcls';
}

var NnameI,VnameI,EmailI
var cli_edit = document.getElementById('cli_edit')

/**
 * The function `editData()` allows the user to edit client data and save the changes.
 */
function editData() {
  if(Nname.childElementCount===0){
  cli_edit.setAttribute('key-title','cli_edit_save')
  cli_edit.classList.remove('mdi-account-edit')
  cli_edit.classList.add('mdi-content-save')
  NnameI = newElement({element:'input',cls:['uk-input','uk-input-small'],attr:[['value',Nname.innerHTML],['oninput','updateValue(this)']]},Nname)
  VnameI = newElement({element:'input',cls:['uk-input','uk-input-small'],attr:[['value',Vname.innerHTML],['oninput','updateValue(this)']]},Vname)
  EmailI = newElement({element:'input',cls:['uk-input','uk-input-small'],attr:[['value',Email.innerHTML],['oninput','updateValue(this)']]},Email)
  // NnameI = document.createElement('input');
  // NnameI.value=Nname.innerHTML;
  // VnameI = document.createElement('input');
  // VnameI.value=Vname.innerHTML;
  // EmailI = document.createElement('input');
  // EmailI.value=Email.innerHTML;

  Nname.innerHTML="";
  Vname.innerHTML="";
  Email.innerHTML="";
  Nname.append(NnameI);
  Vname.append(VnameI);
  Email.append(EmailI);
  LEmail.style.height = "40px"
  LNname.style.height = "40px"
  LVname.style.height = "40px"
  } else{
    cli_edit.setAttribute('key-title','cli_edit')
    cli_edit.classList.add('mdi-account-edit')
    cli_edit.classList.remove('mdi-content-save')
    Nname.innerHTML=NnameI.value;
    Vname.innerHTML=VnameI.value;
    Email.innerHTML=EmailI.value;
    LEmail.style.height = "20px"
    LNname.style.height = "20px"
    LVname.style.height = "20px"
    localStorage.setItem('client_mail',Email.innerHTML);
    localStorage.setItem('client_name',`${Nname.innerHTML} ${Vname.innerHTML}`);
    localStorage.setItem('client_forenames',`${Vname.innerHTML}`)
    localStorage.setItem('client_surename',`${Nname.innerHTML}`)
    document.getElementsByClassName('headliner')[0].innerHTML = `${Vname.innerHTML} ${Nname.innerHTML}`;
    document.getElementsByClassName('headliner')[0].removeAttribute('onclick')
    document.getElementsByClassName('headliner')[0].setAttribute('onclick',`info(${localStorage.getItem('client_id')},'${Nname.innerHTML||""} ${Vname.innerHTML||""}','${Vname.innerHTML||""}','${Nname.innerHTML||""}','${Email.innerHTML||""}','${localStorage.getItem('client_fc')}')`)
    document.getElementById('client').innerHTML = `${Vname.innerHTML} ${Nname.innerHTML}`;
    console.log(Email.innerHTML,Vname.innerHTML,Nname.innerHTML);
    session.send(`sql UPDATE clients SET email='${Email.innerHTML}', forename='${Vname.innerHTML}', surname='${Nname.innerHTML}' WHERE client_id=${localStorage.getItem('client_id')}`)
  }
translatejs();
}