#
# Websocket Anbindung der Anwendung custom/apps/sitzknochenabstand

namespace eval apps/sitzknochenabstand {

    variable pongcounts; # 1 Pongzähler je $clientsocket
    array set pongcounts {}
    variable pongcheck_id ""; # after id für proc pongCheck

    # Haben die Clientsockets auf die Pings geantwortet?
    #   Der WS-Server schickt alle 30s ein "ping" an die Clients,
    #   das diese mit pong beantworten.
    #   "pong" bleibt aus, wenn sich der Client irregulär verabschiedet hat.
    #   Es wird verzögert, wenn die Netzwerkverbindung vorübergehend gestört ist.
    # => Alle 5 min wird geprüft, ob pongs von den Clients eingetroffen sind.
    #    Ein Client, bei dem das nicht (mehr) der Fall ist, wir geschlossen.
    proc pongCheck {} {; #{{{
        variable pongcounts
        variable pongcheck_id
        
        set pongcheck_id ""
        foreach {clientsocket pongcount} [array get pongcounts] {
            if {$pongcount == 0} {; # Client hat nicht (mehr) geantwortet.
                # Erst bei disconnect: unset pongcounts($clientsocket)
	            srvLog [namespace current]::pongCheck Warn "Possibly dead client ($clientsocket)."
	            srvLog [namespace current]::pongCheck Debug "client status: [::websocket::conninfo $clientsocket state]."
                # Das Fehlen der pongs bedeutet nicht immer eine kaputte Verbindung.
                if {[catch {
                    ::websocket::send $clientsocket ping
	                srvLog [namespace current]::pongCheck Debug "ping sent to ${clientsocket}."
                } msg]} {
	                srvLog [namespace current]::pongCheck Error "$msg"
                }
            } else {; # pongs sind angekommen
	            srvLog [namespace current]::pongCheck Debug "$clientsocket is alive."
                set pongcounts($clientsocket) 0
            }
        }
        if {[array size pongcounts] > 0} {; # Es gibt noch clients zum Überwachen.
            set pongcheck_id [after 300000 [namespace current]::pongCheck]
	        srvLog [namespace current] Debug "pongCheck {} restarted."
        }
        #}}}
    }; # proc pongCheck

    # Mitteilung vom Client verarbeiten
       # Hinweis: Das ist ein Callback, das mit ::websocket::live übergeben wird.
       # Es wird von ::websocket aufgerufen und befindet sich deshalb in einem
       # anderen namespace Kontext.
       # Prozeduren aus ::WSServer müssen deshalb mit vollem Namespacepfad
       # aufgerufen werden.
    proc handleClientMessage {clientsocket type msg} {
	    upvar #0 clientcontext$clientsocket context
        variable pongcounts
        variable pongcheck_id
	
	    # $type laut API:
	    #   text        Complete text message
	    #   binary      Complete binary message
	    #   ping        Incoming ping message
	    #   connect     Notification of successful connection to server
	    #   disconnect  Disconnection from remote end
	    #   close       Pending closure of connection
	
	    switch -glob -nocase -- $type {
	        connect {
	            srvLog $clientsocket Info "Client connected"
                if {[catch {::apps::sitzknochenabstand::start} starterror]} {
                    srvLog [namespace current] Error $starterror
                }
                if {"$pongcheck_id" != ""} {
                    after cancel $pongcheck_id
                }
                set pongcounts($clientsocket) 0
                set pongcheck_id [after 300000 [namespace current]::pongCheck]
	        }
	        text {
                # Hier werden die API-Requests entgegegenommen.
	            srvLog $clientsocket Debug "text message received: '$msg'"
                ::apps::sitzknochenabstand::handleCommand $msg
	        }
	        binary {
	            srvLog $clientsocket Info "binary message received"
	        }
	        ping -
	        pong {
	            srvLog $clientsocket Debug "Client $type received"
                incr pongcounts($clientsocket)
	        }
	        close {
				srvLog $clientsocket Info "WS-Connection closing (%s)" $context(ipaddr)
                   # Kein Handlungsbedarf
	        }
	        disconnect {
				srvLog $clientsocket Info "WS-Connection disconnected (%s)" $context(ipaddr)
                if {[catch {::apps::sitzknochenabstand::stop} stoperror]} {
                    srvLog [namespace current] Error $stoperror
                }
                unset pongcounts($clientsocket)
                # Das ist notwendig:
	            ::WSServer::wsClientKill $clientsocket
            }
	        default {
				srvLog $clientsocket Info "WS-Connection unknown message type: %s" $type
                   # Kein Handlungsbedarf
	        }
	    }
    }; # proc handleClientMessage 

}; # namespace eval apps/sitzknochenabstand


