/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/* 
    Created on : 04.05.2021, 21:08:29
    Author     : Peter Bauer
*/
const host = `http://${localStorage.getItem('smartcube')}`;
const ws = `ws://${localStorage.getItem('smartcube')}`
const setting = new Object();
setting.text_color = '#ffffff';
const cw = document.getElementsByClassName("ska")[0].offsetWidth;
localStorage.setItem('sk','');

const host_2 = location.origin;
const ws_2 = host_2.replace('http','ws');
const apps= "satteldruckanalyse";

var sessionID;
if(localStorage.getItem('session').split(" ")[0]=='restart'){
  sessionID = localStorage.getItem('session').split(" ")[1]
} else{
  sessionID = localStorage.getItem('new_session')
}

const canvas_ska = new fabric.Canvas("ska_img");
createCanvas(canvas_ska);
setImage(canvas_ska,`/production/images/Sitzknochenvermessung.png`);

let cm;
let inch;
var vsum = 0;

translatejs();
_name();

try {
var ws_ska = new WebSocket(`${ws}/messages`, ["soap", "wamp"]);
} catch (error) {
    OpenMod('disconected')
}

try {
  var sattelanalyse = new WebSocket(`${ws_2}/apps/${apps}`, ["soap", "wamp"]);
} catch (error) {
  console.error(error); 
}

var analysis = new Object();
analysis.sitbones = new Object();
analysis.anamnesis = new Object();
analysis.x1 = new Object();
//{"sitbones":{"sitzknochenabstand":"","asymmetrie":""}}


sattelanalyse.onopen = (e)=>{
  sattelanalyse.send(`session restart ${sessionID}`)
  sattelanalyse.send(`analysis ["sitbones","anamnesis","x1"]`)
}

sattelanalyse.onmessage = (e) => {

  let data = JSON.parse(e.data)
  console.log(data); //TODO DEF
  
  if (data.wsevent === "analyses"){
    let d = data.analyses;
    for (const key in d) {
            const element = d[key];
            for (const key2 in element) {
                    const element2 = element[key2];
                    let ele = document.getElementById(key2)
                    ele.value = element2
                    // console.log(key,key2,element2);
                    analysis[key][key2]=element2
            }
    }
  }

}

ws_ska.onmessage = (e) =>{
    translatejs()
    let data = JSON.parse(e.data)

    console.log(data);

    if(data.v_sum == 0.0){
      vsum = 0;
    }
    
    if(data.wsevent == 'plugged'){
        OpenMod('connected')
        document.getElementById('glow').classList.add('glow')
    }
    if(data.wsevent === 'hockerbild' && data.v_sum > 0){
      console.log("draw image");
      let img = `${host}/hockerbild?rnd=${(new Date).getTime()}`;
      console.log(img);
      setImage(canvas_ska, img);

    }
    if(data.wsevent === 'sitzknochenabstand' && vsum === 0){
      //if(vsum == 0){
        vsum = 1
        store(data.sitzknochenabstand,"sitzknochenabstand","sitbones")
        document.getElementById('sitzknochenabstand').value = data.sitzknochenabstand
        var inter = setInterval( () => {
          draw_cross(canvas_ska,[(data.schwerpunkt1_x+0.5) * (cw / 28) , (cw/1.75) - (data.schwerpunkt1_y+0.5) * (cw / 28)]);
          draw_cross(canvas_ska,[(data.schwerpunkt2_x+0.5)* (cw / 28) , (cw/1.75) - (data.schwerpunkt2_y+0.5) * (cw / 28)]);
          console.log(lineDistance([data.schwerpunkt1_x * (cw / 28) , (cw/1.75) - data.schwerpunkt1_y * (cw / 28)],[data.schwerpunkt2_x * (cw / 28) , (cw/1.75) - data.schwerpunkt2_y * (cw / 28)])/(cw/28));
          cm_inch(data.sitzknochenabstand)
          document.getElementById('val').value = `${cm}` //<br> ${inch}`
          localStorage.setItem('sk',`${cm}`)
          vsum++
          clearInterval(inter);
        }, 1000);

      //}
    }
}

function lineDistance(p1, p2) {
  return Math.hypot(p2[0] - p1[0], p2[1] - p1[1])
}

function draw_cross(ele,pos) {
  console.log(pos);
  let c = ele.getContext('2d')
  c.lineWidth = 5;
  c.strokeStyle = setting.text_color;

  c.beginPath()
  c.moveTo(pos[0],pos[1])
  c.lineTo(pos[0],pos[1]+10)
  c.stroke();

  c.beginPath()
  c.moveTo(pos[0],pos[1])
  c.lineTo(pos[0],pos[1]-10)
  c.stroke();

  c.beginPath()
  c.moveTo(pos[0],pos[1])
  c.lineTo(pos[0]+10,pos[1])
  c.stroke();
  
  c.beginPath()
  c.moveTo(pos[0],pos[1])
  c.lineTo(pos[0]-10,pos[1])
  c.stroke();
}

/**
 * The function converts a measurement in centimeters to inches.
 * @param params - The parameter "params" in the given function represents the length in centimeters
 * that needs to be converted to inches.
 */
function cm_inch(params) {
    cm = `${params.toFixed(2)} cm`;
    inch = params / 2.54;
    inch = `${inch.toFixed(2)} inch`;
    ska = true;
}

/**
 * It takes a canvas, an image, and a boolean, and then it adds the image to the canvas, and then it
 * draws the text and the grid if the boolean is true
 * @param params - the canvas object
 * @param img - the image to be loaded
 * @param grid - boolean, whether to draw the grid or not
 */
function setImage(params, img) {
    fabric.Image.fromURL(img, function (oImg) {
      oImg.scaleToWidth(cw);
      oImg.hasControls = false;
      oImg.set("selectable", false);
      params.add(oImg);
    });
  }
  
  /**
   * Create a canvas object with the given parameters, and set the height and width to the values of the
   * global variables cw and ch.
   * @param params - The object that contains the parameters for the canvas.
   */
  function createCanvas(params) {
    params.selection = false; // disable group selection
    params.hasControls = false;
    params.lockMovement= false;
    params.setHeight(cw/1.75);
    params.setWidth(cw);
  }

  /**
 * The function opens a UIkit modal with the ID specified in the parameter.
 * @param params - The parameter `params` is a string that represents the ID of the modal that needs to
 * be opened. The function `OpenMod` takes this parameter and uses it to show the corresponding modal
 * using the UIkit framework.
 */
function OpenMod(params) {
    UIkit.modal(`#modal-${params}`).show();
  }

/**
 * It gets the name from local storage and puts it in the right places
 */
function _name() {
  let name = localStorage.getItem('client_name').split(' ')
  //document.getElementById('auswertung_h3').innerHTML += ' '+name[1]+" "+name[0]
  document.getElementById('name_vorname').innerHTML = name[0]+', '+name[1] 
}

function store(val,key,a) {
  analysis[a][key] = val

  for (const key in analysis) {
          const element = analysis[key];
          sattelanalyse.send(`analysis {"${key}":${JSON.stringify(element)}}`)
          if(log)
          console.log('store',`analysis {"${key}":${JSON.stringify(element)}}`);
  }
  
}