#!/bin/bash
#
# btremove.sh
#
#   Entfernt registrierte Bluetooth Geräte.
#
# Aufruf: btremove.sh [<device_name>]
#         Ohne Angabe von <device_name> werden alle Geräte entfernt, deren Name mit "SmartCover" beginnt.
#

# Mac-Adressen der zu entfernenden Geräte
addresses=""

if [ -z "$1" ]; then # Alle SmartCover Geräte
    for address in `bluetoothctl devices | grep 'SmartCover' | cut -d ' ' -f 2`; do
        if [ -z "$addresses" ]; then
            addresses=$address
        else
            addresses="$addresses $address"
        fi
    done
else # Nur das angegebene Gerät
    addresses=`bluetoothctl devices | grep $1 | cut -d ' ' -f 2`
fi

for address in $addresses; do
    bluetoothctl remove $address > /dev/null
    [ $? -ne 0 ] && exit 1
done

exit 0

