/*
 * satteldruckanalyse.js
 * JavaScript Funktionen für satteldruckanalyse.tcls
 *
 */

var conn;
var custommask = 
   [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
    1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
];
var x1questions = new Object({
    "code": "x1",
    "text": "Client's extension 1",
    "fragen": [{
        "code": "code11",
        "antworttyp": 1,
        "text": "Client's 1st extension 1 value",
        "vorgaben": null,
        "antwort": ""
    }, {
        "code": "code12",
        "antworttyp": 1,
        "text": "Client's 1st extension 1 value",
        "vorgaben": null,
        "antwort": ""
    }]
});
var appquestions = new Array();
appquestions[0] = x1questions;
var appsettings = new Object(); //TODO bei wsevent "appsettings" hier speichern
var clientsettings = new Object();

clientsettings.recording_time = 6;
clientsettings.recording_delay = 3;


/**
 * The function `toogleMaskpoint` toggles the value of `custommask` at the specified index and updates
 * the corresponding HTML element.
 * @param i - The parameter `i` represents the row index of the mask point.
 * @param j - The parameter `j` represents the column index of the mask point.
 */
function toogleMaskpoint(i, j) {
    var idx = i * 16 + j;
    var id = `mval${idx}`;

    // console.log ("toogleMaskpoint ("+i+", "+j+")");
    if (custommask[idx] == 0) {
        custommask[idx] = 1;
        document.getElementById(id).innerHTML = `${1}`
    } else {
        custommask[idx] = 0;
        document.getElementById(id).innerHTML = `${0}`
    }
} 

/**
 * The function `sendMask()` sends a command to a WebSocket connection to set a mask, including a mask
 * name and custom mask values.
 * @returns nothing (undefined).
 */
function sendMask() {
    if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) {
        var cmd = "set mask"
        var maskname = document.getElementById("maskname").value;

        if (maskname != "") {
            cmd += ` -store ${maskname}`;
        }
        for (i = 0; i < 28; ++i) {
            for (j = 0; j < 16; ++j) {
                cmd += " ";
                cmd += custommask[i * 16 + j];
            }
        }
        conn.send(cmd);
        return;
    }
    alert("Must connect.");
}

/**
 * The function `createSetClientsettings` sets the values of `recording_time` and `recording_delay`
 * properties in `clientsettings` object, and updates the value of `message2send` input field with a
 * command to set the client settings.
 */
function createSetClientsettings() {
    clientsettings.recording_time = document.getElementById("recording_time").value;
    clientsettings.recording_delay = document.getElementById("recording_delay").value;
    document.getElementById("message2send").value = `set clientsettings ${JSON.stringify(clientsettings)}`;
    document.location.href = '#command'
}


/**
 * The function sets a mask by assigning values to an array and updating corresponding HTML elements.
 * @param values - The "values" parameter is an array containing the values to be set in the
 * "custommask" array. The "custommask" array is a 2-dimensional array with dimensions 28x16. The
 * values in the "values" array will be assigned to the corresponding positions in the "custom
 */
function setMask(values) {
    var i, j;
    var mi;

    for (i = 0; i < 28; ++i) {
        for (j = 0; j < 16; ++j) {
            mi = 16 * i + j;
            custommask[mi] = values[mi];
            document.getElementById(`mval${mi}`).innerHTML = `&nbsp;${values[mi]}&nbsp;`
        }
    }
}


/**
 * The function `sattelbildAktualisieren` updates the source of an image element based on the value of
 * the `i_img` parameter.
 * @param i_img - The parameter `i_img` is an integer that represents the image to be updated.
 */
function sattelbildAktualisieren(i_img) {
    // Der Zeitstempel verhindert die Benutzung des letzten Bildes im Cache.
    switch (i_img) {
        case 0:
            document.getElementById("sattelbild").src = `/sattelbild?image=sda_live&rnd=${(new Date).getTime()}`;
            break;
        case 1:
            document.getElementById("integration1").src = `/sattelbild?image=sda_int1&rnd=${(new Date).getTime()}`;
            break;
        case 2:
            document.getElementById("integration2").src = `/sattelbild?image=sda_int2&rnd=${(new Date).getTime()}`;
            break;
    }
}


/**
 * The function `normwerteAktualisieren` updates the values of HTML elements based on an array of
 * values.
 * @param ids - nv<0 ... 16*28> The `ids` parameter is a string representing the base id of the elements you want to
 * update. The function will append "nv" to this base id to form the actual id of each element to
 * update.
 * @param values - An array of values that need to be updated in the HTML document.
 * @param n_rows - The parameter `n_rows` represents the number of rows in the table or grid where the
 * values will be updated.
 * @param n_cols - The parameter `n_cols` represents the number of columns in a grid or table.
 */
function normwerteAktualisieren(ids, values, n_rows, n_cols) {
    var i;
    var v;

    ids += "nv"
    for (i = 0; i < n_rows * n_cols; ++i) {
        v = values[i];
        let el = document.getElementById(ids + i)
        if(v==0){
            el.innerHTML = `000`
            el.removeAttribute('style')
            el.setAttribute('style','color:black; margin: 2px;')
        } else if (v < 10) {
            el.innerHTML = `00${v}`;
            el.removeAttribute('style')
            el.setAttribute('style','color:red; margin: 2px;')
        } else if (v < 100) {
            el.innerHTML = `0${v}`;
            el.removeAttribute('style')
            el.setAttribute('style','color:red; margin: 2px;')
        } else {
            el.innerHTML = v;
            el.removeAttribute('style')
            el.setAttribute('style','color:red; margin: 2px;')
        }
    }
}


//TODO Das klappt wohl nur, wenn auch JPEG aktiv ist.
/**
 * The function accepts an array of values representing an image, along with the number of rows and
 * columns, and logs the maximum value in the array.
 * @param values - The `values` parameter is an array containing the pixel values of an image. Each
 * element in the array represents the intensity of a pixel.
 * @param n_rows - The parameter `n_rows` represents the number of rows in the image.
 * @param n_cols - The parameter `n_cols` represents the number of columns in the image.
 */
function acceptNormImage(values, n_rows, n_cols) {
    // Nur Logmeldung ausgeben
    var i;
    var max = 0;

    for (i = 0; i < n_rows * n_cols; ++i) {
        if (max < values[i])
            max = values[i];
    }
    console.log(`normvalues, max=${max}`);
}


/**
 * The function `createStoreCommand` creates a command string for storing information based on the
 * provided channel and input values.
 * @param channel - The `channel` parameter represents the channel number for which the store command
 * is being created. It is used to determine which HTML elements to retrieve values from.
 */
function createStoreCommand(channel) {
    var command = "recording store " + channel;
    var infos = new Object();

    // Texte einbauen
    if (channel == 1) {
        infos.product = document.getElementById("product1").value;
        infos.product_label = document.getElementById("product_label1").value;
        infos.notes = document.getElementById("notes1").value;
    } else if (channel == 2) {
        infos.product = document.getElementById("product2").value;
        infos.product_label = document.getElementById("product_label2").value;
        infos.notes = document.getElementById("notes2").value;
    }
    document.getElementById("message2send").value = `${command} ${JSON.stringify(infos)}`;
    document.location.href = '#command'
}


/**
 * The function creates a client command by retrieving values from input fields and formatting them
 * into a JSON string.
 */
function createClientCommand() {
    var command = "session start ";
    var client = new Object();

    client.forename = document.getElementById("forename").value;
    client.surname = document.getElementById("surname").value;
    client.email = document.getElementById("email").value;
    document.getElementById("message2send").value = `${command} ${JSON.stringify(client)}`;
    document.location.href = '#command'
}


/**
 * The function creates a command to store analysis data based on a given set of analyses.
 * @param analyses - The parameter "analyses" is an array that contains the blocks of analysis to be
 * included in the command.
 */
function createAnalysisStoreCommand(analyses) {
    var command = "analysis ";
    var object = new Object();
    var block = "";
    var code = "";
    var value = "";

    for (i in appquestions) {
        block = appquestions[i].code;
        if (analyses.indexOf(block) >= 0) {
            for (j in appquestions[i].fragen) {
                code = appquestions[i].fragen[j].code;
                value = document.forms.appquestions.elements[code].value;
                if (object[block] === undefined) {
                    object[block] = new Object()
                }
                object[block][code] = value;
            }
        }
    }
    document.getElementById("message2send").value = `${command} ${JSON.stringify(object)}`;
    document.location.href = '#command'
}

/**
 * The function "handleSQLResult" updates the innerHTML of an element with the number of rows received
 * and logs each row to the console.
 * @param rows - The `rows` parameter is an array of objects representing the result of a SQL query.
 * Each object in the array represents a row in the result set, with each property of the object
 * representing a column in the row.
 */
function handleSQLResult(rows) {
    document.getElementById("message").innerHTML = `sqlresult: ${rows.length} rows received (see console)`;
    rows.forEach(
        (row) => {
            console.log(row);
        }
    );
}

var onsqlresult = handleSQLResult;

/* Create a session gallery
   (Das geht sicher auch eleganter.)
*/

var session_recording_ids = new Array();
var session_recording_results = new Array();
var last_recording_ix = -1;
var next_recording_ix = 0;
var last_recording_id = 0;
var image_accepted = false;
var results_accepted = false;

/**
 * The function "addRecordingToGallery" adds a recording image and its corresponding velocity score to
 * a gallery.
 */
function addRecordingToGallery() {
    var image_id = "integration_" + last_recording_id;

    document.getElementById("gallery").innerHTML += `<div style="flex-direction: column;align-items: center;width: 20em" uk-grid><img id="${image_id} " src="/sattelbild?image=sda_int3&rnd=${(new Date).getTime()}"> <div>veloscore: ${session_recording_results[last_recording_ix].veloscore}</div></div>`;
    image_accepted = false;
    results_accepted = false;
}


/**
 * The function accepts a recording image, sets a flag to indicate acceptance, and if the results are
 * also accepted, adds the recording to a gallery and retrieves the next recording.
 */
function acceptRecordingImage() {
    image_accepted = true;
    if (results_accepted) {
        addRecordingToGallery()
    }
    retrieveNextRecording();
}


/**
 * The function "acceptRecordingResults" is used to store and display a message in a session recording,
 * and if an image has also been accepted, it adds the recording to a gallery.
 * @param msg - The parameter "msg" is the message that is being accepted and processed in the
 * function. It could be any type of message or data that needs to be stored or used in the function.
 */
function acceptRecordingResults(msg) {
    // msg festhalten für die Anzeige
    if (last_recording_id == 0) {
        // => Ursprung ist ein eingegebenes Kommando.
        session_recording_results.length = 0;
        session_recording_results.push(msg);
        last_recording_ix = 0;
    } else {
        // => Ursprung ist createSessionGallery().
        session_recording_results.push(msg);
    }
    results_accepted = true;
    if (image_accepted) {
        addRecordingToGallery()
    }
}


/**
 * The function retrieves the next recording based on the current index and sends a request to retrieve
 * the recording data.
 * @returns The function does not explicitly return a value.
 */
function retrieveNextRecording() {
    if (next_recording_ix >= session_recording_ids.length) {
        console.log("No more recordings.");
        location.href = "#vergleichsgalerie";
        onsqlresult = handleSQLResult;
        last_recording_id = 0;
        return;
    }
    last_recording_id = session_recording_ids[next_recording_ix];
    last_recording_ix = next_recording_ix;
    if (document.getElementById("session_compare_mode").checked) {
        conn.send(`recording retrieve ${last_recording_id}`);
    } else {
        conn.send(`recording retrieve ${last_recording_id} 3`);
    }
    ++next_recording_ix;
}


/**
 * The function accepts an array of rows and extracts the recording IDs from each row, then sets some
 * variables and retrieves the next recording.
 * @param rows - The "rows" parameter is an array of objects. Each object represents a row of data and
 * contains a property called "recording_id". The function loops through each row and pushes the value
 * of "recording_id" into the "session_recording_ids" array.
 */
function acceptRecordingIds(rows) {
    onsqlresult = null;
    session_recording_ids = new Array();
    session_recording_results = new Array();
    for (const row of rows) {
        session_recording_ids.push(row.recording_id);
    }
    next_recording_ix = 0;
    last_recording_ix = -1;
    //TODO Fehler! Das ist immer 0.
    console.log(`${next_recording_ix} recordings accepted.`);
    document.getElementById("gallery").innerHTML = "";
    image_accepted = false;
    results_accepted = false;
    retrieveNextRecording();
}


/**
 * The function creates a session gallery by retrieving recording IDs from a database based on a
 * session ID.
 * @returns The function does not explicitly return anything.
 */
function createSessionGallery() {
    var session_id = parseInt(document.getElementById("session_id").value);

    if (typeof conn != "object" || conn.readyState != WebSocket.OPEN) {
        alert("Must connect.");
        return;
    }
    if (isNaN(session_id)) {
        alert("session_id must be an integer.");
        return;
    }
    onsqlresult = acceptRecordingIds;
    conn.send(`sql SELECT recording_id FROM recordings WHERE analysis=2 AND session_id=${session_id} ORDER BY finished`);
}


/**
 * The function `handleWSMessage` is responsible for processing WebSocket messages and updating the
 * HTML elements based on the received message.
 * @param {String} wsmessage - The `wsmessage` parameter is a string that represents a message received from a
 * WebSocket connection. It is expected to be a JSON string that can be parsed into an object. The
 * function then handles different events based on the properties of the parsed object.
 * @returns The function `handleWSMessage` does not return any value. It performs various actions based
 * on the received WebSocket message, such as updating the DOM elements, calling other functions, and
 * displaying messages.
 */
function handleWSMessage(wsmessage) {
    let msg;
    let statusinfo = document.getElementById('statusinfo');
    let maxValue = document.getElementById('max_value');
    let message = document.getElementById("message");

    try {
        msg = JSON.parse(wsmessage);
    } catch (error) {
        statusinfo.innerHTML = `Kein gültiger JSON-String: "${wsmessage}"`;
        return;
    }
    //TODO Gibt es msg.wsevent ? Nein => error?
    // msg.wsevent == undefined
    // msg.error => class: ???
    if (msg.wsevent == "sda_live") {
        sattelbildAktualisieren(0);
    } else if (msg.wsevent == "sda_int1") {
        sattelbildAktualisieren(1);
    } else if (msg.wsevent == "sda_int2") {
        sattelbildAktualisieren(2);
    } else if (msg.wsevent == "sda_int3") {
        acceptRecordingImage();
    } else if (msg.wsevent == "sattelnorm") {
        if (msg.imagetype == "sda_live") {
            normwerteAktualisieren("l", msg.values, msg.n_rows, msg.n_cols);
        } else if (msg.imagetype == "sda_int1") {
            normwerteAktualisieren("i1", msg.values, msg.n_rows, msg.n_cols);
        } else if (msg.imagetype == "sda_int2") {
            normwerteAktualisieren("i2", msg.values, msg.n_rows, msg.n_cols);
        } else if (msg.imagetype == "sda_int3") {
            acceptNormImage(msg.values, msg.n_rows, msg.n_cols);
        }
    } else if (msg.wsevent == "max_value") {
        maxValue.innerHTML = `Max.:${msg.value}%`;
    } else if (msg.wsevent == "ttystate") {
        message.innerHTML = wsmessage.replace(/</g, "&lt;").replace(/>/g, "&gt;");
        if (msg.state == "active") {
            ChangeColor("usb_state", "green");
        } else {
            ChangeColor("usb_state", "gray");
        }
    } else if (msg.wsevent == "ttychange") {
        message.innerHTML = wsmessage.replace(/</g, "&lt;").replace(/>/g, "&gt;");
        if (msg.change == "plugged") {
            ChangeColor("usb_state", "green");
        } else {
            ChangeColor("usb_state", "gray");
        }
    } else if (msg.wsevent == "btevent") {
        message.innerHTML = wsmessage.replace(/</g, "&lt;").replace(/>/g, "&gt;");
        if (msg.btevent == "data") {
            ChangeColor("usb_state", "grey");
            ChangeColor("bt_state", "green");
            //document.getElementById("usb_state").color = "grey";
            //document.getElementById("bt_state").color = "green";
        } else {
            if (msg.btevent == "disconnected") { // reguläres Verbindungsende
                // Hier nichts weiter zu tun.
            } else if (msg.btevent == "ambiguity") { // Mehdeutigkeit
                alert_text = "Multiple devices found:";
                command = "btconnect"
                for (i in msg.devices) {
                    alert_text += "\n";
                    alert_text += msg.devices[i];
                    command += " ";
                    command += msg.devices[i];
                }
                alert(alert_text);
                document.getElementById("message2send").value = command;
            } else if (msg.btevent == "error") { // Verbindungsfehler
                if (msg.class == "fail") { // Das Herstellen der Verbindung ist gescheitert.
                    alert(`Could not establish Bluetooth connection:\n${msg.msg}`);
                } else { // Anderer Verbindungsfehler
                    alert(`Bluetooth connection error:\n${msg.msg}`);
                }
            }
            ChangeColor("bt_state", "grey")
            //document.getElementById("bt_state").color = "grey";
            // Ob USB verfügbar ist kann hier nicht bestimmt werden.
            // Die App sendet nach dem Bluetooth-Verbindungsende eine diesbezügliche Statusmeldung. (ttystate)
        }
    } else if (msg.wsevent == "result1") {
        message.innerHTML = wsmessage.replace(/</g, "&lt;").replace(/>/g, "&gt;");
        if (msg.product !== undefined) {
            document.getElementById("product1").value = msg.product;
        }
        if (msg.product_label !== undefined) {
            document.getElementById("product_label1").value = msg.product_label;
        }
        if (msg.notes !== undefined) {
            document.getElementById("notes1").value = msg.notes;
        }
    } else if (msg.wsevent == "result2") {
        message.innerHTML = wsmessage.replace(/</g, "&lt;").replace(/>/g, "&gt;");
        if (msg.product !== undefined) {
            document.getElementById("product2").value = msg.product;
        }
        if (msg.product_label !== undefined) {
            document.getElementById("product_label2").value = msg.product_label;
        }
        if (msg.notes !== undefined) {
            document.getElementById("notes2").value = msg.notes;
        }
    } else if (msg.wsevent == "result3") {
        acceptRecordingResults(msg);
    } else if (msg.wsevent == "sqlresult") {
        if (onsqlresult !== null) {
            onsqlresult(msg.rows);
        }
    } else if (msg.wsevent == "mask") {
        setMask(msg.values);
    } else if (msg.wsevent == "appquestions") {
        appquestions = msg.appquestions;
        appquestions.push(x1questions);
        // in div "appquestions" anzeigen
        let html = "";
        //html += "<TABLE>";
        let codes = new Array();
        for (i in appquestions) {
            html += `<h3>${appquestions[i].text}(${appquestions[i].code})</h3>`;
            for (j in appquestions[i].fragen) {
                html += `${appquestions[i].fragen[j].text}(${appquestions[i].fragen[j].code})`;
                html += `<input class="uk-input" placeholder="" name="${appquestions[i].fragen[j].code}">`
                //TODO Typ berücksichtigen
                // Extrawurst bei asymmetrie
                //html += "</TR>";
            }
            var code = appquestions[i].code;
            codes.push(code);
            html += `<button class="uk-button uk-button-primary" type="button" onclick="createAnalysisStoreCommand(['${code}'])">createAnalysisStoreCommand(['${code}'])</button>`
        }
        //html += "</TABLE>";
        html += `<br><br><button class="uk-button uk-button-primary" type="button" onclick="createAnalysisStoreCommand(['${codes.join("','")}'])">createAnalysisStoreCommand(['${codes.join("','")}'])</button>`;
        html += "<br><small>('x1' added by client test application.)</small>";
        document.getElementById("appquestions").innerHTML = html;
        message.innerHTML = "''appquestions' stored in corresponding global variable.";
        location.href = "#appquestion";
        //console.log ("Inspect variable 'appquestions'!");
    } else {
        message.innerHTML = wsmessage.replace(/</g, "&lt;").replace(/>/g, "&gt;");
    }
    //TODO clientsettings übernehmen
}


/**
 * The function "connect" establishes a WebSocket connection and handles the status and messages
 * received from the server.
 */
function connect() {
    let statusinfo = document.getElementById('statusinfo');
    let websocket = document.getElementById('ws_url').value;

    if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) conn.close();

    try {
        conn = new WebSocket(websocket, ["soap", "wamp"])
    } catch (error) {
        statusinfo.innerHTML = `Fehler:\n${error}`
    }

    switch (conn.readyState) {
        case WebSocket.CONNECTING:
            statusinfo.innerHTML = "WebSocket-Verbindung wird hergestellt."
            conn.onopen = (evt) => {
                statusinfo.innerHTML = "WebSocket-Verbindung ist hergestellt.";
                conn.onclose = (evt) => {
                    statusinfo.innerHTML = "WebSocket-Verbindung wurde geschlossen.";
                    document.getElementById("message").innerHTML = "";
                    // Weder USB noch BT Verbindung
                    ChangeColor("usb_state", "grey");
                    ChangeColor("bt_state", "grey");
                };
            };
            break;
        case WebSocket.OPEN: // Verbindung ist hergestellt und bereit darüber zu kommunizieren.
            statusinfo.innerHTML = "WebSocket-Verbindung ist hergestellt.";
            break;
        case WebSocket.CLOSED: // Die Verbindung konnte nicht hergestellt werden.
            statusinfo.innerHTML = "WebSocket-Verbindung konnte nicht hergestellt werden.";
            break;
    }
    // Eingetroffene Meldung vom Server bearbeiten
    conn.onmessage = (evt) => {
        handleWSMessage(evt.data);
    };
}

/**
 * The function disconnect checks if a WebSocket connection is open and closes it, and then changes the
 * color of two elements to grey.
 * @returns nothing (undefined) if the condition `(typeof conn == "object" && conn.readyState ==
 * WebSocket.OPEN)` is not met.
 */
function disconnect() {
    if (!(typeof conn == "object" && conn.readyState == WebSocket.OPEN)) {
        return;
    }
    conn.close();
    ChangeColor("usb_state", "grey");
    ChangeColor("bt_state", "grey");
}

/**
 * The clearMessage function clears the value of an input field with the id "message2send".
 */
function clearMessage() {
    document.getElementById("message2send").value = "";
}


/**
 * The function sends a message through a WebSocket connection if it is open, otherwise it displays an
 * alert.
 * @param value - The `value` parameter is the message that you want to send through the WebSocket
 * connection. It can be any data type that can be serialized and sent over the network, such as a
 * string, number, object, or array.
 */
function sendMessage(value) {
    if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) {
        document.getElementById("message").innerHTML = "";
        conn.send(value);
    } else {
        alert("Must connect.");
    }
}

/*{{{ nicht mehr benötigt
//TODO retrieveXY() ist überflüssig, weil das auch als Kommando eingegeben werden kann.
// Wenn es hier entfernt wird, dann vorher in der HTML-Datei entfernen.

function retrieveRecording () {
    var db_id;
    var left_right;
    var command;

    db_id = document.getElementById("db_id").value;
    left_right = document.getElementById("left_right").value;
    command = "retrieve recording "+db_id+" "+left_right;
    console.log (command);
    // ws-Kommando schicken
    document.getElementById("message2send").value = command;
    sendMessage ();
}

function retrieveSession () {
    var db_id;
    var left_right;
    var command;

    db_id = document.getElementById("db_id").value;
    command = "retrieve session "+db_id;
    console.log (command);
    // ws-Kommando schicken
    document.getElementById("message2send").value = command;
    sendMessage ();
}
}}}*/

/**
 * The function "ChangeColor" changes the color of an element with a given name to a specified color.
 * @param {String} name - The name parameter is the id of the HTML element that you want to change the color of.
 * @param {String} color - The `color` parameter is a string that represents the color value you want to change
 * the element to. It can be any valid CSS color value, such as "red", "#FF0000", or "rgb(255, 0, 0)".
 */
function ChangeColor(name, color) {
    let ele = document.getElementById(name)
    ele.removeAttribute('style')
    ele.setAttribute('style', `color:${color}`)
}

function genMask(){

    let frame = document.getElementById(`mask`);
    let html="";

    for (i=0; i<28; ++i) {
       html += "<div style='display: flex'>";
        for (j=0; j<16; ++j) {
            html += `<div style="cursor: pointer; margin: 0 0.5em" id="mval${i*16+j}" onclick="toogleMaskpoint (${i}, ${j});">${custommask[i*16+j]}</div>`;
        }
        html += ("</div>");
    }
    frame.innerHTML = html
}

/**
 * The function `genNormFrame` generates a grid of div elements with unique IDs and displays them
 * inside a specified HTML element.
 * @param num - The `num` parameter is used to determine the value of the `lnv` variable. It is an
 * integer value that can be either 0, 1, or 2.
 */
function genNormFrame(num) {
    let frame = document.getElementById(`norm${num}`)
    let lnv = num ===2 ? "i2nv" : num ===1 ? "i1nv" : num===0 ? "lnv" : ""

    let html=""

    for (i_row=27; i_row>=0; --i_row) {
        i = i_row * 16;
        html += "<div style='display: flex'>";
        for (i_col=0; i_col<16; ++i_col) {
            html += `<div id="${lnv}${i}" style="margin: 2px">000</div>`;
            ++i;
        }
        html += "</div>";
    }
    frame.innerHTML=html
}

genNormFrame(0)
genNormFrame(1)
genNormFrame(2)
genMask()