/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/* 
    Created on : 04.08.2022, 18:01:55
    Author     : Peter Bauer
*/
const products = JSON.parse(sessionStorage.getItem('produkte'));
const user = sessionStorage.getItem('user');
const imgURL = "https://produkte.velometrik.de/";
const baseURL ="https://www.the-perfect-fit-system.com/"
const toMain = document.getElementById('products_div');
var produktdetails = new Object();

console.log(products,user,imgURL,toMain);

for (const i of products) {
    createProductCard(i);
}

/**
 * The function `createProductCard` creates a product card element with information from a JSON object
 * and makes an API call to retrieve additional information.
 * @param jsn - The parameter `jsn` is an object that contains information about a product. It likely
 * includes properties such as `vmkid`, `herst`, and `typ`, which are used to populate the product
 * card.
 */
function createProductCard(jsn) {
    console.log('jsn',jsn);
    let card    = newElement({element:'div',cls:['uk-card','uk-card-default','uk-grid-collapse','uk-child-width-1-2@s','uk-margin'],attr:[['uk-grid',''],['style','padding: 0;box-shadow: none;border:none;border-bottom: 1px solid var(--light-2);border-radius: 0;']]},toMain)
        let imgLeft = newElement({element:'div',cls:['uk-card-media-left','uk-cover-container'],attr:[['style','display: flex;flex-direction: column;justify-content: center;']]},card)
            let img     = newElement({element:'img',attr:[['src',`${imgURL}${jsn.vmkid}.jpg`],['width','600'],['height','400']]},imgLeft)
            //let canvas  = newElement({element:'canvas',attr:[['width','600'],['height','400']]},imgLeft)
        let div = newElement({element:'div'},card)
            let body = newElement({element:'div',cls:['uk-card-body']},div)
            let h3   = newElement({element:'h3',cls:['uk-card-title']},body).innerHTML = jsn.herst
            let h3_2 = newElement({element:'h3',cls:['uk-card-title']},body).innerHTML = jsn.typ
            let info = newElement({element:'div',id:`info_${jsn.vmkid}`},body)
            AXIOS_Produkt_info(jsn.vmkid)
}

/**
 * The AXIOS_Produkt_info function makes an HTTP GET request to a specified URL with parameters and
 * credentials, and then performs additional actions based on the response.
 * @param vmkid - The `vmkid` parameter is a unique identifier for a product. It is used in the
 * `AXIOS_Load_Details` function to load the details of the product.
 */
function AXIOS_Produkt_info(vmkid) {
    axios.get(`${ baseURL }vmkservice/login`, {
            params: {
                portaluser: user,
                passwd: 'velopasswort'
            },
            method: 'GET',
            withCredentials: true
        })
        .then(response => {
            if (response.data === '12 forbidden') {
                sessionStorage.setItem('error', JSON.stringify(response));
                OpenModDialog({type:'error',title:["error"],msg:`${response.data}`,master_btn:['button_ok']})
                return;
            }
            AXIOS_Load_Details(vmkid);
        })
        .catch(err => {
            getError(err)
        });

}
/**
 * The AXIOS_Load_Details function makes an HTTP GET request using Axios to retrieve product details
 * based on a given vmkid, and then displays the details in a table on the webpage.
 * @param vmkid - The `vmkid` parameter is used to specify the ID of a virtual machine. It is passed as
 * a parameter in the Axios GET request to retrieve details about the virtual machine from the server.
 */
function AXIOS_Load_Details(vmkid) {
    axios.get(`${ baseURL }vmkservice/produkt`, {
            params: {
                lang: 'deu',
                vmkid: vmkid
            },
            method: 'GET',
            withCredentials: true
        })
        .then(response => {
            if (response.data === '12 forbidden') {
                console.log('error');
                return;
            }
            produktdetails = response.data;
            console.log(produktdetails);
            let to = document.getElementById(`info_${vmkid}`)
            let table = newElement({element:'table',cls:['uk-table','uk-table-striped'],attr:[['style','font-size: x-small;']]},to);
            let tbody = newElement({element:'tbody'},table);
            let inter = setInterval(()=> {
                for (const i of produktdetails) {
                    let tr = newElement({element:'tr'},tbody)
                    for (const key in i) {
                            const element = i[key];
                            if(key == 'eigenschaft'){
                                newElement({element:'td',attr:[['key',`${element.replaceAll(' ','_')}`],['style','padding:1em;']]},tr).innerHTML = element || ""
                            } else {
                                if(element){
                                    if(element.includes("a")||element.includes("e")||element.includes("o")||element.includes("i")||element.includes("u")){
                                        newElement({element:'td',attr:[['key',`${element.replaceAll(' ','_')}`],['style','padding:1em;']]},tr).innerHTML = element || ""
                                    } else {
                                        newElement({element:'td',attr:[['style','padding:1em;']]},tr).innerHTML = element || ""
                                    }
                                }
                            }
                    }
                }
                translatejs();
                to.classList.remove('uk-hidden')
                clearInterval(inter);
                }, 0);
            AXIOS_logout();

        })
        .catch(err => {
            getError(err)
        });
}
/**
 * The AXIOS_logout function sends a GET request to the "vmkservice/logout" endpoint using the Axios
 * library in JavaScript.
 */
function AXIOS_logout() {
    axios.get(`${ baseURL }vmkservice/logout`)
        .then(response => {
            //console.log('logout',response);
        })
        .catch(err => {
            getError(err)
        });
}