#! /bin/bash
#
# vmkstationd.sh
#

### BEGIN INIT INFO
# Provides:          vmkstationd
# Required-Start:    $local_fs $remote_fs $network $syslog $named
# Required-Stop:     $local_fs $remote_fs $network $syslog $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# X-Interactive:     true
# Short-Description: Velometrik Arbeitsstation
# Description:       Start des Stationsservers
#  Dieses Skript startet den Server einer Velometrik-Arbeitsstation.
### END INIT INFO

# Das Skript nach /etc/init.d kopieren und mit
#$ update-rc.d vmkstationd.sh defaults
# scharf schalten.


VMKSTATIOND=/usr/local/vmkstationd/vmkstationd.tcl
LOGDIR=/var/local/log

# Zur Vorversion zurückgehen, sofern es die gibt
downgrade ()
{
    # update.sh und activate.sh für /usr/local/vmkstationd_last
    if [ -x /usr/local/vmkstationd_last/setup/update.sh ]; then # Vorversion existiert
        /usr/local/vmkstationd_last/setup/update.sh >> ${LOGDIR}/vlbsetup.log
        if [ $? -ne 0 ]; then
            return 1
        fi
        /usr/local/vmkstationd_last/setup/activate.sh >> ${LOGDIR}/vlbsetup.log
        if [ $? -ne 0 ]; then
            return 1
        fi
        # last wird aktuell
        rm -f /usr/local/vmkstationd
        mv /usr/local/vmkstationd_last /usr/local/vmkstationd
    fi
}

# PID des laufenden Prozesses oder leer.
PID=`pgrep -f "/usr/bin/tclsh $VMKSTATIOND"`

case "$1" in
    start)
        if [ -n "$PID" ]; then
            echo "vmkstationd laeuft bereits. PID=${PID}."
            exit
        fi
        if [ ! -d $LOGDIR ]; then
            mkdir -p $LOGDIR
        fi
        if [ -x /usr/local/vmkstationd_next/setup/activate.sh ]; then # Eine neue Version wurde bereitgestellt.
            # => Neue Version zum Starten aktivieren
            /usr/local/vmkstationd_next/setup/activate.sh >> ${LOGDIR}/vlbsetup.log
            if [ $? -ne 0 ]; then # Fehler
                if [ -x /usr/local/vmkstationd_last/setup/update.sh ]; then # wiederherstellen
                    downgrade
                fi
            fi
        elif [ -x /usr/local/vmkstationd_last/setup/update.sh ]; then # Start mit neuer Version fehlgeschlagen
            # => Zur vorversion zurückgehen
            downgrade
        fi
        # Die (nunmehr) aktuelle Version starten.
        cd $LOGDIR
        $VMKSTATIOND -L ${LOGDIR}/vmkstationd.log &
        ;;
    status)
        if [ -n "$PID" ]; then
            echo "vmkstationd laeuft. PID=${PID}."
            exit 0
        else
            echo "vmkstationd laeuft nicht."
            exit 3
        fi
        ;;
    stop)
        if [ -z "$PID" ]; then
            echo "vmkstationd laeuft nicht."
        fi
        # Es müssen auch die Childprozesse gekillt werden.
        CHILDPIDS=`pgrep -P $PID`
        for CHILDPID in $CHILDPIDS; do
            kill $CHILDPID 
            wait $CHILDPID 
            echo "vmkstationd child process $CHILDPID beendet."
        done
        kill $PID
        if [ $? -eq 0 ]; then
            echo "vmkstationd beendet."
        else
            echo "vmkstationd konnte nicht beendet werden."
        fi
        ;;
    restart)
        $0 stop
        $0 start
        ;;
    *)
        echo "Usage: $0 {start|status|stop|restart}"
        exit 1
        ;;
esac

