#!/bin/bash
#
# .../setup/update.sh
#
# Velometrik GmbH
#
# Installationsskript für vmkstationd
#
# Author: Siegmar Müller
# Historie:
#   28.10.2019  Begonnen
#   22.11.2019  Fertiggestellt
#

if [ -z "$LOGFILE" ]; then
    LOGFILE=/var/local/log/vmkupdate.log
else
    echo -e "\n-------------------------------------------------------------------------------" | tee -a $LOGFILE
fi
echo "update.sh `date '+%d.%m.%Y %H:%M:%S'`" | tee -a $LOGFILE
# Debianpakete prüfen/nachinstallieren
# Zuvor die Paketlisten aktualisieren
# apt-get update liefert auch bei fehlender Internetverbindung den Status 0.
# apt-get install hingegen liefert keinen Fehlerstatus.
apt-get update 2>&1 | tee -a $LOGFILE
test ${PIPESTATUS[0]} -ne 0 && exit 1
DEBIAN_PAKETE="tcl8.6 tcl-thread tcllib tcl-tls"
for DEB_PAKET in $DEBIAN_PAKETE; do
    dpkg -l $DEB_PAKET > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        echo "$DEB_PAKET ist bereits installiert." | tee -a $LOGFILE
    else
        apt-get -y install $DEB_PAKET 2>&1 | tee -a $LOGFILE
        test ${PIPESTATUS[0]} -ne 0 && exit 1
    fi
done
# Verzeichnis des entpackten Installationspaketes:
NEWDIR=`echo \`realpath $0\` | sed 's?/setup/[a-z]*\.sh??'`
# Basisverzeichnis des entpackten Installationspaketes:
echo "Neue Version in: $NEWDIR" | tee -a $LOGFILE
# Dateien, die nicht im Hauptverzeichnis bleiben, an die richtige Stelle schaffen:
cp -v $NEWDIR/setup/dhcpcd.exit-hook /etc/dhcpcd.exit-hook 2>&1 | tee -a $LOGFILE
test ${PIPESTATUS[0]} -ne 0 && exit 1
# Link auf neue Version erzeugen, wenn sie tatsächlich neu ist.
CREATE_LINK=true
if [ -L /usr/local/vmkstationd ]; then
    echo "Aktuelle Version in: `readlink /usr/local/vmkstationd`" | tee -a $LOGFILE
    if [ `readlink /usr/local/vmkstationd` == $NEWDIR ]; then
        echo "Aktuelle Version ist bereits die neue." | tee -a $LOGFILE
        CREATE_LINK=false
    fi
else
    echo "Es gibt keine aktuelle Version" | tee -a $LOGFILE
fi

if `$CREATE_LINK`; then
    rm -f -v /usr/local/vmkstationd_next | tee -a $LOGFILE
    ln -s -v $NEWDIR /usr/local/vmkstationd_next 2>&1 | tee -a $LOGFILE
    test ${PIPESTATUS[0]} -ne 0 && exit 1
    echo "vmkstationd_next auf $NEWDIR verlinkt." | tee -a $LOGFILE
fi

