/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/*
    Created on : 12.06.2021, 15:08:29
    Author     : Peter Bauer
*/

//TODO aufräumen Funktionen prüfen und wenn entfernen bei nicht nutzung
const host = location.origin;
const ws = host.replace('http','ws');
const apps= "satteldruckanalyse";

function SystemCards() {
    try {
      fetch("/production/json/cards.json", {
        mode: "no-cors",
      }) // disable CORS because path does not contain http(s)
      .then((res) => res.json())
      .then((data) => (Setting_List(data.systemcards)));
    } catch (error) {
      getError(error)
    }
}

SystemCards()

const restoreForm = document.forms.namedItem("restore2");
//console.log(restoreForm);
restoreForm.addEventListener(
    "submit",
    (event) => {
        const formData = new FormData(restoreForm);
        const request = new XMLHttpRequest();
        request.open("POST", "/db_buprest", true);
        request.onload = () => {
            if (request.status === 200) {
                OpenModDialog({type:'warn',title:["config_reinit"],msg:`${aLangKeys[lang]['new_init']}`,master_btn:['button_ok','reinit()']})
            } else {
                OpenModDialog({type:'error',title:["db_upload_err"],msg:`${request.responseText}`,master_btn:['button_ok']})
            }
        };
        request.send(formData);
        event.preventDefault();
    },
    false
);

const api = new WebSocket(`${ws}/apps/${apps}`, ["soap", "wamp"]);

var onsqlresult = getLog();
var setting = new Object();

//var interA = setInterval(function () {
//    api.send('analysis ["x99"]')
//    clearInterval(interA);
//}, 500);

api.onopen = () => {
    api.send(`session restart 1`)
    api.send('analysis ["x99"]')
}
api.onmessage = (msg) => {
    console.log(msg.data);
    let data = new Object();
    try {
        data = JSON.parse(msg.data)   
    } catch (error) {
        console.error(error)
    }
    
    if(log)
        console.log('api.onmessage',data);

    if (data.wsevent === "sqlresult"){
        try {
            onsqlresult (data.rows);           
        } catch (error) {
            console.log(error);
        }
    }

}

function getLog(params) {
    console.log(params||'no SQL');
}

function setSetting() {
    api.send(`analysis {"x99":${JSON.stringify(setting)}}`)
}
/**
 * It sends a request to the server to change the language file
 */
function setLanguagefile() {
    var systemsprache = document.getElementById("systemsprache").value;

    var url = "/production/setlanguagefile.tcls?systemsprache=" + systemsprache;

    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_system_hilfe\"><!--Einstellungen übernehmen und rebooten--></span></p>";

    /* Sending a request to the server. */
    httpSetconfig.open("GET", url, true);
    httpSetconfig.send();

    translatejs();
}

/**
 * It sends a request to the server to set the keyboard layout
 */
function setKeyboardfile() {
    var keyboardlayout = document.getElementById("keyboardlayout").value;

    var url = `/production/setkeyboardfile.tcls?keyboardlayout=${keyboardlayout}`;

    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_system_hilfe\"><!--Einstellungen übernehmen und rebooten--></span></p>";

    /* Sending a request to the server. */
    httpSetconfig.open("GET", url, true);
    httpSetconfig.send();

    translatejs();
}

/**
 * It sends a request to the server to set the configuration file
 */
function setConfigfile() {
    let stationsnummer = document.getElementById("stationsnummer").value;
    
    /*The "encodeURIComponent()" function is used to encode the value of the input to make it safe to be used in a URL. */
    let farbe = encodeURIComponent(document.getElementById("farbe").value);
    let empfindlichkeit = document.getElementById("empfindlichkeit").value;
    let webservice = document.getElementById("webservice").value;
    let url_smartcube = document.getElementById("url_smartcube").value;
    
    /* The above code is checking if the variable `url_smartcube` contains the string "http://". If it
    does, it splits the string at "http://" and takes the second part of the split (i.e. the part after
    "http://"). Then it replaces all forward slashes ("/") in that part with an empty string and assigns
    the resulting string back to `url_smartcube`. Essentially, it is removing the "http://" and any
    forward slashes from the URL. */
    if(url_smartcube.includes('http://')){
        let url = url_smartcube.split('http://')[1]
        url_smartcube = url.replaceAll('/','')
    }
    //var url = "/production/setconfigfile.tcls?stationsnummer=" + stationsnummer + "&farbe=" + farbe + "&empfindlichkeit=" + empfindlichkeit + "&webservice=" + webservice + "&url_smartcube=" + url_smartcube;
    const url = `/production/setconfigfile.tcls?stationsnummer=${stationsnummer}&farbe=${farbe}&empfindlichkeit=${empfindlichkeit}&webservice=${webservice}&url_smartcube=${url_smartcube}`;

    /* Sending a request to the server. */
    httpSetconfig.open("GET", url, true);
    httpSetconfig.send();


    OpenModDialog({type:'warn',title:["config_reinit"],msg:`${aLangKeys[lang]['new_init']}`,master_btn:['button_ok','reinit()']})

}

/**
 * It sends a request to the server to download the update file
 */
function downloadFile() {
    gears_on()
    var updatefile = document.getElementById("updatefile").value;

    /* Checking if the updatefile is empty. If it is empty, it will change the border and background
    color of the input field. */
    if (updatefile) {

        const url = `vlbupdate.tcls?updatefile=${updatefile}`;

        const oReq = new XMLHttpRequest();

        oReq.addEventListener("progress", updateProgress);
        oReq.addEventListener("load", transferComplete);
        oReq.addEventListener("error", transferFailed);
        oReq.addEventListener("abort", transferCanceled);

        oReq.open("GET", url, true);
        oReq.send();

        console.log(oReq.progress);
        /* Setting the value of the element with the id `updatemassage` to the value of the response. */
        oReq.onload = function(e) {
            var arraybuffer = oReq.response; // not responseText
            console.log(arraybuffer);
            if (arraybuffer.includes("Error: 500")) {
                document.getElementById("updatemassage").value = "UPDATE FEHLGESCHLAGEN"
            } else {
                document.getElementById('updatemassage').value = arraybuffer
            }
            setTimeout(() => {
                gears_off()
                setReboot()
            }, 500);
        }

        // progress on transfers from the server to the client (downloads)
        /**
         * The function is called when the progress event is fired. The progress event is fired
         * periodically when the data is being transferred. The event object contains the total number
         * of bytes that will be transferred (total) and the number of bytes transferred so far
         * (loaded)
         * @param oEvent - The event object.
         */
        function updateProgress(oEvent) {
            if (oEvent.lengthComputable) {
                var percentComplete = oEvent.loaded / oEvent.total * 100;
                console.log(percentComplete);
                document.getElementById('updatemassage').value += "Einen Moment bitte " + percentComplete;
            } else {
                // Unable to compute progress information since the total size is unknown
            }
        }

        /**
         * The function transferComplete() is called when the transfer is complete
         * @param evt - The event object.
         */
        function transferComplete(evt) {
            console.log("The transfer is complete.", evt);
        }

        /**
         * If the file transfer fails, the user will be notified
         * @param evt - The event object.
         */
        function transferFailed(evt) {
            console.log("An error occurred while transferring the file.", evt);
        }

        /**
         * The transfer has been canceled by the user.
         * @param evt - The event object.
         */
        function transferCanceled(evt) {
            console.log("The transfer has been canceled by the user.", evt);
        }

        // document.getElementById("message").innerHTML = "";
//
        // /* Sending a request to the server. */
        // httpSetconfig.open("GET", url, true);
        // httpSetconfig.send();

        translatejs();
        return;

    }
    document.getElementById("updatefile").style.border = "1px solid red";
    document.getElementById("updatefile").style.background = "#ffd6d6";
    document.getElementById("updatefile").setAttribute("placeholder", "e.g. vlbupdate-XXX.tar.gz");
}

/**
 * "When the user clicks on the gear icon, show the gear modal."
 * 
 * The `console.log` statement is a debugging tool. It's a way to print out a message to the browser's
 * console
 */
function gears_on() {
    console.log('show gear');
    $('#gear').modal('show');
}

/**
 * "When the user clicks the gear icon, hide the gear modal."
 * 
 * The first line of the function is a console.log statement. This is a debugging tool that will print
 * the text "hide gear" to the console
 */
function gears_off() {
    console.log('hide gear');
    $('#gear').modal('hide');
}
/**
 * It shows a modal dialog with a message
 */
function setReboot() {

    // Request starten
    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_rebootvelobox\"><!--Reboot Velobox--></span></p>";

    translatejs();

    $("#reboot").modal('show');
}

if(localStorage.getItem('right_col')){
    for (let name of document.getElementsByClassName('back')) {
        if(name.childNodes[1].classList.value === localStorage.getItem('right_col')){
            name.classList.remove('mdi-checkbox-blank-circle-outline');
            name.classList.add('mdi-checkbox-marked-circle-outline');
        } else{
            name.classList.remove('mdi-checkbox-marked-circle-outline');
            name.classList.add('mdi-checkbox-blank-circle-outline');
        }
    }
} 
function selectBack(params) {
    if(log)
    console.log(params);
    localStorage.setItem('right_col',params.childNodes[1].classList.value)
    let b = document.getElementsByClassName('right_col')[0]
    b.removeAttribute('class');
    b.classList.add(params.childNodes[1].classList.value,'right_col');

    for (let n of document.getElementsByClassName('back')) {
        if(n.childNodes[1].classList.value === localStorage.getItem('right_col')){
            n.classList.remove('mdi-checkbox-blank-circle-outline');
            n.classList.add('mdi-checkbox-marked-circle-outline');
        } else{
            n.classList.remove('mdi-checkbox-marked-circle-outline');
            n.classList.add('mdi-checkbox-blank-circle-outline');
        }
    }
    setting.bgImage = params.childNodes[1].classList.value;
    setSetting()
}

/**
 * If the parameter is 'on', set the local storage item 'DarkMode' to 0, otherwise remove the local
 * storage item 'DarkMode' and reload the page.
 * @param params - The parameter that is passed to the function.
 */
function DarkMode(params) {
    if(params==='on'){
      localStorage.setItem('DarkMode',0)
      setting.darkMode = 1
    } else {
      localStorage.removeItem('DarkMode')
      setting.darkMode = 0
    }
    setSetting()
    location.reload()
    }

/**
 * The function creates a list of settings with icons and labels using HTML and CSS classes.
 * @param list - The `list` parameter is an array of arrays, where each inner array contains two
 * elements: the first element is a string representing the setting name, and the second element is a
 * string representing the icon to be displayed for that setting.
 */
function Setting_List(list) {
    let append = document.getElementById('system-card-holder');
    list.forEach(element => {
        let div = newElement({element:'div'},append)
        let i = newElement({element:'i',cls:['readme_card','readme','mdi','mdi-help-circle-outline'],attr:[['key-title','ReadMe_title_help'],['key-readme',`Help_${element[0]}`],['onclick',`OpenReadMe('Help_${element[0]}')`]]},div)
        let uk_card = newElement({element:'div',cls:['uk-card','uk-card-default','cur_pointer','dash-card'],attr:[['onclick',`OpenSetting('${element[0]}')`],['key-title',`${element[0]}`]]},div)
        let uk_card_header = newElement({element:'div',cls:['uk-card-header','flex-column-center']},uk_card)
        let mdi = newElement({element:'div',cls:['mdi',`${element[1]}`],attr:[['style','font-size: 100px;']]},uk_card_header)
        let uk_card_body = newElement({element:'div',cls:['uk-card-body','uk-padding-small','uk-text-center'],attr:[['key',`${element[0]}`]]},uk_card).innerHTML = `<!--${element[0]}-->`
    }); 
    translatejs()
}
/**
 * The function opens a UIkit modal with the ID corresponding to the input SettingName.
 * @param {String}SettingName - The parameter `SettingName` is a string that represents the name of the setting
 * that needs to be accessed or modified. It is used as a reference to open the corresponding modal
 * window with the settings options.
 */
function OpenSetting(SettingName) {
    UIkit.modal(`#modal-${SettingName}`).show();
}

function addDate() {
    const d = new Date();
    document.getElementById("startBackup").download = `VeloboxBup_${d.getFullYear() * 10000 + (d.getMonth() + 1) * 100 + d.getDate()}`;
}