/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/*
    Created on : 04.06.2021, 21:08:29
    Author     : Peter Bauer
*/
var aLangKeys = new Object();
var lang;
var back = document.getElementsByClassName('right_col')[0];
let menu_bread = document.getElementById('menu_bread');
var log = localStorage.getItem('log') || false;

var week = ["week_0","week_1","week_2","week_3","week_4","week_5","week_6"];
var month = ["mon_0","mon_1","mon_2","mon_3","mon_4","mon_5","mon_6","mon_7","mon_8","mon_9","mon_10","mon_11"];

var httpSetconfig = new XMLHttpRequest();
var httpreboot = new XMLHttpRequest();


var devLangKeys = localStorage.getItem('devLang') ? JSON.parse(localStorage.getItem('devLang')) : new Object();


if(localStorage.getItem('right_col')){
  back.classList.add(localStorage.getItem('right_col'));
} else{
  back.classList.add(`img_0`)
}
/**
 * It takes a JSON object as a parameter, then loops through all the elements with the attribute "key"
 * and replaces the innerHTML with the value of the key attribute in the JSON object
 * @param params - The object that contains the language keys and their values.
 */
 function _Translate(params) {
  console.log('init translatejs');
  aLangKeys = params
  // console.log(params)
      if(localStorage.getItem('lang')){
          lang = localStorage.getItem('lang')
          // console.log(localStorage.getItem('lang'));
        }
  let lang_list = document.getElementById('lang_list');
  // let lang_list_2 = document.getElementById('lang_list_2');
  // lang_list_2.innerHTML="";
  lang_list.innerHTML="";
  let zusatzlang = params.zusatzlang;
  let primarylang = params.lang;
  let li_pl = document.createElement('li');
  let div_pl = document.createElement('div');
  div_pl.classList.add('col-md-3', 'col-sm-12', 'form-group')
  div_pl.innerHTML = `<a href="#" onclick="langSelected('${primarylang.split(' ')[0]}_${primarylang.split(' ')[0]}.UTF-8');"><img class="sprachwahl" src="images/${primarylang.split(' ')[0]}.png"> ${primarylang.split(' ')[1]}</a>`
  li_pl.setAttribute('style','float: none;width: 100%;margin-bottom: 10px;')
  li_pl.innerHTML = `<a style="justify-content: space-between;" href="#select" onclick="langSelected('${primarylang.split(' ')[0]}_${primarylang.split(' ')[0]}.UTF-8');"><img class="sprachwahl_klein" src="images/${primarylang.split(' ')[0]}.png">${primarylang.split(' ')[1]}</a>`
  lang_list.prepend(li_pl)
  // lang_list_2.prepend(div_pl)
  zusatzlang.forEach(langs => {
  let div = document.createElement('div');
  div.classList.add('col-md-3', 'col-sm-12', 'form-group')
  div.innerHTML = `<a href="#" onclick="langSelected('${langs.split(' ')[0]}_${langs.split(' ')[0]}.UTF-8');"><img class="sprachwahl" src="images/${langs.split(' ')[0]}.png"> ${langs.split(' ')[1]}</a>`
  let li = document.createElement('li');
  li.setAttribute('style','float: none;width: 100%;margin-bottom: 10px;')
  li.innerHTML = `<a style="justify-content: space-between;" href="#select" onclick="langSelected('${langs.split(' ')[0]}_${langs.split(' ')[0]}.UTF-8');"><img class="sprachwahl_klein" src="images/${langs.split(' ')[0]}.png">${langs.split(' ')[1]}</a>`
  lang_list.append(li)
  // lang_list_2.append(div)
  });
/* The above code is used to change the placeholder of the input fields. */
  for(const key3 in document.querySelectorAll('[key-place]')){
    const element3 = document.querySelectorAll('[key-place]')[key3];
      if(element3.tagName){
       let ele = element3.getAttribute('key-place')
       element3.setAttribute('placeholder',`${params[lang][ele]}`)
       if(element3.getAttribute('placeholder')=="undefined"){
        devLangKeys[element3.getAttribute('key-place')]=element3.getAttribute('key-place')
       } else{
        devLangKeys[element3.getAttribute('key-place')]=element3.getAttribute('placeholder')
       }
      localStorage.setItem('devLang',JSON.stringify(devLangKeys))
      }
  }
  /* The above code is setting the title attribute of the element with the key-title attribute to the
  value of the key in the params object. */
  for(const key2 in document.querySelectorAll('[key-title]')){
    const element2 = document.querySelectorAll('[key-title]')[key2];
      if(element2.tagName){
       let ele = element2.getAttribute('key-title')
       element2.setAttribute('title',`${params[lang][ele]}`)
       if(element2.getAttribute('title')=="undefined"){
        devLangKeys[element2.getAttribute('key-title')]=element2.getAttribute('key-title')
       } else{
        devLangKeys[element2.getAttribute('key-title')]=element2.getAttribute('title')
       }
      localStorage.setItem('devLang',JSON.stringify(devLangKeys))
      }
  }
/* Adding a class to the element and then creating a modal for the element. */
  for(const key4 in document.querySelectorAll('[key-readme]')){
    const readmeElement = document.querySelectorAll('[key-readme]')[key4];
    if(readmeElement.tagName){
      readmeElement.classList.add('readme','mdi','mdi-help-circle-outline')
      let varRead = readmeElement.getAttribute('key-readme');
      CreateReadMeMod(varRead);
      readmeElement.setAttribute('onclick',`OpenReadMe('${varRead}')`) //Z 634
    }
  }
/* Looping through all the elements with the attribute key and replacing the innerHTML with the value
of the key in the params object. */
  for (const key in document.querySelectorAll('[key]')) {
    const element = document.querySelectorAll('[key]')[key];
    if(element.innerHTML){
    element.innerHTML = `${params[lang][element.getAttribute("key")]}`;
    if(element.innerHTML=="undefined"){
      devLangKeys[element.getAttribute('key')]=element.getAttribute('key')
    } else{
      devLangKeys[element.getAttribute('key')]=element.innerHTML
    }
    localStorage.setItem('devLang',JSON.stringify(devLangKeys))
    }
  }
  $("#sprachwahl").attr("src", `images/${lang}.png`);
}

/**
 * It sets the language to the local storage and then fetches the json file and translates the page.
 * @param {String}lang - The language you want to translate to.
 */
function langSelected(lang) {
  let httplang = new XMLHttpRequest();
  let result = lang.substring(0, 2);
  var url = `/production/setlanguagefile.tcls?systemsprache=${result}`;
  localStorage.setItem('lang',result)
  fetch("/production/localisation/lang.json", {
    mode: "no-cors",
  }) // disable CORS because path does not contain http(s)
    .then((res) => res.json())
    .then((data) => (_Translate(data)));

  httplang.open("GET", url, true);
  httplang.send();
}

function dashboardCards() {
  try {
    fetch("/production/json/cards.json", {
      mode: "no-cors",
    }) // disable CORS because path does not contain http(s)
    .then((res) => res.json())
    .then((data) => (DashCards(data)));
  } catch (error) {
    getError(error)
  }
}

var cardsReady = false

function DashCards(jsn){
  const to = document.getElementById('dash-card-holder');
  for (const key in jsn) {
    if(key === 'dashbordcards'){
      const e = jsn[key];
      for (const i of e) {
        if(i.visible === "true"){
          let div   = newElement({element:'div',id:`div_${i.name}`},to)
          let help  = newElement({element:'i',cls:['readme_card'],attr:[['key-title','ReadMe_title_help'],['key-readme',`Help_Tile_${i.name}`]]},div);
          let card  = newElement({element:'div',id:`${i.name}`,cls:['uk-card','uk-card-default','cur_pointer','dash-card'],attr:[['onclick',`LinkTo('${i.link}.tcls?check=true')`]]},div);
          let head  = newElement({element:'div',cls:['uk-card-header','flex-column-center']},card);
          let img   = newElement({element:'img',id:`img_${i.name}`,cls:['img-circle'],attr:[['width','150'],['height','135'],['src',`${i.image}`]]},head);
          let body  = newElement({element:'div',cls:['uk-card-body','uk-padding-small','uk-text-center'],attr:[['key',`${i.tkey}`]]},card).innerHTML = "<!---->";
          if(i.name === 'Seatbonemeasurement'){
            card.classList.add('no-hocker');
            localStorage.setItem('smartcube_link',false)
            img.classList.add('uk-blend-luminosity')
          }
        }
      }
    }
  }
}
/**
 * It fetches the JSON file, then calls the _Translate function with the JSON file as an argument.
 */
function translatejs() {
  try {
    fetch("/production/localisation/lang.json?v=1", {
      mode: "no-cors",
    }) // disable CORS because path does not contain http(s)
      .then((res) => res.json())
      .then((data) => (_Translate(data)));
  } catch (error) {
    getError(error)
  }
}

$(document).ready(function () {
  translatejs();
  localstart();
});

function reinit() {
  var url = "/production/reinit.tcls";

  localStorage.removeItem('smartcube')

  httpreboot.open("GET", url, true);
  httpreboot.send();

  let inter = setInterval(()=> {
    window.location.reload(true);
      clearInterval(inter);
    }, 1000);
} // reinit()
/**
 * The function starts a countdown and then reboots the Velobox
 */
function reboot() {
  var url = "/production/reboot.tcls";

  // btn1 ist das X zum schließen des Fensters
  //var btn1 = document.getElementById("btn1");
  //btn1.setAttribute("disabled", "true");
  localStorage.clear()

  var btn2 = document.getElementById("btn2");
  btn2.setAttribute("disabled", "true");

  var btn3 = document.getElementById("btn3");
  btn3.setAttribute("disabled", "true");

  countdown();

  httpreboot.open("GET", url, true);
  httpreboot.send();
} // reboot()

/**
 * It counts down from 60 seconds and reloads the page when it reaches 0
 */
function countdown() {
  var seconds = 50;
  var progress = document.getElementById('progress_restart')
  function tick() {
    seconds--;
      progress.value +=1
    if (seconds > 0) {
      setTimeout(tick, 1000);
    } else {
      location.pathname = "/"
    }
  }
   translatejs();
  tick();
}
/**
 * It takes an array of strings and creates a breadcrumb navigation bar
 * @param {Arraya<string>}params - an array of strings that will be used to create the breadcrumb.
 */
function BreadCrumb(params) {
    var path = $('.meinpfad')[0];
    path.innerHTML = "";
    var ihome = document.createElement('i');
    ihome.classList.add('mdi','mdi-sitemap')
    var spanhome = document.createElement('span');
    spanhome.setAttribute('key','mainmenu_home');
    spanhome.setAttribute('onclick',`LinkTo('dashboard.tcls')`)
    path.append(ihome);
    path.append(spanhome);
    params.forEach(element => {
      var i = document.createElement('i');
      i.classList.add('mdi','mdi-menu-right');
      path.append(i);
      var s = document.createElement('span');
      // s.classList.add('tr');
      s.setAttribute('key',`bread_${element}`)
      s.setAttribute('onclick',`LinkTo('${element}.tcls')`)
      s.setAttribute('style','cursor: pointer')
      s.innerHTML = element;
      path.append(s);
      // if(element !='dashboard'){
        let li = document.createElement('li');
        let a = document.createElement('a');
        a.classList.add('font-12');
        a.setAttribute('key',`bread_${element}`);
        a.setAttribute('href',`/production/${element}.tcls`)
        a.id = element.replaceAll(' ','')
        a.innerHTML = element
        //if(location.pathname == "/production/dashboard.tcls"){
        // li.classList.add('hidden')
        //}
        if(element==='client'){
          let a2 = newElement({element:'a',attr:[['href',`/production/${element}.tcls`],['style','display:none;']]},li)
          a.removeAttribute('key');
          a.innerHTML = localStorage.getItem('client_name')
          a.setAttribute('href','#')
          a.setAttribute('onclick',`info(${localStorage.getItem('client_id')},'${localStorage.getItem('client_name')}','${localStorage.getItem('client_mail')||""}','${localStorage.getItem('client_fc')}')`)
          //info(`${localStorage.getItem('client_id')}`,`${localStorage.getItem('client_name')}`,`${localStorage.getItem('client_mail')||""}`,`${localStorage.getItem('client_fc')}`)
          s.removeAttribute('key');
          s.innerHTML = localStorage.getItem('client_name')
        }
        menu_bread.append(li)
        li.append(a)
    });
}
/**
 * It removes the local storage items 'ReadFirstStart' and 'ReadFirstSatteldruckanalyse'
 */
function HelpReset() {
  localStorage.removeItem("ReadFirstStart");
  localStorage.removeItem("ReadFirstSatteldruckanalyse");
}

/**
 * It sends a request to the server to get the handbook file for the selected language
 * @param sprache - The language of the handbook.
 */
 function setHandbuchfile(sprache) {
  var url = "/production/korrekturhandbuch.tcls?sprache=" + sprache;
  httpSetconfig.open("GET", url, true);
  httpSetconfig.send();
}

/**
 * The function takes a parameter, which is the name of the page you want to link to, and then it
 * changes the location of the current page to the page you want to link to
 * @param params - The name of the parameter you want to pass to the function.
 */
function LinkTo(params) {
  location.href = `/production/${params}`
}

function mod_about() {
  UIkit.modal("#modal-about").show();
}

/**
 * The function "PrintLog" logs a message to the console if the "log" variable is true.
 * @param {Array<String>}params - The parameter "params" is a variable that represents the data or message that needs
 * to be logged. It is passed as an argument to the function "PrintLog".
 */
function PrintLog(params) {
  if (log) {
    params.forEach(element => {
      console.log(element);
    });
  }
}

/**
* It checks if the user has already seen the first start modal and if not, it shows it
*/
function localstart() {

  if (localStorage.getItem("ReadFirstStart") === null) {
      console.log("Init FirstStart");
      localStorage.setItem("ReadFirstStart", false);
  }

  if (localStorage.getItem("viewmode") === null) {
      console.log("Init ViewMode");
      localStorage.setItem("viewmode", "basic");
  }

  if (localStorage.getItem("ReadFirstSatteldruckanalyse") === "false" && document.getElementById("firstsatteldruckanalyse")) {
      $("#firstsatteldruckanalyse").modal("show");
  }

  if (localStorage.getItem("ReadFirstStart") === "false" && location.pathname == "/production/dashboard.tcls") {
      //$("#firststart").modal("show");
      UIkit.modal("#firststart").show();
  } else {
      console.log(
          "FirstStart deactivated",
          localStorage.getItem("ReadFirstStart")
      );
  }
}

if(location.pathname == "/production/dashboard.tcls"){
  dashboardCards()
  BreadCrumb(['dashboard']);
}
if(location.pathname == "/production/clients.tcls"){
  BreadCrumb(['dashboard','clients']);
}
if(location.pathname == "/production/session.tcls"){
  BreadCrumb(['dashboard','clients','session']);
}
if(location.pathname == "/production/client.tcls"){
  BreadCrumb(['dashboard','clients','client'])
}
if(location.pathname == "/production/saddle_pressure_analysis.tcls"){
  BreadCrumb(['dashboard','clients','client','saddle_pressure_analysis']);
}
if(location.pathname == "/production/anamnese.tcls"){
  BreadCrumb(['dashboard','clients','client','anamnese']);
}
if(location.pathname == "/production/protokoll.tcls"){
  BreadCrumb(['dashboard','clients','client','protokoll','galerie'])
}
if(location.pathname == "/production/galerie.tcls"){
  BreadCrumb(['dashboard','clients','client','protokoll','galerie'])
}
if(location.pathname == "/production/handbuch.tcls"){
  BreadCrumb(['dashboard','handbuch'])
}
if(location.pathname == "/production/system.tcls"){
  BreadCrumb(['dashboard','system'])
}
if(location.pathname == "/production/sitzknochenvermessung.tcls"){
  BreadCrumb(['dashboard','sitzknochenvermessung'])
}
if(location.pathname == "/production/wlanconfig.tcls"){
  BreadCrumb(['dashboard','wlanconfig'])
}
if(location.pathname == "/production/changelog.tcls"){
  BreadCrumb(['dashboard','changelog'])
}
if(location.pathname == "/production/tpfs.tcls"){
  BreadCrumb(['dashboard','tpfs'])
}
if(location.pathname == "/production/products.tcls"){
  BreadCrumb(['dashboard','tpfs','products'])
}

var checkbox = document.getElementById('basic');
var checkbox_view = document.getElementById('switch-1')
var checkbox_mask1 = document.getElementById('mask1')
var checkbox_mask2 = document.getElementById('mask2')
var checkbox_set_comp = document.getElementById('set_comp')
var checkbox_maskedit = document.getElementById('maskedit');

function chk_wifi() {
const btn_eth = document.getElementById('eth');
const span_eth = document.getElementById('eth_con');

try {
  if(btn_eth.dataset.inet == ""){
    btn_eth.classList.remove('mdi-lan-connect')
    btn_eth.classList.add('mdi-lan-disconnect')
    btn_eth.setAttribute('disabled','')
    span_eth.setAttribute('style','color: var(--red);')
  } else {
    span_eth.setAttribute('style','color: var(--primary);')
  }
} catch (error) {
  getError(error)
}


//WIFI-CONN
//mdi-wifi-off
const btn_wifi = document.getElementById('wifi')
const span_wifi = document.getElementById('wifi_con')
const li_id = document.getElementById('wifi_id')
const li_id_hr = document.getElementById('wifi_id_hr')

try {
  if(btn_wifi.dataset.inet != ""){
    span_wifi.setAttribute('style','color: var(--primary);')
  } else {
    btn_wifi.classList.remove('mdi-wifi')
    btn_wifi.classList.add('mdi-wifi-off')
    span_wifi.setAttribute('style','color: var(--red);')
    span_wifi.setAttribute('key','con_disconekt')
    li_id.classList.add('hidden')
    li_id_hr.classList.add('hidden')
    translatejs()
  }
} catch (error) {
  getError(error)
}
}

$(document).ready(function () {
  chk_wifi();
  ToggleViewMode(localStorage.getItem("viewmode"));
  if(localStorage.getItem('viewmode')==='basic'){
    checkbox_view.removeAttribute('checked');
    // document.getElementById("basic").nextSibling.classList.remove('custom_switch')
    ToggleViewMode('basic');
  } else{
    try {
    checkbox_view.setAttribute('checked','')
    // document.getElementById("basic").nextSibling.classList.add('custom_switch')
    ToggleViewMode('advanced');
  } catch (error) {
    getError(error)
    }
  }
  if(location.pathname == "/production/saddle_pressure_analysis.tcls"){
    checkbox_mask1.removeAttribute('checked')
    checkbox_mask2.removeAttribute('checked')
    checkbox_maskedit.removeAttribute('checked')
  }
});



checkbox_view.addEventListener('change', function() {
if (this.checked) {
  console.log("basic is checked..");
  // document.getElementById("basic").nextSibling.classList.add('custom_switch')
  ToggleViewMode('advanced');
} else {
  console.log("basic is not checked..");
  // document.getElementById("basic").nextSibling.classList.remove('custom_switch')
  ToggleViewMode('basic');
}
});


try {
  checkbox_mask1.addEventListener('change', function() {
    console.log(this.dataset.num);
    if (this.checked) {
      document.getElementById("mask1").nextSibling.classList.add('custom_switch')
      showMask(this.dataset.num)
    } else {
      document.getElementById("mask1").nextSibling.classList.remove('custom_switch')
      hideMask(this.dataset.num)
    }
    });
} catch (error) {
  //getError(error)
}

try {
  checkbox_mask2.addEventListener('change', function() {
    console.log(this.dataset.num);
    if (this.checked) {
      document.getElementById("mask2").nextSibling.classList.add('custom_switch')
      showMask(this.dataset.num)
    } else {
      document.getElementById("mask2").nextSibling.classList.remove('custom_switch')
      hideMask(this.dataset.num)
    }
});
} catch (error) {
  //getError(error)
}

try {
  checkbox_maskedit.addEventListener('change', function() {
    console.log(this.dataset.num);
    if (this.checked) {
      document.getElementById("maskedit").nextSibling.classList.add('custom_switch')
      hide_mask()
    } else {
      document.getElementById("maskedit").nextSibling.classList.remove('custom_switch')
      hide_mask()
    }
});
} catch (error) {
  //getError(error)
}

try {
  checkbox_set_comp.addEventListener('change', function() {
    console.log(this.dataset.num);
    if (this.checked) {
      document.getElementById("set_comp").nextSibling.classList.add('custom_switch')
      set_comp("on")
    } else {
      document.getElementById("set_comp").nextSibling.classList.remove('custom_switch')
      set_comp("off")
    }
    });
} catch (error) {
  //getError(error)
}

var men = document.getElementById('menu_toggle');

men.addEventListener('click',()=>{
let m_men = document.getElementsByClassName('men');

  if(document.getElementsByTagName('body')[0].classList.contains('nav-md')){
    for (const iterator of m_men) {
      iterator.classList.add('hide')
    }
  } else {
    for (const iterator of m_men) {
      iterator.classList.remove('hide')
    }
  }
})

/**
 * It takes a string, and returns a translated string
 * @param {String}params - The string you want to translate.
 * @returns The value of the key in the object.
 */
function gettrans(params) {
  lang = localStorage.getItem('lang')
  console.log(params,lang);
  translatejs()
  console.log(aLangKeys);
  try {
  return aLangKeys[lang][params]
  } catch (error) {
    getError(error)
  }
}

/**
 * It sets the position of the element with the id of "foo" to fixed, and sets the width and height of
 * the element to the width and height of the window
 */
function abso() {
ch = $(window).height();
cw = $(window).width()/1.25;
  $('#foo').css({
      position: 'fixed',
      background: 'white !important',
      zIndex: 1000,
      width: $(window).width(),
      height: $(window).height(),
      top: 0,
      right: '10%',
      bottom: 0,
      left: '10%'
  });
}


try {
let side_smartcube = document.getElementById('sitzknochen-menu');
  side_smartcube.setAttribute('href','/production/sitzknochenvermessung.tcls?check=true')
} catch (error) {
  getError(error)
}


/* A clock. */
let clock_dash = setInterval(function () {
  let c = document.getElementById('clock');
  let time = new Date();
  let h = time.getHours() < 10 ? '0' + time.getHours() : time.getHours();
  let m = time.getMinutes() < 10 ? '0' + time.getMinutes() : time.getMinutes();
  let s = time.getSeconds() < 10 ? '0' + time.getSeconds() : time.getSeconds();
  let time_str = `${aLangKeys[lang][week[time.getDay()]]} ${time.getDate()} ${aLangKeys[lang][month[time.getMonth()]]} ${h}:${m}:${s}`;
  c.innerHTML = time_str;
 }, 1000);
// $(window).resize(function() {
//   abso();
// });

/**
 * It creates a new element with the given parameters and appends it to the given element
 *
 * @function
 * @name newElement
 * @kind function
 * @param {Object<JSON>} jsn - JSON object
 * @param {String} jsn.element    - HTML element name
 * @param {String} jsn.id    - ID of the element
 * @param {Array<String>} jsn.cls - classes of the element
 * @param {Array<Array<String>>} jsn.attr - Attriburtes of the HTML element
 * @param {HTMLElement} DOM_Element - the complete element
 * @returns {HTMLElement}
 */
function newElement(jsn, DOM_Element) {
  let e = document.createElement(jsn.element)
  if(jsn.cls){
      jsn.cls.forEach(element => {
          e.classList.add(element)
      });
  }
  if(jsn.id){
      e.id = jsn.id
  }
  if(jsn.attr){
      jsn.attr.forEach(element=>{
          e.setAttribute(element[0],element[1])
      });
  }
  if(log){
    console.log('newElement',e);
  }
  DOM_Element.append(e)
  return e;
}

// MODAL README
/**
 * It creates a modal window with a button to close it, and then fetches the HTML file from the server
 * and inserts it into the modal window
 * @param {String}params - the name of the file to be loaded.
 */
function CreateReadMeMod(params) {
  let append;
  if(document.getElementById('ModalHolder')){
    append = document.getElementById('ModalHolder');
  } else {
    append = newElement({element:'div',id:'ModalHolder'},document.getElementsByTagName('body')[0]);
  }

  let ModalDiv  =  newElement({element:'div',id:`mod_${params}`,attr:[['uk-modal','']]},append);
  let ModalBody =  newElement({element:'div',cls:['uk-modal-dialog','uk-modal-body']},ModalDiv);
  let ModalBtnX =  newElement({element:'button',cls:['uk-modal-close-default'],attr:[['type','button'],['uk-close','']]},ModalBody);
  let ModalReadmeText1 = newElement({element:'p'},ModalBody);

  try {
    fetch(`/production/manuals/${lang}/${params}.html?v=1`, {
      mode: "no-cors",
    }) // disable CORS because path does not contain http(s)
      .then((res) => res.text())
      .then((data) => (ModalReadmeText1.innerHTML=data));
  } catch (error) {
    ModalReadmeText1.innerHTML = error;
    getError(error)
  }
}


/**
 * The function displays an error message in a dialog box.
 * @param err - The "err" parameter is a variable that is expected to contain an error message or
 * object. This function takes that error and displays it in a dialog box with the title "error" and a
 * single "OK" button for the user to dismiss the dialog.
 */
function getError (err){
  OpenModDialog({type:'error',title:["error"],msg:`${err}`,master_btn:['button_ok']})
}

/**
 * > This function opens a modal window with the id of `mod_`
 * @param {String}params - The name of the modal you want to open.
 */
function OpenReadMe(params) {
  UIkit.modal(`#mod_${params}`).show();
}

/**
 * If the error message is not displayed, display it. Otherwise, hide it
 */
function showErrormessage() {
  let x = document.getElementsByClassName("error_p");
  for (const ele of x) {
    if (ele.style.display === "none") {
      ele.style.display = "block";
  } else {
      ele.style.display = "none";
  }
  }
}
/**
 * `window.open(url, name, specs, replace)`
 *
 * The `url` is the page you want to open. The `name` is the name of the window. The `specs` are the
 * features of the window. The `replace` is a boolean value that determines whether the URL creates a
 * new entry or replaces the current entry in the history list
 */
function openWindow() {
  window.open(`${location.origin}/production/dashboard.tcls`, "NewWindow",`toolbar=no,menubar=no,scrollbars=no,fullscreen=yes,width=${screen.width},height=${screen.height}`)
  //this.close()
  closeWindow()
}
function closeWindow() {
  window.open('','_parent','');
  window.close();
}

// sample warn
//let dialogSample = {type:'warn',title:"Sitzung #215 löschen?",msg:["cli_session_text"],master_btn:["button_delete","SelectSessionDel()"],slave_btn:["button_cancel"]}
/**
 * It creates a modal dialog with a header, body and footer
 * @param {JSON.type}jsn - head:"overwrites the defautl head",title:what happend, msg:more info hidden,master_btn:[translationkey,onclick(nothing=close),slave_btn:[translationkey,onclick(nothing=close)]
 * @type {String} -warn || error || neutral || success
 * @head {Sring} - overwrites the head
 * @title {String || Array} -Array:set an translate key -String: a normal string
 * @msg {string || Array} - Array: set the translate key for more informations -String: a normal string (server messages)
 * @master_btn {Array<String>} - ["transKey",functon()-optional] if no function default is close modal --Optional
 * @slave_btn {Array<String>} - ["transKey",functon()-optional] if no function default is close modal --Optional
 */
function OpenModDialog(jsn){
let holder;
if(document.getElementById('ModalHolder')){
  holder = document.getElementById('ModalHolder');
} else {
  holder = newElement({element:'div',id:'ModalHolder'},document.getElementsByTagName('body')[0]);
}

let modal = newElement({element:'div',attr:[['uk-modal','']]},holder)
let dialog= newElement({element:'div',cls:['uk-modal-dialog']},modal)
let head  = newElement({element:'div',cls:['uk-modal-header',`mod_${jsn.type}`]},dialog)
  let title = newElement({element:'h2',cls:['uk-modal-title'],attr:[['style','color:var(--secondary-text)'],[`key`,`mod_${jsn.type}`]]},head).innerHTML = '<!--title-->'
if(jsn.head){
  let title = newElement({element:'h2',cls:['uk-modal-title'],attr:[['style','color:var(--secondary-text)']]},head).innerHTML = jsn.head
}
let X = newElement({element:'button',cls:['uk-modal-close-default'],attr:[['uk-close','']]},head)
let body = newElement({element:'div',cls:['uk-modal-body']},dialog)
let h4 = newElement({element:'h4',attr:[['style','color:var(--primary-text)'],['onclick','showErrormessage()']]},body)
let h4d= newElement({element:'div',cls:['info_msg','uk-margin-bottom']},h4)
if(jsn.type === 'warn'){
  let ico = newElement({element:'span',cls:['uk-margin-right','ico-16','mdi','mdi-alert'],attr:[['style',`color:var(--${jsn.type})`]]},h4d)
}
if(jsn.type === 'error'){
  let ico = newElement({element:'span',cls:['uk-margin-right','ico-16','mdi','mdi-minus-circle'],attr:[['style',`color:var(--${jsn.type})`]]},h4d)
}
if(jsn.type === 'success'){
  let ico = newElement({element:'span',cls:['uk-margin-right','ico-16','mdi','mdi-help-circle'],attr:[['style',`color:var(--${jsn.type})`]]},h4d)
}
if(jsn.type === 'neutral'){
  let ico = newElement({element:'span',cls:['uk-margin-right','ico-16','mdi','mdi-alert-circle'],attr:[['style',`color:var(--${jsn.type})`]]},h4d)
}
if(Array.isArray(jsn.title)){
  let warn = newElement({element:'span',attr:[['key',jsn.title[0]]]},h4d).innerHTML = '<!--title-->'
} else{
  let warn = newElement({element:'span'},h4d).innerHTML = jsn.title

}
let p = newElement({element:'p',cls:['error_p'],attr:[['style','display:none']]},h4)
if(Array.isArray(jsn.msg)){
let span = newElement({element:'span',attr:[['key',jsn.msg]]},p).innerHTML= '<!--msg-->'
} else {
let span = newElement({element:'span'},p).innerHTML= jsn.msg
}
let foot = newElement({element:'div',cls:['uk-modal-footer','uk-text-right']},dialog)
if(jsn.slave_btn){
  let slave = newElement({element:'button',cls:['uk-button', 'uk-button-default', 'uk-modal-close'],attr:[['key',jsn.slave_btn[0]]]},foot)
  if(jsn.slave_btn[1])
  slave.setAttribute('onclick',jsn.slave_btn[1])
  slave.innerHTML = '<!--title-->'
}
if (jsn.master_btn) {
  let master = newElement({element:'button',cls:['uk-margin-left','uk-button', `uk-button-${jsn.type}`, 'uk-modal-close'],attr:[['key',jsn.master_btn[0]]]},foot)
  if(jsn.master_btn[1])
  master.setAttribute('onclick',jsn.master_btn[1])
  master.innerHTML = '<!--title-->'
}
translatejs()
UIkit.modal(modal).show();
}

var elem = document.documentElement;
var fullScreen = false

function Vollbild() {
    if (fullScreen) {
        closeFullscreen()
        }
    if (!fullScreen) {
        openFullscreen()
        }
    }

function openFullscreen() {
    if (elem.requestFullscreen) {
        elem.requestFullscreen();
        }
    else if (elem.mozRequestFullScreen) { /* Firefox */
        elem.mozRequestFullScreen();
        }
    else if (elem.webkitRequestFullscreen) { /* Chrome, Safari & Opera */
        elem.webkitRequestFullscreen();
        }
    else if (elem.msRequestFullscreen) { /* IE/Edge */
        elem.msRequestFullscreen();
        }
        fullScreen = true
    }

function closeFullscreen() {
    if (document.exitFullscreen) {
        document.exitFullscreen();
        }
    else if (document.mozCancelFullScreen) {
        document.mozCancelFullScreen();
        }
    else if (document.webkitExitFullscreen) {
        document.webkitExitFullscreen();
        }
    else if (document.msExitFullscreen) {
        document.msExitFullscreen();
        }
        fullScreen=false
    }

