/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* 
    Created on : 16.04.2021, 22:02:29
    Author     : Peter Bauer
*/

const host = location.origin;
const ws = host.replace("http", "ws");
const app = "satteldruckanalyse";

const sessionID =
  localStorage.getItem("session").split(" ")[0] == "restart"
    ? localStorage.getItem("session").split(" ")[1]
    : localStorage.getItem("new_session");
    //console.log(sessionID);
try {
  var sattelanalyse = new WebSocket(`${ws}/apps/${app}`, ["soap", "wamp"]);
} catch (error) {
  PrintLog([error]);
}
var onsqlresult = null;
//var load_num;
var galerie_image_info = {};
//var galerie_info= {}
var recID;
var recData = {};
//var img1;
//var img2;
var chk1;
var chk1;
//var ch, cw;
//var chart_a;
//var chart_b;
var DelImg;


let sda_frame3 = `${host}/sattelbild?image=blank`;

_name();
_satteldruckanalyse();

/**
 * It gets the name from local storage and puts it in the right places
 */
function _name() {
  let name = localStorage.getItem("client_name").split(" ");
  let infos = document.getElementById('galerie_info');
  infos.innerHTML = `${name[1]} ${name[0]} - ${localStorage.getItem('session_note')||""}`;

}

/**
 * It opens a websocket connection to the server, and sends a few commands to it
 */
function _satteldruckanalyse() {
  sattelanalyse.onopen = (e) => {
    rec_cancel(1);
    rec_cancel(2);
    onsqlresult = RowImg;
    sattelanalyse.send(
      `sql select * from recordings where session_id=${sessionID} and analysis='2'`
    );
    sattelanalyse.send(`session restart ${sessionID}`);
    sattelanalyse.send("set compare on");
    sattelanalyse.send(`analysis ["sitbones","anamnesis","x1"]`);

    PrintLog([
      "_satteldruckanalyse",
      `sql select * from recordings where session_id=${sessionID} and analysis='2'`,
    ]);
    PrintLog(["_satteldruckanalyse", `session restart ${sessionID}`]);
    PrintLog(["_satteldruckanalyse", `set compare on`]);
    PrintLog(["_satteldruckanalyse", `analysis ["sitbones","anamnesis","x1"]`]);
  };
}

/**
 * The function `rec_cancel` sends a message and logs a recording cancellation with a given number.
 * @param {Number}num - The parameter "num" is a number that represents the recording number that needs to be
 * cancelled.
 */
function rec_cancel(num) {
  sattelanalyse.send(`recording cancel ${num}`);
  PrintLog([`recording cancel ${num}`]);
}

/**
 * It takes a parameter, and logs it to the console
 * @param params - {
 */
function getLog(params) {
  console.log(params);
}

sattelanalyse.onmessage = (e) => {
  let data = JSON.parse(e.data);
  if (log) console.log("sattelanalyse.onmessage", data);
  // console.log(data);

  if (data.wsevent === "result3") {
    // console.log(data)
    galerie_image_info = data;
  }
  if (data.wsevent === "sqlresult") {
    // console.log(data)
    try {
      onsqlresult(data.rows);
    } catch (error) {
      console.log(error);
    }
  }
  if (data.wsevent === "sda_int3") {
    // console.log('sda_int3');
    let img = document.getElementsByClassName("imgGal1")[fi - 1];
    // let a = document.getElementsByClassName('imgGal2')[fi-1];
    sda_frame3 = `${host}/sattelbild?image=sda_int3&rnd=${new Date().getTime()}`;
    img.src = sda_frame3;
    img.setAttribute("onclick", `OpenChart(${recID[fi - 1]})`);
    recData[recID[fi - 1]] = JSON.stringify(galerie_image_info);
    // a.setAttribute('onclick',`sattelanalyse.send('recording retrieve ${recID[fi-1]} ${load_num}')`)
    if (galerie_image_info.pelvisrotation)
      pel = `${galerie_image_info.pelvisrotation.width || ""}:${
        galerie_image_info.pelvisrotation.height || ""
      }`;
    else pel = "-";
    document.getElementsByClassName("info_img")[fi - 1].innerHTML = `
     <ul class="uk-list uk-list-collapse">
     <li key="pro_satteldruck_veloscore">Veloscore</li>
     <li key="pro_satteldruck_becken">Rotation</li>
     <li key="pro_satteldruck_leftright">Lins/Rechts</li>
     <li key="pro_satteldruck_frontback">Vorn/Hinten</li>
     </ul>
     <ul class="uk-list uk-list-collapse">
     <li id="veloscore_${recID[fi - 1]}">${galerie_image_info.veloscore}</li>
     <li id="becken_${recID[fi - 1]}" >${pel}</li>
     <li id="leftright_${recID[fi - 1]}">${galerie_image_info.left_right}</li>
     <li id="frontback_${recID[fi - 1]}">${galerie_image_info.front_rear}</li>
     </ul>
     <textarea readonly class="uk-textarea" style="width:180px;height: 60px;margin-left:40px ">${galerie_image_info.notes}</textarea>`;
    document.getElementsByClassName("name_img")[fi - 1].innerHTML = `
     <h2 class="uk-text-center">${
       galerie_image_info.product_label || "(no Typ)"
     }</h2>
     <p class="uk-text-center"><small>${
       galerie_image_info.product ||
       "(no " + aLangKeys[lang]["pro_satteldruck_marke"] + ")"
     }</small></p>`;
    if (recID[fi]) {
      console.log("sda_init3 send");
      sattelanalyse.send(`recording retrieve ${recID[fi]}`);
      fi++;
    }
  }
  if (data.wsevent === "appquestions") {
    console.log(data.appquestions);
  }
};


function open_img(params) {
  UIkit.modal($(`#modal-center-load${params}`)).show();
}

function load(params, id) {
  sattelanalyse.send(`recording retrieve ${id} ${params}`);
  if (log) {
    console.log("load", `recording retrieve ${id} ${params}`);
  }
}
function openDelDialog(params) {
  DelImg = params;
  OpenModDialog({
    type: "warn",
    title: ["del_img_title"],
    msg: ["del_img"],
    master_btn: ["button_delete", "del_img()"],
    slave_btn: ["button_cancel"],
  });
}

function del_img() {
  sattelanalyse.send(`sql DELETE FROM recordings WHERE recording_id=${DelImg}`);
  if (log) {
    console.log(
      "del img",
      `sql DELETE FROM recordings WHERE recording_id=${DelImg}`
    );
  }
  location.reload();
}

function result_1(params) {
  if (log) console.log("result_1", params);
  document.getElementById("S1").innerHTML = params.product;
  document.getElementById("T1").innerHTML = params.product_label;
  document.getElementById("v1").innerHTML = params.front_rear;
  document.getElementById("l1").innerHTML = params.left_right;
  document.getElementById("V1").innerHTML = params.veloscore;
  if (params.pelvisrotation)
    document.getElementById("B1").innerHTML =
      `${params.pelvisrotation.center.x || ""}x${
        params.pelvisrotation.center.y || ""
      }` || "";
  document.getElementById("N1").innerHTML = params.notes;
}
function result_2(params) {
  if (log) console.log("result_2", params);
  document.getElementById("S2").innerHTML = params.product;
  document.getElementById("T2").innerHTML = params.product_label;
  document.getElementById("v2").innerHTML = params.front_rear;
  document.getElementById("l2").innerHTML = params.left_right;
  document.getElementById("V2").innerHTML = params.veloscore;
  if (params.pelvisrotation)
    document.getElementById("B2").innerHTML =
      `${params.pelvisrotation.center.x || ""}x${
        params.pelvisrotation.center.y || ""
      }` || "";
  document.getElementById("N2").innerHTML = params.notes;
}


function RowImg(params) {
  fi = 0;
  recID = [];
  onsqlresult = null;
  var append1 = document.getElementById("img_list2");
  append1.innerHTML = "";
  //var ap = (document.getElementById("imagelist").innerHTML = "");
  params.forEach((element) => {
    if (fi === 0) {
      console.log("RowImg send");
      sattelanalyse.send(`recording retrieve ${element.recording_id} 3`);
      fi++;
    }
    recID.push(element.recording_id);

    let master = document.createElement("div");
    //master.classList.add('hover');
    //master.id = `img_${element.recording_id}`
    //master.setAttribute('onclick','selectImg(this)')
    append1.append(master);

    let div = document.createElement("div");
    div.classList.add("flex-column-center");
    div.setAttribute(
      "style",
      "border:1px solid green;padding:5px; width:200px;margin:0 10px 0 0;"
    );
    master.append(div);

    let del = document.createElement("div");
    del.classList.add("adba","del_img", "mdi", "mdi-trash-can-outline");
    del.setAttribute("onclick", `openDelDialog(${element.recording_id})`);
    master.append(del);

    let date = document.createElement("p");
    date.classList.add("uk-text-center");
    date.innerHTML = element.finished;
    master.append(date);

    let div_name = document.createElement("div");
    div_name.classList.add(
      "name_img"
    );
    div_name.id = `img_${element.recording_id}`;
    //div_name.setAttribute("onclick", "selectImg(this)");
    div.append(div_name);
    // let a = document.createElement('a')
    // a.href = '#modal_dialog'
    // a.classList.add('imgGal2')

    let img = document.createElement("img");
    img.width = 150;
    img.height = 100;
    img.classList.add("imgGal1","cur");
    div.append(img);

    let div2 = document.createElement("div");
    div2.setAttribute("style", "width: 200px");
    div.append(div2);

    let div_info = document.createElement("div");
    div_info.classList.add("uk-grid", "uk-child-width-1-2", "info_img");
    div_info.setAttribute("style", "margin: 0 -30px;");
    div2.append(div_info);
    // append1.append(a)
  });

}

var max=0;

var SetMax=false;
var newMax=0
  function setMax(params) {
    SetMax = true
    newMax = params
  }

  var dom = document.getElementById('chart-container');
  var myChartX = echarts.init(dom, 'dark', {
    renderer: 'canvas',
    useDirtyRect: false
  });

var open_chartID;
function OpenChart(id) {
    open_chartID = id
    onsqlresult = heatchart
    sattelanalyse.send(`sql select pressure_values from recordings where recording_id = ${id}`)
    UIkit.modal('#chart_modal').show();
}

function PDFgenGal(){
    let name = localStorage.getItem('client_name').split(' ')

    var content = [
        {text: `${aLangKeys[lang]['pro_tab_galerie']} - ${name[1]} ${name[0]}`, style: 'header'},
        '\n',
        {canvas: [ { type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 } ]},
        '\n']

    let contentObj = {}
    let columns = []

    let tmp = {}
    for (const i of document.getElementsByClassName('imgGal1')) {
        // let canvasGal = new fabric.Canvas("canvas_3");
        // createCanvas(canvasGal)
        let image = i

        let toDataURL = () => {
            let canvas = document.createElement('canvas');
    
            // We use naturalWidth and naturalHeight to get the real image size vs the size at which the image is shown on the page
            canvas.width = image.naturalWidth;
            canvas.height = image.naturalHeight;
    
            // We get the 2d drawing context and draw the image in the top left
            canvas.getContext('2d').drawImage(image, 0, 0);
    
            // Convert canvas to DataURL and log to console
            let dataURL = canvas.toDataURL();
            // console.log(dataURL);
            // logs data:image/png;base64,wL2dvYWwgbW9yZ...
            let x = new Object();
            x.image = dataURL
            x.width=150
            columns.push(x)
            console.log(columns.length);
            if(columns.length%3==0){
                tmp.alignment = "justify"
                tmp.columns = columns
                content.push(tmp)
                content.push(`\n`)
                tmp={}
                columns=[]

            }

        };
        // If the image has already loaded, let's go!
        if (image.complete) toDataURL(image);
        // Wait for the image to load before converting
        else image.onload = toDataURL;

    }
    contentObj.alignment = "justify"
    contentObj.columns = columns
    console.log("A",content);
    content.push(contentObj)
    console.log("B",content);

    // console.log(content);
    var dd = {
        content,
            styles: {
                header: {
                    fontSize: 18,
                    bold: true
                },
                bigger: {
                    fontSize: 15,
                    italics: true
                },
                small:{
                    fontSize:10
                }
            },
            defaultStyle: {
                columnGap: 20
            }
            
        }
  pdfMake.createPdf(dd).open();
        
}
var numRows = 28;
var numCols = 16;
// Create an empty 2D array with the specified dimensions
var data2D = new Array(numRows);
var Cdata;
var  tmp;

function heatchart (data){
    let saddle = JSON.parse(recData[open_chartID])
    data.forEach(e=> {
      tmp = e.pressure_values.split(' ')
    })

      for (var i = 0; i < numRows; i++) {
        data2D[i] = new Array(numCols);
      }
      // Fill the 2D array with your data
      for (var i = 0; i < tmp.length; i++) {
        var row = Math.floor(i / numCols);
        var col = i % numCols;
          if(Number(tmp[i]) > max){
            max = tmp[i]
          }
          data2D[row][col] = [col, row, tmp[i]];
      }
      //console.log(data2D.flat());
    var option;
    var ColorRange = ['#00000000','#0000ff','#00ff00','#ffff00','#ff0000']

    
    $.getScript(
      '/production/js/chart/simplex-noise.js'
    ).done(function () {
    //  max = 0;
      //Cdata = generateData(dd);
      myChartX.setOption(
        (option = {
            backgroundColor: '#ffffffff',
          visualMap: {
            show: false, //true
            calculable: true,
            min: 0,
            max: max,
            inRange: {
                color: ColorRange,
            },
          },
          xAxis3D: {
            type: 'category',
            //data: Array.from(Array(numCols).keys()),
          },
          yAxis3D: {
            type: 'category',
            //data: Array.from(Array(numRows).keys()),
          },
          zAxis3D: {
            type: 'value',
            max: max*2,
            min: 0
          },
          toolbox: { 
            show: true, 
            orient: 'vertical', 
            itemsize: 16,
            iconStyle: {
                //color: '#000'
                borderColor: '#999',
                borderWidth: 1 ,
            },
            left:10,
            feature: {
                //magicType: {
                //    type: ["line3D", "bar3D","scatter3D","surface"]
                //}, 
                //dataZoom: { show: true }, 
                //dataView: { show: true },
                saveAsImage: { 
                    show: true, 
                    name: `${saddle.product||'NO_PRODUCT'}-${saddle.product_label||'NO_TYPE'}`, 
                    type: 'png',
                    pixelRatio:2 
                }
            } 
          },
          grid3D: {
                boxWidth: 16*10,
                boxDepth: 28*10,
            axisLine: {
              lineStyle: { color: '#99999900' }
            },
            axisPointer: {
              lineStyle: { color: '#99999900' }
            },
            viewControl: {
                distance:300,
                alpha:45,
                beta:0 //270
            },
            //light: {
            //  main: {
            //    shadow: true,
            //    intensity: 1
            //  }
            //}
            light: {
                main: {
                  intensity: 1.2,
                  shadow: true,
                },
                ambient: {
                  intensity: 0.3,
                },
              },
          },
          series: [
            {
              type: 'bar3D',//line3D, bar3D,scatter3D,surface
              data: data2D.flat(),
              shading: 'lambert', //color,lambert,realistic
              //symbolSize(value) {
              //  console.log(value);
              //  // Customize the size of the data points based on the values
              //  return Math.abs(value[2]) + 10; // Use the absolute value of the Z coordinate
              //},
            //  animation:false,
              label: {
                fontSize: 16,
                borderWidth: 1,
                show:false
              },
              emphasis: {
                label: {
                  fontSize: 20,
                  color: '#00000000',
                  show: true,
                },
                itemStyle: {
                    color: '#000000'
                }
              }
            }
          ]
        })
      );
    });
    
    if (option && typeof option === 'object') {
      myChartX.setOption(option);
    }
    
    window.addEventListener('resize', myChartX.resize);
}

function setChartType(params) {

    myChartX.setOption((option = {
        series: [
            {
                type: params,
                data:data2D.flat(),
                symbolSize:15,
                shading: 'lambert', //color,lambert,realistic
                //symbolSize(value) {
                //  Customize the size of the data points based on the values
                //  console.log(value[2]);
                //  return Math.abs(value[2]) + 2; // Use the absolute value of the Z coordinate
                //},
              //  animation:false,
                label: {
                  fontSize: 16,
                  borderWidth: 1,
                  show:false
                },
                emphasis: {
                  label: {
                    fontSize: 20,
                    color: '#00000000',
                    show: true,
                  }
                }
            }
          ]
    }))
    
}

/**
 * `ClientInfo` is a function that takes a single parameter, `params`, and stores it in local storage
 * @param params - {
 */
function ClientInfo(params) {
    onsqlresult = getLog;
    localStorage.setItem('client_info',JSON.stringify(params));
  }
  /**
   * It takes three arguments, sends a query to the database, and then creates a table with the results
   * of the query
   * @param {number}client_id - The client's ID
   * @param {string}name - The name of the client
   * @param {string}mail - The email address of the user.
   */
  function info(client_id,name,mail,fc) {
    onsqlresult = ClientInfo
    sattelanalyse.send(`sql select * from sessions where client_id=${client_id}`);
    let inter = setInterval(()=> {
        localStorage.setItem('client_fc',fc)
        localStorage.setItem('client_name',name)
        localStorage.setItem('client_mail',mail)
        localStorage.setItem('client_id',client_id)
        location.href = "/production/client.tcls"
        clearInterval(inter);
      }, 500);
  
  }
