#!/bin/bash
#
# create_vmkstationd3_tar_gz.sh
#
# Erzeugt ein Installationspaket für den vmkstationd3
#
# Das Skript befindet sich im Unterverzeichnis /dev
# und muß sich während der Ausführung ebenfalls dort befinden.
# Arbeitsverzeichnis ist das "vmkststiond3" enthaltende Verzeichnis.
# Der Aufruf erfolgt ohne Kommandozeilenparameter.
# Der Start erfolgt nach einer Rückfrage.
# Die Ausführung muß durch root erfolgen, damit die Dateien den Besitzer und die Gruppe "root" erhalten können.
# Dazu wird alles temporär in ein Verzeichnis <SRCDIR>_V<VERSION> kopiert.
# Die Unterverzeichnisse tmp/ und dev/ werden aus dem Archiv ausgeschlossen.
# Der Verzeichnisname ist gleichzeitig der Basisname des Tarfiles.
# 
#
# Velometrik GmbH
#
# Author: Siegmar Müller
# Historie:
#   28.10.2019  erstellt für vmkstationd
#   09.02.2023  umgebaut für vmkstationd3
#


SRCDIR=vmkstationd3

echo "Installationspaket für $SRCDIR erstellen ..."

# Ausführung als root, damit die Dateien Besitzer und Gruppe "root" bekommen können.
if [ $UID -ne 0 ]; then
    echo "Das Skript muß von root ausgeführt werden."
    su -c $0
    exit $?
fi

SCRIPT_DIR=$( cd -- "$( dirname $0 )" > /dev/null && pwd)
if [ "${SCRIPT_DIR:0-17}" != "/$SRCDIR/dev" ]; then
    echo "$( basename $0 ) muß sich im Verzeichnis ../$SRCDIR/dev befinden."
    exit 1
fi
cd $SCRIPT_DIR
cd ../..

# Wir sind nun im Ausführungsverzeichnis.
# Die Versionsnummer wird dem Hauptskript entnonnen.
VERSION=`grep -E '^set VERSION "?[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*' ${SRCDIR}/vmkstationd.tcl | sed 's/"//g;s/[^0-9]*//'`
echo "Gefundene Version: $VERSION"
echo $VERSION | grep '^[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*[^ ]*$' > /dev/null
if [ $? -ne 0 ]; then
    echo "Die Version kann nicht ermittelt werden."
    echo "(Die Syntax scheint nicht zu stimmen.)"
    exit 1
fi
TMPDIR=${SRCDIR}_V${VERSION}
echo "Temp. Verzeichnis: $TMPDIR"

if [ "$SRCDIR" == "$TMPDIR" ]; then
    echo "$SRCDIR müßte zum Packen auf sich selbst kopiert werden."
    exit 1
fi

echo -n "Create ${TMPDIR}.tar from ${SRCDIR} (J|n): "
read ANSWER
[ "${ANSWER}" == "" ] && ANSWER="J"
[ "${ANSWER}" != "J" ] && { echo "abgebrochen"; exit; }

if [ -d $TMPDIR ]; then
    read -p "Verzeichnis ./$TMPDIR löschen?[Jn]: " A
    if [ "$A" == "n" ]; then
        echo "abgebrochen"
        exit
    fi
    rm -rf ./$TMPDIR
fi

cp $SRCDIR -r $TMPDIR
chown -R root $TMPDIR
chgrp -R root $TMPDIR

tar --exclude="dev" --exclude="tmp" -c -f ${SRCDIR}_V${VERSION}.tar $TMPDIR

rm -rf ./$TMPDIR
gzip -f ${SRCDIR}_V${VERSION}.tar
chown root ${SRCDIR}_V${VERSION}.tar.gz
chgrp root ${SRCDIR}_V${VERSION}.tar.gz
echo
echo "${SRCDIR}_V${VERSION}.tar.gz erzeugt"

