# HTTP-Domäne /stationsproxy

namespace eval stationsproxy {

    variable stationsportal ""

    ::http::register https 443 ::tls::socket

    # Angekommene Daten zurückgeben
    proc dataArrived {clientsocket token} {
        upvar #0 clientcontext$clientsocket context
        upvar #0 $token state

        srvLog stationsproxy_$clientsocket Info "$context(url) -> $state(status)"
        if {$state(status) != "ok"} {
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler HTTPS-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "$context(url) konnte nicht geholt werden."]
	        append html [::html::end]
            #TODO Fehlerstatus
        } else {
            set html $state(body)
            array set header $state(meta)
            if {[info exists header(Content-Type)]} {
                # Content-Type in den Header übernehmen
                set context(contenttype) $header(Content-Type)
            }
            ::http::cleanup $token
        }
        ::WSServer::finishDomainResponse $clientsocket $html
        #TODO REQUESTLOGLEVEL ?
		srvLog $clientsocket Info "Done %d Bytes" [string length $html]
    }

    # Requestbehandlung
    proc handleClientRequest {clientsocket {query {}} } {
        upvar #0 clientcontext$clientsocket context
        variable stationsportal

        # Der Stationsserver wurde ursprünglich über der Referer ermittelt, was nicht zuverlässig funktionierte.
        # Jetzt wird der Name des Portalservers vom Webservice geliefert.
        if {"$::PORTALSERVER" != ""} {
            set stationsportal "${::PORTALSERVER}/"
        } elseif {[dict exists $context(request_headers) Referer]} {; #{{{
            set referer [dict get $context(request_headers) Referer]
            # Das ist die volle URL => nur Protokoll- und Hostteil nehmen!
            regexp {^[^/]*//[^/]*/} $referer referer_proto_host
            # Der Proxyserver kann nicht gleichzeitig das Stationsportal sein.
            # Das könnte bei der Weiterleitung zu Endlosrekursion führen.
            if {[dict exists $context(request_headers) Host]} {
                set host [dict get $context(request_headers) Host]
                if {![string match "*$host*" $referer_proto_host]} {
                    # Wenn stationsportal bereits gesetzt ist, ist Vorsicht angesagt.
                    if {"$stationsportal" == ""} {
                        set stationsportal $referer_proto_host
                        srvLog stationsproxy Notice "$stationsportal als Stationsportal registriert"
                    } elseif {$stationsportal != $referer_proto_host} {
                        set stationsportal $referer_proto_host
                        srvLog stationsproxy Notice "$stationsportal als neues Stationsportal registriert"
                    }
                }
            }
            #}}}
        }
        if {"$stationsportal" == ""} {; #{{{ Fehlerseite zurückgeben
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler HTTPS-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "Diese Seite sollte nie zu sehen sein."]
            append html "(Portalserver unbekannt und nicht zu ermitteln)<BR/>"
            # Die Requestheader könnten eine Erklärung liefern.
            dict for {key value} $context(request_headers) {
                append html "${key}: ${value}<BR/>"
            }
	        append html [::html::end]
	        return $html
            #}}}
        }; # if stationsportal unbekannt
        # Weiterleitung an Stationsportal
        set url [regsub {^.*stationsproxy/} $context(url) $stationsportal]
        srvLog stationsproxy_$clientsocket Info "geturl $url from $stationsportal"
        if {[catch {
            set token [::http::geturl $url -command "[namespace current]::dataArrived $clientsocket"]
            set context(self_finish) 1
            set html ""
        } errmsg]} {
            srvLog $clientsocket Error "$url -> $errmsg"
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler HTTPS-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "$url konnte nicht geholt werden."]
            append html $errmsg
	        append html [::html::end]
            #TODO Fehlerstatus ?
        }
	    return $html
    }; # proc handleClientRequest 

}; # namespace eval stationsproxy 

