# Anwendung: "Sitzknochenabstand"
# Datei: custom/apps/sitzknochenabstand.tcl
#

# TODO Piepseransteuerung implementieren

package require json


namespace eval sitzknochenabstand {
    variable VERSION "1.0.0_X"
    variable N_ROWS 16
    variable N_COLS 28
    variable N_AVG 5; # Anzahl der Bilder, über die der Durschnitt gebildet wird
    variable druckbilder [list]
    variable vsums [list]
    variable n_druckbilder 0
    variable i_druckbild 0
    variable dbld_analyse [list]; # für httpdomains::storedbld
    variable analyse [dict create]; # (Ergebnis)
    variable finished 0; # Analyse beendet
    # Die in vlbsettings:applications.clientsettings zu speichernden Einstellungen
    # Diese werden von den diesbezüglichen Kommandos modifiziert.
    # Hier sind die defaults (die ohnehin eingestellt sind, d.h. initial keine Aktion erfordern).
    # variable "appsettings" {{{
    variable appsettings [dict create \
        min_rawvalue {"value" 20 "default" 20} \
        create_jpeg  {"value" "on" "default" "on"} \
        create_norm  {"value" "off" "default" "off"} \
        contrast {"value" 0 "default" 0} \
        bgcolor {"value" "#202040" "default" "#202040"} \
        jpegquality {"value" 60 "default" 60} \
        resolution {"value" 17 "default" 17} \
        grid {"value" "no" "default" "no"} \
        frame {"value" 0 "default" 0} \
        ]
    # }}} variable "appsettings"
    variable jpegoptions [dict create -quality 60 -res 17 -grid no -frame 0]


    # Normiertes Druckbild an die Clients schicken
    # @param imagetype  Bildtyp
    # @param druckbild  Druckwerte
    # @param n_rows     Anzahl Zeilen
    # @param n_cols     Anzahl Spalten
    proc normFinished {imagetype druckbild n_rows n_cols} {; #{{{
        set values [join $druckbild ","]
        ::WSServer::disposeServerMessage apps/sitzknochenabstand text "{\"wsevent\": \"hockernorm\", \"imagetype\": \"$imagetype\", \"n_rows\": $n_rows, \"n_cols\": $n_cols, \"values\": \[$values\]}"
        #}}}
    }; # proc normFinished 


    # Neues JPEG-Bild verfügbar
    # => Clients über Websocket informieren
    proc jpegFinished {imagetype} {; #{{{
        srvLog [namespace current] Debug "::jpegFinished $imagetype"
        if {"$imagetype" in {sitbones}} {
            ::WSServer::disposeServerMessage apps/sitzknochenabstand text "{\"wsevent\": \"hockerbild\"}"
        }
        #}}}
    }; # proc jpegFinished 


    # Handler (Callback) für TTYSattel und BTSattel
    # Nimmt die neuesten Druckdaten zwecks Weiterverwendung entgegen.
    proc handleDBLDValues {druckbild n_rows n_cols v_sum} {; #{{{
        variable N_AVG
        variable druckbilder
        variable vsums
        variable n_druckbilder
        variable i_druckbild
        variable dbld_analyse
        variable analyse
        variable jpegoptions
        variable appsettings
        variable finished

        # Hinweis: Der Kode enthält - historisch bedingt - überflüssige Zustandsvariablen,
        #          tut aber, was er soll.
        srvLog [namespace current]::handleDBLDValues Debug "v_sum = $v_sum"
        set start_analyse 0
        set show_image 0
        if {$v_sum > 0} {; # Druck vorhanden => Prüfe, ob Auswertung sinnvoll ist
            if {!$finished} {
                if {$n_druckbilder == 0} {
                    ::WSServer::disposeServerMessage apps/sitzknochenabstand text [::kvlist2json {wsevent restart}]
                }
                # Bild festhalten
                lset druckbilder $i_druckbild $druckbild
                # v_sum festhalten
                lset vsums $i_druckbild $v_sum
                # Prüfen, ob eine Auswertung sinnvoll ist
                # Auswerten ist sinnvoll bei genug Bildern und wenig Gezappel.
                # Statt zeitaufwendig den Durchschnitt der Bilder zu berechnen, nehmen wir das Druckbild,
                # dessen Drucksumme am nächsten beim Durchschnitt liegt. ($i_min_gezappel)
                if {$n_druckbilder >= $N_AVG} {; #{{{ start_analyse sinnvoll ?
                    set v_avg 0
                    foreach vsum $vsums {
                        incr v_avg $vsum
                    }
                    set v_avg [expr $v_avg / $N_AVG]
                    set start_analyse 1
                    set min_gezappel 10
                    set i_min_gezappel 0
                    set i_vsum 0
                    foreach vsum $vsums {
                        set gezappel [expr abs($vsum - $v_avg) / double($v_avg)]
                        if {$gezappel > 0.1} {
                            # Noch zu viel Gezappel.
                            set start_analyse 0
                            break
                        }
                        if {$gezappel < $min_gezappel} {
                            set min_gezappel $gezappel
                            set i_min_gezappel $i_vsum
                        }
                        incr i_vsum
                    }
                    #}}}
                }
                # Weiter mit nächstem Druckbild
                set i_druckbild [expr ($i_druckbild + 1) % $N_AVG]
                if {$n_druckbilder < $N_AVG} {
                    incr n_druckbilder 
                }
                set show_image 1
            }; # if !$finished
        } else {; # Kein Druck => von vorn anfangen, sobald wieder Druck anliegt
            set n_druckbilder 0
            set i_druckbild 0
            set finished 0
            return; # auch kein Bild ausgeben
        }
        if {$start_analyse} {; #{{{ Genug Druckbilder und kaum Gezappel
            # Analyse für das Bild mit minimalem Gezappel ausführen und Ergebnis festhalten
            # Dieses Bild wird (wahrscheinlich nochmal) ausgegeben, damit letztes Bild und Ergebnis zusammenpassen.
            set druckbild [lindex $druckbilder $i_min_gezappel]
            set analyse [druckbild::analyse std $druckbild $n_rows $n_cols]
            set analyseerfolg [expr [dict get $analyse schwerpunkt1_x]>0 && [dict get $analyse schwerpunkt1_y]>0 && [dict get $analyse schwerpunkt2_x]>0 && [dict get $analyse schwerpunkt2_y]>0]
            if {$analyseerfolg} {; # als Sitzknochenabstand weitergeben
                dict set analyse wsevent sitzknochenabstand
                srvLog [namespace current]::handleDBLDValues Debug "$analyse"
                ::WSServer::disposeServerMessage apps/sitzknochenabstand text [::kvlist2json [dict get $analyse]]
                #TODO Piepser aktivieren
                set finished 1
            }
            dict set analyse v_sum $v_sum
            # Druckbild für Abruf (Mailversand) festhalten
            # Das muß das Druckbild zum Sitzknochenabstand sein.
            if {[namespace exists ::WSServer::httpdomains::storedbld]} {
                set ::WSServer::httpdomains::storedbld::hockerbild $druckbild
                #srvLog {} Debug [join $druckbild " "]
            } else {
                srvLog {} Debug "::WSServer::httpdomains::storedbld doesn't exist."
            }
            #}}}
        }
        if {$show_image} {
            # JPEG-Generierung (falls eingeschaltet) starten
            if {[dict get $appsettings create_jpeg value] == "on"} {
                ::kernel::JPEGHocker::createJPEG $druckbild $n_rows $n_cols $jpegoptions
            }
            # Druckbildnormierung (falls eingeschaltet) starten
            if {[dict get $appsettings create_norm value] == "on"} {
                ::kernel::NormHocker::createNorm ska_live $druckbild $n_rows $n_cols
            }
        }
        #}}}

    }; # proc handleDBLDValues 


    # Handler (Callback) für TTY-Treiberereignisse
    # @param change Änderung als wsevent (key/value-Paare)
    proc handleUSBDriverChange {change} {; #{{{
        ::WSServer::disposeServerMessage apps/sitzknochenabstand text [::kvlist2json $change]
        #}}}
    }; # proc handleUSBDriverChange 


    ##{{{ Die Kommandos (Aufruf durch handleCommand)
    #
    # Kommandos geben einen JSON- (wsevent) oder einen Leerstring zurück.
    # Falls es sich um keinen Leerstring handelt, wird die Rückgabe an die Clients verteilt.
    # Fehlermeldungen folgen dem Format von ::apps::createJSONError.
    #


    # Numerische Konfigurationseinstellungen
    # config min_rawvalue <value>
    # @param args   Liste mit 1x was? und wert
    proc configValue {args} {; #{{{
        variable appsettings

        if {[llength $args] != 2} {
            return [::apps::createJSONError client config "Must be: config <what> <value>"]
        }
        set value [lindex $args 1]
        if {![string is integer -strict $value]} {
            return [::apps::createJSONError client config "Must be: config <what> <integer>"]
        }
        switch [lindex $args 0] {
            "min_rawvalue" {
                if {$value < 0} {
                    return [::apps::createJSONError client config "Must be: config min_rawvalue 1 ..."]
                }
                set ::kernel::TTYHocker::MIN_VALUE $value
                dict set appsettings min_rawvalue value $value
            }
            default {
                return [::apps::createJSONError client config "Must be: config min_rawvalue <min_value>"]
            }
        }
        return ""
        #}}}
    }; # configValue 


    # on/off Konfigurationseinstellungen
    # @param args   Liste mit 1x was? und wert
    proc configSwitch {args} {; #{{{
        variable appsettings

        if {[llength $args] != 2} {
            return [::apps::createJSONError client config "Must be: switch <what> on|off"]
        }
        set value [lindex $args 1]
        if {!($value in {on off})} {
            return [::apps::createJSONError client config "Must be: switch <what> on|off"]
        }
        switch [lindex $args 0] {
            "create_jpeg" {
                dict set appsettings create_jpeg value $value
            }
            "create_norm" {
                dict set appsettings create_norm value $value
            }
            default {
                return [::apps::createJSONError client config "Must be: switch create_jpeg|create_norm on|off"]
            }
        }
        return ""
        #}}}
    }; # configSwitch 


    # Kommando "set jpeg ..."
    # Syntax: set jpeg ...
    #       ... colorcontrast 0...7
    #       ... bgcolor #%02x%02x%02x
    #       ... grid no|dotted|solid
    #       ... resolution 1...???
    #       ... frame 0...???
    #       ... quality 0...100
    # @param args   s. Syntax
    # @return    Fehlermeldung oder Leerstring
    proc setJPEG {args} {; #{{{
        variable appsettings
        variable jpegoptions

        if {[llength $args] < 2} {
            return {Must be: set jpeg <what> <value>}
        }
        srvLog [namespace current]::setJPEG Debug "$args"
        set value [lindex $args 1]
        switch [lindex $args 0] {
            "colorcontrast" {
                set colorcontrast [lindex $args 1]
                if {[regexp {^[0-7]$} $colorcontrast]} {
                    ::DBLD2IMG::setGlobalJPEG colorcontrast $colorcontrast
                    dict set appsettings contrast value $colorcontrast
                    return
                } else {
                    return "Must be: set jpeg colorcontrast 0...7"
                }
            }
            "bgcolor" {
                set color [lindex $args 1]
                if {[regexp {^#[0-9A-Fa-f]{6}$} $color]} {
                    ::DBLD2IMG::setGlobalJPEG bgcolor $color
                    dict set appsettings bgcolor value $color
                    return
                } else {
                    return "Must be: set jpeg bgcolor #%02x%02x%02x"
                }
            }
            "grid" {
                if {!($value in {no dotted solid})} {
                    return "Must be: set jpeg grid no|dotted|solid"
                }
                dict set appsettings grid value $value
                dict set jpegoptions -grid $value
                return
            }
            "resolution" {
                if {[string is integer -strict $value]} {
                    if {$value >= 1} {
                        dict set appsettings resolution value $value
                        dict set jpegoptions -res $value
                        return
                    }
                }
                return "Must be: set jpeg resolution 1 ..."
            }
            "frame" {
                if {[string is integer -strict $value]} {
                    if {$value >= 0} {
                        dict set appsettings frame value $value
                        dict set jpegoptions -frame $value
                        return
                    }
                }
                return "Must be: set jpeg frame 0 ..."
            }
            "quality" {
                if {[string is integer -strict $value]} {
                    if {0 <= $value && $value <= 100} {
                        dict set appsettings jpegquality value $value
                        dict set jpegoptions -quality $value
                        return
                    }
                }
                return "Must be: set jpeg quality 0 ... 100"
            }
            default {
                return {Must be: set jpeg colorcontrast|bgcolor|grid|resolution|frame|quality <value>}
            }
        }; # switch jpeg-Option
        #TODO Letztes Bild nochmal generieren. (Das haben wir aktuell nicht mehr.)
        #}}}
    }; # Kommando "set jpeg ..."


    ##}}} Die Kommandos (Aufruf durch handleCommand)


    # Eingegangenes Kommando an die Kommandoprozedur weiterleiten
    # (Aufruf von custom/wsserver/wsdomains/apps/sitzknochenabstand.tcl)
    # Bei Fehlern geht eine Meldung an die Domäne apps/sitzknochenabstand.
    # @param command    Kommando wie vom Client eingegangen
    proc handleCommand {command} {; #{{{
        variable VERSION

	    srvLog [namespace current] Debug "Command received: $command"
        set commandname [regsub {  *.*$} $command ""]
        set args [regsub {[a-zA-Z][a-zA-Z0-9]* *} $command ""]
        set result ""

        if {[catch {
            switch $commandname {
                "config" {
                    set result [configValue {*}$args]
                }
                "switch" {
                    set result [configSwitch {*}$args]
                }
                "set" {
                    if {[llength $args] < 1} {
                        set what ""
                        set result "set what?"
                    } else {
                        set what [lindex $args 0]
                        set args [lrange $args 1 end]
                        switch $what {
                            "jpeg" {
                                set result [setJPEG {*}$args]
                            }
                            default {
                                set result "Must be: set jpeg ..."
                            }
                        }
                    }
                    if {"$result" != ""} {
                        set result [::apps::createJSONError client "set $what" $result]
                    }
                }
                "version" {
                    # $args werden stillschweigend ignoriert.
                    set version [list wsevent "version" vmkstationd $::VERSION app $VERSION]
                    ::WSServer::disposeServerMessage apps/sitzknochenabstand text [::kvlist2json $version]
                }
                default {
                    set result [::apps::createJSONError client command "Unknown command: $commandname"]
                }
            }
        } error_msg]} {; # Fehler
            if {[info exists errorInfo]} {
                append error_msg "\n$errorInfo"
            }
            #TODO Es ist vielleicht nicht notwendig, das alles an die Clients zu verteilen,
            #     es reicht eine Logmeldung. (satteldruckanalyse dto.)
            set result [::apps::createJSONError internal vmkstationd "$error_msg"]
        }
        if {"$result" != ""} {
            srvLog [namespace current] Warn "Client error: '$result'"
            ::WSServer::disposeServerMessage apps/sitzknochenabstand text $result
        } else {
            srvLog [namespace current] Info "Command executed: '$command'"
        }
        #}}}
    }; # proc handleCommand 


    ##{{{ init{}, start{}, stop{}

    # Initialisierung unmittelbar nach dem Laden
    # (Aktuell nur Dummy)
    proc init {} {; #{{{
        #srvLog [namespace current] Info "Initializing App ..."
        # Keine speziellen Biblitheken.
        #srvLog [namespace current] Info "App initialized."
        #}}}
    }; # proc init 


    # Anwendung starten mit TTY
    proc start {} {; #{{{
        variable N_ROWS
        variable N_COLS
        variable appsettings
        variable jpegoptions

        srvLog [namespace current] Info "Starting App ..."
        # Callbacks setzten
        ::kernel::TTYHocker::addDriverHandler [namespace current]::handleUSBDriverChange
        ::kernel::TTYHocker::addImageHandler [namespace current]::handleDBLDValues 
        ::kernel::JPEGHocker::addImageHandler [namespace current]::jpegFinished
        # Nächste Version
        #TODO ::kernel::JPEGHocker::addOverloadHandler [namespace current]::handleOverload
        ::kernel::NormHocker::addNormHandler [namespace current]::normFinished {ska_live}
        #TODO Overload ? (gibt es (noch?) nicht.)
        # Einstellungen aus der Datenbank holen
        set stored_settings [::kernel::DB::getAppsettings "sitzknochenabstand"]
        srvLog [namespace current]::init Debug "appsettings: $stored_settings"
        dict for {key value} $appsettings {
            # Nur die Einstellungen übernehmen, die es tatsächlich gibt.
            # (Jemand könnte an der Datenbank gespielt haben.)
            if {[dict exists $stored_settings $key]} {
                dict set appsettings $key value [dict get $stored_settings $key]
            } else {
                dict set appsettings $key value [dict get $appsettings $key default]
            }
        }
        set ::kernel::TTYHocker::MIN_VALUE [dict get $appsettings min_rawvalue value]
        # jpegoptions ableiten
        dict set jpegoptions -quality [dict get $appsettings jpegquality value]
        dict set jpegoptions -res [dict get $appsettings resolution value]
        dict set jpegoptions -grid [dict get $appsettings grid value]
        dict set jpegoptions -frame [dict get $appsettings frame value]
        # Hintergrundfarbe und Kontrast setzen
        ::DBLD2IMG::setGlobalJPEG bgcolor [dict get $appsettings bgcolor value] colorcontrast [dict get $appsettings contrast value]
        # Leeres Bild mit Verzögerung schicken
        #TODO createJPEG und createNorm nur, wenn das in den appsettings so eingestellt ist.
        after 1000 "
            set values \[lrepeat \[expr $N_ROWS*$N_COLS\] 0\]
            ::kernel::JPEGHocker::createJPEG \$values $N_ROWS $N_COLS {$jpegoptions}
            ::kernel::NormHocker::createNorm ska_live \$values $N_ROWS $N_COLS
        "
        srvLog [namespace current] Info "App started."
        #}}}
    }; # proc start


    # Anwendung anhalten
    proc stop {} {; #{{{
        variable appsettings

        # Callbacks zurücknehmen
        ::kernel::TTYHocker::removeImageHandler [namespace current]::handleDBLDValues 
        ::kernel::TTYHocker::removeDriverHandler [namespace current]::handleUSBDriverChange
        ::kernel::JPEGHocker::removeImageHandler [namespace current]::jpegFinished
        # Nächste Version
        #TODO ::kernel::JPEGHocker::removeOverloadHandler [namespace current]::handleOverload
        #TODO Thread für normiertes Druckbild beenden
        # appsettings ohne defaults speichern
        set as2store $appsettings
        foreach {key} [dict keys $appsettings] {
            dict unset as2store $key default
        }
        srvLog [namespace current]::stop Debug "settings to store:\n$as2store"
        ::kernel::DB::setAppsettings "sitzknochenabstand" $as2store
        srvLog [namespace current] Info "App stopped."
        #}}}
    }; # proc stop 

    ##}}} init{}, start{}, stop{}

}; # namespace eval sitzknochenabstand 

set app_loaded sitzknochenabstand

