#!/bin/bash
#
# velobox_update_3.0.1
# Einspielen aller Dateien in /usr/local/vmkstationd3/
# Velometrik-GmbH
#
# Historie:
# 22.03.2022	Björn Bauer	erstellt
#

if [ `whoami` != "root" ]; then
echo "ERROR"
    echo "The script must be executed by root!"
    exit 1
fi

if [ `awk -F '=' '/VERSION/ {print $2}' /usr/local/etc/velobox.conf` != "3.0.0" ]; then
echo "ERROR"
echo "You need the Update 3.0.0"
exit 1
fi

echo "htdocs leeren"
rm -r /usr/local/vmkstationd3/htdocs/
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "Fehler beim löschen der htdocs :o"
    exit 1
fi
echo "done"

echo "Files in / will be installed."
if [ ! -r velobox_update_3.0.1.tar.gz ]; then
echo "ERROR"
    echo "velobox_update_3.0.1.tar.gz not found" 
    exit 1
fi

cp velobox_update_3.0.1.tar.gz /
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "Can't copy velobox_update_3.0.1.tar.gz to / ."
    exit 1
fi
cd /
test $? -ne 0 && exit 1
tar xf velobox_update_3.0.1.tar.gz
test $? -ne 0 && exit 1
rm -f velobox_update_3.0.1.tar.gz

echo "Files in / were recorded."

### Standards - Nicht ändern! ###

echo "Benutzerrechte korrigieren"
chown -R root:root /usr/local
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "Benutzerrechte konnten nicht korrigiert werden!"
    exit 1
fi

history -c