/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/* 
    Created on : 04.06.2021, 21:08:29
    Author     : Peter Bauer
*/
// const host = "http://velobox-peter.local:8080";
hide_mask();

const host = `http://${location.host}`;
// const ws = "ws://velobox-peter.local:8080"
const ws = `ws://${location.host}`;

const apps= "satteldruckanalyse";

var onsqlresult = getLog;

// const canvasHocker = new fabric.Canvas("canvas_hocker");
// createHockerCanvas(canvasHocker)

var jsn_result1 = new Object();
var jsn_result2 = new Object();

var cable = false
var showText = true;

let sda_live = `${host}/sattelbild`;
let sda_frame1 = `${host}/sattelbild?image=blank`;
let sda_frame2 = `${host}/sattelbild?image=blank`;

let hocker_frame = `${host}/sattelbild?image=blank`;
let setting = new Object();
let galerie_image_info;
var data;

let note = localStorage.getItem('session_note')

var load_num;
var querys;

var bread=0


document.getElementById('headliner').innerHTML = localStorage.getItem('client_name');

// document.getElementById('product1').setAttribute('placeholder',gettrans('sda_marke'))

/**
 * It sets the pelvis size.
 */
function setPelSize() {
  setting.pelv = $('#pelv').val();
  localStorage.setItem("setting",JSON.stringify(setting));
  sattelanalyse.send(`set clientsettings ${JSON.stringify(setting)}`)

}
/**
 * It takes the value of the input field with the id "time_before" and saves it in the variable
 * "setting.verZeit" in the local storage
 */
function bZeit (){
setting.verZeit = $('#verZeit').val();
localStorage.setItem("setting",JSON.stringify(setting));
sattelanalyse.send(`set clientsettings ${JSON.stringify(setting)}`)
}
/**
 * It takes the value of the input field with the id "aufzeichnung" and saves it in the variable
 * "setting.aufZeit" and then saves the variable "setting" in the local storage
 */
function aZeit (){
setting.aufZeit = $('#aufZeit').val();
localStorage.setItem("setting",JSON.stringify(setting));
sattelanalyse.send(`set clientsettings ${JSON.stringify(setting)}`)
}
/**
 * `setting.center_color = $('#center_color').val();`
 *
 * The above line of code is the only line of code that is needed to change the center color
 */
function CenterColor() {
  setting.center_color = $('#center_color').val();
  localStorage.setItem('setting', JSON.stringify(setting));
  sattelanalyse.send(`set clientsettings ${JSON.stringify(setting)}`)
  BgColor()
}
/**
 * It takes the value of the input field with the id "bg_color" and sets it as the background color of
 * the JPEG image
 */
function BgColor() {
  setting.bgColor = $('#bgColor').val();
  console.log('set bgColor',setting.bgColor);
  sattelanalyse.send(`set jpeg bgcolor ${setting.bgColor}`);
  localStorage.setItem('setting', JSON.stringify(setting));
  sattelanalyse.send(`set clientsettings ${JSON.stringify(setting)}`)
}
/**
 * `function PRColor() { setting.pr_color = $('#pr_color').val(); localStorage.setItem('setting',
 * JSON.stringify(setting)); BgColor() }`
 *
 * The function is called when the user changes the value of the `#pr_color` input element. The value
 * of the input element is stored in the `setting.pr_color` variable. The `setting` variable is then
 * stored in the browser's local storage. The `BgColor()` function is then called to update the
 * background color of the page
 */
function PRColor() {
  setting.pr_color = $('#pr_color').val();
  localStorage.setItem('setting', JSON.stringify(setting));
  sattelanalyse.send(`set clientsettings ${JSON.stringify(setting)}`)
  BgColor()
}
/**
 * `function ITColor(){setting.text_color = $('#it_color').val();localStorage.setItem('setting',
 * JSON.stringify(setting));BgColor()}`
 */
function ITColor(){
  setting.text_color = $('#text_color').val();
  localStorage.setItem('setting', JSON.stringify(setting));
  sattelanalyse.send(`set clientsettings ${JSON.stringify(setting)}`)
  BgColor()
}
/**
 * `LineColor()` is a function that sets the line color to the value of the `#line_color` input element
 */
function LineColor() {
  setting.line_color = $('#line_color').val();
  localStorage.setItem('setting',JSON.stringify(setting))
  sattelanalyse.send(`set clientsettings ${JSON.stringify(setting)}`)
  BgColor()
}
/**
 * If the checkbox is checked, the variable "teil_line" is set to true, otherwise it is set to false
 */
function Einteilung() {
  if ($('#einteilung').is(':checked')) {
    setting.teil_line = true
  } else{
    setting.teil_line = false
  }
  localStorage.setItem("setting",JSON.stringify(setting));
  sattelanalyse.send(`set clientsettings ${JSON.stringify(setting)}`)
  BgColor()
}
/**
 * If the checkbox is checked, then the setting.showText is set to true, otherwise it is set to false
 */
function imageText(){
  if ($('#imgTextcheck').is(':checked')) {
    setting.showText = true
  } else{
    setting.showText = false
  }
  localStorage.setItem("setting",JSON.stringify(setting));
  sattelanalyse.send(`set clientsettings ${JSON.stringify(setting)}`)
  BgColor()
}

let maxValue = 0;
//center of pressure
let cop1={x:0,y:0};
let cop2={x:0,y:0};
let num;

var ch;
var cw;
/* The above code is getting the height and width of the Frame-3 class. */
ch = document.getElementsByClassName("Frame-3")[0].offsetHeight;
cw = document.getElementsByClassName("Frame-3")[0].offsetWidth;


var sattelanalyse = new WebSocket(`${ws}/apps/${apps}`, ["soap", "wamp"]);

var sitzknochen;
var matrixLive;

if(location.pathname === "/production/new_satteldruckanalyse.tcls"){
run_Sattelanalyse();

document.getElementById('note_session').value = note;

var sess;
/* The above code is listening for a change in the note_session textarea. When a change is detected,
the code sends a SQL query to the database to update the notes column in the sessions table with the
new value of the textarea. */
document.getElementById('note_session').onchange = function() {
  // console.log("note_session change");
  if(localStorage.getItem('session').split(' ')[0] == "restart"){
    sess = localStorage.getItem('session').split(' ')[1]
  } else{
    onsqlresult = getSession
    sattelanalyse.send(`sql SELECT next_id from nextids n WHERE table_name = 'sessions'`)
  }
  sattelanalyse.send(`sql UPDATE sessions SET notes='${document.getElementById('note_session').value}' WHERE session_id=${sess}`)
}
// console.log($(window).height()>$(window).width,$(window).height(),'>',)
if($(window).height()>$(window).width()){
  let append = document.getElementById('tableth')
  let btn = document.createElement('button')
  btn.setAttribute('onclick','abso()')
  btn.innerHTML='#full'
  append.append(btn)
}

/* Checking if the cable is connected or not. If it is not connected, it will show a modal. */
var conBT = setInterval(function () {
  if(cable==false){
  UIkit.modal($("#modal-connect-with-bluetooth")).show();
  let append = document.getElementsByClassName('navbar-right')[0];
  let li = newElement({element:'li',cls:['nav-item']},append);
  let btn = newElement({element:'button',cls:['uk-button','uk-button-small','uk-button-default','ico-16', 'mdi', 'mdi-bluetooth'],attr:[['onclick','UIkit.modal($("#modal-connect-with-bluetooth")).show()'],['key-title','sda_bluetooth_con']]},li)
  }
  clearInterval(conBT);
}, 1000);
translatejs();
}

/**
 * "When the user clicks the save button, show the save mask modal."
 *
 * The `save_mask()` function is called by the `onclick` attribute of the save button
 */
function save_mask() {
  UIkit.modal($("#modal-save-mask")).show();
}
/**
 * The function `getHockerNr(num)` creates a new WebSocket connection to the SmartCube with the number
 * `num` and runs the function `run_Sitzknochen(num)` to handle the connection.
 * @param num - The number of the cube you want to connect to.
 */
function getHockerNr(num){
  try {
  sitzknochen = new WebSocket(`ws://smartcube${num}.local/messages`,["soap","wamp"]);
  run_Sitzknochen(num);
  } catch (error) {
   console.error(error);
  }
}

/**
 * `set_mask` sets the mask to one of the following: `nomask`, `standard`, `large`, `custom` or `<name>`
 * @param param - The name of the mask to use.
 */
function set_mask(param){
    sattelanalyse.send(`set mask ${param}`);
}

/**
 * It deletes a mask from the database
 * @param param - the name of the mask
 */
function del_mask(param){
  sattelanalyse.send(`sql delete from masks where name='${param}'`)
  document.getElementById(`${param}`).classList.add('hide')

}

/**
 * It sends a message to the server to set the compare parameter
 * @param param - the parameter to set
 */
function set_comp(param) {
  // console.log('set_comp',param);
  sattelanalyse.send(`set compare ${param}`);
}

/**
 * It sends a message to the server to start a session and then it displays the client's name and email
 * address
 *
 * @param val - localStorage value of session
 */
function session (val){
      // console.log('session',val);
    sattelanalyse.send(`session ${val}`)
    onsqlresult = Maskmenue;
    sattelanalyse.send(`sql select name from masks where mask_id > 4`);
}

/**
 * It takes the number of the image, gets the values of the three input fields, and sends them to the
 * server
 * @param num - the number of the image to be saved
 */
function save_rec(num) {
  let info = new Object();
  info.product = $(`#product${num}`)[0].value;
  info.product_label = $(`#product_label${num}`)[0].value;
  info.notes = $(`#notes${num}`)[0].value;
  // console.log(`recording store ${num} ${JSON.stringify(info)}`);
  sattelanalyse.send(`recording store ${num} ${JSON.stringify(info)}`);
  //TODO: Dialog nach aktuellem CI erstellen und übersetzen!
  UIkit.notification({message: `${aLangKeys[lang]['save_data']}`})
}

/**
 * It sends a SQL query to the server, and when the server responds, it calls the function RowImg
 * @param num - the number of the recording to load
 */
function load_rec(num) {
  load_num = num
  // console.log('load ',num);
  if(localStorage.getItem('session').split(' ')[0]=='restart'){
  onsqlresult = RowImg
  sattelanalyse.send(`sql select * from recordings WHERE analysis=2 AND session_id=${localStorage.getItem('session').split(' ')[1]}`)
  }
  if(localStorage.getItem('session').split(' ')[0]=='start'){
   onsqlresult = getSession
   sattelanalyse.send(`sql SELECT next_id from nextids n WHERE table_name = 'sessions'`)
   let getrow = setInterval(function () {
    onsqlresult = RowImg
    sattelanalyse.send(`sql select * from recordings WHERE analysis=2 AND session_id=${localStorage.getItem('new_session')}`)
    clearInterval(getrow);
  }, 1000);
  }

  }


/**
 * This function is called when the database returns a result from the query. It takes the result as a
 * parameter and sets the local storage variable 'new_session' to the next available session id
 * @param params - [{next_id: 1}]
 */
function getSession(params) {
  onsqlresult = getLog;
  // console.log(params);
  params.forEach(element => {
    // console.log(element.next_id-1);
    sess= element.next_id-1;
    console.log(sess);
    localStorage.setItem('new_session',element.next_id-1)
  });
}

/**
 * It sends a message to the server that the session is finished
 */
function end_session(){
  sattelanalyse.send('session finish')
}
/**
 * It sends a message to the server to cancel the recording of the specified number
 * @param {number}num - The number of the recording to cancel.
 */
function rec_cancel(num) {
  sattelanalyse.send(`recording cancel ${num}`);
}
/**
 * It creates a websocket connection to the smartcube and listens for messages. If the message is of
 * type "sitzknochenabstand" it will draw the sitzknochenabstand on the canvas
 * @param num - the number of the cube you want to connect to.
 */
function run_Sitzknochen(num) {
  //  createHockerCanvas(canvasHocker);
  let hocker_frame = `http://smartcube${num}.local/hockerbild?rnd=${(new Date).getTime()}`;
  //  drawHockerIMG(canvasHocker,hocker_frame)

    sitzknochen.onmessage = (e)=> {
      if(log)
      console.log(e);

      var sitz_data = new Object();

      try {
        sitz_data = JSON.parse(e.data);
      } catch (error) {
        console.error(error);
      }

      if(sitz_data.wsevent === "plugged"){
        hocker_frame = `http://smartcube${num}.local/hockerbild?rnd=${(new Date).getTime()}`;
        drawHockerIMG(canvasHocker,hocker_frame);
      }

      if(sitz_data.wsevent === "hockerbild"){
        hocker_frame = `http://smartcube${num}.local/hockerbild?rnd=${(new Date).getTime()}`;
        drawHockerIMG(canvasHocker,hocker_frame);
      }

      if(sitz_data.wsevent === "sitzknochenabstand"){
        var v_sum = sitz_data.v_sum || 0.0;
        hocker_frame = `http://smartcube${num}.local/hockerbild?rnd=${(new Date).getTime()}`;
        setHockerImage(canvasHocker,hocker_frame,{x1:sitz_data.schwerpunkt1_x,y1: sitz_data.schwerpunkt1_y, x2:sitz_data.schwerpunkt2_x, y2:sitz_data.schwerpunkt2_y},sitz_data.sitzknochenabstand,v_sum)
      }

    }
    sitzknochen.onerror= (e)=>{
      console.error(e);
    }
}

/**
 * If the user tries to leave the page, ask them if they're sure they want to leave.
 * @param event - The event object.
 * @returns The return value of the function is the string "Are you sure you want to leave the page?"
 */
const onConfirmRefresh = function (event) {
  event.preventDefault();
  return event.returnValue = "Are you sure you want to leave the page?";
}

/* Adding an event listener to the window object. The event listener is listening for the beforeunload
event. When the event is triggered, the onConfirmRefresh function is called. */
window.addEventListener("beforeunload", onConfirmRefresh, { capture: true });

/**
 * It sets up the websocket connection and defines what happens when the server sends a message
 */
function run_Sattelanalyse() {

    sattelanalyse.onopen = (e) =>{
      rec_cancel(1);
      rec_cancel(2);
      sattelanalyse.send('get clientsettings')
      if(localStorage.getItem('session').split(' ')[0]=='restart'){
        sess = localStorage.getItem('session').split(' ')[1]
      }
      if(localStorage.getItem('session').split(' ')[0]=='start'){
         onsqlresult = getSession
         sattelanalyse.send(`sql SELECT next_id from nextids n WHERE table_name = 'sessions'`)
      }
    }

    sattelanalyse.onmessage = (e) => {

      data = new Object();

        try {
           data = JSON.parse(e.data);
        } catch (error) {
          console.error(error);
        }
        if(log)
        console.log(data);
        if(data.wsevent ==="clientsettings"){
          setting = data.clientsettings
          if(setting.initial){
            for (const key in setting) {
              const element = setting[key];
              if($(`#${key}`)[0]){
              $(`#${key}`)[0].value = element
              // console.log($(`#${key}`)[0].value);
              }
            }
            } else {
              setting = new Object();
              setting.initial = true;
              setting.bgColor = "#000000";
              setting.mask = "nomask";
              setting.aufZeit = 3;
              setting.verZeit = 3;
              setting.center_color="#ff0000";
              setting.teil_color = "#ffffff";
              setting.teil_line = true;
              setting.text_color ="#ffffff";
              setting.pr_color="#000000";
              setting.line_color ="#ffff00";
              setting.showText = true;
              setting.pelv = 1
              sattelanalyse.send(`set clientsettings ${JSON.stringify(setting)}`)
              for (const key in setting) {
                const element = setting[key];
                if($(`#${key}`)[0]){
                $(`#${key}`)[0].value = element
                // console.log($(`#${key}`)[0].value);
              }
            }
            }
          }



        /* Checking if the data.wsevent is equal to "error" and if it is, it will call the error_msg
        function and pass the data to it. */
        if(data.wsevent === "error"){
          error_msg(data);
        }

        /* The above code is checking if the data.wsevent is equal to "btevent" and if it is, it will check if
        the data.btevent is equal to "error" and if it is, it will hide the modal and display the error
        message. If the data.btevent is equal to "status", it will display the name and address of the
        connected device. */
        if(data.wsevent === "btevent"){
          /* Checking if the data.btevent is equal to "error" and if it is, it will hide the modal and
          display the error message. */
          if (data.btevent === "error") {
          UIkit.modal($("#modal-connect-bluetooth")).hide();
          error_msg(data);
          }
          // data.btevent = "ambiguity"
          // data.devices = ['eins','zwei','drei']

          if(data.btevent === "ambiguity"){
            let append = document.getElementById('multi_device');
            data.devices.forEach(element => {
              console.log(element);
              let tr = newElement({element:'tr'},append);
              let td1= newElement({element:'td'},tr);
              td1.innerHTML = element
              let td2= newElement({element:'td'},tr);
              let btn= newElement({element:'button',cls:['uk-button', 'uk-button-default', 'uk-button-small','ico-16','mdi','mdi-connection'],attr:[['onclick',`sattelanalyse.send('btconnect ${element}')`]]},td2)
            });

          UIkit.modal($("#modal-mod_multi")).show();
          }
          /* A JavaScript code that is executed when the event "status" is received. */
          if(data.btevent === "status"){
            if(data.devices[0]){
            let e1 = document.getElementById('link_bolt');
            e1.removeAttribute('onclick');
            let e2 = document.getElementById("bolt");
            e2.classList.remove('mdi-link-variant-off');
            e2.classList.add('mdi-link-variant');
            e2.style.color="green";
            $('#bt_verbindung_hergestellt')[0].innerHTML = 'Verbunden';
            $('#bt_verbindung_text')[0].innerHTML = `Gerätename: ${data.devices[0].name}<br>Macadresse: ${data.devices[0].address}`;
            }
          }
        }

        /* The above code is checking if the state is active. If it is active, then it will run the
        code. */
        if(data.state ==='active'){
          console.log('active');
          console.log(setting);
          sattelanalyse.send(`set jpeg colorcontrast ${$('#vertical').val()}`)
          $('#aufZeit')[0].value = setting.aufZeit
          $('#verZeit')[0].value = setting.verZeit
          document.getElementById('center_color').value = setting.center_color
          document.getElementById('bgColor').value = setting.bgColor
          document.getElementById('pr_color').value = setting.pr_color
          document.getElementById('text_color').value = setting.text_color
          document.getElementById('line_color').value = setting.line_color
          $('#pelv')[0].value = setting.pelv
          /* Checking if the setting.teil_line is true or false. If it is true, it will check the
          checkbox. If it is false, it will uncheck the checkbox. */
          if(setting.teil_line===true){
            $('#einteilung')[0].setAttribute('checked','')
          } else{
            $('#einteilung')[0].removeAttribute('checked')
          }
          /* The above code is checking if the showText is true or false. If it is true, then it will
          check the box. If it is false, then it will uncheck the box. */
          if (setting.showText === true) {
            $('#imgTextcheck')[0].setAttribute('checked','')
          } else{
            $('#imgTextcheck')[0].removeAttribute('checked')
          }
        }

        /* Setting the background image of the element with the id "live_img" to the image at the url
        img3. */
        if (data.wsevent === "sattelbild") {
            img3 = `${host}/sattelbild?rnd=${(new Date).getTime()}`;
            document.getElementById('live_img').style.backgroundImage(img3);
        }
        /* Setting the image source to the sda_live image. */
        if (data.wsevent === "sda_live") {
            sda_live = `${host}/sattelbild?image=sda_live&rnd=${(new Date).getTime()}`;
            var d = document.getElementById('div_live_img');
            d.setAttribute("src",`${host}/sattelbild?image=sda_live&rnd=${(new Date).getTime()}`);
            d.setAttribute("width",cw);
            d.setAttribute("height",ch);
        }
        /* Setting the image of the canvas to the image from the server. */
        if (data.wsevent === "sda_int1") {
            sda_frame1 = `${host}/sattelbild?image=sda_int1&rnd=${(new Date).getTime()}`;
             setImage(canvas1, sda_frame1, false);
             if(jsn_result1.wsevent){
              let inter = setInterval(function () {
                result_1(jsn_result1)
                clearInterval(inter);
              }, 100);
             }
        }
        /* Setting the image to the canvas. */
        if (data.wsevent === "sda_int2") {
            sda_frame2 = `${host}/sattelbild?image=sda_int2&rnd=${(new Date).getTime()}`;
             setImage(canvas2, sda_frame2, false);
             if(jsn_result2.wsevent){
              let inter = setInterval(function () {
                result_2(jsn_result2)
                clearInterval(inter);
              }, 100);
             }

        }
        /* The above code is a JavaScript function that is executed when the sattelanalyse object sends
        a message to the web page. */
        if (data.wsevent === "sda_int3") {
          // console.log('sda_int3');
          let img = document.getElementsByClassName('imgGal1')[fi-1];
          let a = document.getElementsByClassName('imgGal2')[fi-1];
          sda_frame3 = `${host}/sattelbild?image=sda_int3&rnd=${(new Date).getTime()}`;
          img.src=sda_frame3
          a.setAttribute('onclick',`sattelanalyse.send('recording retrieve ${recID[fi-1]} ${load_num}')`)
          if(galerie_image_info.pelvisrotation)
            pel = `${galerie_image_info.pelvisrotation.width||""}:${galerie_image_info.pelvisrotation.height||""}`
          else
            pel ="-"
         document.getElementsByClassName('info_img')[fi-1].innerHTML =`
         <ul class="uk-list uk-list-collapse">
         <li key="pro_satteldruck_veloscore">Veloscore</li>
         <li key="pro_satteldruck_becken">Rotation</li>
         <li key="pro_satteldruck_leftright">Lins/Rechts</li>
         <li key="pro_satteldruck_frontback">Vorn/Hinten</li>
         </ul>
         <ul class="uk-list uk-list-collapse">
         <li>${galerie_image_info.veloscore}</li>
         <li>${pel}</li>
         <li>${galerie_image_info.left_right}</li>
         <li>${galerie_image_info.front_rear}</li>
         </ul>`
         document.getElementsByClassName('name_img')[fi-1].innerHTML=`
         <h2 class="uk-text-center">${galerie_image_info.product_label||"(no name)"}</h2>
         <p class="uk-text-center"><small>${galerie_image_info.product||"(no name)"}</small></p>`
          /* Sending a message to the sattelanalyse object. */
          if(recID[fi]){
              // console.log('sda_init3 send');
              sattelanalyse.send(`recording retrieve ${recID[fi]} 3`)
              fi++
          }
      }
        /* Setting the max value of the progress bar to the value of the data.value. */
        if (data.wsevent === "max_value") {
            maxValue = data.value;
            var bar = document.getElementById('js-progressbar_max');
            bar.value = maxValue;
        }
        if (data.wsevent === "result1") {
            result_1(data);
            jsn_result1 = data;
            if(data.pelvisrotation){
            cop1.x = data.pelvisrotation.center.x;
            cop1.y = data.pelvisrotation.center.y;
            }
        }
        if (data.wsevent === "result3"){
          // console.log(data)
          galerie_image_info = data;
        }
        if (data.wsevent === "result2") {
            result_2(data);
            jsn_result2 = data;
            if(data.pelvisrotation){
            cop2.x = data.pelvisrotation.center.x;
            cop2.y = data.pelvisrotation.center.y;
            }
            if(bread === 0){
              let append = document.getElementById('menu_bread')
              let li = newElement({element:'li'},append)
              let a = newElement({element:'a',cls:['font-12'],attr:[['onclick','toProtokol()'],['key','pro_protokoll']]},li)
              a.innerHTML = '<!--Protokoll-->'
              translatejs();
              bread++
             }
        }
       /* Checking the state of the tty. */
        if (data.wsevent === "ttystate"){
            ttystate_check(data)
        }
       /* Reloading the page when the tty changes. */
        if(data.wsevent === "ttychange"){
            location.reload();
        }
        if(data.wsevent === "appquestions"){
          querys = data.appquestions
        }
        /* A JavaScript function that is called when the server sends a message with the event name
        "sqlresult". */
        if (data.wsevent === "sqlresult"){
          try {
          onsqlresult (data.rows);
          } catch (error) {
            console.log(error);
          }
        }
    }
    sattelanalyse.onerror = (error) => {
      console.error(`[error] ${error.message}`);
    };
}


/**
 * It takes an array of objects, and for each object, it calls a function called add_mask, passing the
 * name property of the object as a parameter
 * @param params - an array of objects, each object has a name property
 */
function Maskmenue (params){
  onsqlresult = getLog;
  params.forEach(element => {
     add_mask(element.name)
  });
}

/**
 * It creates a list item with a div inside, and two links inside the div. The first link is for
 * setting the mask, and the second link is for deleting the mask
 * @param name - the name of the mask
 */
function add_mask(name){
  let append = $('#mask_list')
  let e = newElement({element:'li'},append)
  let div = newElement({element:'div',cls:['mask_link'],id:`${name}`},e)
  let a = newElement({element:'a',attr:[['href','#modal-dialog'],['onclick',`set_mask("${name}")`]]},div)
  let a2 = newElement({element:'a',attr:[['onclick',`del_mask("${name}")`],['href','#modal-dialog']]},div)
  let span = newElement({element:'span',cls:['ico-16','mdi','mdi-trash-can-outline']},a2)
  a.innerHTML = name
}


/**
 * It takes an array and removes all the elements in that array that are in arguments[1], arguments[2],
 * etc
 * @param arr - The array you want to remove items from.
 * @returns The array with the value removed.
 */
function removeArr(arr) {
  var what, a = arguments, L = a.length, ax;
  while (L > 1 && arr.length) {
      what = a[--L];
      while ((ax= arr.indexOf(what)) !== -1) {
          arr.splice(ax, 1);
      }
  }
  return arr;
}


/**
 * If the state is active and the driver is ttyACM0, then show the modal-tty_smartCover_ok modal.
 * Otherwise, show the modal-tty_smartCover_off modal and hide the card_A card
 * @param jsn - the JSON object returned from the server
 */
function ttystate_check(jsn) {
  // state, driver
  let ele = document.getElementById("bolt");
  let ele2= document.getElementById('link_bolt')

  if (jsn.state === "active" && jsn.driver === "ttyACM0") {
    ele.classList.remove('mdi-circle-outline')
    ele.classList.add('mdi-link-variant')
    ele.style.color="var(--primary-light)";
    cable = true;
  } else {
    ele.classList.remove('mdi-circle-outline')
    ele.classList.add('mdi-link-variant-off')
    ele2.setAttribute('onclick','UIkit.modal($("#modal-connect-with-bluetooth")).show()')
    ele.style.color="red";
  }
}

/**
 * It opens a modal window and sends a command to the server.
 */
function con_bluetooth() {
  let con = setInterval(function () {
    UIkit.modal($("#modal-connect-bluetooth")).show();
    sattelanalyse.send(`btconnect`);
    console.log('btconnect');
    clearInterval(con);
  }, 100);
}

/**
 * It takes a JSON object and displays it in a modal
 * @param jsn - The JSON object that is returned from the server.
 */
function error_msg (jsn){
  console.log("Error Message: ",jsn);  
  let h2 = document.getElementById('error_h2');
  let ico = document.getElementById('err_icon');
  let txt = document.getElementById('error_p');
  let txt_num = document.getElementById('err_number')

  //h2.innerHTML = `${jsn.class} - ERROR`;
  
  if(jsn.class == 'user'){
    ico.setAttribute('uk-icon','icon: warning; ratio: 1')
  }
  if(jsn.class == 'client'){
    ico.setAttribute('uk-icon','icon: desktop; ratio: 1')
  }
  if(jsn.class == 'internal'){
    ico.setAttribute('uk-icon','icon: server; ratio: 1')
  }
  if(jsn.class == 'fail'){
    ico.setAttribute('uk-icon','icon: warning; ratio: 1')
    txt_num.setAttribute('key','err_bt_fail');
  }

  txt.innerHTML = `MESSAGE: ${jsn.msg} `;
  
  if(jsn.source){
    txt.innerHTML += `SOURCE: ${jsn.source} `
  }
  if(jsn.nr){
    txt.innerHTML += `ERROR-CODE: ${jsn.nr} `
  }
  if(jsn.nr == 3){
    txt_num.setAttribute('key','err_num_3');
  }
  if(jsn.nr == 1){
    txt_num.setAttribute('key','err_num_1');
  }
  translatejs()
  UIkit.modal($("#modal-mod_error")).show();
}
/**
 * It opens a modal window
 */
function sattel_einstellungen() {
  UIkit.modal($("#modal-einstellungen")).show();
}
var img_a1=0;
var img_a2=0;
/**
 * It takes a number as an argument, and then it uses that number to find the progress bar with the
 * same number in its id. Then it uses the value of the progress bar to determine how long it should
 * take to fill the progress bar
 * @param num - The number of the progress bar.
 */
function ProgressTimeHandler(num) {
  const bar = document.getElementById(`js-progressbar_${num}`);
  const aufnahme = setting.aufZeit;// document.getElementById(`aufzeichnung`).value;
  const before = setting.verZeit; // document.getElementById(`time_before`).value;
  let lauf = true;
  if(num===1){
  jsn_result1= new Object();
  if(img_a1>0)
    save_rec(1)
  img_a1++
  }
  if(num===2){
  jsn_result2= new Object();
  if(img_a2>0)
    save_rec(2)
  img_a2++
  }
  
  /* A progress bar that is used to show the user how much time is left until the next recording. */
  var ani = setInterval(()=>{
    if (lauf) {
      const v = 100 / before;
      bar.value += v;
    } else {
      const v = 100 / aufnahme;
      bar.value -= v;
    }

    if (bar.value >= bar.max && lauf) {
      lauf = false;
      sattelanalyse.send(`record ${aufnahme} ${num}`);
    }

    if (bar.value <= 0 && !lauf) clearInterval(ani);
  }, 1000);
}


const canvas1 = new fabric.Canvas("canvas_1");
const canvas2 = new fabric.Canvas("canvas_2");
const canvas3 = new fabric.Canvas("live_img");


createCanvas(canvas1);
createCanvas(canvas2);
createCanvas(canvas3);

img3 = `/sattelbild?rnd=${new Date().getTime()}`;

measure(canvas1);
measure(canvas2);



/**
 * It sends a command to the server to set the background color of the JPEG image
 * @param color - The color to set the background to.
 */
function setBgColor(color) {
  $('#bg_color_txt').val(color);
  // sattelanalyse.send(`set jpeg bgcolor ${color}`);
}

/**
 * It sets the value of the text input field with the id `center_color_txt` to the value of the
 * parameter `color`
 * @param color - The color to set the center of the image to.
 */
function setCenterColor(color) {
  $('#center_color_txt').val(color);
  // sattelanalyse.send(`set jpeg bgcolor ${color}`);
}

/**
 * Create a canvas object with the given parameters, and set the height and width to the values of the
 * global variables cw and ch.
 * @param params - The object that contains the parameters for the canvas.
 */
function createCanvas(params) {
  params.selection = false; // disable group selection
  params.hasControls = false;
  params.lockMovement= false;
  params.setHeight(ch);
  params.setWidth(cw);
}

/**
 * It creates a canvas object and sets the height and width of the canvas to the height and width of
 * the browser window
 * @param params - The object that is passed to the function.
 */
function createHockerCanvas(params) {
  params.selection = false; // disable group selection
  params.hasControls = false;
  params.lockMovement= false;
  params.setHeight(cw);
  params.setWidth(ch);
}

/**
 * It takes a canvas, an image, and a boolean, and then it adds the image to the canvas, and then it
 * draws the text and the grid if the boolean is true
 * @param params - the canvas object
 * @param img - the image to be loaded
 * @param grid - boolean, whether to draw the grid or not
 */
function setImage(params, img, grid) {
  fabric.Image.fromURL(img, function (oImg) {
    oImg.scaleToWidth(cw);
    oImg.hasControls = true;
    oImg.set("selectable", false);
    params.add(oImg);
  });
}

/**
 * It takes in a fabric.js canvas object, an image, a coordinate, a number of centimeters, and a sum of
 * the number of centimeters of all the hockers in the room. If the sum is not zero, it adds the image
 * to the canvas, and then calls three other functions to add text, and two lines to the canvas
 * @param params - the canvas
 * @param img - the image to be drawn
 * @param coord - the coordinates of the hocker
 * @param cm - the number of the hocker
 * @param v_sum - the value of the hocker
 */
function setHockerImage(params,img,coord,cm,v_sum) {
if(v_sum !== 0){
  //  console.log(cm);
   $('#sitzknochenabstand').val(`${cm} cm`)
  fabric.Image.fromURL(img, function (oImg) {
    oImg.scaleToWidth(ch);
    oImg.hasControls = false;
    oImg.set("selectable", false);
    params.add(oImg);
    drawHockertext(params,cm);
    drawHockercop1(params, coord);
    drawHockercop2(params, coord);
  });
}
}


function drawHockerIMG(params,img){
  // console.log(params,img);
  fabric.Image.fromURL(img, function (oImg) {
    oImg.scaleToWidth(ch);
    oImg.hasControls = false;
    oImg.set("selectable", false);
    params.add(oImg);
  })
}

/**
 * It draws a text on the canvas
 * @param c - the canvas object
 */
function drawtext(c,left,top,stext) {
    var text = new fabric.Text(stext, {
      left: left,
      top: top,
      fontSize: 14,
      fontFamily:"Ruda, Helvetica Neue,Helvetica, Arial, sans-serif",
      fill: setting.text_color,
      selectable: false,
      selection: false
    });
    c.add(text);
}

/**
 * It draws a line on the canvas
 * @param c - the canvas object
 * @param left1 - the x coordinate of the first point
 * @param left2 - the x coordinate of the end of the line
 * @param top1 - the top position of the first point
 * @param top2 - the y-coordinate of the end of the line
 */
function drawLine(c,left1,left2,top1,top2) {
  let line = new fabric.Line([left1,top1,left2,top2],{
    stroke:setting.text_color,
    selectable: false,
    selection: false
  })
  c.add(line);
}

/**
 * It takes two arguments, a canvas object and a number, and draws a text on the canvas object
 * @param c - the canvas object
 * @param cm - The height of the hocker in cm.
 */
function drawHockertext(c,cm) {
    var text = new fabric.Text(`${cm} cm`, {
      left: ch/2.3,
      top: cw/1.2,
      fontSize: 40,
      stroke: "rgba(55, 255, 50, 0.9)"
    });
    c.add(text);
}

function drawHockercop1(c,xy) {
  var x1 = xy.x1 * (ch / 28);
  var x2 = cw - xy.y1 * (cw / 16);
  var kreis = new fabric.Circle({
    left: x1 - 10,
    top: x2 - 10,
    radius: 10,
    fill: "rgba(255,255,255,0.7)",
    selectable: false,
    selection: false,
    border: 0
  });
  c.add(kreis);
}

function drawHockercop2(c,xy) {
  var x1 = xy.x2 * (ch / 28);
  var x2 = cw - xy.y2 * (cw / 16);
  var kreis = new fabric.Circle({
    left: x1 - 10,
    top: x2 - 10,
    radius: 10,
    fill: "rgba(255,255,255,0.7)",
    selectable: false,
    selection: false,
    border: 0
  });
  c.add(kreis);
}

/**
 * It draws a line between two points and calculates the length of the line
 * @param canvas - the canvas object
 * @returns A function that takes a canvas as an argument.
 */
function measure(canvas) {
  var line, isDown,text;
  var startx = [];
  var endx = [];
  var starty = [];
  var endy = [];
  var temp = 0;
  // var graphtype;
  var trigger = 1;
  // var text;
  var count = 0;
  var color_a = "red";

//BgColor()
  canvas.on("mouse:dblclick",function(o){
    console.log(canvas);
    BgColor();

  });

  canvas.on("mouse:down", function (o) {
    if (trigger===1) {
      isDown = true;
      var pointer = canvas.getPointer(o.e);

      var points = [pointer.x, pointer.y, pointer.x, pointer.y];
      startx[temp] = pointer.x;
      starty[temp] = pointer.y;
      line = new fabric.Line(points, {
        strokeWidth: 2,
        stroke: color_a,
        originX: "center",
        originY: "center"
      });
      canvas.add(line);
      count++;
    } else {
      canvas.forEachObject(function (o) {
        o.setCoords();
      });
    }
  });

  canvas.on("mouse:move", function (o) {
    canvas.remove(text);
    canvas.renderAll();
    if (!isDown) return;
    var pointer = canvas.getPointer(o.e);
    line.set({
      x2: pointer.x,
      y2: pointer.y
    });

    endx[temp] = pointer.x;
    endy[temp] = pointer.y;

    if (trigger === 1) {
      var px = Calculate.lineLength(
        startx[temp],
        starty[temp],
        endx[temp],
        endy[temp]
      );
      text = new fabric.Text("x" + count + ": " + px + " cm", {
        left: startx[temp],
        top: starty[temp],
        stroke: setting.text_color,
        fontSize: 12,
        fontFamily:"Ruda, Helvetica Neue,Helvetica, Arial, sans-serif"
      });
      // text = new fabric.Text('Length ' + px/5, { left: endx[temp], top: endy[temp], fontSize: 12 });
      canvas.add(text);
    }

    canvas.renderAll();
  });

  canvas.on("mouse:up", function (o) {
    if (trigger===1) {
      var px = Calculate.lineLength(
        startx[temp],
        starty[temp],
        endx[temp],
        endy[temp]
      );
      text = new fabric.Text("x" + count + ": " + px + " cm", {
        left: startx[temp],
        top: starty[temp],
        stroke: setting.text_color,
        fontSize: 12,
        fontFamily:"Ruda, Helvetica Neue,Helvetica, Arial, sans-serif"
      });
      // text1 = new fabric.Text('Length ' + px/5, { left: endx[temp], top: endy[temp], fontSize: 12 });
      canvas.add(text);
    }

    canvas.renderAll();
    var pointer = canvas.getPointer(o.e);
    isDown = false;
  });

  canvas.on("mouse:out",function (e) {
    // e.target.setStroke(color_b);
    if (text) text.setStroke(color_a);
    trigger = 1;

    canvas.renderAll();
  });

  // canvas.on("mouse:wheel", function (opt) {
  //   opt.e.preventDefault();
  //   opt.e.stopPropagation();
  //   if (opt.e.ctrlKey) {
  //     // console.log("pinch");
  //     var delta = opt.e.deltaY;
  //     var zoom = canvas.getZoom();
  //     zoom *= 0.999 ** delta;
  //     canvas.setZoom(zoom);
  //   } else {
  //     var e = opt.e;
  //     // var vpt = this.viewportTransform;
  //     // vpt[4] += e.deltaX;
  //     // vpt[5] += e.deltaY;
  //     this.requestRenderAll();
  //   }
  // });

  var Calculate = {
    lineLength: function (x1, y1, x2, y2) {
      var linePixelsX = x1 - x2;
      var linePixelsY = y1 - y2;
      var gregVar = linePixelsX - linePixelsY;
      // horizontal/vertical components of line in pixels
      var horizontalMPP = ch / 28 / (cw / 16);
      var verticalMPP = ch / 28 / (cw / 16);
      // horizontal/vertical meters per pixel, p being according canvas measurement in pixels and m being the measurement (in meters) of the area it should represent
      var lineMetersX = linePixelsX * horizontalMPP;
      var lineMetersY = linePixelsY * verticalMPP;
      //                      // calculate horizontal/vertical line components in meters
      var lineMetersTotal =
        lineMetersX * lineMetersX + lineMetersY * lineMetersY;
      lineMetersTotal = Math.sqrt(lineMetersTotal).toFixed(2);
      return (lineMetersTotal / (cw / 16)).toPrecision(4);
    },
  };
}

var imageSaver1 = document.getElementById("lnkDownload1");
imageSaver1.addEventListener("click", saveImage_n1, false);
var imageSaver2 = document.getElementById("lnkDownload2");
imageSaver2.addEventListener("click", saveImage_n2, false);


/**
 * `saveImage_n1()` is a function that saves the current canvas as a png file
 */
function saveImage_n1() {
  var timestamp = new Date()
  this.href = canvas1.toDataURL({
    format: "png",
    quality: 100,
    width: cw,
    height: ch,
    crossOriginIsolated: false,
  });
    this.download = `${localStorage.client_name}_${timestamp.toLocaleString()}.png`;
}


/**
 * The function `saveImage_n2()` is called when the user clicks on the download button. It saves the
 * current canvas as a PNG image with the name `Messung_Frame_B.png` in the download folder of the user
 */
function saveImage_n2() {
  var timestamp = new Date()
  this.href = canvas2.toDataURL({
    format: "png",
    quality: 100,
    width: cw,
    height: ch,
    crossorigin: "anonymous",
  });
    this.download = `${localStorage.client_name}_${timestamp.toLocaleString()}.png`;

}


/**
 * It sends a command to the sattelanalyse server to set the grid type for all three JPEG streams
 * @param type - line, dotted, no
 */
function grid_socet(type){
  sattelanalyse.send(`set jpeg 0 grid ${type}`);
  sattelanalyse.send(`set jpeg 1 grid ${type}`);
  sattelanalyse.send(`set jpeg 2 grid ${type}`);
  if(jsn_result1.wsevent){
    let inter = setInterval(function () {
      result_1(jsn_result1)
      clearInterval(inter);
    }, 100);
   }
   if(jsn_result2.wsevent){
    let inter = setInterval(function () {
      result_2(jsn_result2)
      clearInterval(inter);
    }, 100);
   }
}

/**
 * It sends a command to the server to set the color contrast of the JPEG image
 * @param num - 0-7
 */
function set_contrast(num){
  // console.log(`set jpeg colorcontrast ${num}`);
  sattelanalyse.send(`set jpeg colorcontrast ${num}`);
}

/**
 * "When the user clicks on the button, toggle the class 'hide' on the element with the class 'line'."
 *
 * The first line of the function is a variable declaration. The variable is called 'elm' and it's
 * assigned the value of the jQuery selector $(".line"). This means that the variable 'elm' is now a
 * jQuery object that represents the element with the class 'line'
 */
function hide_mask() {
  let elm = $(".line");
  elm.toggleClass("hide");
}

function result1(x, y,z,canvas) {
  // console.log(x,y,z,canvas);
  var x1 = x * (cw / 16);
  var x2 = ch - y * (ch / 28);
  var mult = ch/28
  var points = [z.center_left.x * mult,ch - z.center_left.y * mult , z.center_right.x * mult, ch - z.center_right.y * mult];
  //line
  line = new fabric.Line(points, {
    strokeWidth: 2,
    stroke: setting.line_color,
    originX: "center",
    originY: "center",
    selectable: false,
    selection: false
  });
  if(z.pelvisrotation)
  var c = [
    {
		x: z.pelvisrotation.c1.x*mult, y: ch - z.pelvisrotation.c1.y * mult
	  },
     {
     x:z.pelvisrotation.front.x*mult,y:ch - z.pelvisrotation.front.y*mult
     },
    {
		x: z.pelvisrotation.c2.x*mult, y: ch - z.pelvisrotation.c2.y * mult
	  },
     {
     x:z.pelvisrotation.right.x*mult,y:ch-z.pelvisrotation.right.y*mult
     },
    {
    x: z.pelvisrotation.c3.x*mult, y: ch - z.pelvisrotation.c3.y * mult
	  },
     {
     x:z.pelvisrotation.rear.x*mult,y:ch-z.pelvisrotation.rear.y*mult
     },
    {
    x: z.pelvisrotation.c4.x*mult, y: ch - z.pelvisrotation.c4.y * mult
	  },
     {
     x:z.pelvisrotation.left.x*mult,y:ch-z.pelvisrotation.left.y*mult
     },
    {
      x: z.pelvisrotation.c1.x*mult, y: ch - z.pelvisrotation.c1.y * mult
      },
]
if(z.pelvisrotation)
	var polygon = new fabric.Polygon(c, {
		strokeWidth: 1,
    stroke: setting.pr_color,
    fill:'rgba(0,0,0,0)',
		scaleX: setting.pelv,
		scaleY: setting.pelv,
    selectable: false,
    selection: false
	});
  //center of Presure
  var kreis = new fabric.Circle({
    left: x1 - 10,
    top: x2 - 10,
    radius: 10,
    // fill: setting.center_color,
      fill: 'rgba(255,255,255,0.3)',
      stroke: setting.center_color,
    selectable: false,
    selection: false,
    border: 0
  });
  if(setting.showText){
  let abstand = 0;
  drawtext(canvas,10,10,`${aLangKeys[lang]['sda_leftright']}:`);
  abstand=aLangKeys[lang]['sda_leftright'].length;
  drawtext(canvas,10,30,`${aLangKeys[lang]['sda_frontrear']}:`);
  if(aLangKeys[lang]['sda_frontrear']>abstand)
  abstand=aLangKeys[lang]['sda_frontrear'].length;
  abstand=abstand+120;
  drawtext(canvas,abstand,10,`${z.left_right}`);
  drawtext(canvas,abstand,30,`${z.front_rear}`);
    if(z.pelvisrotation){
    drawtext(canvas,10,50,`${aLangKeys[lang]['sda_rotation']}:`);
    drawtext(canvas,abstand,50,`${z.pelvisrotation.width}:${z.pelvisrotation.height}`);
    }
  }
  canvas.add(kreis);
  canvas.add(line);
  if(z.pelvisrotation)
	canvas.add(polygon);
  if(setting.teil_line){
  drawLine(canvas,cw/2,cw/2,ch/2,ch);
  drawLine(canvas,0,cw,ch/2,ch/2);
  }
  canvas.renderAll();
}


/**
 * The function takes the JSON object returned from the API and displays the results on the page
 * @param jsn - the JSON object returned from the API
 */
function result_1(jsn) {
  // console.log(jsn);
  $("#res1_veloscore")[0].innerHTML = jsn.veloscore||'';
  $("#res1_front_rear")[0].innerHTML = jsn.front_rear||'';
  $("#res1_left_right")[0].innerHTML = jsn.left_right||'';
  $('#product1')[0].value = jsn.product||'';
  $('#product_label1')[0].value =jsn.product_label||'';
  $('#notes1')[0].value = jsn.notes||'';
  if(jsn.pelvisrotation){
  $("#res1_rotation")[0].innerHTML =
  jsn.pelvisrotation.width + ":" + jsn.pelvisrotation.height||'';
  var res1 = setInterval(function () {
    var x = jsn.pelvisrotation.width/jsn.pelvisrotation.height;
    result1(jsn.pelvisrotation.center.x, jsn.pelvisrotation.center.y,jsn,canvas1);
    clearInterval(res1);
  }, 1000);
} else{
  $("#res1_rotation")[0].innerHTML = 'no Data'
  var res1 = setInterval(function () {
    result1(jsn.center.x, jsn.center.y,jsn,canvas1);
    clearInterval(res1);
  }, 1000);
}
}

/**
 * It takes the JSON object returned from the server and displays the results on the page
 * @param jsn - the JSON object returned from the API
 */
function result_2(jsn) {
  // console.log(jsn);
  $("#res2_veloscore")[0].innerHTML = jsn.veloscore;
  $("#res2_front_rear")[0].innerHTML = jsn.front_rear;
  $("#res2_left_right")[0].innerHTML = jsn.left_right;
  $('#product2')[0].value = jsn.product||'';
  $('#product_label2')[0].value =jsn.product_label||'';
  $('#notes2')[0].value = jsn.notes||'';
  if(jsn.pelvisrotation){
  $("#res2_rotation")[0].innerHTML =
  jsn.pelvisrotation.width + ":" + jsn.pelvisrotation.height;
  var res2 = setInterval(function () {
    result1(jsn.pelvisrotation.center.x, jsn.pelvisrotation.center.y,jsn,canvas2);
    clearInterval(res2);
  }, 1000);
} else{
  $("#res2_rotation")[0].innerHTML = 'no Data'
  var res2 = setInterval(function () {
    result1(jsn.center.x, jsn.center.y,jsn,canvas2);
    clearInterval(res2);
  }, 1000);
}
}

/**
 * It reads the values of the three input fields and sends them to the server
 */
function toProtokol() {
  if(localStorage.getItem('session').split(' ')[0]=='restart'){
    sess = localStorage.getItem('session').split(' ')[1]
  }
  if(localStorage.getItem('session').split(' ')[0]=='start'){
     onsqlresult = getSession
     sattelanalyse.send(`sql SELECT next_id from nextids n WHERE table_name = 'sessions'`)
  }
  let info = new Object();
  info.product = $(`#product1`)[0].value;
  info.product_label = $(`#product_label1`)[0].value;
  info.notes = $(`#notes1`)[0].value;
  // console.log(`recording store 1 ${JSON.stringify(info)}`);
  sattelanalyse.send(`recording store 1 ${JSON.stringify(info)}`);
  info.product = $(`#product2`)[0].value;
  info.product_label = $(`#product_label2`)[0].value;
  info.notes = $(`#notes2`)[0].value;
  // console.log(`recording store 2 ${JSON.stringify(info)}`);
  sattelanalyse.send(`recording store 2 ${JSON.stringify(info)}`);
  sattelanalyse.send(`sql UPDATE sessions SET notes='${document.getElementById('note_session').value||""}' WHERE session_id=${sess}`)
  location.pathname = '/production/protokoll.tcls';
}

/**
 * It opens the modal window with the ID "modal-einstellungen" when the button with the ID "config" is
 * clicked
 */
function config() {
  UIkit.modal('#modal-einstellungen').show();
}

/**
 * It takes a parameter, and logs it to the console
 * @param params - {
 */
function getLog(params){
  console.log(params);
}

// function session_img(num) {
//   load_num = num
//   onsqlresult = RowImg
//   session.send(`sql select * from recordings where session_id=${session_id}`)
// }

/**
 * It takes an array of objects, each object has a recording_id property, and it creates a list of
 * images, each image is a thumbnail of the recording_id
 * @param params - an array of objects, each object has a recording_id property
 */
function RowImg(params) {
  fi = 0;
  recID = [];
  onsqlresult = getLog;
  // var live = document.getElementById('live');
  // live.classList.add('hidden')
  var append1 = document.getElementById('img_list')//('img_gal')
  // append1.classList.remove('hidden_imglist')
  append1.classList.add('uk-padding')
  append1.setAttribute('style','width: 92vw')
  append1.innerHTML ="";
  var close = document.createElement('button')
  close.setAttribute('onclick','exitImgList()')
  close.setAttribute('style','height: 3em;width: 3em;right: 2em;')
  close.classList.add('uk-button','close','uk-position-right')
  close.innerHTML = "X"
  append1.append(close)
  params.forEach(element => {
      // console.log(element);
      let res = JSON.parse(element.results)
          if(fi===0){
              // console.log('RowImg send');
              sattelanalyse.send(`recording retrieve ${element.recording_id} 3`)
              fi++
          }
          recID.push(element.recording_id)
          // let a = document.createElement('div')
          // // a.href = '#modal_dialog'
          // a.classList.add('imgGal2','hover')
          // let img = document.createElement('img');
          // img.width=150
          // img.height=100
          // img.classList.add('imgGal1')
          // let velosore = document.createElement('div');
          // velosore.innerHTML = `Veloscore: ${res.veloscore}`
          // a.append(img)
          // a.append(velosore)
          // append1.append(a)
          let master = document.createElement('div');
            master.classList.add('hover','imgGal2');
            master.id = `img_${element.recording_id}`
            // master.setAttribute('onclick','selectImg(this)')
            append1.append(master);

            let div = document.createElement('div');
            div.classList.add('flex-column-center')
            div.setAttribute('style','border:1px solid green;padding:5px; width:200px;margin:0 10px 0 0;');
            master.append(div);

            let date = document.createElement('p');
            date.classList.add('uk-text-center');
            date.innerHTML = element.finished;
            master.append(date)

            let div_name = document.createElement('div');
            div_name.classList.add('name_img');
            div.append(div_name)
            // let a = document.createElement('a')
            // a.href = '#modal_dialog'
            // a.classList.add('imgGal2')

            let img = document.createElement('img');
            img.width=150;
            img.height=100;
            img.classList.add('imgGal1');
            div.append(img);

            let div2 = document.createElement('div')
            div2.setAttribute('style','width: 200px')
            div.append(div2)

            let div_info = document.createElement('div');
            div_info.classList.add('uk-grid','uk-child-width-1-2','info_img');
            div_info.setAttribute('style','margin: 0 -30px;');
            div2.append(div_info);
  });

}

/**
 * The function is called when the user clicks on the "Exit" button. The function removes the "hidden"
 * class from the "live" div and adds the "hidden" class to the "img_list" div
 */
function exitImgList() {
  // var live = document.getElementById('live');
  // live.classList.remove('hidden')
  var append1 = document.getElementById('img_list')//('img_gal')
  append1.setAttribute('style','width: 0')
  append1.classList.remove('uk-padding')
  // append1.classList.add('hidden_imglist')
  // append1.classList.remove('imglist')
}

/**
 * It sends a command to the Sattelanalyse server to show the mask of the JPEG image with the given
 * number
 * @param num - the number of the camera
 */
function showMask (num){
  sattelanalyse.send(`set jpeg ${num} mask show`)
}
/**
 * It sends a command to the Sattelanalyse server to hide the mask of the JPEG image with the given
 * number
 * @param num - the number of the jpeg you want to hide the mask on
 */
function hideMask (num){
  sattelanalyse.send(`set jpeg ${num} mask hide`)
}

$('document').ready(()=>{
    let comp = document.getElementsByClassName('switchery')
      comp[0].setAttribute('style','background-color: var(--primary);border-color: var(--primary);box-shadow: var(--primary) 0px 0px 0px 11px inset;transition: border 0.4s ease 0s, box-shadow 0.4s ease 0s, background-color 1.2s ease 0s;')
});

function showErrormessage() {
    let x = document.getElementById("error_p");
    if (x.style.display === "none") {
        x.style.display = "block";
    } else {
        x.style.display = "none";
    }
} 