#!/bin/bash
#
# velobox_update_3.0.0.sh
# Einspielen aller Dateien in /usr/local/vmkstationd/
# Velometrik-GmbH
#
# Historie:
#   06.03.2023	Peter Bauer   	erstellt
#   12.04.2023	Björn Bauer	Links geändert

if [ `whoami` != "root" ]; then
echo "ERROR"
    echo "The script must be executed by root!"
    exit 1
fi

if [ `awk -F '=' '/VERSION/ {print $2}' /usr/local/etc/velobox.conf` != "2.1.1" ]; then
echo "ERROR"
echo "You need the Update 2.1.1"
exit 1
fi

echo "Paketquellen aktualisieren"
apt-get update --fix-missing
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # Paketquellen konnten nicht aktualisiert werden."
    exit 1
fi
echo "done"

echo "Install sqlite3 tcl8.6-tdbc-sqlite3 tcl8.6-tdbc-postgres"
apt-get install -y sqlite3 tcl8.6-tdbc-sqlite3 tcl8.6-tdbc-postgres
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # apt install sqlite3 tcl8.6-tdbc-sqlite3 tcl8.6-tdbc-postgres"
    exit 1
fi
echo "done"

echo "Remove libx11-.*"
apt-get remove -y --auto-remove --purge libx11-.*
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # apt-get remove --auto-remove --purge libx11-.*"
    exit 1
fi
echo "done"

echo "Remove desktop-base lightdm lxappearance lxde-common lxde-icon-theme lxinput lxpanel lxpolkit lxrandr lxsession-edit lxshortcut lxtask lxterminal obconf openbox raspberrypi-artwork xarchiver xinit xserver-xorg xserver-xorg-video-fbdev"
apt-get remove -y desktop-base lightdm lxappearance lxde-common lxde-icon-theme lxinput lxpanel lxpolkit lxrandr lxsession-edit lxshortcut lxtask lxterminal obconf openbox raspberrypi-artwork xarchiver xinit xserver-xorg xserver-xorg-video-fbdev
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # apt-get remove desktop-base lightdm lxappearance lxde-common lxde-icon-theme lxinput lxpanel lxpolkit lxrandr lxsession-edit lxshortcut lxtask lxterminal obconf openbox raspberrypi-artwork xarchiver xinit xserver-xorg xserver-xorg-video-fbdev"
    exit 1
fi
echo "done"

echo "Remove gnome-themes-standard-data"
apt-get remove -y gnome-themes-standard-data
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # apt-get remove gnome-themes-standard-data"
    exit 1
fi
echo "done"

echo "Remove desktop-file-utils xdg-utils"
apt-get remove -y desktop-file-utils xdg-utils
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # apt-get remove desktop-file-utils xdg-utils"
    exit 1
fi
echo "done"

echo "Purge wolfram-engine"
apt-get purge -y wolfram-engine
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # apt-get purge wolfram-engine"
    exit 1
fi
echo "done"

echo "Remove apache2"
apt-get remove -y apache2
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # apt-get remove apache2"
    exit 1
fi
echo "done"

echo "Autoremove"
apt-get autoremove -y
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # apt-get autoremove"
    exit 1
fi
echo "done"

echo "Autoclean"
apt-get autoclean
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # apt-get autoclean"
    exit 1
fi
echo "done"

echo "Clean"
apt-get clean
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # apt-get clean"
    exit 1
fi
echo "done"

echo "vmkstationd.conf ergänzen"
sed -i 's/# set PORT 80/set PORT 80/g' /usr/local/etc/vmkstationd.conf
sed -i '$aset URL_SMARTCUBE ""' /usr/local/etc/vmkstationd.conf
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # vmkstationd.conf ergänzen"
    exit 1
fi
echo "done"

echo "Files in / will be installed."
if [ ! -r velobox_update_3.0.0.tar.gz ]; then
echo "ERROR"
    echo "velobox_update_3.0.0.tar.gz not found" 
    exit 1
fi
cp velobox_update_3.0.0.tar.gz /
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "Can't copy velobox_update_3.0.0.tar.gz to / ."
    exit 1
fi
cd /
test $? -ne 0 && exit 1
tar xf velobox_update_3.0.0.tar.gz
test $? -ne 0 && exit 1
rm -f velobox_update_3.0.0.tar.gz

echo "Files in / were recorded."

echo "Symbolischer Link löschen"
rm /usr/local/vmkstationd
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # rm /usr/local/vmkstationd"
    exit 1
fi
echo "done"

echo "Symbolischer Link auf den aktuellen Stationsdaemon erstellen"
ln -s /usr/local/vmkstationd3/ /usr/local/vmkstationd
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # ln -s /usr/local/vmkstationd3/ /usr/local/vmkstationd"
    exit 1
fi
echo "done"

echo "Vorhandene Kunden in Datenbank importieren"
/usr/local/vmkstationd3/setup/import_dbldfiles.tcl
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # /usr/local/vmkstationd3/setup/import_dbldfiles.tcl"
    exit 1
fi
echo "done"

reboot now