#!/bin/bash
#
# .../setup/setup.sh
#
# Velometrik GmbH
#
# Installationsskript für vmkstationd
# Dieses Skript ist der Startpunkt für eine Neuinstallation.
#
# Author: Siegmar Müller
# Historie:
#   28.10.2019  Begonnen
#   22.11.2019  Fertiggestellt
#

LOGFILE=/var/local/log/vmksetup.log
if [ -f $LOGFILE ]; then
    echo -e "\n-------------------------------------------------------------------------------" >> $LOGFILE
    N_LOGLINES0=`wc -l $LOGFILE | sed 's/ .*$//'`
else
    # Das Logverzeichnis existiert noch nicht in einem neu aufgesetzten System.
    mkdir -p `dirname $LOGFILE`
    N_LOGLINES0=0
fi
echo "setup.sh `date '+%d.%m.%Y %H:%M:%S'`" | tee -a $LOGFILE
SETUP_DIR=`echo \`realpath $0\` | sed 's?/setup.sh??'`
echo "SETUP_DIR = $SETUP_DIR" | tee -a $LOGFILE
# Debian-Pakete, die für Setup und Servicezwecke benötigt werden.
#TODO apt-get update (Dann aber nicht nochmal bei update.sh)
DEBIAN_PAKETE="dialog anacron tcl8.6"
for DEB_PAKET in $DEBIAN_PAKETE; do
    STATUS=`dpkg-query --showformat '${db:Status-Status}' -W $DEB_PAKET 2>&1`
    if [ $? -ne 0 ]; then
        echo "FEHLER: $STATUS" | tee -a $LOGFILE
        exit 1
    elif [ "$STATUS" == "installed" ]; then
        echo "$DEB_PAKET ist bereits installiert." | tee -a $LOGFILE
    elif [ "$STATUS" == "not-installed" ]; then
        apt-get -y install $DEB_PAKET 2>&1 | tee -a $LOGFILE
        test ${PIPESTATUS[0]} -ne 0 && exit 1
    else
        echo "FEHLER: Unbekannter Status ($STATUS) für Paket $DEB_PAKET." | tee -a $LOGFILE
        exit 1
    fi
done
# Hardwarekonfiguration erstellen
Piepserplatine="-"
Minidisplay="-"
# /usr/local/etc/vmkstationd.conf holen, wenn es das gibt
# (Evtl. ist setup.sh schon einmal gelaufen.)
if [ -f /usr/local/etc/vmkstationd.conf ]; then
	# Hardwarekonfiguration übernehmen
	CONFIG=`tclsh <<-END_OF_TCL
		source /usr/local/etc/vmkstationd.conf
		#puts "[regsub ::config:: \\$var ""]=[set \\$var]"
		foreach {komponente wert} [array get HARDWARE] {
			puts "\\$komponente=\\"\\$wert\\""
		}
	END_OF_TCL`
	for config in $CONFIG; do
		eval $config
	done
	echo -e "Hardwarekonfiguration von /usr/local/etc/vmkstationd.conf übernommen:\n$CONFIG" | tee -a $LOGFILE
fi
# X ist installiert <=> which startx ist erfolgreich
which startx > /dev/null
with_X=$?
while `true`; do #{{{
    if [ $with_X -eq 0 ]; then
    	komponente=`dialog --extra-button --extra-label " Modifizieren " --default-button extra --ok-label "Übernehmen" \
			--menu "Hardwarekonfiguration:" 0 0 2 \
			Minidisplay "$Minidisplay" \
			Piepserplatine "$Piepserplatine" \
			3>&1 1>&2 2>&3`
	else
    	komponente=`dialog --extra-button --extra-label " Modifizieren " --default-button extra --ok-label "Übernehmen" \
			--menu "Hardwarekonfiguration:" 0 0 2 \
			Piepserplatine "$Piepserplatine" \
			3>&1 1>&2 2>&3`
	fi
    case $? in
        0)
            break
            ;;
        1) exit 1
			;;
    esac
    case $komponente in
        Minidisplay) 
            Minidisplay=`dialog --no-cancel --default-item "$Minidisplay" \
			--menu "Minidisplay" 0 0 2 \
			"-" "Kein Minidisplay" \
            RB-TFT-3.5 "" \
			3>&1 1>&2 2>&3`
            ;;
        Piepserplatine)
            Piepserplatine=`dialog --no-cancel --default-item "$Piepserplatine" \
			--menu "Piepserplatine" 0 0 3 \
			"-" "Keine Piepserplatine" \
            V0 "Prototyp" \
            V1 "Version 1" \
			3>&1 1>&2 2>&3`
            ;;
    esac
	#}}}
done
dialog --clear
# Bisheriges Log (nochmal) ausgeben (dialog hat das Lesen verhindert.)
N_LOGLINES=`wc -l $LOGFILE | sed 's/ .*$//'`
N_LOGLINES=`expr $N_LOGLINES - $N_LOGLINES0`
tail -$N_LOGLINES $LOGFILE
echo -e "\n/usr/local/etc/vmkstationd.conf neu anlegen ..." | tee -a $LOGFILE
if [ -f /usr/local/etc/vmkstationd.conf ]; then
	echo "Von setup.sh gerettet `date '+%d.%m.%Y %H:%M:%S':`" >> /usr/local/etc/vmkstationd.conf
	# Die Fehlermeldung landet statt im Logfile im Backup.
	cat /usr/local/etc/vmkstationd.conf >> /usr/local/etc/vmkstationd.conf~ 2>&1 | tee -a $LOGFILE
	test ${PIPESTATUS[0]} -ne 0 && exit 1
	rm /usr/local/etc/vmkstationd.conf 2>&1 | tee -a $LOGFILE
fi
while read LINE; do
	echo $LINE | tee -a /usr/local/etc/vmkstationd.conf | tee -a $LOGFILE
	if `echo $LINE | grep -q '# Hardwarekonfiguration'`; then
			echo "set HARDWARE(Piepserplatine) \"$Piepserplatine\"" | tee -a /usr/local/etc/vmkstationd.conf | tee -a $LOGFILE
		if [ $with_X -eq 0 ]; then
			echo "set HARDWARE(Minidisplay) \"$Minidisplay\"" | tee -a /usr/local/etc/vmkstationd.conf | tee -a $LOGFILE
		else
			echo "set HARDWARE(Minidisplay) \"-\"" | tee -a /usr/local/etc/vmkstationd.conf | tee -a $LOGFILE
		fi
	fi
done < $SETUP_DIR/vmkstationd.conf
echo "... fertig." | tee -a $LOGFILE
echo "" | tee -a $LOGFILE
# Login über USB einrichten
if [ -L /etc/systemd/system/getty.target.wants/serial-getty@ttyUSB0.service ]; then
    echo "Login über USB ist bereits einrichtet." | tee -a $LOGFILE
else
    echo "Login über USB wird eingerichtet ..." | tee -a $LOGFILE
    cp -v /lib/systemd/system/serial-getty@.service /etc/systemd/system/getty.target.wants/serial-getty@ttyUSB0.service 2>&1 | tee -a $LOGFILE
    test ${PIPESTATUS[0]} -ne 0 && exit 1
    systemctl enable serial-getty@ttyUSB0.service 2>&1 | tee -a $LOGFILE
    test ${PIPESTATUS[0]} -ne 0 && exit 1
    echo "... Login über USB ist eingerichtet." | tee -a $LOGFILE
fi
# sshd freigebenen für root-Anmeldung
grep -q '^PermitRootLogin yes' /etc/ssh/sshd_config
if [ $? -eq 0 ]; then
    echo "root login über ssh ist bereits freigegeben." | tee -a $LOGFILE
else
    echo "root login über ssh wird freigegeben ...." | tee -a $LOGFILE
    cp -v /etc/ssh/sshd_config /etc/ssh/sshd_config~ 2>&1 | tee -a $LOGFILE
    test ${PIPESTATUS[0]} -ne 0 && exit 1
    sed '/#PermitRootLogin/a PermitRootLogin yes' /etc/ssh/sshd_config~ > /etc/ssh/sshd_config
    test $? -ne 0 && exit 1
    service sshd restart 2>&1 | tee -a $LOGFILE
    test ${PIPESTATUS[0]} -ne 0 && exit 1
    echo "... root login über ssh ist freigegeben." | tee -a $LOGFILE
fi
# /boot/config.txt Initialisierung Piepserplatine prüfen und wenn nötig vornehmen
grep -q '^gpio=' /boot/config.txt
if [ $? -eq 0 ]; then
    echo "Die gpio-Anschlüsse sind bereits konfiguriert." | tee -a $LOGFILE
else
    cp -v  /boot/config.txt /boot/config.txt~ 2>&1 | tee -a $LOGFILE
	# Das kann nicht eingerückt werden:
sed '/\[pi4\]/ i\
# GPIO fuer Velometrik Piepser initialisieren\
gpio=2-4,14=op,dl\
gpio=15=ip,pu\
' /boot/config.txt~ > /boot/config.txt
    echo "Die gpio-Anschlüsse wurden für die Piepserplatine konfiguriert." | tee -a $LOGFILE

fi
# anacron job für updatecheck einrichten.
cp -v $SETUP_DIR/updatecheck /etc/cron.daily 2>&1 | tee -a $LOGFILE
[ $? -ne 0 ] && exit 1
# Display konfigurieren
if [ $with_X -eq 0 ]; then
    if [ "$Minidisplay" != "-" ]; then
        if [ -x $SETUIP_DIR/setup_${Minidisplay}.sh ]; then
	        $SETUIP_DIR/setup_${Minidisplay}.sh 2>&1 | tee -a $LOGFILE
            test ${PIPESTATUS[0]} -ne 0 && exit 1
        else
            echo "FEHLER: Skript $SETUIP_DIR/setup_${Minidisplay}.sh existiert nicht oder ist nicht ausführbar."
            exit 1
        fi
    fi
fi
# vmkstationd als Service (neu) einrichten.
service vmkstationd.sh status 2>&1 | tee -a $LOGFILE
RC=${PIPESTATUS[0]}
if [ $RC -eq 0 ]; then # Service läuft
	echo "vmkstationd wird gestoppt und neu installiert." | tee -a $LOGFILE
    service vmkstationd.sh stop 2>&1  | tee -a $LOGFILE
    test ${PIPESTATUS[0]} -ne 0 && exit 1
elif [ $RC -eq 3 ]; then # Service existiert, läuft aber nicht
    echo "vmkstationd wird neu installiert." | tee -a $LOGFILE
elif [ $RC -eq 4 ]; then # Service existiert noch nicht
    echo "vmkstationd wird erstmalig installiert." | tee -a $LOGFILE
fi
cp -v $SETUP_DIR/vmkstationd.sh /etc/init.d/ 2>&1  | tee -a $LOGFILE
test ${PIPESTATUS[0]} -ne 0 && exit 1
update-rc.d vmkstationd.sh defaults 2>&1  | tee -a $LOGFILE
test ${PIPESTATUS[0]} -ne 0 && exit 1

. $SETUP_DIR/update.sh

. $SETUP_DIR/activate.sh

echo "setup.sh erfolgreich beendet. Log in $LOGFILE"
