# Bibliotheksmodul für die Datenübernahme vom Hocker

namespace eval ::TTYHocker {
    variable fd_tty ""
    variable lines [list]
    variable i_row
    variable image_handler_procname
    variable MIN_VALUE 0; # Druckwert unterhalb dem alles 0 gesetzt wird

    # Callback für anliegende Daten vom TTY-Treiber
    proc handleTTY {} {; #{{{
        variable fd_tty
        variable lines
        variable i_row
        variable image_handler_procname
        variable MIN_VALUE

	    set n [gets $fd_tty line]
	    if {$n < 0} {; #{{{ Fehler bei der Datenuebernahme => Abbruch
            if {[eof $fd_tty]} {
		    	if {[catch {close $fd_tty} msg]} {
	                # Die Fehlerursache wird bei close zurückgegeben.
			        srvLog $fd_tty Error "$msg"
			    } else {; # Keine Fehlermeldung evtl. aufgrung -blocking 0 (s. proc start)
                    # z.B. Error: echo_off() fehlgeschlagen: errno=25 (Inappropriate ioctl for device)
			        srvLog $fd_tty Notice "Verbindung zum Hocker getrennt ($msg)."
	            }
            }
	        return
	        #}}}
	    }

        if {$n == 0} {; #{{{ Leerzeile vor neuem Block
            incr i_row
            if {$i_row == 28} {; # Erwartete Blockgröße
                set n_rows $i_row
                set n_cols [llength [lindex $lines 0]]
                # Umbau für Druckbildvektor (Druckbild drehen)
                set v_sum 0
                set druckbild [list]
                for {set i_col 0} {$i_col < $n_cols} {incr i_col} {; # von hinten nach vorn
                    for {set i_row 0} {$i_row < $n_rows} {incr i_row} {; # von links nach rechts
                        set v [lindex [lindex $lines $i_row] $i_col]
                        if {$v < $MIN_VALUE} {
                            lappend druckbild 0
                        } else {
                            lappend druckbild $v
                            incr v_sum $v
                        }
                    }
                }
                # Grafikerzeugung anschieben
                # Achtung! Durch die Drehung sind jetzt n_rows und n_cols vertauscht.
                $image_handler_procname $druckbild $n_cols $n_rows $v_sum
            }; # else nicht die erwartete Blockgröße => Block ignorieren
            set i_row -1
            #}}}
        } else {; #{{{ (Weitere) Zeile mit Messwerten
            incr i_row
            if {[llength $lines] >= $i_row} {
                lset lines $i_row [split $line ","]
            } else {
                lappend lines [split $line ","]
            }
            #}}}
        }; # else (Weitere) Zeile mit Messwerten

        #}}}
    }; # proc handleTTY 


    # Start der Datenübernahme vom Hocker
    # @param driver_name     Name des Treibers in /dev
    # @param speed           Baudrate als Integer
    # @param cb_dbld_handler Name der Callback Prozedur für die Übergabe eines Druckbildes
    #                        Argumente: druckbild n_rows n_cols v_sum
    # @return                1 bei Erfolg, 0 bei Fehler
    proc start {driver_name speed cb_dbld_handler} {; #{{{
        variable fd_tty
        variable i_row
        variable image_handler_procname

        if {[catch {
            open "|${::BINDIR}/read_tty -B $speed -n $driver_name" r
            } fd_tty]} {
            srvLog {} Error "$fd_tty"
            set fd_tty ""
            return 0
        }
        # -blocking 0 führt im Fehlerfall dazu, daß bei close kein Fehler ausgelöst wird, auch wenn es einen gab.
        # => Im Zweifel zum Testen auskommentieren.
        fconfigure $fd_tty -blocking 0
        fileevent $fd_tty readable [list [namespace current]::handleTTY]
        set i_row -1
        set image_handler_procname $cb_dbld_handler
        srvLog $fd_tty Notice "Datenübernahme vom Hocker gestartet. (${::BINDIR}/read_tty, PID=[pid $fd_tty])"
        return 1
        #}}}
    }; # proc start 

}; # namespace eval ::TTYHocker 


