# Bibliotheksmodul für die Überwachung der Gerätetreiber /dev/ttyACM...

#TODO Mehrere Callbacks, hinzufügbar und entfernbar

namespace eval watchTTYACM {
    variable fd_watch ""
    # Callbacks für Änderungen (dict)
    # Schlüssel Prozedurname, Wert Treibertyp(en)
    variable cb_driverchanged_procnames [dict create]
    #TODO Erkannte Treiber mit type
    variable drivers [dict create]

    # Callback für anliegende Daten vom watch_ttyACM
    proc handleWatch {} {; #{{{
        variable fd_watch
        variable cb_driverchanged_procnames
        variable drivers

	    set n [gets $fd_watch line]
	    if {$n < 0} {; #{{{ Fehler bei der Datenuebernahme => Abbruch
            if {[eof $fd_watch]} {
		    	if {[catch {close $fd_watch} msg]} {
	                # Die Fehlerursache wird bei close zurückgegeben.
			        srvLog $fd_watch Error "$msg"
			    } else {
			        srvLog $fd_watch Error "Unerwartetes Ende der Treiberüberwachung."
	            }
            }; #TODO else fblocked (s. manpage, auch gets und fconfigure)
            set fd_watch ""
	        return
	        #}}}
	    }
        if {$n > 0} {; #{{{ Meldung empfangen
            srvLog $fd_watch Notice $line
            set items [split $line]
            
            set change [dict create "action" [lindex $items 0] "driver" [lindex $items 1]]
            #TODO {^I: } ist eine Information => Ebenfalls festhalten
            #TODO {^E: } ist eine Fehlermeldung => Ebenfalls festhalten
            switch -regexp [dict get $change "action"] {
                {^\+$} {; # Matte neu angeschlossen
                    # z.B. + ttyACM0 MT_STD B19200
                    dict set change "type" [lindex $items 2]
                    dict set change "speed" [string range [lindex $items 3] 1 end]; # ohne "B"
                    dict set drivers [lindex $items 1] [lindex $items 2]
                } 
                {^\-$} {
                    if {[dict exists $drivers [lindex $items 1]]} {
                        dict set change "type" [dict get $drivers [lindex $items 1]]
                        dict unset drivers [lindex $items 1]
                    } else {; # Zuvor nicht registrierter Treiber entfernt
                        dict set change "type" "unknown"
                        #TODO Doc: Wenn das wichtig ist, muß ein Handler für "unknown" vorhanden sein.
                        #TODO Warnung?
                    }
                }
                default {; # nichts Relevantes
                    srvLog "$fd_watch" {Debug} "=> nichts Relevantes"
                    return
                }
            }
            # Callbacks durchgehen
            dict for {cb_driverchanged_procname type} $cb_driverchanged_procnames {
                # Aufruf der Callbacks für die betroffene oder alle Matten 
                # (glob-Vergleich erforderlich)
                if {[string match "$type" [dict get $change type]] ||  "$type"==""} {
                    srvLog "$fd_watch" {Debug} "Aufruf: $cb_driverchanged_procname $change"
                    $cb_driverchanged_procname $change
                }
            }
            #}}}
        }
        # n == 0 wäre eine Leerzeile und wird ignoriert.
        #}}}
    }; # proc handleWatch


    # Start der Überwachung der geladenen Treiber /dev/ttyACM<n>
    # @param cb_driverchanged   Name der Callback Prozedur für eine Statusänderung
    #                           Argumente: cange, dict mit der Änderung. Schlüssel:
    #                                      action   '+' neu, '-' entfernt
    #                                      driver   Treiber (ttyACM<nn>)
    #                                      type     Mattentyp
    #                                      speed    Baudrate als Integer
    # @return                   1 bei Erfolg, 0 bei Fehler
    proc start {} {; #{{{
        variable fd_watch
        #??? variable cb_driverchanged_procnames 

        #TODO close falls $fd_watch != "" (falls Neustart erlaubt wird)
        if {[catch {
            open "|${::BINDIR}/watch_ttyACM" r
            } fd_watch]} {
            srvLog {} Error "$fd_watch"
            set fd_watch ""
            return 0
        }
        fconfigure $fd_watch -blocking 0
        fileevent $fd_watch readable [list [namespace current]::handleWatch]
        srvLog $fd_watch Notice "Treiberüberwachung /dev/ttyACM... gestartet."
        return 1
        #}}}
    }; # proc start

    # Handlerprozedur eines Clients hinzufügen
    # @param cb_driverchanged   Kompletter Name der Prozedur
    # @param driver_type        Mattentyp(en)
    #                           Evtl. mit '*', '?' als Platzhalter
    proc addDriverchangedHandler {cb_driverchanged {driver_type ""}} {
        variable fd_watch
        variable cb_driverchanged_procnames

        dict set cb_driverchanged_procnames $cb_driverchanged $driver_type
        srvLog $fd_watch Notice "Handler $cb_driverchanged zu Treiberüberwachung /dev/ttyACM... hinzugefügt."
    }

    #TODO proc deleteDriverchangedHandler {cb_driverchanged}

}; # namespace eval watchTTYACM

