/*
 * satteldruckanalyse.js
 * JavaScript Funktionen für satteldruckanalyse.tcls
 *
*/

    var custommask =
    [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1,
     1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
     1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
     1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
     1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
     1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
     1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
     1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
     1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
     1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
     1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
     1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
     1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
     1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
     1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
     1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
     1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
     1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
     1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
     1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
     1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
     1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1,
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];

    var x1questions = new Object({"code":"x1","text":"Client's extension 1","fragen":[{"code":"code11","antworttyp":1,"text":"Client's 1st extension 1 value","vorgaben":null,"antwort":""},{"code":"code12","antworttyp":1,"text":"Client's 1st extension 1 value","vorgaben":null,"antwort":""}]});
    var appquestions = new Array();
    appquestions[0] = x1questions;
    var appsettings = new Object(); //TODO bei wsevent "appsettings" hier speichern
    var clientsettings = new Object();

    clientsettings.recording_time = 6;
    clientsettings.recording_delay = 3;


    function toogleMaskpoint (i, j) {
        var idx = i*16 + j;
        var id = "mval"+idx;

        // console.log ("toogleMaskpoint ("+i+", "+j+")");
        if (custommask[idx] == 0) {
            custommask[idx] = 1;
            document.getElementById(id).innerHTML = "&nbsp;"+1+"&nbsp;"
        } else {
            custommask[idx] = 0;
            document.getElementById(id).innerHTML = "&nbsp;"+0+"&nbsp;"
        }
    } // toogleMaskpoint()


    function sendMask () {
        if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) {
            var cmd = "set mask"
            var maskname = document.getElementById("maskname").value;
            
            if (maskname != "") {
                cmd += " -store "+maskname;
            }
            for (i=0; i<28; ++i) {
                for (j=0; j<16; ++j) {
                    cmd += " ";
                    cmd += custommask[i*16 + j];
                }
            }
            conn.send (cmd);
        } else {
            alert ("Must connect.");
        }
    } // sendMask()


    function createSetClientsettings () {
        clientsettings.recording_time = document.getElementById("recording_time").value;
        clientsettings.recording_delay = document.getElementById("recording_delay").value;
        document.getElementById("message2send").value = "set clientsettings " + JSON.stringify(clientsettings);
    } // createSetClientsettings()


    /*
        custommask neu setzen und anzeigen
    */
    function setMask (values) {
        var i, j;
        var mi;
       
        for (i=0; i<28; ++i) {
            for (j=0; j<16; ++j) {
                mi = 16*i + j;
                custommask[mi] = values[mi];
                document.getElementById('mval'+mi).innerHTML = "&nbsp;"+values[mi]+"&nbsp;"
            }
        }
    } // setMask


    function sattelbildAktualisieren (i_img) {
        // Der Zeitstempel verhindert die Benutzung des letzten Bildes im Cache.
        switch (i_img) {
            case 0:
                document.getElementById("sattelbild").src = "/sattelbild?image=sda_live&rnd="+(new Date).getTime();
                break;
            case 1:
                document.getElementById("integration1").src = "/sattelbild?image=sda_int1&rnd="+(new Date).getTime();
                break;
            case 2:
                document.getElementById("integration2").src = "/sattelbild?image=sda_int2&rnd="+(new Date).getTime();
                break;
        }
    }


    function createStoreCommand(channel) {
        var command = "recording store "+channel;
        var infos = new Object();

        // Texte einbauen
        if (channel == 1) {
            infos.product = document.getElementById("product1").value;
            infos.product_label = document.getElementById("product_label1").value;
            infos.notes = document.getElementById("notes1").value;
        } else if (channel == 2) {
            infos.product = document.getElementById("product2").value;
            infos.product_label = document.getElementById("product_label2").value;
            infos.notes = document.getElementById("notes2").value;
        }
        document.getElementById("message2send").value = command + " " + JSON.stringify(infos);
    }


    function createClientCommand() {
        var command = "session start ";
        var client = new Object();

        client.forename = document.getElementById("forename").value;
        client.surname = document.getElementById("surname").value;
        client.email = document.getElementById("email").value;
        document.getElementById("message2send").value = command + " " + JSON.stringify(client);
    }


    // analyses:    Array der Blockcodes
    function createAnalysisStoreCommand(analyses) {
        var command = "analysis ";
        var object = new Object();
        var block = "";
        var code = "";
        var value = "";

        for (i in appquestions) {
            block = appquestions[i].code;
            if (analyses.indexOf(block) >= 0) {
                for (j in appquestions[i].fragen) {
                    code = appquestions[i].fragen[j].code;
                    value = document.forms.appquestions.elements[code].value;
                    if (object[block] === undefined) {
                        object[block] = new Object()
                    }
                    object[block][code] = value;
                }
            }
        }
        document.getElementById("message2send").value = command + " " + JSON.stringify(object);
    }


    // Behandlung des nächsten sqlresult

    // Simple example for onsqlresult
    function handleSQLResult (rows) {
        document.getElementById("message").innerHTML = "sqlresult: "+rows.length+" rows received (see console)";
        rows.forEach (
            function (row) {
                console.log (row);
            }
        );
    }

    var onsqlresult = handleSQLResult;

    /* Create a session gallery
       (Das geht sicher auch eleganter.)
    */

    var session_recording_ids = new Array();
    var session_recording_results = new Array();
    var last_recording_ix = -1;
    var next_recording_ix = 0;
    var last_recording_id = 0;
    var image_accepted = false;
    var results_accepted = false;

    // Anzeige von Bild und Ergebnissen
    function addRecordingToGallery () {
        var image_id = "integration_" + last_recording_id;

        document.getElementById("gallery").innerHTML += '<IMG id="'+image_id+' " src="/sattelbild?image=sda_int3&rnd='+(new Date).getTime()+'"> '+session_recording_results[last_recording_ix].veloscore;
        image_accepted = false;
        results_accepted = false;
    }


    function acceptRecordingImage () {
        image_accepted = true;
        if (results_accepted) {
            addRecordingToGallery()
        }
        retrieveNextRecording();
    }


    function acceptRecordingResults (msg) {
        // msg festhalten für die Anzeige
        if (last_recording_id == 0) {
            // => Ursprung ist ein eingegebenes Kommando.
            session_recording_results.length = 0;
            session_recording_results.push(msg);
            last_recording_ix = 0;
        } else {
            // => Ursprung ist createSessionGallery().
            session_recording_results.push(msg);
        }
        results_accepted = true;
        if (image_accepted) {
            addRecordingToGallery()
        }
    }


    function retrieveNextRecording () {
        if (next_recording_ix >= session_recording_ids.length) {
            console.log ("No more recordings.");
            location.href = "#vergleichsgalerie";
            onsqlresult = handleSQLResult;
            last_recording_id = 0;
            return;
        }
        last_recording_id = session_recording_ids[next_recording_ix];
        last_recording_ix = next_recording_ix;
        if (document.getElementById("session_compare_mode").checked) {
            conn.send ("recording retrieve " + last_recording_id);
        } else {
            conn.send ("recording retrieve " + last_recording_id + " 3");
        }
        ++next_recording_ix;
    }


    function acceptRecordingIds (rows) {
        onsqlresult = null;
        session_recording_ids = new Array();
        session_recording_results = new Array();
        for (let row of rows) {
            session_recording_ids.push (row.recording_id); 
        }
        next_recording_ix = 0; 
        last_recording_ix = -1; 
        console.log (next_recording_ix+" recordings accepted.");
        document.getElementById("gallery").innerHTML = "";
        image_accepted = false;
        results_accepted = false;
        retrieveNextRecording();
    }


    function createSessionGallery() {
        var session_id = parseInt(document.getElementById("session_id").value);

        if (typeof conn != "object" || conn.readyState != WebSocket.OPEN) {
            alert ("Must connect.");
            return;
        }
        if (isNaN(session_id)) {
            alert ("session_id must be an integer.");
            return;
        }
        onsqlresult = acceptRecordingIds;
        conn.send ("sql SELECT recording_id FROM recordings WHERE analysis=2 AND session_id="+session_id+" ORDER BY finished");
    }

    /*End: Create a session gallery */


    function handleWSMessage (wsmessage) {//{{{
        var msg;

        try {
             msg = JSON.parse (wsmessage);
        } catch (error) {
            console.log ("Kein gültiger JSON-String: \"" + wsmessage + "\"");
            return;
        }
        //TODO Gibt es msg.wsevent ? Nein => error?
        // msg.wsevent == undefined
        // msg.error => class: ???
        if (msg.wsevent == "sda_live") {
	        sattelbildAktualisieren(0);
        } else if (msg.wsevent == "sda_int1") {
	        sattelbildAktualisieren(1);
        } else if (msg.wsevent == "sda_int2") {
	        sattelbildAktualisieren(2);
        } else if (msg.wsevent == "sda_int3") {
            acceptRecordingImage();
        } else if (msg.wsevent == "max_value") {
	        document.getElementById("max_value").innerHTML = "Max.:"+msg.value+"%";
        } else if (msg.wsevent == "ttystate") {
	        document.getElementById("message").innerHTML = wsmessage.replace(/</g,"&lt;").replace(/>/g,"&gt;");
            if (msg.state == "active") {
	            document.getElementById("usb_state").color = "green";
            } else {
	            document.getElementById("usb_state").color = "grey";
            }
        } else if (msg.wsevent == "ttychange") {
	        document.getElementById("message").innerHTML = wsmessage.replace(/</g,"&lt;").replace(/>/g,"&gt;");
            if (msg.change == "plugged") {
	            document.getElementById("usb_state").color = "green";
            } else {
	            document.getElementById("usb_state").color = "grey";
            }
        } else if (msg.wsevent == "btevent") {
	        document.getElementById("message").innerHTML = wsmessage.replace(/</g,"&lt;").replace(/>/g,"&gt;");
            if (msg.btevent == "data") {
	            document.getElementById("usb_state").color = "grey";
	            document.getElementById("bt_state").color = "green";
            } else {
                if (msg.btevent == "disconnected") {// reguläres Verbindungsende
                    // Hier nichts weiter zu tun.
                } else if (msg.btevent == "ambiguity") {// Mehdeutigkeit
                    alert_text = "Multiple devices found:";
                    command = "btconnect"
                    for (i in msg.devices) { 
                        alert_text += "\n";
                        alert_text += msg.devices[i];
                        command += " ";
                        command += msg.devices[i];
                    }
                    alert (alert_text);
                    document.getElementById("message2send").value = command;
                } else if (msg.btevent == "error") {// Verbindungsfehler
                    if (msg.class == "fail") {// Das Herstellen der Verbindung ist gescheitert.
                        alert ("Could not establish Bluetooth connection:\n"+msg.msg);
                    } else {// Anderer Verbindungsfehler
                        alert ("Bluetooth connection error:\n"+msg.msg);
                    }
                }
	            document.getElementById("bt_state").color = "grey";
	            // Ob USB verfügbar ist kann hier nicht bestimmt werden.
                // Die App sendet nach dem Bluetooth-Verbindungsende eine diesbezügliche Statusmeldung. (ttystate)
            }
        } else if (msg.wsevent == "result1") {
	        document.getElementById("message").innerHTML = wsmessage.replace(/</g,"&lt;").replace(/>/g,"&gt;");
            if (msg.product !== undefined) {
                document.getElementById("product1").value = msg.product;
            }
            if (msg.product_label !== undefined) {
                document.getElementById("product_label1").value = msg.product_label;
            }
            if (msg.notes !== undefined) {
                document.getElementById("notes1").value = msg.notes;
            }
        } else if (msg.wsevent == "result2") {
	        document.getElementById("message").innerHTML = wsmessage.replace(/</g,"&lt;").replace(/>/g,"&gt;");
            if (msg.product !== undefined) {
                document.getElementById("product2").value = msg.product;
            }
            if (msg.product_label !== undefined) {
                document.getElementById("product_label2").value = msg.product_label;
            }
            if (msg.notes !== undefined) {
                document.getElementById("notes2").value = msg.notes;
            }
        } else if (msg.wsevent == "result3") {
            acceptRecordingResults (msg);
        } else if (msg.wsevent == "sqlresult") {
            if (onsqlresult !== null) {
                onsqlresult (msg.rows); 
            }
        } else if (msg.wsevent == "mask") {
            setMask (msg.values);
        } else if (msg.wsevent == "appquestions") {
            appquestions = msg.appquestions;
            appquestions.push(x1questions);
            // in div "appquestions" anzeigen
            var html = "";
            html += "<TABLE>";
            var codes = new Array();
            for (i in appquestions) {
                html += "<TR><TH>"+appquestions[i].text+"("+appquestions[i].code+")</TH></TR>";
                for (j in appquestions[i].fragen) {
                    html += "<TR><TD>"+appquestions[i].fragen[j].text+"("+appquestions[i].fragen[j].code+")</TD>";
                    html += "<TD><INPUT name=\""+appquestions[i].fragen[j].code+"\" size=20 value=\"\"></TD>"
                    //TODO Typ berücksichtigen
                    // Extrawurst bei asymmetrie
                    html += "</TR>";
                }
                var code = appquestions[i].code;
                codes.push (code);
                html += "<TR><TD colspan=2><INPUT type=\"button\" onclick=\"createAnalysisStoreCommand(['"+code+"'])\" value=\"createAnalysisStoreCommand(['"+code+"'])\"/><BR/></TD></TR>"
            }
            html += "</TABLE>";
            html += "<INPUT type=\"button\" onclick=\"createAnalysisStoreCommand(['"+codes.join("','")+"'])\" value=\"createAnalysisStoreCommand(['"+codes.join("','")+"'])\"/><BR/>";
            html += "<SMALL>('x1' added by client test application.)</SMALL><BR/>";
	        document.getElementById("appquestions").innerHTML = html;
	        document.getElementById("message").innerHTML = "''appquestions' stored in corresponding global variable.";
            location.href = "#appquestions";
            console.log ("Inspect variable 'appquestions'!");
        } else {
	        document.getElementById("message").innerHTML = wsmessage.replace(/</g,"&lt;").replace(/>/g,"&gt;");
        }
        //TODO clientsettings übernehmen
        //}}}
    } // handleWSMessage()

    var conn;

    function connect () {//{{{
	    if (window["WebSocket"]) {// Der Browser kennt WebSocket.
            if (typeof conn == "object") {
                if (conn.readyState == WebSocket.OPEN)
                    conn.close();
            }
	        // Verbindung herstellen
	        try {
	            // Der Server erwartet wenigstens ein (Sub)Protokoll, auch wenn das nicht benutzt wird.
	            conn = new WebSocket(document.getElementById("ws_url").value, "dummy");
	        } catch (error) {
	            //??? nur SECURITY_ERROR
	            document.getElementById("statusinfo").innerHTML = "Wenn das 'mal kein Fehler ist.";
	        }
	        switch (conn.readyState) {
	            case WebSocket.CONNECTING: // Die Verbindung ist noch nicht hergestellt.
	                document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung wird hergestellt.";
	                conn.onopen = function (evt) {
	                    document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung ist hergestellt.";
	                    conn.onclose = function (evt) {
	                        document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung wurde geschlossen.";
	                        document.getElementById("message").innerHTML = "";
                            // Weder USB noch BT Verbindung
	                        document.getElementById("usb_state").color = "grey";
	                        document.getElementById("bt_state").color = "grey";
	                    };
	                };
	                conn.onclose = function (evt) {
	                    document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung konnte nicht hergestellt werden.";
	                };
	                break;
	            case WebSocket.OPEN:       // Verbindung ist hergestellt und bereit darüber zu kommunizieren.
	                document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung ist hergestellt.";
	                break;
	            case WebSocket.CLOSING:    // Verbindung ist im Prozess des Schließens.
	            case WebSocket.CLOSED:     // Die Verbindung konnte nicht hergestellt werden.
	                document.getElementById("statusinfo").innerHTML = "WebSocket-Verbindung konnte nicht hergestellt werden.";
	                break;
	        }
	        // Eingetroffene Meldung vom Server bearbeiten
	        conn.onmessage = function (evt) {
                handleWSMessage (evt.data);
	        };
	    } else {
	        document.getElementById("statusinfo").innerHTML = "WebSocket ist in diesem Browser nicht verfügbar";
	    }
        //}}}
    } // connect()

    function disconnect () {
        if (typeof conn == "object") {
            if (conn.readyState == WebSocket.OPEN) {
                conn.close();
	            document.getElementById("usb_state").color = "grey";
	            document.getElementById("bt_state").color = "grey";
            }
        }
    }

    function clearMessage () {
        document.getElementById("message2send").value = "";
    }

    function sendMessage () {
        if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) {
	        document.getElementById("message").innerHTML = "";
            conn.send (document.getElementById("message2send").value);
        } else {
            alert ("Must connect.");
        }
    } // sendMessage()

    /*{{{ nicht mehr benötigt
    //TODO retrieveXY() ist überflüssig, weil das auch als Kommando eingegeben werden kann.
    // Wenn es hier entfernt wird, dann vorher in der HTML-Datei entfernen.

    function retrieveRecording () {
        var db_id;
        var left_right;
        var command;

        db_id = document.getElementById("db_id").value;
        left_right = document.getElementById("left_right").value;
        command = "retrieve recording "+db_id+" "+left_right;
        console.log (command);
        // ws-Kommando schicken
        document.getElementById("message2send").value = command;
        sendMessage ();
    }

    function retrieveSession () {
        var db_id;
        var left_right;
        var command;

        db_id = document.getElementById("db_id").value;
        command = "retrieve session "+db_id;
        console.log (command);
        // ws-Kommando schicken
        document.getElementById("message2send").value = command;
        sendMessage ();
    }
    }}}*/

