/*
 * Copyright (C) 2022 Velometrik GmbH
 * <http://www.velometrik.de/>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: 
 * support@velometrik.de
 * 
 * System
 *    
 ******************************************************************************************************/

/**
 * It loops through all elements with the class "tr" and replaces the text with the value of the key
 * attribute in the aLangKeys array
 */
// function translatejs() {
//     // var lang = getCookie("langSelected");
//     $('.tr').each(function(i) {
//         $(this).text(aLangKeys[lang][$(this).attr('key')]);
//     });
// }

/**
 * It sends a request to the server to change the language file
 */
function setLanguagefile() {
    var systemsprache = document.getElementById("systemsprache").value;

    var url = "/production/setlanguagefile.tcls?systemsprache=" + systemsprache;

    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_system_hilfe\"><!--Einstellungen übernehmen und rebooten--></span></p>";

    /* Sending a request to the server. */
    httpSetconfig.open("GET", url, true);
    httpSetconfig.send();

    translatejs();
}

/**
 * It sends a request to the server to set the keyboard layout
 */
function setKeyboardfile() {
    var keyboardlayout = document.getElementById("keyboardlayout").value;

    var url = "/production/setkeyboardfile.tcls?keyboardlayout=" + keyboardlayout;

    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_system_hilfe\"><!--Einstellungen übernehmen und rebooten--></span></p>";

    /* Sending a request to the server. */
    httpSetconfig.open("GET", url, true);
    httpSetconfig.send();

    translatejs();
}

/**
 * It sends a request to the server to set the configuration file
 */
function setConfigfile() {

    var stationsnummer = document.getElementById("stationsnummer").value;
    // Sonderzeichen umwandeln
    var farbe = encodeURIComponent(document.getElementById("farbe").value);
    var empfindlichkeit = document.getElementById("empfindlichkeit").value;
    var webservice = document.getElementById("webservice").value;
    var url_smartcube = document.getElementById("url_smartcube").value;

    var url = "/production/setconfigfile.tcls?stationsnummer=" + stationsnummer + "&farbe=" + farbe + "&empfindlichkeit=" + empfindlichkeit + "&webservice=" + webservice + "&url_smartcube=" + url_smartcube;

    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_system_hilfe\"><!--Einstellungen übernehmen und rebooten--></span></p>";

    /* Sending a request to the server. */
    httpSetconfig.open("GET", url, true);
    httpSetconfig.send();

    translatejs();
}

/**
 * It sends a request to the server to download the update file
 */
function downloadFile() {
    gears_on()
    var updatefile = document.getElementById("updatefile").value;

    /* Checking if the updatefile is empty. If it is empty, it will change the border and background
    color of the input field. */
    if (!updatefile) {
        document.getElementById("updatefile").style.border = "1px solid red";
        document.getElementById("updatefile").style.background = "#ffd6d6";
        document.getElementById("updatefile").setAttribute("placeholder", "e.g. vlbupdate-XXX.tar.gz");
    } else {

        var url = "vlbupdate.tcls?updatefile=" + updatefile;

        var oReq = new XMLHttpRequest();

        oReq.addEventListener("progress", updateProgress);
        oReq.addEventListener("load", transferComplete);
        oReq.addEventListener("error", transferFailed);
        oReq.addEventListener("abort", transferCanceled);

        oReq.open("GET", url, true);
        oReq.send();

        /* Setting the value of the element with the id `updatemassage` to the value of the response. */
        oReq.onload = function(e) {
            console.log(oReq);
            var arraybuffer = oReq.response; // not responseText
            if (arraybuffer.includes("Error: 500")) {
                document.getElementById("updatemassage").value = "UPDATE FEHLGESCHLAGEN"
            } else {
                document.getElementById('updatemassage').value = arraybuffer
            }
            setTimeout(function() {
                gears_off()
            }, 500);
        }

        // progress on transfers from the server to the client (downloads)
        /**
         * The function is called when the progress event is fired. The progress event is fired
         * periodically when the data is being transferred. The event object contains the total number
         * of bytes that will be transferred (total) and the number of bytes transferred so far
         * (loaded)
         * @param oEvent - The event object.
         */
        function updateProgress(oEvent) {
            if (oEvent.lengthComputable) {
                var percentComplete = oEvent.loaded / oEvent.total * 100;
                console.log(percentComplete);
                document.getElementById('updatemassage').value += "Einen Moment bitte " + percentComplete;
            } else {
                // Unable to compute progress information since the total size is unknown
            }
        }

        /**
         * The function transferComplete() is called when the transfer is complete
         * @param evt - The event object.
         */
        function transferComplete(evt) {
            console.log("The transfer is complete.", evt);
        }

        /**
         * If the file transfer fails, the user will be notified
         * @param evt - The event object.
         */
        function transferFailed(evt) {
            console.log("An error occurred while transferring the file.", evt);
        }

        /**
         * The transfer has been canceled by the user.
         * @param evt - The event object.
         */
        function transferCanceled(evt) {
            console.log("The transfer has been canceled by the user.", evt);
        }

        /**
         * The function updateProgress() is called when the upload is in progress
         * @param evt - The event object.
         */
        function updateProgress(evt) {
            console.log('updateProgress', evt);
            document.getElementById('updatemassage').value = "Einen Moment bitte"
        }
        // document.getElementById("message").innerHTML = "";

        // /* Sending a request to the server. */
        // httpSetconfig.open("GET", url, true);
        // httpSetconfig.send();

        translatejs();

    }
}

/**
 * "When the user clicks on the gear icon, show the gear modal."
 * 
 * The `console.log` statement is a debugging tool. It's a way to print out a message to the browser's
 * console
 */
function gears_on() {
    console.log('show gear');
    $('#gear').modal('show');
}

/**
 * "When the user clicks the gear icon, hide the gear modal."
 * 
 * The first line of the function is a console.log statement. This is a debugging tool that will print
 * the text "hide gear" to the console
 */
function gears_off() {
    console.log('hide gear');
    $('#gear').modal('hide');
}
/**
 * It shows a modal dialog with a message
 */
function setReboot() {

    // Request starten
    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_rebootvelobox\"><!--Reboot Velobox--></span></p>";

    translatejs();

    $("#reboot").modal('show');
}

if(localStorage.getItem('right_col')){
    for (let name of document.getElementsByClassName('back')) {
        if(name.childNodes[1].classList.value === localStorage.getItem('right_col')){
            name.classList.remove('mdi-checkbox-blank-circle-outline');
            name.classList.add('mdi-checkbox-marked-circle-outline');
        } else{
            name.classList.remove('mdi-checkbox-marked-circle-outline');
            name.classList.add('mdi-checkbox-blank-circle-outline');
        }
    }
} 
function selectBack(params) {
    localStorage.setItem('right_col',params.childNodes[1].classList.value)
    let b = document.getElementsByClassName('right_col')[0]
    b.removeAttribute('class');
    b.classList.add(params.childNodes[1].classList.value,'right_col');

    for (let n of document.getElementsByClassName('back')) {
        if(n.childNodes[1].classList.value === localStorage.getItem('right_col')){
            n.classList.remove('mdi-checkbox-blank-circle-outline');
            n.classList.add('mdi-checkbox-marked-circle-outline');
        } else{
            n.classList.remove('mdi-checkbox-marked-circle-outline');
            n.classList.add('mdi-checkbox-blank-circle-outline');
        }
    }

}