/*
 * Copyright (C) 2022 Peter Bauer / Velometrik GmbH
 * <http://www.velometrik.de/>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * `fs()` is the function that is called when the page is loaded. It calls `localstart()` which sets up
 * the local storage, `translatejs()` which translates the page, and `drawCanvas()` which draws the
 * canvas
 */
 function fs() {
//   localstart();
}

/**
* If the checkbox is checked, set the localStorage item "ReadFirstStart" to true, otherwise set it to
* false
*/
function setFirstStart() {
  const firststart = document.getElementById("chb_firststart");
  if (firststart.checked) {
      localStorage.setItem("ReadFirstStart", true);
  } else {
      localStorage.setItem("ReadFirstStart", false);
  }
}



/**
* It checks the local storage for the value of the key 'viewmode'. If the value is 'basic', it adds
* the class 'basicview' to all elements with the class 'adba'. If the value is 'advanced', it removes
* the class 'basicview' from all elements with the class 'adba'
* @param {string} mode - This is the view mode you want to switch to.
*/
function ToggleViewMode(mode) {
  localStorage.setItem("viewmode", mode);

  if (localStorage.getItem("viewmode") === "basic") {
    //   document.getElementById("ModeBasic").classList.add("link_focus");
    //   document.getElementById("ModeAdvanced").classList.remove("link_focus");
      for (
          let index = 0; index < document.getElementsByClassName("adba").length; index++
      ) {
          const element = document.getElementsByClassName("adba")[index];
          element.classList.add("basicview");
      }
  } else if (localStorage.getItem("viewmode") === "advanced") {
    //   document.getElementById("ModeBasic").classList.remove("link_focus");
    //   document.getElementById("ModeAdvanced").classList.add("link_focus");
      for (
          let index = 0; index < document.getElementsByClassName("adba").length; index++
      ) {
          const element = document.getElementsByClassName("adba")[index];
          element.classList.remove("basicview");
      }
  }
}



/**
* If the localStorage item "ReadFirstSatteldruckanalyse" is false, then show the modal with the id
* "firstsatteldruckanalyse".
*/
// function FirstSatteldruckanalyse() {
//   if (localStorage.getItem("ReadFirstSatteldruckanalyse") === "false") {
//     if (document.getElementById("firstsatteldruckanalyse")) {
//     $("#firstsatteldruckanalyse").modal("show");
//     }
//   }
// }

/**
* If the checkbox is checked, the value of the localStorage item "ReadFirstSatteldruckanalyse" is set
* to true. If the checkbox is not checked, the value of the localStorage item
* "ReadFirstSatteldruckanalyse" is set to false
*/
function setFirstSatteldruckanalyse() {
  const firstSatteldruckanalyse = document.getElementById(
      "chb_firstSatteldruckanalyse"
  );
  if (firstSatteldruckanalyse.checked) {
      localStorage.setItem("ReadFirstSatteldruckanalyse", true);
  } else {
      localStorage.setItem("ReadFirstSatteldruckanalyse", false);
  }
}

// function drawCanvas()
// {
//   var c = document.getElementById("mask")
//   var canvas = new fabric.Canvas("mask");

//   var xy = $(".canvasFrameA");

//    var cA = new fabric.Canvas("CanvasAnalyse_A");
//    cA.setHeight(xy[0].clientHeight);
//    cA.setWidth(xy[0].clientWidth);

//    var cB = new fabric.Canvas("CanvasAnalyse_B");
//    cB.setHeight(xy[0].clientHeight);
//    cB.setWidth(xy[0].clientWidth);

//   var text = new fabric.Text('live', {
//     left: 100,
//     top: 100,
//     shadow: 'rgba(0,0,0,0.3) 5px 5px 5px',
//     stroke: 'red',
//     selectable: false
//   });
//   // var imgElement = document.getElementById('live');
//   // var imgInstance = new fabric.Image(imgElement, {
//   //   left: 0,
//   //   top: 0,
//   //   angle: 0,
//   //   opacity: 0.85
//   // });
//   // canvas.add(imgInstance);
//   var filter = new fabric.Image.filters.Blur({
//     blur: 0.1
//   });


//   fabric.Image.fromURL('/img/presure.jpeg', (oImg) => {
//     // oImg.left = 50;
//     // console.log(oImg);
//     oImg.scaleToWidth(c.width/1.5);
//     oImg.hasControls=false;
//     oImg.filters.push(filter);
//     oImg.applyFilters();
//     canvas.add(oImg);
//     canvas.add(text);
//   canvas.renderAll();
//   });

//   fabric.Image.fromURL('/img/presure.jpeg', (oImgA) => {
//     // oImgA.left=xy[0].clientWidth / 5.5;
//     oImgA.scaleToHeight(xy[0].clientHeight);

//     cA.setHeight(oImgA.height);
//     cA.setWidth(oImgA.width);
//     oImgA.left = 20;
//     cA.add(oImgA);
//   });
//   fabric.Image.fromURL('/img/presure.jpeg', (oImgB) => {

//     oImgB.scaleToHeight(xy[0].clientHeight);

//     cB.setHeight(oImgB.height);
//     cB.setWidth(oImgB.width);
//     oImgB.left = 20;
//     cB.add(oImgB);
//   });
// }

function myTimer() {

  const width = document.querySelector("#Analyse_B").clientWidth;
  const height = (document.querySelector("#Analyse_B").clientWidth * 1.75);
  const m = dm();
  const points = [];
  let max = 0;


  for (let i = 0; i < m.length; i++) {
      const ex = m[i];
      for (let j = 0; j < ex.length; j++) {
          const ey = ex[j];
          // console.log(i);
          if (max < ey)
              max = ey
          const point = {
              x: Math.floor(j * width / ex.length),
              y: Math.floor(i * height / m.length),
              value: ey
          };
          points.push(point);
          // console.log(point);
      }
  }
  // heatmap data format

  const data = {
      max: max,
      data: points
  };

  // if you have a set of datapoints always use setData instead of addData
  // for data initialization
  heatmapInstance.removeData();
  heatmapInstance.setData(data);
  // console.log(heatmapInstance.getData());
}
// clientHeight: 661
// clientLeft: 0
// clientTop: 0
// clientWidth: 610
function dm() {
  var m = []

  for (let i = 0; i < 28; i++) {
      m[i] = []
      const e1 = m[i];
      for (let j = 0; j < 16; j++) {
          if (j % 2 == 1 && i % 2 == 1) {
              m[i][j] = Math.floor(Math.random() * 2500)
          } else {
              m[i][j] = -1
          }
      }
  }

  return m
}

var kuenzel1 = [
  [0, 0, 0, 1143, 2750, 3912, 5380, 4882, 6031, 4767, 3465, 2572, 922, 0, 0, 0, ],
  [0, 0, 0, 1308, 3126, 4050, 5144, 3910, 4421, 4649, 3971, 3047, 1231, 0, 0, 0],
  [0, 0, 57, 1573, 3239, 3917, 4739, 3065, 3535, 4317, 3889, 3282, 1297, 0, 0, 0],
  [0, 0, 321, 1804, 3319, 3723, 4163, 2648, 3108, 4137, 4188, 3576, 1693, 329, 0, 0],
  [0, 0, 440, 2088, 3442, 3340, 3562, 2068, 2435, 3560, 3784, 3673, 1775, 320, 0, 0],
  [0, 0, 532, 2643, 3321, 2915, 2590, 1544, 1957, 2968, 3765, 3937, 2489, 437, 0, 0],
  [0, 0, 1002, 3285, 3428, 2244, 1786, 892, 1198, 2136, 3287, 4269, 3700, 708, 0, 0],
  [0, 0, 1866, 3875, 3054, 1663, 1034, 533, 759, 1533, 2846, 4667, 4486, 1389, 0, 0],
  [0, 693, 3002, 4364, 2822, 1172, 642, 67, 349, 860, 1902, 3508, 4798, 1310, 0, 0, ],
  [0, 894, 3519, 4258, 2103, 929, 361, 0, 0, 453, 1360, 3262, 4164, 1854, 352, 0, ],
  [0, 1016, 3516, 3445, 1690, 567, 0, 0, 0, 13, 868, 1802, 2983, 1132, 241, 0, ],
  [0, 1335, 3086, 2480, 970, 159, 0, 0, 0, 0, 342, 715, 1005, 581, 23, 0, ],
  [0, 2345, 2350, 1497, 449, 0, 0, 0, 0, 0, 0, 0, 54, 23, 0, 0, ],
  [0, 2772, 1876, 431, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 1491, 0, ],
  [0, 3132, 1245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1706, 2530, 1870, ],
  [0, 2250, 951, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1572, 4887, 1659, ],
  [0, 1062, 365, 0, 0, 0, 0, 0, 0, 0, 0, 0, 495, 2997, 4459, 3345, ],
  [1502, 429, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 239, 932, 2547, 860, ],
  [2143, 1118, 180, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 236, 0, 0, ],
  [2143, 537, 0, 0, 0, 519, 0, 0, 0, 0, 678, 0, 0, 328, 0, 0, ],
  [612, 0, 412, 0, 799, 2206, 610, 0, 0, 2311, 1442, 710, 348, 912, 361, 0, ],
  [1961, 517, 742, 485, 2013, 3980, 1732, 363, 1657, 2529, 3265, 673, 633, 1348, 593, 0, ],
  [2028, 1669, 877, 566, 1827, 3338, 1537, 95, 243, 1947, 1103, 335, 449, 974, 432, 0, ],
  [2200, 355, 458, 0, 0, 1428, 0, 0, 0, 0, 318, 0, 0, 386, 0, 0, ],
  [232, 475, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ],
  [40, 447, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ],
  [0, 425, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ],
  [0, 546, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ],
];
var kuenzel2 = [
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, 3645, 3612, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, 3842, 3362, 3769, 3917, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, 4719, 2964, 3497, 4433, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, 4494, 2340, 2887, 4655, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, 3978, 1556, 2177, 4286, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, 2638, 3927, 3102, 1058, 1524, 3889, 4128, 2274, -1, -1, -1, -1],
  [-1, -1, -1, -1, 2757, 3253, 2426, 664, 972, 3211, 4279, 3292, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, 3150, 2785, 1590, 422, 555, 2373, 4235, 4270, -1, -1, -1, -1, ],
  [-1, -1, -1, 3263, 3299, 2184, 870, 0, 223, 1402, 3272, 4928, 4328, -1, -1, -1, ],
  [-1, -1, -1, 4110, 3228, 1623, 291, 0, 0, 722, 2267, 4779, 5587, -1, -1, -1, ],
  [-1, -1, -1, 4831, 3374, 1343, 211, 0, 0, 440, 1678, 3785, 5506, -1, -1, -1, ],
  [-1, -1, 4454, 3528, 1996, 888, 0, 0, 0, 302, 1210, 2914, 4696, 4786, -1, -1, ],
  [-1, -1, 4115, 2997, 1617, 713, 0, 0, 0, 61, 853, 1952, 3605, 4572, -1, -1, ],
  [-1, 3311, 3169, 2432, 1336, 596, 0, 0, 0, 250, 862, 1521, 2424, 3656, 3455, -1],
  [-1, 2125, 2279, 2020, 1286, 435, 0, 0, 0, 465, 909, 1704, 1925, 2829, 3800, -1],
  [-1, 2762, 1626, 1438, 753, 330, 106, 0, 0, 63, 820, 1140, 1427, 2117, 3767, -1, ],
  [-1, 4715, 1997, 707, 174, 94, 162, 0, 0, 0, 49, 625, 586, 1695, 5034, -1, ],
  [-1, 5427, 1672, 161, 0, 0, 0, 0, 0, 0, 0, 0, 306, 1841, 3483, -1, ],
  [-1, -1, 1814, 0, 0, 0, 0, 0, 0, 0, 0, 0, 302, 849, -1, -1, ],
  [-1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 472, 592, -1, -1, ],
  [-1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, ],
  [-1, -1, -1, -1, 0, 0, 660, -1, -1, 0, 0, 0, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, ],
];

var druckmatrix = [
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, -1, 0, 0, -1, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1],
  [-1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1],
  [-1, -1, -1, -1, 0, 0, 136, 0, 0, 0, 0, 0, -1, -1, -1, -1],
  [-1, -1, -1, 0, 0, 0, 269, 287, 0, 0, 0, 0, 0, -1, -1, -1],
  [-1, -1, -1, 0, 0, 65, 481, 594, 330, 0, 0, 0, 0, -1, -1, -1],
  [-1, -1, -1, 213, 409, 577, 900, 1169, 946, 541, 416, 282, 72, -1, -1, -1],
  [-1, -1, 752, 802, 868, 1042, 1315, 1540, 1286, 925, 832, 778, 698, 587, -1, -1],
  [-1, -1, 1719, 1729, 1671, 1695, 1704, 1802, 1630, 1461, 1501, 1558, 1511, 1470, -1, -1],
  [-1, -1, 2638, 2500, 2355, 2148, 1955, 1802, 1948, 2036, 2254, 2420, 2523, 2516, -1, -1],
  [-1, -1, 4230, 3859, 3442, 2992, 2486, 2186, 2466, 2652, 3001, 3270, 3419, 3526, -1, -1],
  [-1, -1, 4246, 3952, 3663, 3171, 2781, 2423, 2893, 3282, 3799, 4308, 4703, 5411, -1, -1],
  [-1, -1, 5965, 4959, 4437, 3889, 3281, 2847, 3251, 3571, 4048, 4489, 4916, 5515, -1, -1],
  [-1, -1, 5224, 4758, 4358, 3797, 3373, 2899, 3626, 4077, 4732, 5462, 6426, 7323, -1, -1],
  [-1, -1, 6604, 5851, 4976, 4225, 3517, 3035, 3640, 4158, 4634, 5252, 5963, 6306, -1, -1],
  [-1, -1, 5333, 5170, 4426, 3945, 3425, 3215, 3816, 4361, 5215, 6266, 6987, 6012, -1, -1],
  [-1, -1, -1, 5251, 4715, 4091, 3816, 3447, 4143, 4383, 4823, 5228, 4692, -1, -1, -1],
  [-1, -1, -1, -1, 3534, 3578, 3017, -1, -1, 4855, 4597, 3682, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],
];
var druckmatrix2 = [
  [, 0, 0, 0, 0, 364, 1024, 2051, 2163, 1088, 464, 0, 0, 0, 0, 0, 0],
  [, 0, 0, 0, 100, 971, 1963, 1998, 998, 980, 982, 472, 0, 0, 0, 0, 0],
  [, 0, 0, 0, 348, 1396, 2480, 1971, 700, 1098, 1287, 729, 0, 0, 0, 0, 0],
  [0, 0, 0, 406, 1736, 2885, 2144, 631, 1447, 1588, 913, 330, 0, 0, 0, 0],
  [0, 0, 0, 739, 2318, 3616, 2593, 1269, 2022, 2073, 1155, 448, 0, 0, 0, 0],
  [0, 0, 0, 911, 2369, 3598, 2275, 1216, 2608, 2410, 1399, 598, 0, 0, 0, 0],
  [0, 0, 147, 1142, 2584, 3146, 1891, 1096, 2714, 2593, 1532, 734, 0, 0, 0, 0],
  [0, 0, 330, 1326, 2322, 2689, 1248, 838, 2466, 2519, 1656, 757, 58, 0, 0, 0],
  [0, 0, 658, 1587, 2325, 2274, 925, 559, 1916, 2136, 1465, 746, 15, 0, 0, 0],
  [0, 12, 874, 1968, 2202, 2051, 781, 412, 1547, 1980, 1401, 759, 188, 0, 0, 0],
  [
      0, 394, 1347, 2105, 2464, 1980, 929, 506, 1460, 2061, 1460, 883, 387, 0, 0,
      0,
  ],
  [
      0, 722, 1573, 2212, 2361, 1712, 782, 539, 1224, 2081, 1530, 1063, 545, 40,
      0, 0,
  ],
  [
      313, 1349, 2210, 2467, 2292, 1371, 536, 328, 888, 1812, 1624, 1438, 850,
      438, 344, 735,
  ],
  [
      1176, 2339, 2425, 2373, 2146, 759, 331, 0, 596, 1752, 1858, 1820, 1371, 838,
      1073, 1225,
  ],
  [
      1610, 3342, 3475, 2803, 1931, 710, 0, 0, 473, 1456, 1793, 2021, 1818, 1127,
      1120, 2125,
  ],
  [
      3606, 3557, 2961, 2493, 1317, 9, 0, 0, 86, 1155, 1802, 2325, 2243, 1886,
      1732, 2146,
  ],
  [
      3584, 4368, 3726, 2749, 1195, 0, 0, 0, 0, 948, 1908, 2285, 2503, 2344, 2386,
      2543,
  ],
  [
      5913, 3674, 3116, 2515, 743, 0, 0, 0, 0, 948, 2063, 2528, 2869, 3483, 3420,
      2852,
  ],
  [
      4656, 4502, 3442, 2231, 698, 0, 0, 0, 0, 625, 1921, 2490, 2766, 3511, 3589,
      2253,
  ],
  [
      5944, 3478, 2865, 1674, 430, 0, 0, 0, 0, 520, 2022, 2739, 3387, 4217, 3860,
      2408,
  ],
  [
      3699, 3655, 2772, 1361, 408, 0, 0, 0, 0, 464, 1591, 2617, 2818, 3945, 4424,
      2430,
  ],
  [
      3762, 2496, 2040, 752, 0, 0, 0, 0, 0, 411, 1467, 2331, 3001, 4768, 4683,
      3379,
  ],
  [
      2160, 2237, 1556, 544, 0, 0, 0, 0, 0, 155, 957, 1835, 2371, 3299, 3377,
      2133,
  ],
  [3218, 1662, 1027, 149, 0, 0, 0, 0, 0, 98, 970, 1532, 2418, 2838, 2001, 1221],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],
  [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],
];
// 2480 x 3508
var heatmapInstance = "";
var imageSaver = document.getElementById('lnkDownload');
// imageSaver.addEventListener('click', saveImage, false);
function saveImage() {
  this.href = heatmapInstance.getDataURL()
  this.download = 'canvas.png'
}

function test(container, matrix) {
  // const m = matrix
  const m = matrix
  const c_container = container;
  //const width = c_container.clientWidth;
  //const height = c_container.clientHeight;
  var width = c_container.clientWidth;
  //  var height= c_container.clientWidth*1.75;
  var height = c_container.clientHeight;
  //  console.log(width,height, container);
  heatmapInstance = h337.create({
      container: container.children[0],
      radius: width / 47,
      width: width,
      height: height,
  });

  const points = [];
  let max = 0;


  for (let i = 0; i < m.length; i++) {
      const ex = m[i];
      for (let j = 0; j < ex.length; j++) {
          const ey = ex[j];
          // console.log(i);
          if (max < ey)
              max = ey
          const point = {
              x: Math.floor(j * width / ex.length),
              y: Math.floor(i * height / m.length),
              value: ey
          };
          points.push(point);
          // console.log(point);
      }
  }
  // heatmap data format

  const data = {
      max: max,
      data: points
  };

  // if you have a set of datapoints always use setData instead of addData
  // for data initialization
  heatmapInstance.removeData();
  heatmapInstance.setData(data);
  // console.log(heatmapInstance.getDataURL());
  $(document).ready(function() {
      const c = new fabric.Canvas(container.children[1].children[0], {
          selection: false,
          height: height,
          width: width,
      });
      // drawGrid(c);
  });

  function drawGrid(c) {
      const options = {
              distance: c.width / 16,
              width: c.width,
              height: c.height,
              param: {
                  stroke: "#ebebeb",
                  strokeWidth: 1,
                  selectable: false
              }
          },
          gridLen = options.height / options.distance;

      for (var i = 0; i < gridLen; i++) {
          var distance = i * options.distance,
              horizontal = new fabric.Line(
                  [distance, 0, distance, options.height],
                  options.param
              ),
              vertical = new fabric.Line(
                  [0, distance, options.height, distance],
                  options.param
              );
          c.add(horizontal);
          c.add(vertical);
          if (i % 4 === 0) {
              horizontal.set({ stroke: "#cccccc" });
              vertical.set({ stroke: "#cccccc" });
          }
      }
  }

}


var custommask = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
  0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
];
/* Creating a grid of divs with the class "a" and the id "Mp"+id. */
if (document.getElementsByClassName('live')[0])
  for (let i = 0; i < 28; i++) {
      for (let j = 0; j < 16; j++) {
          let id = i * 16 + j;
          let x = document.createElement('div');
          x.setAttribute("onclick", `toogleMaskpoint(${i},${j},${id})`)
          x.id = "Mp" + id
          x.classList.add("a");
          document.getElementsByClassName('live')[0].append(x);
          tM(i, j, id)
      }
  }

if (document.getElementsByClassName('Frame-3')[0])
  for (let i = 0; i < 28; i++) {
      let e = document.createElement('div');
      e.classList.add("row" + i, "line")
      document.getElementsByClassName('Frame-3')[0].append(e);
      for (let j = 0; j < 16; j++) {
          let id = i * 16 + j;
          let x = document.createElement('div');
          x.setAttribute("onclick", `toogleMaskpoint(${i},${j},${id})`)
          x.id = "Mp" + id
          x.classList.add("grid_a")
          x.classList.add("a");
          document.getElementsByClassName('row' + i)[0].append(x);
          tM(i, j, id)

      }
  }

/**
* It takes the contents of the custommask array and sends it to the server
*/
function sendMask() {
  // if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) {
  var cmd = "set mask"

  for (i = 0; i < 28; ++i) {
      for (j = 0; j < 16; ++j) {
          cmd += " ";
          cmd += custommask[i * 16 + j];
      }
  }
  // console.log("send mask");
  sattelanalyse.send(cmd);

  sattelanalyse.send('set mask custom')
      // console.log(cmd);
      // conn.send (cmd);
      // } else {
      // alert ("Must connect.");
      // }
}

function saveMask(name) {
    name=name.replaceAll(" ","");
    name=name.replace("10","X");
    name=name.replace("1","I");
    name=name.replace("2","II");
    name=name.replace("3","III");
    name=name.replace("4","IV");
    name=name.replace("5","V");
    name=name.replace("6","VI");
    name=name.replace("7","VII");
    name=name.replace("8","VIII");
    name=name.replace("9","IX");
    var cmd = `set mask -store ${name}`

    for (i = 0; i < 28; ++i) {
        for (j = 0; j < 16; ++j) {
            cmd += " ";
            cmd += custommask[i * 16 + j];
        }
    }
    // console.log("send mask");
    sattelanalyse.send(cmd);
    sattelanalyse.send(`set mask ${name}`)
    hide_mask();
    add_mask(name)
    // onsqlresult = Maskmenue;
    // sattelanalyse.send(`sql select name from masks where mask_id > 4`);
}

/**
* It toggles the maskpoint at the given index, and sends the mask to the server
* @param i - the row of the Mp
* @param j - the number of rows
* @param idx - the index of the Mp in the custommask array
*/
function toogleMaskpoint(i, j, idx) {
  var id = "Mp" + idx;
  if (custommask[idx] == 1) {
      custommask[idx] = 0;
      document.getElementById(id).style.backgroundColor = 'rgb(255 255 255 / 0%)'
      sendMask()
  } else {
      custommask[idx] = 1;
      document.getElementById(id).style.backgroundColor = '#e50e0e52'
      sendMask()
  }
}

function tM(i, j, idx) {
  var id = "Mp" + idx;

  if (custommask[idx] == 1) {
      custommask[idx] = 0;
      document.getElementById(id).style.backgroundColor = 'rgb(255 255 255 / 0%)'
  } else {
      custommask[idx] = 1;
      document.getElementById(id).style.backgroundColor = '#e50e0e52'
  }
}

