#
# Websocket Anbindung der Anwendung custom/apps/jpegsattelbild

namespace eval apps/jpegsattelbild {

    # Mitteilung vom Client verarbeiten
       # Hinweis: Das ist ein Callback, das mit ::websocket::live übergeben wird.
       # Es wird von ::websocket aufgerufen und befindet sich deshalb in einem
       # anderen namespace Kontext.
       # Prozeduren aus ::WSServer müssen deshalb mit vollem Namespacepfad
       # aufgerufen werden.
    proc handleClientMessage {clientsocket type msg} {
	    upvar #0 clientcontext$clientsocket context
           # variable ...
	
	    # type laut API:
	    #   text        Complete text message
	    #   binary      Complete binary message
	    #   ping        Incoming ping message
	    #   connect     Notification of successful connection to server
	    #   disconnect  Disconnection from remote end
	    #   close       Pending closure of connection
	
	    switch -glob -nocase -- $type {
	        connect {
	            srvLog $clientsocket Info "Client connected"
                if {[catch {::apps::jpegsattelbild::start} starterror]} {
                    srvLog [namespace current] Error $starterror
                }
	        }
	        text {
                # Hier werden die API-Requests entgegegenommen.
	            srvLog $clientsocket Debug "text message received: '$msg'"
                ::apps::jpegsattelbild::handleCommand $msg
	        }
	        binary {
	            srvLog $clientsocket Info "binary message received"
	        }
	        ping -
	        pong {
	            srvLog $clientsocket Debug "Client $type received"
                   # Kein Handlungsbedarf
	        }
	        close {
				srvLog $clientsocket Info "WS-Connection closing (%s)" $context(ipaddr)
                   # Kein Handlungsbedarf
	        }
	        disconnect {
				srvLog $clientsocket Info "WS-Connection disconnected (%s)" $context(ipaddr)
                if {[catch {::apps::jpegsattelbild::stop} starterror]} {
                    srvLog [namespace current] Error $starterror
                }
                # Das ist notwendig:
	            ::WSServer::wsClientKill $clientsocket
            }
	        default {
				srvLog $clientsocket Info "WS-Connection unknown message type: %s" $type
                   # Kein Handlungsbedarf
	        }
	    }
    }; # proc handleClientMessage 

}

