# HTTP-Domäne /stationsproxy

namespace eval stationsproxy {

    variable stationsportal ""

    ::http::register https 443 ::tls::socket

    proc handleClientRequest {clientsocket {query {}} } {
        upvar #0 clientcontext$clientsocket context
        variable stationsportal

        # Der Stationsserver wurde ursprünglich über der Referer ermittelt, was nicht zuverlässig funktionierte.
        # Jetzt wird der Name des Portalservers vom Webservice geliefert.
        # TODO Der Kode im elseif wird überflüssig, wenn das zuverlässig funktioniert.
        if {"$::PORTALSERVER" != ""} {
            set stationsportal "${::PORTALSERVER}/"
        } elseif {[dict exists $context(request_headers) Referer]} {
            set referer [dict get $context(request_headers) Referer]
            # Das ist die volle URL => nur Protokoll- und Hostteil nehmen!
            regexp {^[^/]*//[^/]*/} $referer referer_proto_host
            # Der Proxyserver kann nicht gleichzeitig das Stationsportal sein.
            # Das könnte bei der Weiterleitung zu Endlosrekursion führen.
            if {[dict exists $context(request_headers) Host]} {
                set host [dict get $context(request_headers) Host]
                if {![string match "*$host*" $referer_proto_host]} {
                    # Wenn stationsportal bereits gesetzt ist, ist Vorsicht angesagt.
                    if {"$stationsportal" == ""} {
                        set stationsportal $referer_proto_host
                        srvLog stationsproxy Notice "$stationsportal als Stationsportal registriert"
                    } elseif {$stationsportal != $referer_proto_host} {
                        set stationsportal $referer_proto_host
                        srvLog stationsproxy Notice "$stationsportal als neues Stationsportal registriert"
                    }
                }
            }
        }
        if {"$stationsportal" == ""} {
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler HTTPS-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "Diese Seite sollte nie zu sehen sein."]
            # Die Requestheader könnten eine Erklärung liefern.
            dict for {key value} $context(request_headers) {
                append html "${key}: ${value}<BR/>"
            }
	        append html [::html::end]
	        return $html
        }
        # Weiterleitung an Stationsportal
        set url [regsub {^.*stationsproxy/} $context(url) $stationsportal]
        srvLog stationsproxy_$clientsocket Info "geturl $url from $stationsportal"
        #TODO Das ist die volle URL => Queryparameter abschneiden
        if {[catch {set token [::http::geturl $url]} errmsg]} {
            srvLog stationsproxy Error "$url -> $errmsg"
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler HTTPS-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "$url konnte nicht geholt werden."]
            append html $errmsg
	        append html [::html::end]
            #TODO Fehlerstatus
	        return $html
        }
        srvLog stationsproxy_$clientsocket Info "$url -> [::http::status $token]"
        if {[::http::status $token] != "ok"} {
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler HTTPS-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "$url konnte nicht geholt werden."]
	        append html [::html::end]
            #TODO Fehlerstatus
	        return $html
        }
        set html [::http::data $token]
        array set header [::http::meta $token]
        if {[info exists header(Content-Type)]} {
            # Content-Type in den Header übernehmen
            set context(contenttype) $header(Content-Type)
        }
        ::http::cleanup $token
        return $html
    }; # proc handleClientRequest 

}; # namespace eval stationsproxy 

