# HTTP-Domäne /service
#
#TODO ordentliche Doku
#
# Schlüssel/Werte in den GET-Parametern:
#   reload_app <app>
#   vars_app <app>
#   reload_httpdomain <domain>
#   vars_httpdomain <domain>
#

namespace eval service {

    #TODO Was wird hier erzeugt ?
    proc handleClientRequest {clientsocket {query {}} } {
        upvar #0 clientcontext$clientsocket context

        set html "<!doctype html>\n"
        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
        append html [::html::head "Velobox: Service"]
        append html [::html::bodyTag]
        append html "<a href=service>[::html::h3 "vmkstationd3 Service"]</a>"
        append html [::html::html_entities "(HTTP-Domäne \"service\"\n)"]
        foreach {key value} $query {
            switch $key {
                reload_app {
                    append html "reload ${value}:<br/>"
                    append html [::html::nl2br "[::apps::reload $value]\n"]
                    set dir [file dirname [info script]]
                    # Zugehöriges Websocket-Modul, falls existent
                    if {[file exists $::dir/custom/wsserver/wsdomains/apps/${value}.tcl]} {
                        #TODO source (wo einbauen?)
                        append html "Unimplemented: reload $::dir/custom/wsserver/wsdomains/apps/${value}.tcl<br/>"
                    }
                    # Zugehöriges HTML-Modul, falls existent
                    if {[file exists $::dir/custom/wsserver/httpdomains/apps/${value}.tcl]} {
                        #TODO source (wo einbauen?)
                        append html "Unimplemented: reload $::dir/custom/wsserver/httpdomains/apps/${value}.tcl<br/>"
                    }
                }
                vars_app {
                    append html [::html::h5 "vars of $value"]
                    append html "<table>"
                    append html [::html::foreach {varname} [lsort [info vars ::apps::${value}::*]] {
                            <tr>
                                <td>[regsub {^.*::} $varname {}]</td>
                                <td>[if {[info exists $varname]} {set $varname}]</td>
                            </tr>
                        }
                    ]
                    append html "</table>"
                }
                reload_httpdomain {
                    append html [::html::nl2br "[::WSServer::httpdomains::reload $value]\n"]
                }
                vars_httpdomain {
                    #TODO
                }
            }
        }
        append html [::html::h4 "Apps"]
        # Versteckte Formulare für Apps anlegen.
        # Das ist notwendig, weil HTML keine Formulare innerhalb einer Tabelle erlaubt.
        append html [
            ::html::foreach {app} [dict keys $::apps::apps_loaded] {
                <form id=frm_reload_app_$app>
                    <input type=hidden name=reload_app value="$app"/>
                </form>
                <form id=frm_vars_app_$app>
                    <input type=hidden name=vars_app value="$app"/>
                </form>
            }
        ]
        append html "<table>"
        append html [
            ::html::foreach {app} [dict keys $::apps::apps_loaded] {
                <tr>
                    <td>$app</td>
                    <td><input type=submit form=frm_vars_app_$app value="vars"/></td>
                    <td><input type=submit form=frm_reload_app_$app value="reload"/></td>
                </tr>
            }
        ]
        append html "</table>"

        append html [::html::h4 "Httpdomains"]
        # Versteckte Formulare für Httpdomains anlegen.
        append html [
            ::html::foreach {httpdomain} [dict keys $::WSServer::httpdomains::httpdomains_loaded] {
                <form id=frm_reload_httpdomain_$httpdomain>
                    <input type=hidden name=reload_httpdomain value="$httpdomain"/>
                </form>
            }
        ]
        append html "<table>"
        append html [
            ::html::foreach {httpdomain} [dict keys $::WSServer::httpdomains::httpdomains_loaded] {
                <tr>
                    <td>$httpdomain</td>
                    <!--TODO vars-->
                    <td><input type=submit form=frm_reload_httpdomain_$httpdomain value="reload"/></td>
                </tr>
            }
        ]
        append html "</table>"
        append html [::html::end]
        return $html
    }; # proc handleClientRequest 

}; # namespace eval service 

