#!/bin/bash
#
# setup-htdocs.sh
# Einspielen aller Dateien in /usr/local/vmkstationd/
# Velometrik-GmbH
#
# Historie:
#   09.06.2022	Peter Bauer   Erstellt
#

if [ `whoami` != "root" ]; then
echo "ERROR"
    echo "The script must be executed by root!"
    exit 1
fi

echo "rm /usr/local/bin/wlan.sh"
rm /usr/local/bin/wlan.sh
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "rm /usr/local/bin/wlan.sh"
fi
echo "done"

echo "rm /etc/systemd/system/wlan.service"
rm /etc/systemd/system/wlan.service
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "rm /etc/systemd/system/wlan.service"
fi
echo "done"

echo "rm /etc/systemd/system/wlan.timer"
rm /etc/systemd/system/wlan.timer
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "rm /etc/systemd/system/wlan.timer"
fi
echo "done"

echo "rm /etc/systemd/system/multi-user.target.wants/wlan.service"
rm /etc/systemd/system/multi-user.target.wants/wlan.service
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "rm /etc/systemd/system/multi-user.target.wants/wlan.service"
fi
echo "done"

echo "Journal verkleinern"
journalctl --vacuum-size=50M
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "error at # journalctl --vacuum-size=50M"
    exit 1
fi
echo "done"

echo "Jurnal time 1d"
journalctl --vacuum-time=1d
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "urnal time 1d"
    exit 1
fi
echo "done"



echo "Files in / will be installed."
if [ ! -r velobox_update_2.1.1.tar.gz ]; then
echo "ERROR"
    echo "velobox_update_2.1.1.tar.gz not found" 
    exit 1
fi
cp velobox_update_2.1.1.tar.gz /
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "Can't copy velobox_update_2.1.1.tar.gz to / ."
    exit 1
fi
cd /
test $? -ne 0 && exit 1
tar xf velobox_update_2.1.1.tar.gz
test $? -ne 0 && exit 1
rm -f velobox_update_2.1.1.tar.gz

echo "Files in / were recorded."

echo "apt-get purge chromium-browser -y"
apt-get purge chromium-browser -y
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "apt-get purge chromium-browser -y"
    exit 1
fi
echo "done"

echo "apt-get purge firefox-esr -y"
apt-get purge firefox-esr -y
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "apt-get purge firefox-esr -y"
    exit 1
fi
echo "done"

echo "apt-get autoremove -y"
apt-get autoremove -y
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "apt-get autoremove -y"
    exit 1
fi
echo "done"

echo "chmod +x /usr/local/bin/wps_connect.sh"
chmod +x /usr/local/bin/wps_connect.sh
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "chmod +x /usr/local/bin/wps_connect.sh"
    exit 1
fi
echo "done"

echo "ln -s /etc/systemd/system/wps_connect.service /etc/systemd/system/multi-user.target.wants/"
ln -s /etc/systemd/system/wps_connect.service /etc/systemd/system/multi-user.target.wants/
if [ $? -ne 0 ]; then
echo "ERROR"
    echo "ln -s /etc/systemd/system/wps_connect.service /etc/systemd/system/multi-user.target.wants/"
    exit 1
fi
echo "done"

reboot now