/*
 * Copyright (C) 2022 Velometrik GmbH
 * <http://www.velometrik.de/>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: 
 * support@velometrik.de
 * 
 * wlanconfig
 *    
 */

/* A jQuery function that is used to create a table with the id "netzwerke" and to make it responsive. */
$('#netzwerke').DataTable({
    responsive: false
});

/**
 * It loops through all elements with the class "tr" and replaces the text with the value of the key
 * attribute in the aLangKeys array
 */
function translatejs() {
    var lang = getCookie("langSelected");
    $('.tr').each(function(i) {
        $(this).text(aLangKeys[lang][$(this).attr('key')]);
    });
}

/* A function that is called when the result of the scan is received. */
httpScanresult.onreadystatechange = function() {
    if (httpScanresult.readyState == 4) {
        console.log("iwscan.tcls beenden mit Status " + httpScanresult.status);
        if (httpScanresult.status == 200) {
            var response = httpScanresult.responseText;
            var scanresult = JSON.parse(response);
            var essids = new Set();

            if (scanresult.length == 0) {
                document.getElementById("scanresult").innerHTML = "<tr><td colspan=\"6\"><span class=\"tr badge badge-warning\" key=\"netzwerk_keinen_accesspoint\"><!--Keinen Accesspoint gefunden--></span></td></tr>";
            } else {
                var html = "";

                for (i = 0; i < scanresult.length; ++i) {
                    var essid = scanresult[i].essid;

                    html += '<tr>'
                    html += '<td class=\"align-middle\">' + scanresult[i].cell + '</td>';
                    html += '<td class=\"align-middle\">' + essid + '</td>';
                    html += '<td class=\"align-middle\">' + scanresult[i].level + ' dBm</td>';

                    if (!essids.has(essid) && essid != essid_connected) {
                        var ap = gespeichert[essid];
                        var psk = (ap === undefined) ? "" : ap.psk;

                        html += '<td class=\"align-middle\"><input type="password" class="form-control" value="' + psk + '" id="psk_' + essid + '"></td>'
                        html += '<td class=\"align-middle\">'
                        html += '<button type="button" class="btn btn-primary" onclick="umschalten(\'psk_' + essid + '\');"><i class="fa fa-eye"></i></button>'
                        html += '<button type="button" class="btn btn-primary" onclick="wlanconnect(\'' + essid + '\');"><i class="fa fa-plug"></i></button>'
                        html += '</td>'

                        essids.add(essid);
                    } else {
                        html += "<td class=\"align-middle\"><input type=\"password\" class=\"form-control\" readonly=\"readonly\"></td>"
                        html += "<td class=\"align-middle\" colspan=\"2\"><span class=\"tr badge badge-warning\" key=\"netzwerk_nicht_verfuegbar\"><!--Netzwerk nicht verfügbar--></span></td>";
                    }
                    html += "";
                }
                html += "</tr>"
                document.getElementById("scanresult").innerHTML = html;
                translatejs();

            }
        } else {
            console.log("HTTP-Fehler " + httpScanresult.status, " bei iwscan.tcls.");
        }
    }
};

/* A function that is called when the result of the scan is received. */
httpIwconfig.onreadystatechange = function() {
    if (httpIwconfig.readyState == 4) {
        console.log("iwscan.tcls beenden mit Status " + httpIwconfig.status);
        if (httpIwconfig.status == 200) {
            var response = httpIwconfig.responseText;
            console.log(response);
            if (response.substr(0, 5) == "Error") {
                document.getElementById("wlanstatus").innerHTML = "<div class=\"alert alert-warning alert-dismissible\" role=\"alert\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\"><span aria-hidden=\"true\">×</span></button><strong><span class=\"tr\" key=\"netzwerk_nichtverbunden\"><!--Nicht verbunden--></span></strong></div>";
            } else {
                var connection = JSON.parse(response);

                document.getElementById("wlanstatus").innerHTML = "<div class=\"alert alert-warning alert-dismissible\" role=\"alert\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\"><span aria-hidden=\"true\">×</span></button><strong><span class=\"tr\" key=\"netzwerk_verbundenmit\">Verbunden mit </span> " + connection.essid + " (IP: " + connection.inet + ")</strong></div>";
                essid_connected = connection.essid;
                refreshWLAN();
            }
        }
    }
    translatejs();
};

/**
 * It sends a request to the server to execute the iwscan.tcls script
 * @returns The result of the iwscan.tcls script.
 */
function refreshWLAN() {
    if (httpScanresult.readyState == 4) {
        document.getElementById("scanresult").innerHTML = "<td colspan=\"6\"><div class=\"alert alert-warning alert-dismissible\" role=\"alert\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\"><span aria-hidden=\"true\">×</span></button><strong><span class=\"tr\" key=\"netzwerk_netzwerkwirdgesucht\"><!--Suche nach Wlan Netzwerken...--></span></strong></div></td>";
    } else if (httpScanresult.readyState != 0) {
        return;
    }
    translatejs();

    /* Sending a request to the server to execute the iwscan.tcls script. */
    httpScanresult.open("GET", "iwscan.tcls?rnd=" + (new Date).getTime(), true);
    httpScanresult.send();
}

/**
 * If the type of the element with the id "id" is "password", then change it to "text", otherwise
 * change it to "password"
 * @param {string} id - The id of the password field.
 */
function umschalten(id) {
    var x = document.getElementById(id);
    if (x.type === "password") {
        x.type = "text";
    } else {
        x.type = "password";
    }
}

/**
 * It sends a request to the server to connect to a WLAN with the given ESSID and the given key
 * @param {string} essid - The name of the network you want to connect to.
 * @returns The return value is the result of the last command executed in the function.
 */
function wlanconnect(essid) {
    var x = document.getElementById("psk_" + essid);
    var key = x.value;
    var url = "/production/wlanconnect.tcls?essid=" + essid + "&key=" + key;

    if (key.length === 0) {
        document.getElementById("wlanstatus").innerHTML = "<div class=\"alert alert-danger alert-dismissible\" role=\"alert\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\"><span aria-hidden=\"true\">×</span></button><strong>Verbindungen zu offenen WLANs sind nicht erlaubt! </strong></div>";
        return;
    }
    translatejs();

    document.getElementById("wlanstatus").innerHTML = "<div class=\"alert alert-warning alert-dismissible\" role=\"alert\"><button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\"><span aria-hidden=\"true\">×</span></button><strong>Verbinde mit " + essid + " ...</strong></div>";
    httpIwconfig.open("GET", url, true);
    httpIwconfig.send();
}

/* Calling the function `refreshWLAN()` which is defined above. */
refreshWLAN();