/*
 * Copyright (C) 2022 Velometrik GmbH
 * <http://www.velometrik.de/>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: 
 * support@velometrik.de
 * 
 * Satteldruckanalyse
 *    
 */

/* global variable. */
var conn;

/**
 * It sets the src attribute of the image element with the id "sattelbild" to the URL "/sattelbild"
 * with a random number appended to the URL
 */
function sattelbildAktualisieren() {
    /* It sets the src attribute of the image element with the id "sattelbild" to the URL "/sattelbild"
    with a random number appended to the URL because the cache */
    document.getElementById("sattelbild").src = "/sattelbild?rnd=" + (new Date).getTime();
}


/**
 * It handles messages from the websocket
 * Meldung vom Websocketserver der Arbeitsstation verarbeiten
 * @param wsmessage - The message received from the server.    wsmessage   Meldung (JSON-String)
 * @returns the value of the last statement executed.
 */
function handleWSMessage(wsmessage) {
    var msg;

    try {
        msg = JSON.parse(wsmessage);
    } catch (error) {
        console.log("Kein gültiger JSON-String: \"" + wsmessage + "\"");
        return;
    }
    if (msg.wsevent == "hockerbild") {
        // ignorieren
    } else if (msg.wsevent == "sattelbild") {
        sattelbildAktualisieren();
    } else if (msg.wsevent == "plugged") {
        if (msg.type.substr(0, 6) == "MT_SAT") {
            sattelbildAktualisieren();
            document.getElementById("message").innerHTML = "<span style=\"cursor:pointer;}\" title=\"angeschlossen\"><i class=\"fa fa-circle\" style=\"color: var(--primary);\"></i> SENSOR</span>";
        }
    } else if (msg.wsevent == "unplugged") {
        if (msg.type.substr(0, 6) == "MT_SAT") {
            document.getElementById("message").innerHTML = "<span style=\"cursor:pointer;}\" title=\"Sensor wurde entfernt\"><i class=\"fa fa-circle-o\"></i> SENSOR</span>";
        }
    } else {
        document.getElementById("message").innerHTML = evt.data;
    }


}

/**
 * It tries to establish a connection to the server and sets up the event handlers for the connection
 * returned on succsess the request to the element ID "statusinfo" 
 * @param ws_url - The URL of the WebSocket server.
 */
function connect(ws_url) {
    if (window["WebSocket"]) {
        /* It checks if the connection is already open and closes it. */
        if (typeof conn == "object") {
            if (conn.readyState == WebSocket.OPEN)
                conn.close();
        }
        try {
            /* The server expects at least one (sub) protocol, even if it is not used. */
            conn = new WebSocket(ws_url, "dummy");
        } /* It catches an error and logs it to the console. */
        catch (error) {
            console.error("Websocket Error:", error);
            document.getElementById("statusinfo").innerHTML = "Wenn das 'mal kein Fehler ist.";
        }
        /* Checking the status of the connection and setting the statusinfo element accordingly. */
        switch (conn.readyState) {
            case WebSocket.CONNECTING:
                document.getElementById("statusinfo").innerHTML = "<i class=\"fa fa-circle\" title=\"wird verbunden\"></i> WEBSOCKET";
                conn.onopen = function(evt) {
                    document.getElementById("statusinfo").innerHTML = "<span style=\"cursor:pointer;}\" title=\"verbunden\"><i class=\"fa fa-circle\" style=\"color: var(--primary);\"></i> WEBSOCKET</span>";
                    conn.onclose = function(evt) {
                        document.getElementById("statusinfo").innerHTML = "<i class=\"fa fa-circle-o\" title=\"Verbindung wurde geschlossen\"></i> WEBSOCKET";
                        document.getElementById("message").innerHTML = "";
                    };
                };
                conn.onclose = function(evt) {
                    document.getElementById("statusinfo").innerHTML = "<i class=\"fa fa-circle-o\" title=\"Verbindung konnte nicht hergestellt werden\"></i> WEBSOCKET";
                };
                break;
            case WebSocket.OPEN:
                document.getElementById("statusinfo").innerHTML = "<span style=\"cursor:pointer;}\" title=\"verbunden\"><i class=\"fa fa-circle\" style=\"color: var(--primary);\"></i> WEBSOCKET</span>";
                break;
            case WebSocket.CLOSING: // Verbindung ist im Prozess des Schließens.
            case WebSocket.CLOSED: // Die Verbindung konnte nicht hergestellt werden.
                document.getElementById("statusinfo").innerHTML = "<i class=\"fa fa-circle-o\" title=\"Verbindung konnte nicht hergestellt werden\"></i> WEBSOCKET";
                break;
        }
        /* Setting the `onmessage` property of the `conn` object to a function that calls the
        `handleWSMessage` function with the `evt.data` parameter. */
        conn.onmessage = function(evt) {
            handleWSMessage(evt.data);
        };
    } else {
        document.getElementById("statusinfo").innerHTML = "WebSocket ist in diesem Browser nicht verfügbar";
    }
}


/* It calls the `connect` function with the URL of the WebSocket server. */
connect("ws://" + window.location.hostname + ":" + window.location.port + "/messages");
