/*
 * Copyright (C) 2022 Peter Bauer; Björn Bauer / Velometrik GmbH
 * <http://www.velometrik.de/>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * It loops through all elements with the class "tr" and replaces the text with the value of the key
 * attribute in the aLangKeys array
 */
function translatejs() {
  var lang = getCookie("langSelected");
  $(".tr").each(function (i) {
    $(this).text(aLangKeys[lang][$(this).attr("key")]);
  });
}

/**
 * This function sets a cookie with a name and value.
 * @param {string} c_name - The name of the cookie.
 * @param {string} value - The value to be stored in the cookie.
 * @param {Date} exdays - The number of days that the cookie will be valid.
 */
function setCookie(c_name, value, exdays) {
  var exdate = new Date();
  exdate.setDate(exdate.getDate() + exdays);
  var c_value =
    escape(value) + (exdays == null ? "" : "; expires=" + exdate.toUTCString());
  document.cookie = c_name + "=" + c_value;
}

/**
 * This function returns the value of a cookie
 * @param {string} c_name - The name of the cookie to retrieve.
 * @returns The value of the cookie.
 */
function getCookie(c_name) {
  var i,
    x,
    y,
    ARRcookies = document.cookie.split(";");
  for (i = 0; i < ARRcookies.length; i++) {
    x = ARRcookies[i].substr(0, ARRcookies[i].indexOf("="));
    y = ARRcookies[i].substr(ARRcookies[i].indexOf("=") + 1);
    x = x.replace(/^\s+|\s+$/g, "");
    if (x == c_name) {
      return unescape(y);
    }
  }
}

/* Creating an array for each language. */
var aLangKeys = new Object();

/* This is creating an array for each language. */
aLangKeys["de"] = new Object();
aLangKeys["en"] = new Object();
aLangKeys["es"] = new Object();
aLangKeys["pt"] = new Object();
aLangKeys["nl"] = new Object();
aLangKeys["fr"] = new Object();

// Funktioniert einwandfrei --- nicht löschen
fetch("/production/localisation/lang.json", {
  mode: "no-cors",
}) // disable CORS because path does not contain http(s)
  .then((res) => res.json())
  .then((data) => (aLangKeys = data));

/**
 * The function takes the value of the selected option in the dropdown menu and sets a cookie with that
 * value.
 *
 * The cookie is set for 365 days.
 *
 * The function then reloads the page
 * @param lang - The language code of the language you want to set.
 */
function langSelected(lang) {
  let result = lang.substring(0, 2);

  document.cookie =
    "langSelected=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
  setCookie("langSelected", result, 1);
  console.log(lang + " , " + result);

  var systemsprache = lang;

  var url = "/production/setlanguagefile.tcls?systemsprache=" + systemsprache;

  document.getElementById("message").innerHTML =
    '<p><span class="tr" key="system_system_hilfe"><!--Einstellungen übernehmen und rebooten--></span></p>';

  /* Sending a GET request to the url. */
  httpSetconfig.open("GET", url, true);
  httpSetconfig.send();

  translatejs();

  $("#reboot").modal("show");
}

/* The code is executed when the document is ready. */
$(document).ready(function () {
  var lang = getCookie("langSelected");

  /* Checking if the cookie "langSelected" exists. If it does not exist, it checks if the browser
    language is one of the supported languages. If it is, it sets the cookie to the browser
    language. If it is not, it sets the cookie to "en". If the cookie exists, it sets the language
    icon to the language in the cookie. */
  if (lang == null) {
    console.log('Der Cookie "langSelected" wurde noch nicht gesetzt!');

    if (
      navigator.language === "de" ||
      navigator.language === "en" ||
      navigator.language === "es" ||
      navigator.language === "pt"
    ) {
      lang = navigator.language;
      setCookie("langSelected", lang, 1);
      //Sprachicon setzen
      $("#sprachwahl").attr("src", "images/" + lang + ".png");
      console.log('Sprache auf "' + lang + '" gesetzt');
    } else {
      lang = "en";
      setCookie("langSelected", lang, 1);
      //Sprachicon setzen
      $("#sprachwahl").attr("src", "images/" + lang + ".png");
      console.log(
        'Browsersprache konnte nicht ermittelt werden und wurde auf "' +
          lang +
          '" gesetzt.'
      );
    }
  } else {
    // do cookie exists stuff
    console.log("Sprache: " + lang);
    //Sprachicon setzen
    $("#sprachwahl").attr("src", "images/" + lang + ".png");
  }

  // Verhalten bei onclick
  /* This is a JavaScript function that is executed when the user clicks on a language button. */
  $(".lang").click(function () {
    var lang = $(this).attr("id");
    // übersetze alle übersetzbaren Felder
    $(".tr").each(function (i) {
      $(this).text(aLangKeys[lang][$(this).attr("key")]);
      console.log($(".tr").attr("key"));
    });
  });

  /* This is a JavaScript function that is executed when the user clicks on a language button. */
  $(".tr").each(function (i) {
    $(this).text(aLangKeys[lang][$(this).attr("key")]);
  });

  /* Setting the version number in the footer. */
  $(".version").each(function (i) {
    $(this).text(localStorage.getItem("VERSION"));
  });
});

// Fullscreen
/* A JavaScript function that is executed when the user clicks on a language button. */
$(document).ready(function () {
  $(".fullscreen_button").on("click", function () {
    (document.fullScreenElement && null !== document.fullScreenElement) ||
    (!document.mozFullScreen && !document.webkitIsFullScreen)
      ? document.documentElement.requestFullScreen
        ? document.documentElement.requestFullScreen()
        : document.documentElement.mozRequestFullScreen
        ? document.documentElement.mozRequestFullScreen()
        : document.documentElement.webkitRequestFullScreen &&
          document.documentElement.webkitRequestFullScreen(
            Element.ALLOW_KEYBOARD_INPUT
          )
      : document.cancelFullScreen
      ? document.cancelFullScreen()
      : document.mozCancelFullScreen
      ? document.mozCancelFullScreen()
      : document.webkitCancelFullScreen && document.webkitCancelFullScreen();
  });
});

/**
 * The function starts a countdown and then reboots the Velobox
 */
function reboot() {
  var url = "/production/reboot.tcls";

  // btn1 ist das X zum schließen des Fensters
  //var btn1 = document.getElementById("btn1");
  //btn1.setAttribute("disabled", "true");

  var btn2 = document.getElementById("btn2");
  btn2.setAttribute("disabled", "true");

  var btn3 = document.getElementById("btn3");
  btn3.setAttribute("disabled", "true");

  countdown();

  httpreboot.open("GET", url, true);
  httpreboot.send();
} // reboot()

/**
 * It counts down from 60 seconds and reloads the page when it reaches 0
 */
function countdown() {
  var seconds = 60;

  function tick() {
    var counter = document.getElementById("counter");
    seconds--;
    counter.innerHTML =
      '<span class="tr" key="global_einsatzbereit"><!--Die Velobox ist wieder einsatzbereit in nur--></span> <b>0:' +
      (seconds < 10 ? "0" : "") +
      String(seconds) +
      '</b> <span class="tr" key="global_minuten"><!--Minuten--></span>';
    if (seconds > 0) {
      setTimeout(tick, 1000);
    } else {
      document.location.reload(true);
    }
  }
  translatejs();
  tick();
}

/**
 * It removes the local storage items 'ReadFirstStart' and 'ReadFirstSatteldruckanalyse'
 */
function HelpReset() {
  localStorage.removeItem("ReadFirstStart");
  localStorage.removeItem("ReadFirstSatteldruckanalyse");
}
