/*
 * Copyright (C) 2022 Peter Bauer / Velometrik GmbH
 * <http://www.velometrik.de/>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * `localstart()` is a function that is called when the page is loaded
 */
function fs() {
  localstart();
  getVersion();
}

/**
 * If the checkbox is checked, set the localStorage item "ReadFirstStart" to true, otherwise set it to
 * false
 */
function setFirstStart() {
  var firststart = document.getElementById("chb_firststart");
  if (firststart.checked) {
    localStorage.setItem("ReadFirstStart", true);
  } else {
    localStorage.setItem("ReadFirstStart", false);
  }
}

/**
 * It checks if the user has already seen the first start modal and if not, it shows it
 */
function localstart() {
  if (localStorage.getItem("ReadFirstStart") === null) {
    console.log("Init FirstStart");
    localStorage.setItem("ReadFirstStart", false);
  }

  if (localStorage.getItem("viewmode") === null) {
    console.log("Init ViewMode");
    localStorage.setItem("viewmode", "basic");
  }

  if (localStorage.getItem("ReadFirstSatteldruckanalyse") === null) {
    console.log("Init FirstSatteldruckanalyse");
    localStorage.setItem("ReadFirstSatteldruckanalyse", false);
  }

  if (localStorage.getItem("ReadFirstSatteldruckanalyse") === "false") {
    if (document.getElementById("firstsatteldruckanalyse")) {
    $("#firstsatteldruckanalyse").modal("show");     
    }
  }

  var ModeBasic = document.getElementById("ModeBasic");
  var ModeAdvanced = document.getElementById("ModeAdvanced");
  if (localStorage.getItem("viewmode") === "basic") {
    document.getElementById("ModeBasic").classList.add("link_focus");
    document.getElementById("ModeAdvanced").classList.remove("link_focus");
    ModeBasic.focus();
  } else {
    document.getElementById("ModeBasic").classList.remove("link_focus");
    document.getElementById("ModeAdvanced").classList.add("link_focus");
    ModeAdvanced.focus();
  }

  ToggleViewMode(localStorage.getItem("viewmode"));

  if (localStorage.getItem("ReadFirstStart") === "false") {
    $("#firststart").modal("show");
  } else {
    console.log(
      "FirstStart deactivated",
      localStorage.getItem("ReadFirstStart")
    );
  }
}

/**
 * It checks the local storage for the value of the key 'viewmode'. If the value is 'basic', it adds
 * the class 'basicview' to all elements with the class 'adba'. If the value is 'advanced', it removes
 * the class 'basicview' from all elements with the class 'adba'
 * @param {string} mode - This is the view mode you want to switch to.
 */
function ToggleViewMode(mode) {
  localStorage.setItem("viewmode", mode);

  if (localStorage.getItem("viewmode") === "basic") {
    document.getElementById("ModeBasic").classList.add("link_focus");
    document.getElementById("ModeAdvanced").classList.remove("link_focus");
    for (
      let index = 0;
      index < document.getElementsByClassName("adba").length;
      index++
    ) {
      const element = document.getElementsByClassName("adba")[index];
      element.classList.add("basicview");
    }
  } else if (localStorage.getItem("viewmode") === "advanced") {
    document.getElementById("ModeBasic").classList.remove("link_focus");
    document.getElementById("ModeAdvanced").classList.add("link_focus");
    for (
      let index = 0;
      index < document.getElementsByClassName("adba").length;
      index++
    ) {
      const element = document.getElementsByClassName("adba")[index];
      element.classList.remove("basicview");
    }
  }
}

/**
 * If the localStorage item "ReadFirstSatteldruckanalyse" is false, then show the modal with the id
 * "firstsatteldruckanalyse".
 */
// function FirstSatteldruckanalyse() {
//   if (localStorage.getItem("ReadFirstSatteldruckanalyse") === "false") {
//     if (document.getElementById("firstsatteldruckanalyse")) {
//     $("#firstsatteldruckanalyse").modal("show");     
//     }
//   }
// }

/**
 * If the checkbox is checked, the value of the localStorage item "ReadFirstSatteldruckanalyse" is set
 * to true. If the checkbox is not checked, the value of the localStorage item
 * "ReadFirstSatteldruckanalyse" is set to false
 */
function setFirstSatteldruckanalyse() {
  var firstSatteldruckanalyse = document.getElementById(
    "chb_firstSatteldruckanalyse"
  );
  if (firstSatteldruckanalyse.checked) {
    localStorage.setItem("ReadFirstSatteldruckanalyse", true);
  } else {
    localStorage.setItem("ReadFirstSatteldruckanalyse", false);
  }
}

/**
 * The function `getVersion()` makes an HTTP GET request to the server, which returns the version
 * number of the server
 */
function getVersion() {
  var url = "getversion.tcls?version=0";
  var oReq = new XMLHttpRequest();

  oReq.open("GET", url, true);
  oReq.send();

  oReq.onload = function (e) {
    console.log(oReq.responseText);
    localStorage.setItem("VERSION", oReq.response.split("\n")[0]); // not responseText
  };
}
