#!/bin/sh
# manew: try to establish wlan connection if not yet existing

if ! wpa_cli status > /dev/null 2>&1; then
    echo "no wlan adapter found" 
else
    while ! wpa_cli status | grep "ssid" 
        do
            echo "no wlan connected, try to reconnect to known WLANS" 
        for i in `wpa_cli list_networks |grep DISABLED|cut -f1`
            do
                echo "enable network $i" 
                wpa_cli enable $i
            done
    wpa_cli reconnect
    sleep 2
    if ! wpa_cli status | grep "ssid" 
        then
            echo "no known wlan connected, scan for new wlans" 
        while ! wpa_cli scan |grep -q OK
            do
                echo "scan not ok, retry in 1s" 
                sleep 1
            done
                echo "scan results:" 
                wpa_cli scan_results
                echo "check for WPS Button" 
                wpa_cli wps_pbc
                echo "wait 3 s until recheck" 
                sleep 3
    fi
    done
fi